package gov.va.caret.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.service.ServiceContext;

import com.liferay.portlet.expando.model.ExpandoBridge;

import java.io.Serializable;

import java.util.Date;

/**
 * The base model interface for the CalEt service. Represents a row in the &quot;CARET_CALL_EVENT&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation {@link gov.va.caret.model.impl.CalEtModelImpl} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link gov.va.caret.model.impl.CalEtImpl}.
 * </p>
 *
 * @author caret
 * @see CalEt
 * @see gov.va.caret.model.impl.CalEtImpl
 * @see gov.va.caret.model.impl.CalEtModelImpl
 * @generated
 */
public interface CalEtModel extends BaseModel<CalEt> {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this interface directly. All methods that expect a cal et model instance should use the {@link CalEt} interface instead.
     */

    /**
     * Returns the primary key of this cal et.
     *
     * @return the primary key of this cal et
     */
    public long getPrimaryKey();

    /**
     * Sets the primary key of this cal et.
     *
     * @param primaryKey the primary key of this cal et
     */
    public void setPrimaryKey(long primaryKey);

    /**
     * Returns the cal et ID of this cal et.
     *
     * @return the cal et ID of this cal et
     */
    public long getCalEtId();

    /**
     * Sets the cal et ID of this cal et.
     *
     * @param calEtId the cal et ID of this cal et
     */
    public void setCalEtId(long calEtId);

    /**
     * Returns the call ID of this cal et.
     *
     * @return the call ID of this cal et
     */
    public long getCallId();

    /**
     * Sets the call ID of this cal et.
     *
     * @param callId the call ID of this cal et
     */
    public void setCallId(long callId);

    /**
     * Returns the event of this cal et.
     *
     * @return the event of this cal et
     */
    @AutoEscape
    public String getEvent();

    /**
     * Sets the event of this cal et.
     *
     * @param event the event of this cal et
     */
    public void setEvent(String event);

    /**
     * Returns the comment of this cal et.
     *
     * @return the comment of this cal et
     */
    @AutoEscape
    public String getComment();

    /**
     * Sets the comment of this cal et.
     *
     * @param comment the comment of this cal et
     */
    public void setComment(String comment);

    /**
     * Returns the creation date of this cal et.
     *
     * @return the creation date of this cal et
     */
    public Date getCreationDate();

    /**
     * Sets the creation date of this cal et.
     *
     * @param creationDate the creation date of this cal et
     */
    public void setCreationDate(Date creationDate);

    /**
     * Returns the user ID of this cal et.
     *
     * @return the user ID of this cal et
     */
    public long getUserId();

    /**
     * Sets the user ID of this cal et.
     *
     * @param userId the user ID of this cal et
     */
    public void setUserId(long userId);

    /**
     * Returns the user uuid of this cal et.
     *
     * @return the user uuid of this cal et
     * @throws SystemException if a system exception occurred
     */
    public String getUserUuid() throws SystemException;

    /**
     * Sets the user uuid of this cal et.
     *
     * @param userUuid the user uuid of this cal et
     */
    public void setUserUuid(String userUuid);

    @Override
    public boolean isNew();

    @Override
    public void setNew(boolean n);

    @Override
    public boolean isCachedModel();

    @Override
    public void setCachedModel(boolean cachedModel);

    @Override
    public boolean isEscapedModel();

    @Override
    public Serializable getPrimaryKeyObj();

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj);

    @Override
    public ExpandoBridge getExpandoBridge();

    @Override
    public void setExpandoBridgeAttributes(BaseModel<?> baseModel);

    @Override
    public void setExpandoBridgeAttributes(ExpandoBridge expandoBridge);

    @Override
    public void setExpandoBridgeAttributes(ServiceContext serviceContext);

    @Override
    public Object clone();

    @Override
    public int compareTo(gov.va.caret.model.CalEt calEt);

    @Override
    public int hashCode();

    @Override
    public CacheModel<gov.va.caret.model.CalEt> toCacheModel();

    @Override
    public gov.va.caret.model.CalEt toEscapedModel();

    @Override
    public gov.va.caret.model.CalEt toUnescapedModel();

    @Override
    public String toString();

    @Override
    public String toXmlString();
}
