package gov.va.caret.model;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.impl.BaseModelImpl;

import gov.va.caret.service.BoxGpLocalServiceUtil;
import gov.va.caret.service.ClpSerializer;

import java.io.Serializable;

import java.lang.reflect.Method;

import java.util.HashMap;
import java.util.Map;


public class BoxGpClp extends BaseModelImpl<BoxGp> implements BoxGp {
    private long _boxGpId;
    private String _boxGroup;
    private String _boxSubGroup;
    private String _label;
    private int _viewSequence;
    private BaseModel<?> _boxGpRemoteModel;
    private Class<?> _clpSerializerClass = gov.va.caret.service.ClpSerializer.class;

    public BoxGpClp() {
    }

    @Override
    public Class<?> getModelClass() {
        return BoxGp.class;
    }

    @Override
    public String getModelClassName() {
        return BoxGp.class.getName();
    }

    @Override
    public long getPrimaryKey() {
        return _boxGpId;
    }

    @Override
    public void setPrimaryKey(long primaryKey) {
        setBoxGpId(primaryKey);
    }

    @Override
    public Serializable getPrimaryKeyObj() {
        return _boxGpId;
    }

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        setPrimaryKey(((Long) primaryKeyObj).longValue());
    }

    @Override
    public Map<String, Object> getModelAttributes() {
        Map<String, Object> attributes = new HashMap<String, Object>();

        attributes.put("boxGpId", getBoxGpId());
        attributes.put("boxGroup", getBoxGroup());
        attributes.put("boxSubGroup", getBoxSubGroup());
        attributes.put("label", getLabel());
        attributes.put("viewSequence", getViewSequence());

        return attributes;
    }

    @Override
    public void setModelAttributes(Map<String, Object> attributes) {
        Long boxGpId = (Long) attributes.get("boxGpId");

        if (boxGpId != null) {
            setBoxGpId(boxGpId);
        }

        String boxGroup = (String) attributes.get("boxGroup");

        if (boxGroup != null) {
            setBoxGroup(boxGroup);
        }

        String boxSubGroup = (String) attributes.get("boxSubGroup");

        if (boxSubGroup != null) {
            setBoxSubGroup(boxSubGroup);
        }

        String label = (String) attributes.get("label");

        if (label != null) {
            setLabel(label);
        }

        Integer viewSequence = (Integer) attributes.get("viewSequence");

        if (viewSequence != null) {
            setViewSequence(viewSequence);
        }
    }

    @Override
    public long getBoxGpId() {
        return _boxGpId;
    }

    @Override
    public void setBoxGpId(long boxGpId) {
        _boxGpId = boxGpId;

        if (_boxGpRemoteModel != null) {
            try {
                Class<?> clazz = _boxGpRemoteModel.getClass();

                Method method = clazz.getMethod("setBoxGpId", long.class);

                method.invoke(_boxGpRemoteModel, boxGpId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getBoxGroup() {
        return _boxGroup;
    }

    @Override
    public void setBoxGroup(String boxGroup) {
        _boxGroup = boxGroup;

        if (_boxGpRemoteModel != null) {
            try {
                Class<?> clazz = _boxGpRemoteModel.getClass();

                Method method = clazz.getMethod("setBoxGroup", String.class);

                method.invoke(_boxGpRemoteModel, boxGroup);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getBoxSubGroup() {
        return _boxSubGroup;
    }

    @Override
    public void setBoxSubGroup(String boxSubGroup) {
        _boxSubGroup = boxSubGroup;

        if (_boxGpRemoteModel != null) {
            try {
                Class<?> clazz = _boxGpRemoteModel.getClass();

                Method method = clazz.getMethod("setBoxSubGroup", String.class);

                method.invoke(_boxGpRemoteModel, boxSubGroup);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getLabel() {
        return _label;
    }

    @Override
    public void setLabel(String label) {
        _label = label;

        if (_boxGpRemoteModel != null) {
            try {
                Class<?> clazz = _boxGpRemoteModel.getClass();

                Method method = clazz.getMethod("setLabel", String.class);

                method.invoke(_boxGpRemoteModel, label);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public int getViewSequence() {
        return _viewSequence;
    }

    @Override
    public void setViewSequence(int viewSequence) {
        _viewSequence = viewSequence;

        if (_boxGpRemoteModel != null) {
            try {
                Class<?> clazz = _boxGpRemoteModel.getClass();

                Method method = clazz.getMethod("setViewSequence", int.class);

                method.invoke(_boxGpRemoteModel, viewSequence);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    public BaseModel<?> getBoxGpRemoteModel() {
        return _boxGpRemoteModel;
    }

    public void setBoxGpRemoteModel(BaseModel<?> boxGpRemoteModel) {
        _boxGpRemoteModel = boxGpRemoteModel;
    }

    public Object invokeOnRemoteModel(String methodName,
        Class<?>[] parameterTypes, Object[] parameterValues)
        throws Exception {
        Object[] remoteParameterValues = new Object[parameterValues.length];

        for (int i = 0; i < parameterValues.length; i++) {
            if (parameterValues[i] != null) {
                remoteParameterValues[i] = ClpSerializer.translateInput(parameterValues[i]);
            }
        }

        Class<?> remoteModelClass = _boxGpRemoteModel.getClass();

        ClassLoader remoteModelClassLoader = remoteModelClass.getClassLoader();

        Class<?>[] remoteParameterTypes = new Class[parameterTypes.length];

        for (int i = 0; i < parameterTypes.length; i++) {
            if (parameterTypes[i].isPrimitive()) {
                remoteParameterTypes[i] = parameterTypes[i];
            } else {
                String parameterTypeName = parameterTypes[i].getName();

                remoteParameterTypes[i] = remoteModelClassLoader.loadClass(parameterTypeName);
            }
        }

        Method method = remoteModelClass.getMethod(methodName,
                remoteParameterTypes);

        Object returnValue = method.invoke(_boxGpRemoteModel,
                remoteParameterValues);

        if (returnValue != null) {
            returnValue = ClpSerializer.translateOutput(returnValue);
        }

        return returnValue;
    }

    @Override
    public void persist() throws SystemException {
        if (this.isNew()) {
            BoxGpLocalServiceUtil.addBoxGp(this);
        } else {
            BoxGpLocalServiceUtil.updateBoxGp(this);
        }
    }

    @Override
    public BoxGp toEscapedModel() {
        return (BoxGp) ProxyUtil.newProxyInstance(BoxGp.class.getClassLoader(),
            new Class[] { BoxGp.class }, new AutoEscapeBeanHandler(this));
    }

    @Override
    public Object clone() {
        BoxGpClp clone = new BoxGpClp();

        clone.setBoxGpId(getBoxGpId());
        clone.setBoxGroup(getBoxGroup());
        clone.setBoxSubGroup(getBoxSubGroup());
        clone.setLabel(getLabel());
        clone.setViewSequence(getViewSequence());

        return clone;
    }

    @Override
    public int compareTo(BoxGp boxGp) {
        int value = 0;

        if (getViewSequence() < boxGp.getViewSequence()) {
            value = -1;
        } else if (getViewSequence() > boxGp.getViewSequence()) {
            value = 1;
        } else {
            value = 0;
        }

        if (value != 0) {
            return value;
        }

        return 0;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (!(obj instanceof BoxGpClp)) {
            return false;
        }

        BoxGpClp boxGp = (BoxGpClp) obj;

        long primaryKey = boxGp.getPrimaryKey();

        if (getPrimaryKey() == primaryKey) {
            return true;
        } else {
            return false;
        }
    }

    public Class<?> getClpSerializerClass() {
        return _clpSerializerClass;
    }

    @Override
    public int hashCode() {
        return (int) getPrimaryKey();
    }

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(11);

        sb.append("{boxGpId=");
        sb.append(getBoxGpId());
        sb.append(", boxGroup=");
        sb.append(getBoxGroup());
        sb.append(", boxSubGroup=");
        sb.append(getBoxSubGroup());
        sb.append(", label=");
        sb.append(getLabel());
        sb.append(", viewSequence=");
        sb.append(getViewSequence());
        sb.append("}");

        return sb.toString();
    }

    @Override
    public String toXmlString() {
        StringBundler sb = new StringBundler(19);

        sb.append("<model><model-name>");
        sb.append("gov.va.caret.model.BoxGp");
        sb.append("</model-name>");

        sb.append(
            "<column><column-name>boxGpId</column-name><column-value><![CDATA[");
        sb.append(getBoxGpId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>boxGroup</column-name><column-value><![CDATA[");
        sb.append(getBoxGroup());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>boxSubGroup</column-name><column-value><![CDATA[");
        sb.append(getBoxSubGroup());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>label</column-name><column-value><![CDATA[");
        sb.append(getLabel());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>viewSequence</column-name><column-value><![CDATA[");
        sb.append(getViewSequence());
        sb.append("]]></column-value></column>");

        sb.append("</model>");

        return sb.toString();
    }
}
