package gov.va.caret.model;

import java.io.Serializable;

import java.util.ArrayList;
import java.util.List;

/**
 * This class is used by SOAP remote services.
 *
 * @author caret
 * @generated
 */
public class BlsReSoap implements Serializable {
    private long _blsReId;
    private long _blsAeId;
    private int _year;
    private Double _h75;
    private String _city;
    private String _zip;
    private String _state;
    private String _county;

    public BlsReSoap() {
    }

    public static BlsReSoap toSoapModel(BlsRe model) {
        BlsReSoap soapModel = new BlsReSoap();

        soapModel.setBlsReId(model.getBlsReId());
        soapModel.setBlsAeId(model.getBlsAeId());
        soapModel.setYear(model.getYear());
        soapModel.setH75(model.getH75());
        soapModel.setCity(model.getCity());
        soapModel.setZip(model.getZip());
        soapModel.setState(model.getState());
        soapModel.setCounty(model.getCounty());

        return soapModel;
    }

    public static BlsReSoap[] toSoapModels(BlsRe[] models) {
        BlsReSoap[] soapModels = new BlsReSoap[models.length];

        for (int i = 0; i < models.length; i++) {
            soapModels[i] = toSoapModel(models[i]);
        }

        return soapModels;
    }

    public static BlsReSoap[][] toSoapModels(BlsRe[][] models) {
        BlsReSoap[][] soapModels = null;

        if (models.length > 0) {
            soapModels = new BlsReSoap[models.length][models[0].length];
        } else {
            soapModels = new BlsReSoap[0][0];
        }

        for (int i = 0; i < models.length; i++) {
            soapModels[i] = toSoapModels(models[i]);
        }

        return soapModels;
    }

    public static BlsReSoap[] toSoapModels(List<BlsRe> models) {
        List<BlsReSoap> soapModels = new ArrayList<BlsReSoap>(models.size());

        for (BlsRe model : models) {
            soapModels.add(toSoapModel(model));
        }

        return soapModels.toArray(new BlsReSoap[soapModels.size()]);
    }

    public long getPrimaryKey() {
        return _blsReId;
    }

    public void setPrimaryKey(long pk) {
        setBlsReId(pk);
    }

    public long getBlsReId() {
        return _blsReId;
    }

    public void setBlsReId(long blsReId) {
        _blsReId = blsReId;
    }

    public long getBlsAeId() {
        return _blsAeId;
    }

    public void setBlsAeId(long blsAeId) {
        _blsAeId = blsAeId;
    }

    public int getYear() {
        return _year;
    }

    public void setYear(int year) {
        _year = year;
    }

    public Double getH75() {
        return _h75;
    }

    public void setH75(Double h75) {
        _h75 = h75;
    }

    public String getCity() {
        return _city;
    }

    public void setCity(String city) {
        _city = city;
    }

    public String getZip() {
        return _zip;
    }

    public void setZip(String zip) {
        _zip = zip;
    }

    public String getState() {
        return _state;
    }

    public void setState(String state) {
        _state = state;
    }

    public String getCounty() {
        return _county;
    }

    public void setCounty(String county) {
        _county = county;
    }
}
