package gov.va.caret.model;

import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.service.ServiceContext;

import com.liferay.portlet.expando.model.ExpandoBridge;

import java.io.Serializable;

/**
 * The base model interface for the BgNum service. Represents a row in the &quot;CARET_BOXED_GROUP_NUMERIC&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation {@link gov.va.caret.model.impl.BgNumModelImpl} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link gov.va.caret.model.impl.BgNumImpl}.
 * </p>
 *
 * @author caret
 * @see BgNum
 * @see gov.va.caret.model.impl.BgNumImpl
 * @see gov.va.caret.model.impl.BgNumModelImpl
 * @generated
 */
public interface BgNumModel extends BaseModel<BgNum> {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this interface directly. All methods that expect a bg num model instance should use the {@link BgNum} interface instead.
     */

    /**
     * Returns the primary key of this bg num.
     *
     * @return the primary key of this bg num
     */
    public long getPrimaryKey();

    /**
     * Sets the primary key of this bg num.
     *
     * @param primaryKey the primary key of this bg num
     */
    public void setPrimaryKey(long primaryKey);

    /**
     * Returns the bg num ID of this bg num.
     *
     * @return the bg num ID of this bg num
     */
    public long getBgNumId();

    /**
     * Sets the bg num ID of this bg num.
     *
     * @param bgNumId the bg num ID of this bg num
     */
    public void setBgNumId(long bgNumId);

    /**
     * Returns the owner ID of this bg num.
     *
     * @return the owner ID of this bg num
     */
    public long getOwnerId();

    /**
     * Sets the owner ID of this bg num.
     *
     * @param ownerId the owner ID of this bg num
     */
    public void setOwnerId(long ownerId);

    /**
     * Returns the box gp ID of this bg num.
     *
     * @return the box gp ID of this bg num
     */
    public long getBoxGpId();

    /**
     * Sets the box gp ID of this bg num.
     *
     * @param boxGpId the box gp ID of this bg num
     */
    public void setBoxGpId(long boxGpId);

    /**
     * Returns the value of this bg num.
     *
     * @return the value of this bg num
     */
    public double getValue();

    /**
     * Sets the value of this bg num.
     *
     * @param value the value of this bg num
     */
    public void setValue(double value);

    @Override
    public boolean isNew();

    @Override
    public void setNew(boolean n);

    @Override
    public boolean isCachedModel();

    @Override
    public void setCachedModel(boolean cachedModel);

    @Override
    public boolean isEscapedModel();

    @Override
    public Serializable getPrimaryKeyObj();

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj);

    @Override
    public ExpandoBridge getExpandoBridge();

    @Override
    public void setExpandoBridgeAttributes(BaseModel<?> baseModel);

    @Override
    public void setExpandoBridgeAttributes(ExpandoBridge expandoBridge);

    @Override
    public void setExpandoBridgeAttributes(ServiceContext serviceContext);

    @Override
    public Object clone();

    @Override
    public int compareTo(gov.va.caret.model.BgNum bgNum);

    @Override
    public int hashCode();

    @Override
    public CacheModel<gov.va.caret.model.BgNum> toCacheModel();

    @Override
    public gov.va.caret.model.BgNum toEscapedModel();

    @Override
    public gov.va.caret.model.BgNum toUnescapedModel();

    @Override
    public String toString();

    @Override
    public String toXmlString();
}
