<%
/**
 * Copyright (c) 2000-2013 Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */
%>


<%@ taglib uri="http://liferay.com/tld/ui" prefix="liferay-ui" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<%@ include file="/jsp/init.jsp" %>	


<style>
	.letter-title{
		color:blue;
		font-weight:bold;
		font-size:20px;
	}
	.aui p {
		margin-bottom: 20px;
		margin-left: 10px;
	}
	
	.centerHeading {
		text-align: center;
		font-weight:bold;
		font-size:15px;
	}
	
	.subHeading {
		font-weight:bold;
		font-size:15px;
	}
	
	.alertHeading {
		color: red;
		font-weight:bold;
		font-size:15px;
	}
	
	.alertText {
		color: red;
	}
	
	.sectionHeading{
	    border: thin solid #d9d9d9;
	    background-color: #f0efef;
		font-weight: bold;
		margin: 1px;
		padding: 3px;
		width: 99%;
	}
	.section{
	    border: thin solid #d9d9d9;
	    background-color: #f0efef;
		font-weight: bold;
		margin: 1px;
		padding: 3px;
		width: 99%;
	}
	.summaryTable table, th, td{
	    //border: thin solid #d9d9d9;
	    border-collapse: collapse;
	    margin: 12px;
	    padding: 5px;
	    text-align: center;
	}
	.summaryTable tr:hover {
		background-color: #f5f5f5;
	}
	.summaryTable th {
	    background-color: #f0efef;
	}
	.manage-layout-td text{
		/* width: 840px; */
		width: 67px;
		padding-left: 10px;
	}
	.manage-layout-td textarea{
		/* width: 840px; */
		width: 767px;
		padding-left: 10px;
	}

	.messageicon{
	margin-left:50px;font-size: 15px; font-weight:100; float:center;
	}

	.assessment-history-all{
		float:right;
		margin:10px;
	}
	.section-link{
		float:right;
		margin:10px;
	}
	
</style>

<c:set var="caretCss" value="${form_['required']}" />

<div id="mainTab">

<div class="tab-content">
<div class="yui3-skin-sam">
	<div id="modalEditLetterContent0"></div>
</div>

<div id="deleteDocDiv" class="yui3-skin-sam" >	
Do you want to proceed and delete the document?
</div>
<div class="yui3-skin-sam">
	<div id="deleteDocModal"></div>
</div>

<div class="supporting-docs">

<div class="content toggler-content-expanded">	


<legend class="header">Preview & Send</legend>
	<div id="letterContentTable">
	<div id="letterContent" class="letterContent" contenteditable = "true">
			${letterContent}
	</div>
	</div>
	<div class="summaryTable">
		<table style="width:98%">
			<tr>
			  <th width="30%">Letter Name</th> 
			  <th width="5%">Letter Date</th> 
			  <th width="35%">Recipients</th> 
			  <th width="30%">Action</th>			  
			</tr>
		
			<tr id="">
			    <td width="30%">
				    <aui:field-wrapper inlineField="true" inlineLabel="left" first="true" last="false" >
					<aui:select label="" name="previewLetterName" id="previewLetterName" >
						<aui:option value="" label="select-letter" selected="true" />
						<c:forEach var="letterName" items="${cscLetterNames}">
							<aui:option value="${letterName}" label="${letterName}"/>
						</c:forEach>
					</aui:select>
					</aui:field-wrapper>
			    </td>
			    
			    <td width="10%" id="delegateDate">
				    <aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="edit-caret" helpMessage="Letter Date" >
					<aui:input label="" name="letterDate" type="text" size="8" id="letterDate" >
					<aui:validator name="required" />
					</aui:input>
					</aui:field-wrapper>
				</td>
				
			    <td  width="30%" style= "align:left">
				    <aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" >
						<c:forEach var="recipient" items="${recipients}">
							<aui:input label="${recipient.value.fullName}" name="${recipient.key}" type="checkbox" /><br/>
						</c:forEach>
					</aui:field-wrapper>
			    </td>
				
			    <td width="30%">
			   	<portlet:resourceURL var="loadEditLetterContent">
						<portlet:param name="action" value="loadEditLetterContent"/>
						<portlet:param name="vcgId" value="${vcgId}"/>
						<portlet:param name="letterName" value="${letterName}"/>
					</portlet:resourceURL>
					<portlet:resourceURL var="previewLetter">
						<portlet:param name="action" value="previewLetter"/>
						<portlet:param name="vcgId" value="${vcgId}"/>
					</portlet:resourceURL>
					
					<portlet:actionURL var="sendLetter">
						<portlet:param name="javax.portlet.action" value="doAction" />
						<portlet:param name="action" value="sendLetter"/>
						<portlet:param name="vcgId" value="${vcgId}"/>
						<portlet:param name="letterName" value="${letterName}"/>
					</portlet:actionURL>
					<aui:form  style="margin:0px;" action="#" name="editLetter" method="post" enctype="multipart/form-data">
					</aui:form>
					<aui:form  style="margin:0px;" action="${previewLetter}" name="previewLetter" method="post" enctype="multipart/form-data">
					<input type="hidden" id="letterName" name="letterName" value=""/>
					<input type="hidden" id="editedLetterContent" name="editedLetterContent" value=""/>
					</aui:form>
					<aui:form style="margin:0px;" action="${sendLetter}" name="sendLetter" method="post" enctype="multipart/form-data">
						<input type="hidden" id="sendLetterName" name="sendLetterName" value=""/>
						<input type="hidden" id="editedLetterContent" name="editedLetterContent" value=""/>
						<input type="hidden" id="veteranRecipient" name="veteranRecipient" value=""/>
						<input type="hidden" id="primaryCGRecipient" name="primaryCGRecipient" value=""/>
						<input type="hidden" id="secondaryCGRecipient" name="secondaryCGRecipient" value=""/>
						<input type="hidden" id="secondaryTwoCGRecipient" name="secondaryTwoCGRecipient" value=""/>
					</aui:form>
					<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="true" >
						<a href="javascript:previewLetter();"><i class="close-window btn btn-primary" >&nbsp; Preview </i></a>
						<a href="javascript:editLetterContent();"><i class="close-window btn btn-primary" >&nbsp; Edit </i></a>
						<a href="javascript:sendLetter();"><i class="close-window btn btn-primary" >&nbsp; Send</i></a>		
					</aui:field-wrapper>
				</td>
			</tr>
		</table>
		</div>

		<div id="letterValidationDiv" class="yui3-skin-sam">
		    <div id="letterValidationResult"></div>
		</div>
		
	</div>
</div>	

<legend class="header">Previous Letters </legend>
	<div class="summaryTable">
	
	<portlet:resourceURL var="deleteLetter">
	<portlet:param name="action" value="deleteLetter"/>
	<portlet:param name="documId" value="${doc.documId}"/>
	</portlet:resourceURL>
	
	<aui:form style="margin:0px;" action="${deleteLetter}" name="deleteLetter" method="post" enctype="multipart/form-data">
	</aui:form>
	<c:choose>
		<c:when test="${not empty allLetters}">
			<table style="width:98%">
				<tr>
					<th>File Name</th> 
					<th>Recipients</th> 
					<th>Sent Date</th> 
					<th>Action</th>		  
				</tr>
				<c:forEach var="doc" items="${allLetters}">	
					<c:set var="docInfo" value="${fn:split(doc.note, ',')}" />
					<c:set var="docRecipient" value="${docInfo[1]}" />
					<tr id="row_${doc.documId}">
						<td>${doc.name}</td>
						<td>
						<c:set var="recipientValues" value="${fn:split(docRecipient, ';')}" />
							<c:if test="${recipientValues[0] == 'true'}">
								${recipients.veteran.fullName}
								<br/>
							</c:if>
							<c:if test="${recipientValues[1] == 'true'}">
								${recipients.primary.fullName}
								<br/>
							</c:if>
							<c:if test="${recipientValues[2] == 'true'}">
							${recipients.secondary.fullName}
							</c:if>
							<c:if test="${recipientValues[3] == 'true'}">
							${recipients.secondaryTwo.fullName}
							</c:if>
						</td>
						<td>${docInfo[0]}</td>
						<td>
						<portlet:resourceURL var="viewLetter">
						<portlet:param name="action" value="getDocum"/>
						<portlet:param name="documId" value="${doc.documId}"/>
						</portlet:resourceURL>
						<a href="${viewLetter}" target="_blank" ><i class="close-window btn btn-primary" >&nbsp; View</i></a>
						
						<a class="btn-primary delete-document" id="${doc.documId}"><i class="close-window btn btn-primary" >&nbsp; Delete</i></a>
						</td>
					</tr>
				</c:forEach>
			</table>
		</c:when>
		<c:otherwise>
			<div class="messageicon">No letters available</div>
		</c:otherwise>
	</c:choose>
	
	
	</div>
</div>	
</div>
</div>


<aui:script use="aui-datepicker">
		A.all('.icon-calendar').on(
	      'click',
	      function(e) {	
	       		var v = A.one ('#<portlet:namespace/>' + e.currentTarget.attr('id') + "put");
	       		v.select();
	      }
	    );
	new A.DatePicker (
		{
			mask: '%m/%d/%y',
			on: {
				selectChange: function ( event ){
				}
			},
			trigger: '#delegateDate input, #delegateDate button',
			popover:{
				zIndex: 1000
			}
		}
	);
</aui:script>

 <aui:script use="aui-io-request,aui-parse-content,aui-modal">
 
 var modalEditLetterContent = new A.Modal({
		headerContent: '<h4><liferay-ui:message key="edit-letter-content" /></h4>',
	     bodyContent: A.one('#letterContentTable'),//'<div id="editContentDiv" class="editContentDiv" contenteditable = "true">'+data+'</div>',
	     centered: true,
	     destroyOnHide: false,
	     modal: true,
	     render: '#modalEditLetterContent0', 
	     resizable: {
	       handles: 'b, r'
	     },
	     visible: false,
	     width: 950
		});
 
	modalEditLetterContent.addToolbar([
	        {
	          label: 'Cancel',
	          on: {
	            click: function() {
	            	modalEditLetterContent.hide();
	            }
	          }
	        },{
	          label: 'Save Changes',
	          on: {
	            click: function() {
	        	var editedContent = A.one('#letterContent').innerHTML;
	        	modalEditLetterContent.hide();
	            }
	          }
	        }
	   ]);
	
	window.previewLetter = function() {
		var letterName = A.one("#<portlet:namespace/>previewLetterName").val();
		if (letterName == "") {
    		A.one("#<portlet:namespace/>previewLetterName").addClass( 'missing-required-input' );
    		var msg = "<div class='portlet-msg-alert'>Letter name is required</div>";
    		A.one ('#letterValidationResult').html(msg);

		} else {
			A.one('#letterName').val(letterName);	
			var content = document.getElementById("letterContent").innerHTML;
			A.all('#editedLetterContent').val(content);	
			A.one("#<portlet:namespace/>previewLetter").submit();
		}
	}
	
	window.deleteLetter = function() {
		A.one("#<portlet:namespace/>deleteLetter").submit();
	}

	window.sendLetter = function() {
		var letterName = A.one("#<portlet:namespace/>previewLetterName").val();
		if (letterName == "") {
    		A.one("#<portlet:namespace/>previewLetterName").addClass( 'missing-required-input' );
    		var msg = "<div class='portlet-msg-alert'>Letter name is required</div>";
    		A.one ('#letterValidationResult').html(msg);

		} else {
			A.io.request('<%=loadEditLetterContent %>',{
          method: 'POST',
          form: { id: '<portlet:namespace />editLetter' },
          data: {
        	  editLetterName: A.one('#<portlet:namespace/>previewLetterName').val(),
        	  letterDate: A.one('#<portlet:namespace/>letterDate').val()
		  },
          on: {
              success: function(){
        	  		var data = this.get('responseData');
        	  		A.all('#letterContent').html(data);
        	  		var content = document.getElementById("letterContent").innerHTML;
        			A.all('#editedLetterContent').val(content);	
        			var letterName = A.one("#<portlet:namespace/>previewLetterName").val();
        			A.one('#sendLetterName').val(letterName);	

        			A.one('#veteranRecipient').val( A.one("#<portlet:namespace/>veteran").val());	
        			A.one('#primaryCGRecipient').val( A.one("#<portlet:namespace/>primary").val());	
        			if (A.one("#<portlet:namespace/>secondary") != null) {
        				A.one('#secondaryCGRecipient').val(A.one("#<portlet:namespace/>secondary").val());	
        			}
        			if (A.one("#<portlet:namespace/>secondaryTwo") != null) {
            			A.one('#secondaryTwoCGRecipient').val( A.one("#<portlet:namespace/>secondaryTwo").val());	
        			}
        			
        			A.one("#<portlet:namespace/>sendLetter").submit();
               }
         }
		});
		}
		
	}
	
	window.editLetterContent = function() {
				var letterName = A.one("#<portlet:namespace/>previewLetterName").val();
				if (letterName == "") {
		    		A.one("#<portlet:namespace/>previewLetterName").addClass( 'missing-required-input' );
		    		var msg = "<div class='portlet-msg-alert'>Letter name is required</div>";
		    		A.one ('#letterValidationResult').html(msg);

				} else {
					
				A.io.request('<%=loadEditLetterContent %>',{
	              method: 'POST',
	              form: { id: '<portlet:namespace />editLetter' },
	              data: {
	            	  editLetterName: A.one('#<portlet:namespace/>previewLetterName').val(),
	            	  letterDate: A.one('#<portlet:namespace/>letterDate').val()
				  },
	              on: {
	                  success: function(){
	            	  		var data = this.get('responseData');
	            	  		A.all('#letterContent').html(data);
	            	  		modalEditLetterContent.render();
	            			modalEditLetterContent.show();
	                   }
	             }
				});
				}
	}
	
	var deleteDocId = '';
	A.all('.delete-document').on('click', function( event ) 
	{
  	 	window.deleteDocId = event.currentTarget.attr('id');	 	   
		console.log("document id from div is : "+ window.deleteDocId);
		modalDeleteDocument.render();
		modalDeleteDocument.show();		
	});
	
	window.modalDeleteDocument = new A.Modal({
	    headerContent: '<h4><liferay-ui:message key="delete-document" /> </h4>',
	    bodyContent: A.one("#deleteDocDiv"),
	    centered: true,
	    destroyOnHide: false,
	    modal: true,
	    render: '#deleteDocModal',
	    resizable: {
	      handles: 'b, r'
	    },
	    visible: false,
	    width: 800
	});
	 
	 modalDeleteDocument.addToolbar([
	   {
         label: 'Cancel',
         on: {
	            click: function() {
	            	window.deleteDocId = '';
	            	modalDeleteDocument.hide();
              	}
          }
	   },
	   {
          label: 'Delete',
          id: 'modalDelete',
          on: {
              click: function() {
            	window.caretIo( '<portlet:resourceURL><portlet:param name="action" value="deleteDocum"/></portlet:resourceURL>', 'json', 
				{ 
			   		documId: window.deleteDocId,
			   	  	deleteComment: "letters document deleted"
			 	},
				function( data )
				{
					document.getElementById('row_'+window.deleteDocId).style.display = 'none';
					window.deleteDocId = '';
					modalDeleteDocument.hide();
				} );
              }
          }
       }
	 ]);    
	
   </aui:script>