<%@ include file="/jsp/init.jsp" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>


<c:set var="type" value="${SEARCH_CONTAINER_RESULT_ROW.object['type']}" />
<c:set var="worImId" value="${SEARCH_CONTAINER_RESULT_ROW.object['worImId']}" />

<liferay-ui:icon-menu>
	<c:if test="${SEARCH_CONTAINER_RESULT_ROW.object['assignable']}" >
		<portlet:actionURL var="editEntry">
			<portlet:param name="javax.portlet.action" value="doAction"/>
			<portlet:param name="action" value="takeOwnership"/>
			<portlet:param name="worImId" value="${worImId}"/>
			<portlet:param name="type" value="${type}"/>
		</portlet:actionURL>
		<liferay-ui:icon image="edit" message="take-ownership" url="${editEntry}" />
		<liferay-ui:icon image="assign" message="assign-ownership" url="javascript:assignTo(${SEARCH_CONTAINER_RESULT_ROW.object['worImId']});" />
		
<portlet:actionURL var="unassignTo">
	<portlet:param name="javax.portlet.action" value="doAction" />
	<portlet:param name="action" value="unassignTo"/>
	<portlet:param name="worImId" value="${worImId}"/>
</portlet:actionURL>
<liferay-ui:icon image="unassign_user" message="unassign-ownership" url="${unassignTo}" />
		
	</c:if>
	<c:if test="${SEARCH_CONTAINER_RESULT_ROW.object['transferable']}" >
		<liferay-ui:icon image="post" message="transfer-to-facility" url="javascript:transfer(${SEARCH_CONTAINER_RESULT_ROW.object['worImId']});"  />
	</c:if>
	<c:if test="${SEARCH_CONTAINER_RESULT_ROW.object['vcgId'] gt 0}" >
		<portlet:actionURL var="loadVcgManagement">
			<portlet:param name="javax.portlet.action" value="doAction" />
			<portlet:param name="action" value="loadEntry"/>
			<portlet:param name="entry" value="MANAGE_VCG"/>
			<portlet:param name="vcgId" value="${SEARCH_CONTAINER_RESULT_ROW.object['vcgId']}"/>
		</portlet:actionURL>
		<liferay-ui:icon image="group" message="manage-vcg" url="${loadVcgManagement}"  />
	</c:if>
	<c:if test="${SEARCH_CONTAINER_RESULT_ROW.object['docLoaded']}" >
		<portlet:resourceURL var="getDocum">
			<portlet:param name="action" value="getDocum"/>
			<portlet:param name="classPk" value="${SEARCH_CONTAINER_RESULT_ROW.object['classPk']}"/>
		</portlet:resourceURL>
		<liferay-ui:icon image="page" useDialog="false" target="_blank"  message="view-document" url="${getDocum}" />
	</c:if>
	<c:if test="${fn:endsWith(type, '_APP')}">
				<liferay-ui:icon image="add" message="new-note" url="javascript:newWorkNote(${worImId});" />
	</c:if>
			
	<liferay-ui:icon image="time" message="work-audit" url="javascript:auditLog(${SEARCH_CONTAINER_RESULT_ROW.object['worImId']});" />
	
</liferay-ui:icon-menu>





