<%@ include file="/jsp/init.jsp" %>

<portlet:actionURL var="saveEntry">
	<portlet:param name="javax.portlet.action" value="doAction" />
</portlet:actionURL>

	
	<c:set var="form_" value="${caretMap_['form_']}" />
	<c:set var="call" value="${form_['call']}" />
	<c:set var="cssClass" value="${form_['required']}" />
	<c:set var="boxGrp_" value="${form_['boxGrp_']}" />
	
	<legend class="header" id="headerElem">
		<c:choose>
			<c:when test="${isDisabled}">
				<liferay-ui:message key="view-csl-call" /> (${role})
			</c:when>
			<c:when test="${!empty call and call.primaryKey gt 0}">
				<liferay-ui:message key="edit-csl-call" /> (${role})
			</c:when>
			<c:otherwise>
				<liferay-ui:message key="create-csl-call" /> (${role})
			</c:otherwise>
		</c:choose>
	</legend>

<form name="saveEntry" method="post" action="${saveEntry}" >
	<input type="hidden" name="action" value="saveEntry"/>
	<input type="hidden" id="entry" name="entry" value="CREATE_CALLS" >
	<input type="hidden" name="TRACKER" value="${TRACKER}" >

	<fieldset id="sectionCollapse">
	
		<div class="next-section-label section-header toggler-header-expanded">
			<div class="icon-user show-tooltip" title='<liferay-ui:message key="click-to-toggle-pane" />' > 
				<liferay-ui:message key="caller-info" />
			</div>
		</div>
		<hr/>
		 <% //c:if test="${!isDisabled || (true eq enableSoc) }" c:if test="${!empty call and call.primaryKey gt 0}"  %>
			 <div class="auto-save-info">
				<aui:field-wrapper inlineField="true" cssClass="auto-save-row ${cssClass['callType']}" inlineLabel="left" first="false" last="false" >
					<aui:select disabled="${isDisabled}" label="call-callType" name="call_callType" id="call_callType" >
							<aui:option value="" label="select-calltype"  />
								<c:forEach var="boxGrp" items="${form_['standard-call-types']}" >
									<aui:option value="${boxGrp}" label="${boxGrp}" selected="${call.callType eq boxGrp}" />
								</c:forEach>
								<c:forEach var="boxGrp" items="${form_['custom-call-types']}" >
									<aui:option value="${boxGrp.label}" label="${boxGrp.label}" selected="${call.callType eq boxGrp.label}" />
								</c:forEach>
					</aui:select>
				</aui:field-wrapper>
				
				<!-- 
				<div class="auto-save-row">
					<div class="float-left">
						<liferay-ui:message key="completed-without-contact" />
					</div>
					<div class="float-right auto-save">
						<aui:input label="" name="call_withoutContact" type="checkbox" checked="${call.withoutContact eq true}" />
					</div>
				</div>
				-->
				
				<div class="auto-save-row">
					<div class="float-left">
						<liferay-ui:message key="hang-up" />
					</div>
					<div class="float-right auto-save">
						<!-- checked="${call.hangUp eq true}" -->
						<aui:input label="" name="call_hangUp" type="checkbox" />
					</div>
				</div>
				
				<div class="auto-save-row">
					<div class="float-left">
						<liferay-ui:message key="wrong-number" />
					</div>
					<div class="float-right auto-save">
						<!-- checked="${call.wrongNumber eq true}" -->
						<aui:input label="" name="call_wrongNumber" type="checkbox" />
					</div>
				</div>
				<div class="clear-both">
					<a href="<portlet:actionURL/>" class="btn btn-primary btn-cancel" >
						<liferay-ui:message key="cancel" />
					</a>
					<a href="javascript:" id="submitForm0" class="call-submitter btn btn-primary" >
						<liferay-ui:message key="save-for-later" />
					</a>
				</div>
			</div>
		 
		 
		 <div class="content toggler-content-expanded" >
			
			<c:set var="ndx" value="callerPersn" />
	
			<c:set var="person" value="${form_['callerPersn']}" />
			<input type="hidden" name="callerPersn_primaryKey" value="${call.callerPersnId }" id="<portlet:namespace/>use_callerPersn_" />
			<input type="hidden" name="call_primaryKey" value="${call.primaryKey }" />
			
			<c:set var="searchCss" value="search-person-action icon-search tab-click" />
			
			<%@include file="/jsp/internal/editCaller.jsp" %>
			
			<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout ${cssClass['callerRelationship']}"   >
				<aui:select disabled="${isDisabled}" label="caller-relationship" name="call_callerRelationship" id="call_callerRelationship" >
					<aui:option label="select-relationship" value=""  />
					<aui:option label="family" cssClass="section" disabled="true" />
					<c:forEach var="relationship" items="${caretMap_['relationship-family']}">
						<aui:option cssClass="relationship" value="${relationship}" label="${relationship}" selected="${call.callerRelationship eq relationship}" />
					</c:forEach>
					<aui:option label="not-family" cssClass="section" disabled="true" />
					<c:forEach var="relationship" items="${caretMap_['relationship-not-family']}">
						<aui:option cssClass="relationship" value="${relationship}" label="${relationship}" selected="${call.callerRelationship eq relationship}" />
					</c:forEach>
				</aui:select>
			</aui:field-wrapper>
				
			
			<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout email-field ${cssClass['callerEmail']}"  >
				<aui:input disabled="${isDisabled}" label="email" name="${ndx}_email" type="text" cssClass="email-field" max="75" size="25" id="${ndx}_email" value="${person.email}" />
			</aui:field-wrapper>

			<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout ${cssClass['callerState']}"  >
				<aui:select inlineField="true" disabled="${isDisabled}" label="state" name="${ndx}_state" id="${ndx}_state" cssClass="persn-resource-state" >
					<aui:option value="" label="select-state" />
					<aui:option value="other" label="other" />
					<c:forEach var="state" items="${caretMap_['states']}">
						<aui:option value="${state.regionCode}" label="${state.name}" selected="${state.regionCode eq person.state}" />
					</c:forEach>
				</aui:select>
			</aui:field-wrapper>
			
		</div>

	
		<div class="next-section-label section-header">
			<div class="icon-user show-tooltip" title='<liferay-ui:message key="click-to-toggle-pane" />' > 
				<liferay-ui:message key="veteran-information" />
			</div>
		</div>
		<hr/>
		
	    <div class="content toggler-content-${expanded}" >
	      	
			<c:set var="ndx" value="veteranPersn" />
			<c:set var="person" value="${form_['veteranPersn']}" />
		
			
			<input type="hidden" name="${ndx}_primaryKey" value="${person.primaryKey}" id="<portlet:namespace/>use_${ndx}_" />
			<%@include file="/jsp/internal/person.jsp" %>
			
			<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout ${cssClass['veteranEmail']}"  >
				<aui:input label="email" disabled="${isDisabled}" name="${ndx}_email" cssClass="email-field" id="${ndx}_email" max="75" type="text" size="25" value="${person.email}"  />
			</aui:field-wrapper>
			
			<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout ${cssClass['veteranPhone']}"  >
				<aui:input disabled="${isDisabled}" label="phone" name="${ndx}_phone" cssClass="phone-field" type="text" size="25" id="${ndx}_phone" value="${person.phone}" />
			</aui:field-wrapper>
			
			<c:set var="addrGroup" value="address-${ndx}" />
			<c:set var="second" value="${addrGroup}" />
			
			<c:set var="includeFacility" value="${true}" />
			<%@include file="/jsp/internal/editAddress.jsp" %>	
			
			
			<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout"  >
				<aui:select inlineField="true" disabled="${isDisabled}" label="era-service" name="call_eraService" >
					<aui:option value="" label="select-era-service" />
					<c:forEach var="eraService" items="${eraServiceTypes}">
						<aui:option value="${eraService}" label="${eraService}" selected="${eraService eq call.eraService}" />
					</c:forEach>
				</aui:select>
			</aui:field-wrapper>
			
			<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout"  >
				<aui:select disabled="${isDisabled}" label="service-branch" name="call_serviceBranch" >
					<aui:option value="" label="select-service-branch" />
					<c:forEach var="serviceBranch" items="${serviceBranches}">
						<aui:option value="${serviceBranch}" label="${serviceBranch}" selected="${serviceBranch eq call.serviceBranch}" />
					</c:forEach>
				</aui:select>
			</aui:field-wrapper>
			
			<div class="clear-both">
				<div class="veteran-primary-diagnosis" >
			
					<div class="small-legend" >
						<liferay-ui:message key="primary-diagnosis-of-veteran" />
					</div>
					
					<c:forEach var="boxGrp" items="${form_['veteran-primary-diagnosis']}" >
						<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout0"  >
							<aui:input disabled="${isDisabled}" label="${boxGrp.label}" name="boxGrp_${boxGrp.boxGpId}" type="checkbox" value="${boxGrp_[boxGrp.primaryKey]}" />
						</aui:field-wrapper>
					</c:forEach>
					
				</div>
			
			<div class="veteran-supplemental-info">
				
			<div class="supplemental-row enrolled-in-va-health" >
			
				<div class="supplemental-question-veteran width-78-percent">
					<liferay-ui:message key="enrolled-in-va-health" />
				</div>
				
				<c:forEach var="boxGrp" items="${form_['enrolled-in-va-health']}" >
					<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout4"  >
						<aui:input disabled="${isDisabled}" label="${boxGrp.label}" name="boxRadioGrp_enrolledVaHealth" type="radio" value="${boxGrp.primaryKey}" checked="${boxGrp_[boxGrp.primaryKey]}"  />
					</aui:field-wrapper>
				</c:forEach>
				
			</div>	

			<div class="supplemental-row discharged-after-911" >
			
				<div class="supplemental-question-veteran width-78-percent">
					<liferay-ui:message key="discharged-after-911" />
				</div>
				
				<c:forEach var="boxGrp" items="${form_['discharged-after-911']}" >
					<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout4"  >
						<aui:input disabled="${isDisabled}" label="${boxGrp.label}" name="boxRadioGrp_dischargedAfter911" type="radio" value="${boxGrp.primaryKey}" checked="${boxGrp_[boxGrp.primaryKey]}"  />
					</aui:field-wrapper>
				</c:forEach>
				
			</div>	
			<div class="supplemental-row veteran-has-sc-condition" >
			
				<div class="supplemental-question-veteran width-78-percent">
					<liferay-ui:message key="veteran-has-sc-condition" />
				</div>
				
				<c:forEach var="boxGrp" items="${form_['veteran-has-sc-condition']}" >
					<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout4"  >
						<aui:input disabled="${isDisabled}" label="${boxGrp.label}" name="boxRadioGrp_veteranScCondition" type="radio" value="${boxGrp.primaryKey}" checked="${boxGrp_[boxGrp.primaryKey]}"  />
					</aui:field-wrapper>
				</c:forEach>
				
			</div>	
			<div class="supplemental-row prescreen-meets-pcafc" >
			
				<div class="supplemental-question-veteran width-78-percent">
					<liferay-ui:message key="prescreen-meets-pcafc" />
				</div>
				
				<c:forEach var="boxGrp" items="${form_['prescreen-meets-pcafc']}" >
					<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout4"  >
						<aui:input disabled="${isDisabled}" label="${boxGrp.label}" name="boxRadioGrp_prescreenPcafc" type="radio" value="${boxGrp.primaryKey}" checked="${boxGrp_[boxGrp.primaryKey]}"  />
					</aui:field-wrapper>
				</c:forEach>
				
			</div>	
					
					<div class="supplemental-row">
						<aui:field-wrapper inlineField="true" cssClass="supplemental-row" inlineLabel="left" first="false" last="false" >
							<aui:select disabled="${isDisabled}" cssClass="supplemental-answer" label="current-service-status" name="call_serviceStatus" >
									<aui:option value="0" label="select" />
								<c:forEach var="servStat" items="${serviceStatus}">
									<aui:option value="${servStat}" label="${servStat}" selected="${call.serviceStatus eq servStat}" />
								</c:forEach>
							</aui:select>
						</aui:field-wrapper>
					</div>
					
			</div>
				
			</div>
		</div> <!-- content toggler-content-collapsed -->
		
		
		<div class="next-section-label section-header">
			<div class="icon-edit show-tooltip" title='<liferay-ui:message key="click-to-toggle-pane" />' > 
				<liferay-ui:message key="call-information-action-taken" />
			</div>
		</div>
		<hr/>
		
		<div class="content toggler-content-${expanded}" >
			<div class="other-primary-diagnosis" >
			
				<div class="small-legend" >
					<liferay-ui:message key="other-primary-diagnosis" />
				</div>
				
				<c:forEach var="boxGrp" items="${form_['other-primary-diagnosis']}" >
					<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout4"  >
						<aui:input disabled="${isDisabled}" label="${boxGrp.label}" name="boxGrp_${boxGrp.boxGpId}" type="checkbox" value="${boxGrp_[boxGrp.primaryKey]}" />
					</aui:field-wrapper>
				</c:forEach>
				
			</div>
	
	
			<div class="public-law-111-163-reasons" >
			
				<div class="small-legend" >
					<liferay-ui:message key="public-law-111-163-reasons" />
				</div>
				
				<c:forEach var="boxGrp" items="${form_['public-law-111-163-reasons']}" >
					<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout4"  >
						<aui:input disabled="${isDisabled}" label="${boxGrp.label}" name="boxGrp_${boxGrp.boxGpId}" type="checkbox" value="${boxGrp_[boxGrp.primaryKey]}" />
					</aui:field-wrapper>
				</c:forEach>
				
			</div>
			
			<div class="heard-from-us" >
			
				<div class="small-legend" >
					<liferay-ui:message key="heard-from-us" />
				</div>
				
				<c:forEach var="boxGrp" items="${form_['heard-from-us']}" >
					<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout4"  >
						<aui:input disabled="${isDisabled}" label="${boxGrp.label}" name="boxRadioGrp_heardFromUs" type="radio" value="${boxGrp.primaryKey}" checked="${boxGrp_[boxGrp.primaryKey]}"  />
					</aui:field-wrapper>
				</c:forEach>
				
			</div>
			
			<div class="support-lines-transfer" >
			
				<div class="small-legend" >
					<liferay-ui:message key="support-lines-transfer" />
				</div>
				
				<c:forEach var="boxGrp" items="${form_['support-lines-transfer']}" >
					<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout4"  >
						<aui:input disabled="${isDisabled}" label="${boxGrp.label}" name="boxGrp_${boxGrp.boxGpId}" type="checkbox" value="${boxGrp_[boxGrp.primaryKey]}" />
					</aui:field-wrapper>
				</c:forEach>
				
				<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout-wide-input ${cssClass['callerCallbackPref']}"  >
					<aui:input disabled="${isDisabled}" label="person-warm-transferred-to" name="call_transferredTo" size="50" type="text" value="${call.transferredTo}" />
				</aui:field-wrapper>
				
				<div class="small-legend" >
					<liferay-ui:message key="support-lines-number-provided" />
				</div>
				
				<c:forEach var="boxGrp" items="${form_['support-lines-number-provided']}" >
					<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout4"  >
						<aui:input disabled="${isDisabled}" label="${boxGrp.label}" name="boxGrp_${boxGrp.boxGpId}" type="checkbox" value="${boxGrp_[boxGrp.primaryKey]}" />
					</aui:field-wrapper>
				</c:forEach>
				
				<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout-wide-input ${cssClass['callerCallbackPref']}"  >
					<aui:input disabled="${isDisabled}" label="remarks" name="call_transferRemarks" size="50" cssClass="caller-remarks" type="textarea" value="${call.transferRemarks}" />
				</aui:field-wrapper>
				
			</div>
		
			<div class="medium-legend" >
				<liferay-ui:message key="interventions-applied" />
			</div>
			<div class="box-group" >
			
				<div class="interventions-applied-left" >
					<div class="interventions-applied-family">
						<div class="small-legend" >
							<liferay-ui:message key="interventions-applied-family" />
						</div>
						
						<c:forEach var="boxGrp" items="${form_['interventions-applied-family']}" >
							<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout4"  >
								<aui:input disabled="${isDisabled}" label="${boxGrp.label}" name="boxGrp_${boxGrp.boxGpId}" type="checkbox" value="${boxGrp_[boxGrp.primaryKey]}" />
							</aui:field-wrapper>
						</c:forEach>
					</div>
					<div class="interventions-applied-care">
						<div class="small-legend" >
							<liferay-ui:message key="interventions-applied-care" />
						</div>
						
						<c:forEach var="boxGrp" items="${form_['interventions-applied-care']}" >
							<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout4"  >
								<aui:input disabled="${isDisabled}" label="${boxGrp.label}" name="boxGrp_${boxGrp.boxGpId}" type="checkbox" value="${boxGrp_[boxGrp.primaryKey]}" />
							</aui:field-wrapper>
						</c:forEach>
					</div>
					<div class="interventions-applied-respite">
						<div class="small-legend" >
							<liferay-ui:message key="interventions-applied-respite" />
						</div>
						<c:forEach var="boxGrp" items="${form_['interventions-applied-respite']}" >
							<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout4"  >
								<aui:input disabled="${isDisabled}" label="${boxGrp.label}" name="boxGrp_${boxGrp.boxGpId}" type="checkbox" value="${boxGrp_[boxGrp.primaryKey]}" />
							</aui:field-wrapper>
						</c:forEach>
					</div>
					
					<div class="interventions-applied-counseling">
						<div class="small-legend" >
							<liferay-ui:message key="interventions-applied-counseling" />
						</div>
						
						<c:forEach var="boxGrp" items="${form_['interventions-applied-counseling']}" >
							<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout4"  >
								<aui:input disabled="${isDisabled}" label="${boxGrp.label}" name="boxGrp_${boxGrp.boxGpId}" type="checkbox" value="${boxGrp_[boxGrp.primaryKey]}" />
							</aui:field-wrapper>
						</c:forEach>
					</div>
					
				</div>
				<div class="interventions-applied-right" >
					
					<div class="interventions-applied-directives">
						<div class="small-legend" >
							<liferay-ui:message key="interventions-applied-directives" />
						</div>
						<c:forEach var="boxGrp" items="${form_['interventions-applied-directives']}" >
							<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout4"  >
								<aui:input disabled="${isDisabled}" label="${boxGrp.label}" name="boxGrp_${boxGrp.boxGpId}" type="checkbox" value="${boxGrp_[boxGrp.primaryKey]}" />
							</aui:field-wrapper>
						</c:forEach>
					</div>
					
					<div class="interventions-applied-other">	
						<div class="small-legend" >
							<liferay-ui:message key="interventions-applied-other" />
						</div>
						<c:forEach var="boxGrp" items="${form_['interventions-applied-other']}" >
							<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout4"  >
								<aui:input disabled="${isDisabled}" label="${boxGrp.label}" name="boxGrp_${boxGrp.boxGpId}" type="checkbox" value="${boxGrp_[boxGrp.primaryKey]}" />
							</aui:field-wrapper>
						</c:forEach>
						<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout4"  >
							<aui:input disabled="${isDisabled}" label="other" name="call_otherBenefits" type="text" value="${call.otherBenefits}" />
						</aui:field-wrapper>
					</div>
					
				</div>
			</div>
		</div>
	</fieldset>
	
	<c:choose>
	<c:when test="${empty worImId}">
	<c:if test="${true ne isDisabled}">
	
	<div class="save-info-bottom">
			
		<aui:field-wrapper inlineField="true" cssClass="manage-layout ${cssClass['callState']}" inlineLabel="left" first="false" last="false" >
			<aui:select disabled="${isDisabled}" label="call-disposition" name="call_callState" id="callState" cssClass="small-legend" >
				<aui:option value="complete" label="completed"  />
				<aui:option value="completed-without-contact" label="completed-without-contact"  />
				<aui:option value="csl-call-back" label="csl-call-back"  />
				<aui:option value="send-referral" label="send-referral"  />
			</aui:select>
		</aui:field-wrapper>
				
		<div class="clear-both">
			<a href="<portlet:actionURL/>" class="btn btn-primary btn-cancel" >
				<liferay-ui:message key="cancel" />
			</a>
			<a href="javascript:" id="submitForm" class="call-submitter btn btn-primary" >
				<liferay-ui:message key="submit-call" />
			</a>
		</div>
	</div>

	</c:if>
	</c:when>
	<c:otherwise>
		<div class="save-info-bottom">
			<aui:field-wrapper inlineField="true" cssClass="manage-layout ${cssClass['callState']}" inlineLabel="left" first="false" last="false" >
				<aui:select label="call-disposition" name="call_callState" id="callState" cssClass="small-legend" >
					<aui:option value="" label="select"  />
					<aui:option value="call-attempt1" label="call-attempt1"  />
					<aui:option value="call-attempt2" label="call-attempt2"  />
					<aui:option value="completed-referral-with-contact" label="completed-referral-with-contact"  />
					<aui:option value="completed-referral-without-contact" label="completed-referral-without-contact"  />
				</aui:select>
			</aui:field-wrapper>
			
			<aui:field-wrapper inlineField="false" inlineLabel="left" first="false" last="false" cssClass="manage-layout-bottom-input required-input ${cssClass['summary']}"  >
				<aui:input label="comments" name="worIm_comments" size="50" cssClass="caller-summary" type="textarea" id="call_summary"  />
			</aui:field-wrapper>
			
			<input type="hidden" name="onPageComplete" value="${form_['onPageComplete']}" >
			
			<div class="clear-both">
					<c:choose>
						<c:when test="${! empty form_['onPageComplete']}" >
							<c:set var="workItem" value="${form_['workItem']}" />
							<portlet:actionURL var="loadVcgManagement">
								<portlet:param name="javax.portlet.action" value="doAction" />
								<portlet:param name="action" value="loadEntry"/>
								<portlet:param name="entry" value="MANAGE_VCG"/>
								<portlet:param name="vcgId" value="${workItem.vcgId}"/>
							</portlet:actionURL>
							<a href="${loadVcgManagement}" class="btn btn-primary btn-cancel" >
								<liferay-ui:message key="cancel" />
							</a>
						</c:when>
						<c:otherwise>
							<a href="<portlet:actionURL/>" class="btn btn-primary btn-cancel" >
								<liferay-ui:message key="cancel" />
							</a>
						</c:otherwise>
					</c:choose>
				<a href="javascript:" id="submitForm" class="call-submitter btn btn-primary" >
					<liferay-ui:message key="submit" />
				</a>
			</div>
		</div>
	</c:otherwise>
	</c:choose>
	</form>
	
<aui:script use="aui-tooltip,aui-toggler,aui-tabview,aui-modal">
	
	new A.TooltipDelegate( { trigger: '.show-tooltip' } );
	
	window.<portlet:namespace />toggler = new A.TogglerDelegate(
			      {
			        animated: true,
			        closeAllOnExpand: false,
			        container: '#sectionCollapse',
			        content: '.content',
			        //expanded: false,
			        header: '.section-header',
			        transition: {
			          duration: 0.2,
			          easing: 'cubic-bezier(0, 0.1, 0, 1)'
			        }
			      }
			    );
	
		window.bottomTabs = new A.TabView({
		      srcNode: '#bottomTabs',
		      type: 'pills'
		    }
		  ).render();
	
	A.on('domready', function(event){
		if ( false | ${empty worImId and (enableCesp eq true || enableSoc eq true) and isDisabled eq true} ){
			window.bottomTabs.selectChild(${enableCesp eq true?1:2});
			try{
				window.<portlet:namespace />toggler.createAll();
				window.<portlet:namespace />toggler.items[1].collapse();
				window.<portlet:namespace />toggler.items[2].collapse();
			}catch(e){}
		}
		A.all('.tab-click').attr('tabindex',0);
	});
		
	window.preventUser = function() {
		return "<liferay-ui:message key='back-button-lose-form-data' />";
	}
	window.addEventListener('beforeunload', preventUser);
	
	A.all('#breadcrumbs a, .collapse nav-collapse, .btn-primary').on('click', function ( event ) {
	  	window.removeEventListener('beforeunload', preventUser);
	});
	
	window.addNote = function( src ) {
		A.one('#targetNoteId').val(0);
		A.one('#<portlet:namespace/>addNode_comments').val(src);
		modalAddNote.render();
		modalAddNote.show();
	}
	
	var modalAddNote = new A.Modal(
			{
				headerContent : '<h4><liferay-ui:message key="vcg-add-note" /></h4>',
				bodyContent : A.one("#addVcgNote"),
				centered : true,
				destroyOnHide : false,
				modal : true,
				render : '#modalCreateNote',
				resizable : {
					handles : 'b, r'
				},
				visible : false,
				width : 650
			});

	modalAddNote.addToolbar([ {
		label : 'Cancel',
		on : {
			click : function() {
				modalAddNote.hide();
			}
		}
	}, {
		label : 'Update',
		on : {
			click : function() {
				var note = A.one('#<portlet:namespace/>addNode_comments').val();
				if ( note != "" ){ 
				  loadNotes( note, A.one('#targetNoteId').val() );
			      modalAddNote.hide();
		    	}
			}
		}
	} ]);
	
	window.loadNotes = function ( note, noteId ) {
		window.caretIo( '<portlet:resourceURL><portlet:param name="action" value="loadVcgNotes" /><portlet:param name="page" value="vcgNotes" /><portlet:param name="classPk" value="${call.callId}" /><portlet:param name="fromParameter" value="true" /></portlet:resourceURL>', 'html', 
			{ note: note,
			  noteType: 1,
			  noteId: noteId },
			function( data ){ 
				overwrite( A.one( "#vcgNotes" ), data );
				A.one('#<portlet:namespace/>addNode_comments').val("");
			} 
		);
	}
<c:if test="${call.callId gt 0}">
	A.on('domready', loadNotes );
</c:if>
	
</aui:script>

	<!-- each of these tabs now requires their own form...  -->
	<div class="outside-tab">
		<div id="bottomTabs">
			<ul class="nav nav-tabs">
				<li class="active tab-click"><a href="#tab-1">CSL Referral</a></li>
				<li class="tab-click" id="cesp"><a href="#tab-2">CESP</a></li>
				<li class="tab-click" id="soc"><a href="#tab-3">SOC</a></li>
			</ul>
	
			<div class="tab-content">
	    		<div id="tab-1" class="tab-pane">
		    		
		    		<aui:field-wrapper inlineField="true" cssClass="" inlineLabel="left" first="false" last="false" >
		    			<aui:input disabled="${isDisabled}" checked="${call.anonymous}" label="csl-referral-caller-anonymous" name="call_anonymous" type="checkbox" />
		    		</aui:field-wrapper>
		    		<div class="clear-both"></div>
		    		
					<div class="radio-wrapper">
			    		<aui:field-wrapper inlineField="true" cssClass="radio-fields ${cssClass['callerReferralAgreeable']}" inlineLabel="left" first="false" last="false" >
			    			<label class="radio-label">
				    			<liferay-ui:message key="caller-agrees-to-csc-referral" />
			    			</label>
			    			<aui:input disabled="${isDisabled}" label="yes" value="true" name="call_referralAgreeable" type="radio" checked="${call.referralAgreeable}" />
			    			<aui:input disabled="${isDisabled}" label="no" value="false" name="call_referralAgreeable" type="radio" checked="${!call.referralAgreeable}" />
			    		</aui:field-wrapper>
			    		
						<aui:field-wrapper inlineField="true" cssClass="radio-fields ${cssClass['callerContactInfoProvided']}" inlineLabel="left" first="false" last="false" >
			    			<label class="radio-label">
				    			<liferay-ui:message key="csc-contact-shared" />
			    			</label>
			    			<aui:input disabled="${isDisabled}" label="yes" name="call_contactInfoProvided" value="true" type="radio" checked="${call.contactInfoProvided}" />
			    			<aui:input disabled="${isDisabled}" label="no" name="call_contactInfoProvided" value="false" type="radio" checked="${!call.contactInfoProvided}" />
			    		</aui:field-wrapper>
					</div>
		    		
		    		<%-- aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout ${cssClass['callerContactInfo']}"   >
						<aui:input disabled="${isDisabled}" label="name-of-csc" name="call_contactInfo" size="50" type="text" value="${call.contactInfo}" />
					</aui:field-wrapper --%>
		    							
					<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout-wide-input ${cssClass['callerSummary']}"  >
						<aui:input disabled="${isDisabled}" label="summary" name="call_summary" size="50" type="textarea" value="${call.summary}" />
					</aui:field-wrapper>
	    		</div>
	    		
	    		<div id="tab-2" class="tab-pane"> 
				   <c:if test="${call.callId gt 0}">
				        <%@include file="/jsp/internal/cesp.jsp" %>  
				    </c:if>
				    <c:if test="${empty call.callId}">
				        <div class='portlet-msg-alert'><liferay-ui:message key="cesp-cannot-be-created" /></div>
				    </c:if>
				</div>

				    <div id="tab-3" class="tab-pane">
					    <c:if test="${true eq enableSoc}" >
						    	<%@include file="/jsp/internal/soc.jsp" %>
					    </c:if>
				    </div>
			    
	    	</div>
	    	
		</div>
	</div>
	
	<div class="yui3-skin-sam">
	<div id="modalCreateNote"></div>
</div>			

   
	
		
<portlet:actionURL var="addVcgNote">
	<portlet:param name="javax.portlet.action" value="doAction"/>
	<portlet:param name="action" value="addVcgNote"/>
</portlet:actionURL>

<div id="addVcgNote">
	<aui:form action="${addVcgNote}" method="post" name="addNote_fm"  >
	
	<input type="hidden" name="<portlet:namespace/>vcgId" value="${vcg.vcgId}" id="<portlet:namespace/>addNode_vcgId" >
			
	<aui:field-wrapper inlineField="true" inlineLabel="left" cssClass="manage-layout-medium-input ${cssClass}" >
 		<aui:input label="new-call-note" name="addNode_comments" id="addNode_comments" size="35" type="textarea"  />
	</aui:field-wrapper>
		
	</aui:form>
</div>
	
	<aui:script use="aui-tooltip,aui-modal">
		
		
 window.editNote = function ( id ){
 	window.caretIo( '<portlet:resourceURL><portlet:param name="action" value="getNote" /></portlet:resourceURL>', 'json', 
		{ noteId: id }, function( data ){ 
			if ( data.noteId = 0 ){
				console.log('note was already deleted');
				//refresh list
			} else {
  				addNote( data.noteValue );  //gets most current note state
			 	A.one('#targetNoteId').val(id);
			}
		}
	);
  }	
  
  window.deleteNote = function ( id ){
  		A.one('#targetNoteId').val(id);
		modals.render();
    	modals.show();
  }
  
  var modals = new A.Modal({
      bodyContent: "Confirm: Do you want to delete this note?",
      centered: true,
      destroyOnHide: false,
      headerContent: 'Delete Note',
      modal: true,
      render: '#modal33',
      resizable: {
        handles: 'b, r'
      },
      visible: false,
      width: 550
  });
  modals.addToolbar([ {
		label : 'Cancel',
		on : {
			click : function() {
				modals.hide();
			}
		}
	}, {
		label : 'Yes, Delete',
		on : {
			click : function() {
				loadNotes( 'DELETE', A.one('#targetNoteId').val() );
			    modals.hide();
			}
		}
	} ]);
  
</aui:script>

<input type="hidden" id="targetNoteId" value="0" />
<div class="yui3-skin-sam">
	    <div id="modal33"></div>
	</div>
	
	
	
	
	<c:choose>
		<c:when test="${!isDisabled}">
		
	
		<%@include file="/jsp/internal/searchPerson.jsp" %>

		<aui:script use="aui-tooltip">
		
		
		
				A.all('.auto-save').on('click', function ( event ) {
					A.one('#submitForm0').attr('disabled', "");
				});
				
				A.all('.call-submitter').on('click', function ( event ) {
					var callState = A.one('#<portlet:namespace/>callState').val();
					var requireGroupId = false;
					if ( callState == "" || "submitForm0" == event.currentTarget.attr('id') ){
						A.one('#<portlet:namespace/>callState').val('csl-call-back');
					} else if ( callState == "send-referral" ){
						requireGroupId = true;
					}
					if ( true == validateFields( requireGroupId ) ){
						window.removeEventListener('beforeunload', preventUser);
						document.forms['saveEntry'].appendChild(document.getElementById('tab-1'));
						document.forms['saveEntry'].submit();
					}
				});
				
				A.one('#<portlet:namespace/>callState').on('click', function ( event ) {
					if ( this.val() == 'csl-call-back' ){
						A.one('#submitForm').html('<liferay-ui:message key="save-for-later" />');
					} else {
						A.one('#submitForm').html('<liferay-ui:message key="submit-call" />');
					}
				});
				
//				A.one('#<portlet:namespace/>sameAddressCheckbox').on('click',
//					function( event ) {
//					if ( this.attr('checked') ){
//						A.all('.${first}').hide();
//					} else {
//						A.all('.${first}').each(function(ee){
//							var disabled = ee.all('.field, .aui-field-select').first().attr('disabled');
//							if ( !disabled) {
//								ee.show();
//							}
//						});
//					}
//					foreignCheckbox_callerPersn( null, A.one('#<portlet:namespace/>callerPersn_countryCheckbox').attr('checked') );
//				});

				
				var validateFields = function( requireGroupId ){
					var hangUp_status = document.getElementById("<portlet:namespace/>call_hangUp").value;
                    var wrongNumber_status = document.getElementById("<portlet:namespace/>call_wrongNumber").value;
                    var callDispositionValue = document.getElementById("<portlet:namespace/>callState").value;         
                    //
                    if ((hangUp_status == 'true' || wrongNumber_status == 'true') && 
                    						(callDispositionValue.match(/complete/gi)).length > 0) {
                    	return true;
                    }
					var count = 0;
					var groupIdVerified = false;
					  var inputNodes = A.all('.required-input input, .required-input select');
					  var fields = "";
					  for ( var i = 0; i < inputNodes.size() ; i++ ){
						  var node = A.one(inputNodes._nodes[i]);
						  if (node == undefined  || node.attr('disabled') == true ) continue;
							if ( 'select-one' == node.attr('type') ){
				    			if ( node.val() == "" || node.val() == "0" ){
				    				 node.addClass( 'missing-required-input' );
				    				 fields = fields + "<li>" + node.ancestorsByClassName('required-input').one('.control-label').text().trim()+" is required</li>";
				    				 count++;
				    			} else {
				    				if ( node.hasClass('missing-required-input') ){
				    					node.removeClass( 'missing-required-input' );
				    				}
				    			}
				    			if ( '<portlet:namespace/>veteranPersn_groupId' == node.attr('id') ){
				    				groupIdVerified = true;
				    			}
				    		}
							if ( 'text' == node.attr('type') ){
								if ( node.val() == ""   
									|| ( node.hasClass('date-field') && node.val() == 'MM/DD/YYYY' )
									|| ( node.hasClass('ssn-field') && node.val() == '###-##-####' )
									|| ( node.hasClass('email-field') && node.val() == '[USERNAME]@[DOMAIN]' )
									|| ( node.hasClass('phone-field') && node.val() == '(###) ###-####' ) ){
				   					node.addClass( 'missing-required-input' );
				   					fields = fields + "<li>" + node.ancestorsByClassName('required-input').one('.control-label').text().trim()+" is required</li>";
				   					count++;
					   			} else {
					   				if ( node.hasClass('missing-required-input') ){
					   					node.removeClass( 'missing-required-input' );
					   				}
								}
					    	}
					    }
					  if ( !groupIdVerified && requireGroupId ){
						  var nodes = new Array( A.one('#<portlet:namespace/>veteranPersn_groupId'),
						  						A.one('#<portlet:namespace/>veteranPersn_lastName'),
						  						A.one('#<portlet:namespace/>veteranPersn_firstName') );
							nodes.forEach(function(node, index) {
								if ( node.val() == "" || node.val() == "0" ){
			    					node.addClass( 'missing-required-input' );
			    				 	fields = fields + "<li>" + 
			    				 	node.ancestorsByClassName('control-group').one('.control-label').text().trim()+" is required</li>";
			    				 	count++;
			    				} else {
			    					if ( node.hasClass('missing-required-input') ){
			    						node.removeClass( 'missing-required-input' );
			    					}
			    				}
							});
					  }
					  
					  if ( count > 0 ){
		    				var msg = "<div class='portlet-msg-alert'><liferay-ui:message key='please-address-required-fields' /><ul>" + fields +"</ul></div>";
		    				A.one ('#validationResult').html(msg);
				    		modalDataValidation.render();
				    		modalDataValidation.show();
				    		return false;	
				    	}
					  return true;
				}
				
				A.all('.field, .aui-field-select').on(
						  'change',
						function(e){
							  var node = e.currentTarget;
							  if ( 'text' == node.attr('type') && node.val().length > 75){
									node.val( node.val().substring(0,75) );	
						  	  }
						  }
				  );
				
				
				new A.TooltipDelegate( { trigger: '.search-person-action' } );

				var modalDataValidation = new A.Modal({
				    headerContent: '<h4><liferay-ui:message key="data-validation-header" /></h4>',
				    bodyContent: A.one("#validationDiv"),
				    centered: true,
				    destroyOnHide: false,
				    modal: true,
				    render: '#validationModal',
				    resizable: {
				      handles: 'b, r'
				    },
				    visible: false,
				    width: 500
				});
				
				//A.all('.email-field').on(
				//	'change',
				//	function(e){
				//		var node = e.currentTarget;
				//		console.log( node.val() );	
				//	}
				//);
				
		</aui:script>

		<div class="yui3-skin-sam">
		    <div id="validationModal"></div>
		</div>
	
		<div id="validationDiv" class="yui3-skin-sam">
		    <div id="validationResult"></div>
		</div>
			
	
		</c:when>
		<c:otherwise>
			
			<aui:script use="node" >
				A.all('.call-submitter').on('click', function ( event ) {
						window.removeEventListener('beforeunload', preventUser);
						document.forms['saveEntry'].appendChild(document.getElementById('tab-1'));
						document.forms['saveEntry'].submit();
				});
			</aui:script>
		
		</c:otherwise>
	</c:choose>


	
	<c:if test="${!empty call and call.primaryKey gt 0}">
<!--<div class="vcg-notes"> -->
	<div class="next-section-label section-header">
		<div class="icon-list show-tooltip" title='<liferay-ui:message key="click-to-toggle-pane" />' > 
			<liferay-ui:message key="call-notes" />
		</div>
	</div>
	<hr/>
	<div class="content toggler-content-${expanded}" id="vcgNotes" >
		<div class="portlet-msg-info">
			<liferay-ui:message key="no-notes-found" />
		</div>
	</div>
<!--</div>-->
	</c:if>

<%@include file="/jsp/version.jsp" %>
	
	
	