
<%@ include file="/jsp/init.jsp" %>	
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>

	<c:set var="isGlobal" value="${ person.foreigner }" />
	<c:set var="addressCss" >${ cssClass['address'] } ${addrGroup}</c:set>
	<c:if test="${fn:contains(addressCss, 'required-input')}">
		<c:set var="reqA">A</c:set>
	</c:if>
	
	
<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout usps-service ${addrGroup} ${cssClass['address']}"  >
	<aui:input label="address" disabled="${isDisabled}" name="${ndx}_address" id="${ndx}_address" type="text" size="25" value="${person.address}"  />
</aui:field-wrapper>
	
	<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout foreign-country usps-service ${addrGroup} country"  >
		<aui:input label="foreign-country-address" name="${ndx}_country" id="${ndx}_country" type="checkbox" disabled="${isDisabled}" value="${isGlobal}" />
		<a tabindex="0" class="tab-click btn-link btn-primary icon-ok facil-magnet" id="validate_${ndx}u_" title="<liferay-ui:message key="usps-address-check-tip" />" >
			&nbsp;<liferay-ui:message key="usps-address-check" />
		</a>
	</aui:field-wrapper>
	
	<input id="<portlet:namespace/>${ndx}_validAddress" type="hidden" value="${person.validUspsAddress}" name="<portlet:namespace/>${ndx}_validAddress">
		
	<input id="<portlet:namespace/>${ndx}_oldValidAddress" type="hidden" value="${person.validUspsAddress}" >
	<input id="<portlet:namespace/>${ndx}_oldAddress" type="hidden" value="${person.address}" >
	<input id="<portlet:namespace/>${ndx}_oldCity" type="hidden" value="${person.city}" >
	<input id="<portlet:namespace/>${ndx}_oldState" type="hidden" value="${person.state}" >
	<input id="<portlet:namespace/>${ndx}_oldZip" type="hidden" value="${person.zip}" >

	<c:set var="tempAddrGroup" value="${addrGroup}" />
	<c:set var="tempNdx" value="${ndx}" />
	
	
	<c:set var="addrGroup" value="true-global${tempNdx} ${tempAddrGroup}" ></c:set>
	<c:set var="ndx" >${tempNdx}g</c:set>
	
	<%@include file="/jsp/internal/editAddressGlobe.jsp" %>
	
	<c:set var="addrGroup" value="false-global${tempNdx} ${tempAddrGroup}" ></c:set>
	<c:set var="ndx" >${tempNdx}u</c:set>
	<%@include file="/jsp/internal/editAddressUsa.jsp" %>
	
	<c:set var="ndx" value="${tempNdx}" />

<aui:script use="aui-tooltip">

	new A.TooltipDelegate( { trigger: '.upper-icon-padding' } );

	window.foreignCheckbox${ndx} = function (e, use){
			var checked = use || ( e && e.currentTarget.attr('checked') );
			if ( checked ){
				requireField${reqA}( A.one('#<portlet:namespace/>${tempNdx}g_city').ancestor('.field-wrapper') );
				requireField${reqA}( A.one('#<portlet:namespace/>${tempNdx}g_state').ancestor('.field-wrapper') );
				requireField${reqA}( A.one('#<portlet:namespace/>${tempNdx}g_zip').ancestor('.field-wrapper') );
				unrequireField${reqA}( A.one('#<portlet:namespace/>${tempNdx}u_city').ancestor('.field-wrapper') );
				unrequireField${reqA}( A.one('#<portlet:namespace/>${tempNdx}u_state').ancestor('.field-wrapper') );
				unrequireField${reqA}( A.one('#<portlet:namespace/>${tempNdx}u_zip').ancestor('.field-wrapper') );
				unrequireField${reqA}( A.one('#<portlet:namespace/>${tempNdx}_facility'));
				unrequireField( A.one('#validate_${tempNdx}u_'));
			} else {
				requireField( A.one('#validate_${tempNdx}u_'));	
				requireField${reqA}( A.one('#<portlet:namespace/>${tempNdx}_facility'));		
				requireField${reqA}( A.one('#<portlet:namespace/>${tempNdx}u_city').ancestor('.field-wrapper') );
				requireField${reqA}( A.one('#<portlet:namespace/>${tempNdx}u_state').ancestor('.field-wrapper') );
				requireField${reqA}( A.one('#<portlet:namespace/>${tempNdx}u_zip').ancestor('.field-wrapper') );
				unrequireField${reqA}( A.one('#<portlet:namespace/>${tempNdx}g_city').ancestor('.field-wrapper') );
				unrequireField${reqA}( A.one('#<portlet:namespace/>${tempNdx}g_state').ancestor('.field-wrapper') );
				unrequireField${reqA}( A.one('#<portlet:namespace/>${tempNdx}g_zip').ancestor('.field-wrapper') );
			}
		}

	var checkUspsCache = 
		 function( event ) {
		    	var addr = A.one ('#<portlet:namespace/>${tempNdx}_address');
		    	if ( addr ){
		    		addr = addr.val();
			    	var city = A.one ('#<portlet:namespace/>${tempNdx}u_city').val();	
			    	var state = A.one ('#<portlet:namespace/>${tempNdx}u_state').val();
			    	var zip = A.one ('#<portlet:namespace/>${tempNdx}u_zip').val();
			    	if ( addr.length == 0 || city.indexOf ('Select') >= 0 || state.indexOf ('Select') >= 0 || zip.length <= 1 ){
			    		return false;
			    	}
			    	if ( ( A.one('#<portlet:namespace/>${tempNdx}_oldAddress').val() !=  addr ) || ( A.one ('#<portlet:namespace/>${tempNdx}_oldCity').val() !=  city ) || 
			    		( A.one ('#<portlet:namespace/>${tempNdx}_oldState').val() !=  state ) || ( A.one ('#<portlet:namespace/>${tempNdx}_oldZip').val() !=  zip ) ){
			    		try{
			    			var checking = A.one ('#${tempNdx}u_checkingUsps');
			    			if ( checking && !checking.hasClass('caret-loading-tiny') ){
								checking.addClass( 'caret-loading-tiny' );
								checking.show();
			    			}
							   window.caretIo( '<portlet:resourceURL><portlet:param name="action" value="validateCachedAddress" /></portlet:resourceURL>', 'json',
							        {
							            userAddress: addr,
							            userState: state,
							            userCity: city,
							            userZip: zip
							        },
							        function( data ) {
							    		var v = false;
							             if( data.msg == "Service Unavailable" ){
							            	 v = 'false';
							             } else {
							                 if ( data.msg == "Valid Address" ) {
							                	 v = 'true';
							                 } else {
							                	 v = 'false';
							                 }
							             }
							             A.one ('#<portlet:namespace/>${tempNdx}_validAddress').val( v );
							             if ( checking && checking.hasClass('caret-loading-tiny') ){
             								checking.removeClass( 'caret-loading-tiny' );
             								checking.hide();
							             }
							             A${tempNdx}validatedUsps ( v );
							        }, {}, true
							    );
			    		} catch ( e ){
			    		
			    		}
			    	} else {
			    		A.one ('#<portlet:namespace/>${tempNdx}_validAddress').val( A.one ('#<portlet:namespace/>${tempNdx}_oldValidAddress').val() );
			    		A${tempNdx}validatedUsps ( A.one ('#<portlet:namespace/>${tempNdx}_oldValidAddress').val() );
			    	}
		    	}
		};

	var unrequireField = function( unrequire ){
		if ( !unrequire ) return;
        unrequire.hide();
        unrequire.attr('disabled', 'true');
	}
	
	var requireField = function( require ){
		if ( !require ) return;
        require.show();
        require.attr('disabled', '');
	}
	
	var unrequireFieldA = function( unrequire ){
		if ( !unrequire ) return;
		if ( unrequire.hasClass('required-input') ){
             unrequire.removeClass( 'required-input' );
        }
        unrequire.hide();
        unrequire.attr('disabled', 'true');
	}
	
	var requireFieldA = function( require ){
		if ( !require ) return;
		if ( !require.hasClass('required-input') ){
             require.addClass( 'required-input' );
        }
        require.show();
        require.attr('disabled', '');
	}
	
	window.A${tempNdx}validatedUsps = function ( status ){
		if ( 'true' === status ){
         	A.one ('#${tempNdx}u_validUsps').show();
            A.one ('#${tempNdx}u_invalidUsps').hide();
         } else {
         	A.one ('#${tempNdx}u_invalidUsps').show();
        	A.one ('#${tempNdx}u_validUsps').hide();
         }
	}
	
	A.one('#validate_${tempNdx}u_').on('click',  function(e){
		openUspsPopup ( A.one('#<portlet:namespace/>${tempNdx}_address').val(),
					 A.one('#<portlet:namespace/>${tempNdx}u_state').val(),
					 A.one('#<portlet:namespace/>${tempNdx}u_city').val(),
					 A.one('#<portlet:namespace/>${tempNdx}u_zip').val() );
	});
	
	A.one('#<portlet:namespace/>${ndx}_countryCheckbox').on('change', foreignCheckbox${ndx} );
	foreignCheckbox${ndx}( null, A.one('#<portlet:namespace/>${ndx}_countryCheckbox').attr('checked') );
	
	A.one('#<portlet:namespace/>${tempNdx}_address').on('change', checkUspsCache);
	A.one('#<portlet:namespace/>${tempNdx}u_city').on('change', checkUspsCache);
	A.one('#<portlet:namespace/>${tempNdx}u_state').on('change', checkUspsCache);
	A.one('#<portlet:namespace/>${tempNdx}u_zip').on('blur', checkUspsCache);
	A${tempNdx}validatedUsps( '${person.validUspsAddress}' );
	
</aui:script>


<c:if test="${true eq includeFacility}">
	
	<div id="<portlet:namespace/>zipFaciliities" ></div>
	<div id="<portlet:namespace/>vaFacilities" ></div>
	
	<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout manage-layout-wide-input ${addrGroup} ${cssClass['groupId']}"   >
		<aui:select disabled="${isDisabled}" label="preferred-facility" cssClass="preferred-facility" name="${tempNdx}_groupId" id="${ndx}_groupId" >
			<aui:option value="0" label="select-facility" selected="true"/>
			<c:forEach var="district" items="${caretMap_['vhaSystem']}">
				<aui:option value="${district.key}" label="${district.key}" cssClass="district" disabled="true" selected="false" />
				<c:forEach var="visn" items="${district.value}">
					<aui:option value="${visn.key}" label="${visn.key}" cssClass="visn" disabled="true" selected="false"/>
					<c:forEach var="facility" items="${visn.value}">
						<aui:option value="${facility.value}" label="${facility.key}" cssClass="facility" selected="${facility.value eq person.groupId}" />
					</c:forEach>
				</c:forEach>
			</c:forEach>
		</aui:select>
		<a tabindex="0" class="tab-click btn-link short-facility-list btn-primary icon-filter facil-magnet" id="<portlet:namespace/>${ndx}_facility" tabindex="0" title="<liferay-ui:message key="narrow-facilities-to-zip" />" ></a>
	</aui:field-wrapper>

	<aui:script use="aui-tooltip">
		
		A.one("#<portlet:namespace/>vaFacilities").hide();
		A.one("#<portlet:namespace/>zipFaciliities").hide();
		var ttip =  new A.TooltipDelegate( { trigger: '.next-section-label a, .facil-magnet' } );
		
		if ( '${isDisabled}' != 'true' ){
		A.one('#<portlet:namespace/>${ndx}_facility').on( 'click',
	    	function (e){
	    		var zip = A.one('#<portlet:namespace/>${tempNdx}u_zip' ).val();
	    		if ( zip == ''){
	    			return;
	    		}
	    		window.caretIo( '<portlet:resourceURL><portlet:param name="action" value="getFacils" /></portlet:resourceURL>', 'json',
						{ zip: zip },
						function( data ){
							var facilNode;
	  				    	 
	  				    	if ( A.one('#<portlet:namespace/>vaFacilities').html() == "" ){
	  				    		facilNode = A.one ( '#<portlet:namespace/>zipFaciliities');
	  			    		} else {
	  			    			facilNode = A.one('#<portlet:namespace/>${ndx}_groupId');
	  				    	}
	  				    	
	  				    	var options = "<option value=''>Select Facility</option>";
	  						if ( data.size > 0 ){
	  					    	 for ( var i = 0; i < data.size; i++  ){
	  					    		 options = options + '<option value="' + data.facilities[i].groupId + '">'+ data.facilities[i].facility + '</option>';
	  					    	 }
	  						}
	  					    facilNode.html( options );
						} 
				);
	    		
	    		var zipFaciliities = A.one('#<portlet:namespace/>zipFaciliities');
	    		var vaFacilities = A.one('#<portlet:namespace/>vaFacilities');
	    		var facilitySelect = A.one('#<portlet:namespace/>${ndx}_groupId');
	    		
	    		if ( vaFacilities.html() == "" ){
		    		vaFacilities.html( facilitySelect.html() );
	    			facilitySelect.html( zipFaciliities.html() );
	    			zipFaciliities.html('');
	    		} else {
	    			zipFaciliities.html( facilitySelect.html() );
	    			facilitySelect.html( vaFacilities.html() );
	    			vaFacilities.html('');
	    		}
	    });
	    }
	
	</aui:script>
</c:if>

