<%@ include file="init.jsp"%>
<style>
</style>
<%
	int start = 0;
	if (request.getAttribute("start") != null) {
		start = (Integer) request.getAttribute("start");
	}
	int countPerPage = 2;
	List<PMMessage> messages = (List<PMMessage>) request.getAttribute(PMConstants.MESSAGES_LIST);
	Map<Long, List<PMMessage>> childMessages = (HashMap<Long, List<PMMessage>>) request.getAttribute(PMConstants.MESSAGES_MAP);
	int totalCount = (Integer) request.getAttribute(PMConstants.TOTAL_COUNT);
	String prevIndex = "" + (start - countPerPage);
	String nextIndex = "" + (start + countPerPage);
	String pagingLabel = "";
	if(totalCount > 0) {
		pagingLabel = "Showing messages " + (start + 1) + " to " + (start + messages.size()) + " of " + totalCount;
	}
%>

<portlet:renderURL var="prevPageUrl">
	<portlet:param name="page" value="inbox"/>
	<portlet:param name="startIndex" value="<%=prevIndex%>"/>
</portlet:renderURL>
<portlet:renderURL var="nextPageUrl">
	<portlet:param name="page" value="inbox"/>
	<portlet:param name="startIndex" value="<%= nextIndex %>"/>
</portlet:renderURL>

<portlet:actionURL var="deleteMessageActions">
		<portlet:param name="javax.portlet.action" value="doAction"/>
		<portlet:param name="action" value="messageActions"/>
		<portlet:param name="messageAction" value="trash"/>
</portlet:actionURL>
			
	<aui:script use="node" >
		A.all('.message-action').on(
	      'click',
	      function(e) {	
	    	    var messageAction = e.currentTarget.attr('id');
	    	    var messageId = e.currentTarget.attr('href');
	    	    if ( e.currentTarget.attr('name') == "Subject") {
	    	    	messageAction = "view-message";
	    	    	 A.one ('#<portlet:namespace/>messageId').val(messageId);
	    	    }
	    	    A.one ('#<portlet:namespace/>entry').val("INTERNAL_MESSAGE");
	       		A.one ('#<portlet:namespace/>messageAction').val(messageAction);
	       		document.forms["messageActions"].submit();
	      }
	    );
	</aui:script>

<div class="yui3-skin-sam">
    <div id="modal"></div>
</div>

<div id="mainTab">

 
<legend>
<div image="message" class="message"></div> My Messages
<span class="messageicon">
<liferay-ui:icon-menu>
		<liferay-ui:icon image="message" message="compose" url="javascript:composeMessage();"  />
		</liferay-ui:icon-menu>
</span>
</legend>
<span class="messageicon">
<liferay-ui:icon-menu>
		<liferay-ui:icon image="recent_changes" message="Deleted Messages" url="${messageActions}"  />
		</liferay-ui:icon-menu>
</span>
	<div class="pageContent">
		<div style="width:100%;">
			<%
				String errorMessage = (String) request.getAttribute(PMConstants.ERROR_MESSAGE);
				if(errorMessage != null) {
			%>
				<div class="portlet-msg-error" style="width:95%;"><%=errorMessage%></div><br/>
			<%
					request.removeAttribute(PMConstants.ERROR_MESSAGE);
				}
			%>
			<%
				String infoMessage = (String) request.getAttribute(PMConstants.INFO_MESSAGE);
				if(infoMessage != null) {
			%>			
				<div class="portlet-msg-info" style="width:95%;"><%=infoMessage%></div><br/>
			<%
					request.removeAttribute(PMConstants.INFO_MESSAGE);
				}
			%>
		</div>	
		<div id="messages_count"><%=pagingLabel%></div>
		<div id="mailbox">
			<div>
				<br/>
				
				<script type="text/javascript">
					var messageIds = new Array();
					var userIds = new Array();
				</script>
				
				<fieldset id="sectionCollapse1">
					<input type="hidden" id="type" name="type" value="delete" />
					<input type="hidden" id="ids" name="ids" value="" />
					
					<liferay-ui:search-container id="parentMessages"  curParam="parentMessages" emptyResultsMessage="no-messages">
					
					<liferay-ui:search-container-results results="<%=messages%>"  />
		
					<liferay-ui:search-container-row className="gov.va.caret.model.PMMessage" escapedModel="true" modelVar="message" >
					
					<% 
						String sentTo = message.getRecepients();
						List<PMMessage> childMessagesList = childMessages.get(message.getMessageId());
						String responses = Integer.toString(childMessagesList.size()) + " Responses";
						SimpleDateFormat formatter=new SimpleDateFormat("MM/dd/yy HH:mm:ss a");
						String messageDate=formatter.format(message.getPostedDate());
						String embeddedUrl = message.getUrl().replace("amp;", "");
					%>
	
						<liferay-ui:search-container-column-text name="From" value="<%= message.getOwnerName()%>"/><!-- orderable="true" orderableProperty="type_" -->
						<liferay-ui:search-container-column-text name="To" value="<%= message.getOwnerName()%>"/><!-- orderable="true" orderableProperty="type_" -->
						<liferay-ui:search-container-column-text name="Sent" cssClass="date" value="<%=messageDate%>" />
						<liferay-ui:search-container-column-text cssClass="messContent" name="Subject" value="<%=message.getSubject()%>"/>
						<liferay-ui:search-container-column-text cssClass="messageActionMenu" name="Reponses" >
						<liferay-ui:icon-menu >
							<portlet:actionURL var="messageActions">
								<portlet:param name="javax.portlet.action" value="doAction"/>
								<portlet:param name="action" value="messageActions"/>
								<portlet:param name="messageAction" value="view_message"/>
								<portlet:param name="parentMessageId" value="${message.getMessageId()}"/>
							</portlet:actionURL>
									<liferay-ui:icon image="view" message="<%=responses%>" url="${messageActions}" />
						</liferay-ui:icon-menu>
						</liferay-ui:search-container-column-text>
						<liferay-ui:search-container-column-text cssClass="messageActionMenu" name="Item link" >
						<liferay-ui:icon-menu>
							<liferay-ui:icon message="Open-item"  target="_blank" url="<%=embeddedUrl%>" />
						</liferay-ui:icon-menu>
						</liferay-ui:search-container-column-text>
						<liferay-ui:search-container-column-jsp cssClass="messageActionMenu" name="Actions" path="/jsp/im/messageActions.jsp"></liferay-ui:search-container-column-jsp>
						</liferay-ui:search-container-row>
					
					<liferay-ui:search-iterator />
					</liferay-ui:search-container>
					
					
					</fieldset>
			</div>
		</div>
	</div>
</div>

<jsp:include page="/jsp/im/compose.jsp" />