<%
/**
 * Copyright (c) 2000-2013 Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */
%>

<%@include file="/jsp/init.jsp" %>

<!-- %@include file="/jsp/online/console.jsp" % -->

<div class="yui3-skin-sam">
    <div id="modal"></div>
</div>

<%@include file="/jsp/internal/menu.jsp" %>



<div id="mainTab">
  <ul class="nav nav-tabs">
    <li class="tab-click" ><a href="#tab-1"><div class="icon-home"></div> ${role} Dashboard </a></li>
    <li class="tab-click" ><a href="#tab-2"><div class="icon-search"></div> Search</a></li>
    <li class="tab-click" ><a href="#tab-3"><div class="icon-user"></div> <liferay-ui:message key='cg-vendors' /></a></li>
    <li class="tab-click" ><a href="#tab-4"><div class="icon-dollar"></div> Payments</a></li>
    <li class="tab-click" ><a href="#tab-5"><div class="icon-globe"></div> BLS Rates</a></li>
  </ul>

  <div class="tab-content">
    <div id="tab-1" class="tab-pane">
      	<div class="dashboard-top">
      		<div class="internal-split-pane">
      			<fieldset id="sectionCollapseCbopc1">
			      	<legend class="header"><div class="icon-bookmark"></div> My Work</legend>
			      	<div class="content" id="myOccWork" >
					</div>
				</fieldset>
      		</div>
      		<div class="internal-split-pane">
      			<fieldset id="sectionCollapseCbopc2">
		      		<legend class="header"><div class="icon-comment"></div> My Comments/Notes </legend>
		      		<div class="content" id="myNotes" >
	      			</div>
      			</fieldset>
      		</div>
      	</div>
      	
      	
      	<fieldset id="sectionCollapseCbopc3" class="clear-both">
			<legend class="header toggler-header-expanded"><div class="icon-building"></div> Primary Queue </legend>
			   <div id="midTabs" class="content toggler-header-expanded" >
					<ul class="nav nav-tabs">
						<c:forEach var="cbopcQue" items="${caretMap_['cbopcQue']}" >
							<c:set var='queName' value="${cbopcQue['name']}" />
							<c:if test="${empty first}">
								<c:set var='first' value="${queName}" />
							</c:if>
						    <li class="tab-click" ><a href="#${queName}"  ><liferay-ui:message key="${queName}-tab" /> (<span id='total_${queName}'>${total_[queName]}</span>)</a></li>
						</c:forEach>
					</ul>
					<div class="tab-content">
					<c:forEach var="cbopcQue" items="${caretMap_['cbopcQue']}" >
						<div id="${cbopcQue['name']}" class="tab-pane"></div>
					</c:forEach>
					</div>
				</div>
		  </fieldset>
      	
    </div>

    <div id="tab-2" class="tab-pane">
		<%@include file="/jsp/internal/filter.jsp" %>
	</div>
	
	<div id="tab-3" class="tab-pane">
    	<%@include file="/jsp/internal/vendors.jsp" %>
	</div>
	
    <div id="tab-4" class="tab-pane">
    	<%@include file="/jsp/internal/stipends.jsp" %>
	</div>
    
    <div id="tab-5" class="tab-pane">
    	<%@include file="/jsp/internal/blsRates.jsp" %>
    </div>
	
  </div>

</div>


<aui:script use="aui-tabview,aui-modal,aui-dropdown,aui-toggler,node-event-simulate">
	
	for ( i = 1 ; i < 4; i++ ){
	    new A.TogglerDelegate(
	      {
	        animated: true,
	        container: '#sectionCollapseCbopc' + i ,
	        content: '.content',
	        expanded: true,
	        header: '.header',
	        transition: {
	          duration: 0.2,
	          easing: 'cubic-bezier(0, 0.1, 0, 1)'
	        }
	      }
	    );
	}

	A.all('.close-window').on(
	 'click',
	  function() {
		modal.hide();	    	  
	  }
	);
    
    
    var loadList = function(e, page) {
	  	if (!page){
	   		var href = e.currentTarget.getActiveTab().one('a').attr('href');
	  	   	page = href.substring(href.indexOf('#'));
		}
		var node = A.one( page );
	    if (!node || node.hasClass('loaded-pane')){
	    	return false;
	    }
	
		window.caretIo( '<portlet:resourceURL><portlet:param name="action" value="loadList" /></portlet:resourceURL>', 'html', 
			{ page: page },
			function( data ){
				overwrite( node, data );
			} 
		);
	}
    
    window.midTabsOn = 0;
    window.midTabs = new A.TabView({
        srcNode: '#midTabs',
        type: 'pills',
        on: {
            click: function(e){ loadList(e);
             					window.midTabsOn = this._getAttr('selection').get('index');
             				}
          }
      }      
    );
    window.midTabs.render();

	window.bottomTabs3 = new A.TabView({
        srcNode: '#bottomTabs3',
        type: 'pills',
        on: {
             click: function(e){ loadList(e); }
          }
      }      
    );
    window.bottomTabs3.render();
	

  window.careTmainTab = new A.TabView({
      srcNode: '#mainTab',
      type: 'pills'
    }
  );
  window.careTmainTab.render();
  
  A.on('domready', function( event ) {
   	try {
   		loadList(event,'#${first}');
   		loadList(event,'#myOccWork');
   		loadList(event,'#myNotes');
   		A.all('.tab-click').attr('tabindex',0);
   	} catch (e){}
   });
  
</aui:script>

<%@include file="/jsp/internal/actionsSupport2.jsp" %>
<%@include file="/jsp/im/compose.jsp" %>