package gov.va.oit.oed.vaww;

import java.util.Iterator;

import javax.xml.namespace.NamespaceContext;

public class UnattendedNameSpaceContext implements NamespaceContext {
	
	private static String CTX = "ctx";
	private static String IDM = "idm";
	private static String XSI = "xsi";
	private static String CTX_URL = "urn:hl7-org:v3";
	private static String XSI_URL = "http://www.w3.org/2001/XMLSchema-instance";
	private static String IDM_URL = "http://URL         .DNS";
	
	@Override
	public String getPrefix(String namespaceURI) {
		throw new UnsupportedOperationException();
	}
	
	@Override
	public Iterator<String> getPrefixes(String namespaceURI) {
		throw new UnsupportedOperationException();
	}
	
	@Override
	public String getNamespaceURI(String prefix) {
		if (CTX.equals(prefix)) {
			return CTX_URL;
		}
		if (IDM.equals(prefix)){
			return IDM_URL;
		}
		if (XSI.equals(prefix)) {
			return XSI_URL;
		}
		throw new IllegalArgumentException(prefix);
	}
}
