package gov.va.caret.workflow;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

//EXTRA actions with WORK-STATES that are specific to work type versus towards queue actions
	public enum WorkName {
		
		VERIFIED_GT35K ( "VERIFY_Q", true, QueAction.GT_35K_SEND_TO_SUPERVISOR_Q, QueAction.SEND_TO_CHAMP_VA ),//2.	And separate action we will send to Champ VA CBOPC Champ VA role
		VERIFIED_LT35K ( "VERIFY_Q", true, QueAction.SEND_TO_CHAMP_VA ),
		
		//In Verify Que, Stipend Error Work items verified/approved for payment Send to Supervisor Queue 
		STIPEND_ERROR ( "VERIFY_Q", QueAction.VERIFIED_APPROVED_FOR_PAYMENT ),
		
		//-------------------------------------------
////address, phone number, any needed SSN correction, name change (if needed), and/or any other required change
//			Note: CareT must identify work items as pertaining to either 1) Veteran 2) Caregiver 3) Veteran and Caregiver.
		V_INFO_CHANGE ( "VCG_INFO_MOD_Q", QueAction.REJECT_TO_REVIEW_QUEUE ),  
		C_INFO_CHANGE ( "VCG_INFO_MOD_Q", QueAction.REVIEW_VENDOR_UPDATE_COMPLETE ),
		VCG_INFO_CHANGE ( "VCG_INFO_MOD_Q", QueAction.REJECT_TO_REVIEW_QUEUE, QueAction.REVIEW_VENDOR_UPDATE_COMPLETE ),
		
	//-------------------------------------------	
		//primary health insurance, champVA Role
		INSURANCE_CHANGE ("PRIM_HEALTH_INS_Q"),
		TIER_UPDATE ("TIER_MOD_Q"), 

		INFO_CHANGE ("VCG_INFO_MOD_Q" ),
		VETERAN_ADDRESS_CHANGE ("VCG_INFO_MOD_Q" ),
		PII_CHANGE ("VCG_INFO_MOD_Q" ),

		APPROVED_DISPOSITION ("REVIEW_Q"),
		REINSTATED_DISPOSITION ("PRIM_REINST_Q"),
		REVOKED_DISPOSITION ("PRIM_REVOKE_Q"),
		
		REJECTED_PAYMENT,
		DUPLICATE_PAYMENT,
		LOST_CHECK,
		RECOUPMENT,  //Consideration Work Item / Consideration Queue
		HELD_PAYMENT,
		
		CSC_WORK;
	
		
		public List<QueAction> queAction;
		public List<QueAction> extraAction = Collections.EMPTY_LIST;
		boolean automatic;
		String queue;
		WorkName( ){ }
		
		WorkName( String que ){
			this.queAction = new ArrayList( OwnerQueue.valueOf(que).getActions() );
			this.queue = que;
		}
		
		WorkName( String que, QueAction... queAction ){
			this.extraAction = new ArrayList( Arrays.asList(queAction) );
			this.queAction = new ArrayList( OwnerQueue.valueOf(que).getActions() );
			this.queue = que;
		}
		
		WorkName( String que, boolean automatic, QueAction... queAction ){
			this.automatic = automatic;
			this.extraAction = new ArrayList( Arrays.asList(queAction) );
			this.queAction = new ArrayList( OwnerQueue.valueOf(que).getActions() );
			this.queue = que;
		}
		
		public List<QueAction> getActions (){
			return queAction;
		}
		
		public List<QueAction> getExtraActions (){
			return extraAction;
		}
		
		public long getQueueId(){
			if ( queue != null && !queue.isEmpty() ){
				return OwnerQueue.valueOf(queue).getQueueId();
			}
			return 0;
		}
	}