package gov.va.caret.service.persistence;

import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PropsKeys;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnmodifiableList;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.model.ModelListener;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;

import gov.va.caret.NoSuchWaivrException;
import gov.va.caret.model.Waivr;
import gov.va.caret.model.impl.WaivrImpl;
import gov.va.caret.model.impl.WaivrModelImpl;

import java.io.Serializable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * The persistence implementation for the waivr service.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author caret
 * @see WaivrPersistence
 * @see WaivrUtil
 * @generated
 */
public class WaivrPersistenceImpl extends BasePersistenceImpl<Waivr>
    implements WaivrPersistence {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. Always use {@link WaivrUtil} to access the waivr persistence. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this class.
     */
    public static final String FINDER_CLASS_NAME_ENTITY = WaivrImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY +
        ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY +
        ".List2";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_ALL = new FinderPath(WaivrModelImpl.ENTITY_CACHE_ENABLED,
            WaivrModelImpl.FINDER_CACHE_ENABLED, WaivrImpl.class,
            FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL = new FinderPath(WaivrModelImpl.ENTITY_CACHE_ENABLED,
            WaivrModelImpl.FINDER_CACHE_ENABLED, WaivrImpl.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_COUNT_ALL = new FinderPath(WaivrModelImpl.ENTITY_CACHE_ENABLED,
            WaivrModelImpl.FINDER_CACHE_ENABLED, Long.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
    private static final String _SQL_SELECT_WAIVR = "SELECT waivr FROM Waivr waivr";
    private static final String _SQL_COUNT_WAIVR = "SELECT COUNT(waivr) FROM Waivr waivr";
    private static final String _ORDER_BY_ENTITY_ALIAS = "waivr.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No Waivr exists with the primary key ";
    private static final boolean _HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE = GetterUtil.getBoolean(PropsUtil.get(
                PropsKeys.HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE));
    private static Log _log = LogFactoryUtil.getLog(WaivrPersistenceImpl.class);
    private static Waivr _nullWaivr = new WaivrImpl() {
            @Override
            public Object clone() {
                return this;
            }

            @Override
            public CacheModel<Waivr> toCacheModel() {
                return _nullWaivrCacheModel;
            }
        };

    private static CacheModel<Waivr> _nullWaivrCacheModel = new CacheModel<Waivr>() {
            @Override
            public Waivr toEntityModel() {
                return _nullWaivr;
            }
        };

    public WaivrPersistenceImpl() {
        setModelClass(Waivr.class);
    }

    /**
     * Caches the waivr in the entity cache if it is enabled.
     *
     * @param waivr the waivr
     */
    @Override
    public void cacheResult(Waivr waivr) {
        EntityCacheUtil.putResult(WaivrModelImpl.ENTITY_CACHE_ENABLED,
            WaivrImpl.class, waivr.getPrimaryKey(), waivr);

        waivr.resetOriginalValues();
    }

    /**
     * Caches the waivrs in the entity cache if it is enabled.
     *
     * @param waivrs the waivrs
     */
    @Override
    public void cacheResult(List<Waivr> waivrs) {
        for (Waivr waivr : waivrs) {
            if (EntityCacheUtil.getResult(WaivrModelImpl.ENTITY_CACHE_ENABLED,
                        WaivrImpl.class, waivr.getPrimaryKey()) == null) {
                cacheResult(waivr);
            } else {
                waivr.resetOriginalValues();
            }
        }
    }

    /**
     * Clears the cache for all waivrs.
     *
     * <p>
     * The {@link com.liferay.portal.kernel.dao.orm.EntityCache} and {@link com.liferay.portal.kernel.dao.orm.FinderCache} are both cleared by this method.
     * </p>
     */
    @Override
    public void clearCache() {
        if (_HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE) {
            CacheRegistryUtil.clear(WaivrImpl.class.getName());
        }

        EntityCacheUtil.clearCache(WaivrImpl.class.getName());

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    /**
     * Clears the cache for the waivr.
     *
     * <p>
     * The {@link com.liferay.portal.kernel.dao.orm.EntityCache} and {@link com.liferay.portal.kernel.dao.orm.FinderCache} are both cleared by this method.
     * </p>
     */
    @Override
    public void clearCache(Waivr waivr) {
        EntityCacheUtil.removeResult(WaivrModelImpl.ENTITY_CACHE_ENABLED,
            WaivrImpl.class, waivr.getPrimaryKey());

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    @Override
    public void clearCache(List<Waivr> waivrs) {
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);

        for (Waivr waivr : waivrs) {
            EntityCacheUtil.removeResult(WaivrModelImpl.ENTITY_CACHE_ENABLED,
                WaivrImpl.class, waivr.getPrimaryKey());
        }
    }

    /**
     * Creates a new waivr with the primary key. Does not add the waivr to the database.
     *
     * @param waivrId the primary key for the new waivr
     * @return the new waivr
     */
    @Override
    public Waivr create(long waivrId) {
        Waivr waivr = new WaivrImpl();

        waivr.setNew(true);
        waivr.setPrimaryKey(waivrId);

        return waivr;
    }

    /**
     * Removes the waivr with the primary key from the database. Also notifies the appropriate model listeners.
     *
     * @param waivrId the primary key of the waivr
     * @return the waivr that was removed
     * @throws gov.va.caret.NoSuchWaivrException if a waivr with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Waivr remove(long waivrId)
        throws NoSuchWaivrException, SystemException {
        return remove((Serializable) waivrId);
    }

    /**
     * Removes the waivr with the primary key from the database. Also notifies the appropriate model listeners.
     *
     * @param primaryKey the primary key of the waivr
     * @return the waivr that was removed
     * @throws gov.va.caret.NoSuchWaivrException if a waivr with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Waivr remove(Serializable primaryKey)
        throws NoSuchWaivrException, SystemException {
        Session session = null;

        try {
            session = openSession();

            Waivr waivr = (Waivr) session.get(WaivrImpl.class, primaryKey);

            if (waivr == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
                }

                throw new NoSuchWaivrException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY +
                    primaryKey);
            }

            return remove(waivr);
        } catch (NoSuchWaivrException nsee) {
            throw nsee;
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }
    }

    @Override
    protected Waivr removeImpl(Waivr waivr) throws SystemException {
        waivr = toUnwrappedModel(waivr);

        Session session = null;

        try {
            session = openSession();

            if (!session.contains(waivr)) {
                waivr = (Waivr) session.get(WaivrImpl.class,
                        waivr.getPrimaryKeyObj());
            }

            if (waivr != null) {
                session.delete(waivr);
            }
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }

        if (waivr != null) {
            clearCache(waivr);
        }

        return waivr;
    }

    @Override
    public Waivr updateImpl(gov.va.caret.model.Waivr waivr)
        throws SystemException {
        waivr = toUnwrappedModel(waivr);

        boolean isNew = waivr.isNew();

        Session session = null;

        try {
            session = openSession();

            if (waivr.isNew()) {
                session.save(waivr);

                waivr.setNew(false);
            } else {
                session.merge(waivr);
            }
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);

        if (isNew) {
            FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        }

        EntityCacheUtil.putResult(WaivrModelImpl.ENTITY_CACHE_ENABLED,
            WaivrImpl.class, waivr.getPrimaryKey(), waivr);

        return waivr;
    }

    protected Waivr toUnwrappedModel(Waivr waivr) {
        if (waivr instanceof WaivrImpl) {
            return waivr;
        }

        WaivrImpl waivrImpl = new WaivrImpl();

        waivrImpl.setNew(waivr.isNew());
        waivrImpl.setPrimaryKey(waivr.getPrimaryKey());

        waivrImpl.setWaivrId(waivr.getWaivrId());
        waivrImpl.setClassPk(waivr.getClassPk());
        waivrImpl.setAdjudication(waivr.getAdjudication());
        waivrImpl.setReason(waivr.getReason());
        waivrImpl.setNote(waivr.getNote());
        waivrImpl.setCreationDate(waivr.getCreationDate());
        waivrImpl.setCompletionDate(waivr.getCompletionDate());
        waivrImpl.setUserId(waivr.getUserId());

        return waivrImpl;
    }

    /**
     * Returns the waivr with the primary key or throws a {@link com.liferay.portal.NoSuchModelException} if it could not be found.
     *
     * @param primaryKey the primary key of the waivr
     * @return the waivr
     * @throws gov.va.caret.NoSuchWaivrException if a waivr with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Waivr findByPrimaryKey(Serializable primaryKey)
        throws NoSuchWaivrException, SystemException {
        Waivr waivr = fetchByPrimaryKey(primaryKey);

        if (waivr == null) {
            if (_log.isWarnEnabled()) {
                _log.warn(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }

            throw new NoSuchWaivrException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY +
                primaryKey);
        }

        return waivr;
    }

    /**
     * Returns the waivr with the primary key or throws a {@link gov.va.caret.NoSuchWaivrException} if it could not be found.
     *
     * @param waivrId the primary key of the waivr
     * @return the waivr
     * @throws gov.va.caret.NoSuchWaivrException if a waivr with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Waivr findByPrimaryKey(long waivrId)
        throws NoSuchWaivrException, SystemException {
        return findByPrimaryKey((Serializable) waivrId);
    }

    /**
     * Returns the waivr with the primary key or returns <code>null</code> if it could not be found.
     *
     * @param primaryKey the primary key of the waivr
     * @return the waivr, or <code>null</code> if a waivr with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Waivr fetchByPrimaryKey(Serializable primaryKey)
        throws SystemException {
        Waivr waivr = (Waivr) EntityCacheUtil.getResult(WaivrModelImpl.ENTITY_CACHE_ENABLED,
                WaivrImpl.class, primaryKey);

        if (waivr == _nullWaivr) {
            return null;
        }

        if (waivr == null) {
            Session session = null;

            try {
                session = openSession();

                waivr = (Waivr) session.get(WaivrImpl.class, primaryKey);

                if (waivr != null) {
                    cacheResult(waivr);
                } else {
                    EntityCacheUtil.putResult(WaivrModelImpl.ENTITY_CACHE_ENABLED,
                        WaivrImpl.class, primaryKey, _nullWaivr);
                }
            } catch (Exception e) {
                EntityCacheUtil.removeResult(WaivrModelImpl.ENTITY_CACHE_ENABLED,
                    WaivrImpl.class, primaryKey);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return waivr;
    }

    /**
     * Returns the waivr with the primary key or returns <code>null</code> if it could not be found.
     *
     * @param waivrId the primary key of the waivr
     * @return the waivr, or <code>null</code> if a waivr with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Waivr fetchByPrimaryKey(long waivrId) throws SystemException {
        return fetchByPrimaryKey((Serializable) waivrId);
    }

    /**
     * Returns all the waivrs.
     *
     * @return the waivrs
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<Waivr> findAll() throws SystemException {
        return findAll(QueryUtil.ALL_POS, QueryUtil.ALL_POS, null);
    }

    /**
     * Returns a range of all the waivrs.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.WaivrModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param start the lower bound of the range of waivrs
     * @param end the upper bound of the range of waivrs (not inclusive)
     * @return the range of waivrs
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<Waivr> findAll(int start, int end) throws SystemException {
        return findAll(start, end, null);
    }

    /**
     * Returns an ordered range of all the waivrs.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.WaivrModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param start the lower bound of the range of waivrs
     * @param end the upper bound of the range of waivrs (not inclusive)
     * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
     * @return the ordered range of waivrs
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<Waivr> findAll(int start, int end,
        OrderByComparator orderByComparator) throws SystemException {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;

        if ((start == QueryUtil.ALL_POS) && (end == QueryUtil.ALL_POS) &&
                (orderByComparator == null)) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL;
            finderArgs = FINDER_ARGS_EMPTY;
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_ALL;
            finderArgs = new Object[] { start, end, orderByComparator };
        }

        List<Waivr> list = (List<Waivr>) FinderCacheUtil.getResult(finderPath,
                finderArgs, this);

        if (list == null) {
            StringBundler query = null;
            String sql = null;

            if (orderByComparator != null) {
                query = new StringBundler(2 +
                        (orderByComparator.getOrderByFields().length * 3));

                query.append(_SQL_SELECT_WAIVR);

                appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS,
                    orderByComparator);

                sql = query.toString();
            } else {
                sql = _SQL_SELECT_WAIVR;

                if (pagination) {
                    sql = sql.concat(WaivrModelImpl.ORDER_BY_JPQL);
                }
            }

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                if (!pagination) {
                    list = (List<Waivr>) QueryUtil.list(q, getDialect(), start,
                            end, false);

                    Collections.sort(list);

                    list = new UnmodifiableList<Waivr>(list);
                } else {
                    list = (List<Waivr>) QueryUtil.list(q, getDialect(), start,
                            end);
                }

                cacheResult(list);

                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return list;
    }

    /**
     * Removes all the waivrs from the database.
     *
     * @throws SystemException if a system exception occurred
     */
    @Override
    public void removeAll() throws SystemException {
        for (Waivr waivr : findAll()) {
            remove(waivr);
        }
    }

    /**
     * Returns the number of waivrs.
     *
     * @return the number of waivrs
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int countAll() throws SystemException {
        Long count = (Long) FinderCacheUtil.getResult(FINDER_PATH_COUNT_ALL,
                FINDER_ARGS_EMPTY, this);

        if (count == null) {
            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(_SQL_COUNT_WAIVR);

                count = (Long) q.uniqueResult();

                FinderCacheUtil.putResult(FINDER_PATH_COUNT_ALL,
                    FINDER_ARGS_EMPTY, count);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_ALL,
                    FINDER_ARGS_EMPTY);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return count.intValue();
    }

    /**
     * Initializes the waivr persistence.
     */
    public void afterPropertiesSet() {
        String[] listenerClassNames = StringUtil.split(GetterUtil.getString(
                    com.liferay.util.service.ServiceProps.get(
                        "value.object.listener.gov.va.caret.model.Waivr")));

        if (listenerClassNames.length > 0) {
            try {
                List<ModelListener<Waivr>> listenersList = new ArrayList<ModelListener<Waivr>>();

                for (String listenerClassName : listenerClassNames) {
                    listenersList.add((ModelListener<Waivr>) InstanceFactory.newInstance(
                            getClassLoader(), listenerClassName));
                }

                listeners = listenersList.toArray(new ModelListener[listenersList.size()]);
            } catch (Exception e) {
                _log.error(e);
            }
        }
    }

    public void destroy() {
        EntityCacheUtil.removeCache(WaivrImpl.class.getName());
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}
