package gov.va.caret.service.persistence;

import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PropsKeys;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnmodifiableList;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.model.ModelListener;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;

import gov.va.caret.NoSuchVendrException;
import gov.va.caret.model.Vendr;
import gov.va.caret.model.impl.VendrImpl;
import gov.va.caret.model.impl.VendrModelImpl;

import java.io.Serializable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

/**
 * The persistence implementation for the vendr service.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author caret
 * @see VendrPersistence
 * @see VendrUtil
 * @generated
 */
public class VendrPersistenceImpl extends BasePersistenceImpl<Vendr>
    implements VendrPersistence {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. Always use {@link VendrUtil} to access the vendr persistence. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this class.
     */
    public static final String FINDER_CLASS_NAME_ENTITY = VendrImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY +
        ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY +
        ".List2";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_ALL = new FinderPath(VendrModelImpl.ENTITY_CACHE_ENABLED,
            VendrModelImpl.FINDER_CACHE_ENABLED, VendrImpl.class,
            FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL = new FinderPath(VendrModelImpl.ENTITY_CACHE_ENABLED,
            VendrModelImpl.FINDER_CACHE_ENABLED, VendrImpl.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_COUNT_ALL = new FinderPath(VendrModelImpl.ENTITY_CACHE_ENABLED,
            VendrModelImpl.FINDER_CACHE_ENABLED, Long.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_FEDTAXID = new FinderPath(VendrModelImpl.ENTITY_CACHE_ENABLED,
            VendrModelImpl.FINDER_CACHE_ENABLED, VendrImpl.class,
            FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByFedTaxId",
            new String[] {
                String.class.getName(),
                
            Integer.class.getName(), Integer.class.getName(),
                OrderByComparator.class.getName()
            });
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_FEDTAXID =
        new FinderPath(VendrModelImpl.ENTITY_CACHE_ENABLED,
            VendrModelImpl.FINDER_CACHE_ENABLED, VendrImpl.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByFedTaxId",
            new String[] { String.class.getName() },
            VendrModelImpl.FEDTAXID_COLUMN_BITMASK);
    public static final FinderPath FINDER_PATH_COUNT_BY_FEDTAXID = new FinderPath(VendrModelImpl.ENTITY_CACHE_ENABLED,
            VendrModelImpl.FINDER_CACHE_ENABLED, Long.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByFedTaxId",
            new String[] { String.class.getName() });
    private static final String _FINDER_COLUMN_FEDTAXID_FEDTAXID_1 = "vendr.fedTaxId IS NULL";
    private static final String _FINDER_COLUMN_FEDTAXID_FEDTAXID_2 = "vendr.fedTaxId = ?";
    private static final String _FINDER_COLUMN_FEDTAXID_FEDTAXID_3 = "(vendr.fedTaxId IS NULL OR vendr.fedTaxId = '')";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_LASTNAME = new FinderPath(VendrModelImpl.ENTITY_CACHE_ENABLED,
            VendrModelImpl.FINDER_CACHE_ENABLED, VendrImpl.class,
            FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByLastName",
            new String[] {
                String.class.getName(),
                
            Integer.class.getName(), Integer.class.getName(),
                OrderByComparator.class.getName()
            });
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_LASTNAME =
        new FinderPath(VendrModelImpl.ENTITY_CACHE_ENABLED,
            VendrModelImpl.FINDER_CACHE_ENABLED, VendrImpl.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByLastName",
            new String[] { String.class.getName() },
            VendrModelImpl.LASTNAME_COLUMN_BITMASK);
    public static final FinderPath FINDER_PATH_COUNT_BY_LASTNAME = new FinderPath(VendrModelImpl.ENTITY_CACHE_ENABLED,
            VendrModelImpl.FINDER_CACHE_ENABLED, Long.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByLastName",
            new String[] { String.class.getName() });
    private static final String _FINDER_COLUMN_LASTNAME_LASTNAME_1 = "vendr.lastName IS NULL";
    private static final String _FINDER_COLUMN_LASTNAME_LASTNAME_2 = "vendr.lastName = ?";
    private static final String _FINDER_COLUMN_LASTNAME_LASTNAME_3 = "(vendr.lastName IS NULL OR vendr.lastName = '')";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_FIRSTNAME =
        new FinderPath(VendrModelImpl.ENTITY_CACHE_ENABLED,
            VendrModelImpl.FINDER_CACHE_ENABLED, VendrImpl.class,
            FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByFirstName",
            new String[] {
                String.class.getName(),
                
            Integer.class.getName(), Integer.class.getName(),
                OrderByComparator.class.getName()
            });
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_FIRSTNAME =
        new FinderPath(VendrModelImpl.ENTITY_CACHE_ENABLED,
            VendrModelImpl.FINDER_CACHE_ENABLED, VendrImpl.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByFirstName",
            new String[] { String.class.getName() },
            VendrModelImpl.FIRSTNAME_COLUMN_BITMASK);
    public static final FinderPath FINDER_PATH_COUNT_BY_FIRSTNAME = new FinderPath(VendrModelImpl.ENTITY_CACHE_ENABLED,
            VendrModelImpl.FINDER_CACHE_ENABLED, Long.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByFirstName",
            new String[] { String.class.getName() });
    private static final String _FINDER_COLUMN_FIRSTNAME_FIRSTNAME_1 = "vendr.firstName IS NULL";
    private static final String _FINDER_COLUMN_FIRSTNAME_FIRSTNAME_2 = "vendr.firstName = ?";
    private static final String _FINDER_COLUMN_FIRSTNAME_FIRSTNAME_3 = "(vendr.firstName IS NULL OR vendr.firstName = '')";
    private static final String _SQL_SELECT_VENDR = "SELECT vendr FROM Vendr vendr";
    private static final String _SQL_SELECT_VENDR_WHERE = "SELECT vendr FROM Vendr vendr WHERE ";
    private static final String _SQL_COUNT_VENDR = "SELECT COUNT(vendr) FROM Vendr vendr";
    private static final String _SQL_COUNT_VENDR_WHERE = "SELECT COUNT(vendr) FROM Vendr vendr WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "vendr.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No Vendr exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No Vendr exists with the key {";
    private static final boolean _HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE = GetterUtil.getBoolean(PropsUtil.get(
                PropsKeys.HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE));
    private static Log _log = LogFactoryUtil.getLog(VendrPersistenceImpl.class);
    private static Set<String> _badColumnNames = SetUtil.fromArray(new String[] {
                "state"
            });
    private static Vendr _nullVendr = new VendrImpl() {
            @Override
            public Object clone() {
                return this;
            }

            @Override
            public CacheModel<Vendr> toCacheModel() {
                return _nullVendrCacheModel;
            }
        };

    private static CacheModel<Vendr> _nullVendrCacheModel = new CacheModel<Vendr>() {
            @Override
            public Vendr toEntityModel() {
                return _nullVendr;
            }
        };

    public VendrPersistenceImpl() {
        setModelClass(Vendr.class);
    }

    /**
     * Returns all the vendrs where fedTaxId = &#63;.
     *
     * @param fedTaxId the fed tax ID
     * @return the matching vendrs
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<Vendr> findByFedTaxId(String fedTaxId)
        throws SystemException {
        return findByFedTaxId(fedTaxId, QueryUtil.ALL_POS, QueryUtil.ALL_POS,
            null);
    }

    /**
     * Returns a range of all the vendrs where fedTaxId = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.VendrModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param fedTaxId the fed tax ID
     * @param start the lower bound of the range of vendrs
     * @param end the upper bound of the range of vendrs (not inclusive)
     * @return the range of matching vendrs
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<Vendr> findByFedTaxId(String fedTaxId, int start, int end)
        throws SystemException {
        return findByFedTaxId(fedTaxId, start, end, null);
    }

    /**
     * Returns an ordered range of all the vendrs where fedTaxId = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.VendrModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param fedTaxId the fed tax ID
     * @param start the lower bound of the range of vendrs
     * @param end the upper bound of the range of vendrs (not inclusive)
     * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
     * @return the ordered range of matching vendrs
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<Vendr> findByFedTaxId(String fedTaxId, int start, int end,
        OrderByComparator orderByComparator) throws SystemException {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;

        if ((start == QueryUtil.ALL_POS) && (end == QueryUtil.ALL_POS) &&
                (orderByComparator == null)) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_FEDTAXID;
            finderArgs = new Object[] { fedTaxId };
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_FEDTAXID;
            finderArgs = new Object[] { fedTaxId, start, end, orderByComparator };
        }

        List<Vendr> list = (List<Vendr>) FinderCacheUtil.getResult(finderPath,
                finderArgs, this);

        if ((list != null) && !list.isEmpty()) {
            for (Vendr vendr : list) {
                if (!Validator.equals(fedTaxId, vendr.getFedTaxId())) {
                    list = null;

                    break;
                }
            }
        }

        if (list == null) {
            StringBundler query = null;

            if (orderByComparator != null) {
                query = new StringBundler(3 +
                        (orderByComparator.getOrderByFields().length * 3));
            } else {
                query = new StringBundler(3);
            }

            query.append(_SQL_SELECT_VENDR_WHERE);

            boolean bindFedTaxId = false;

            if (fedTaxId == null) {
                query.append(_FINDER_COLUMN_FEDTAXID_FEDTAXID_1);
            } else if (fedTaxId.equals(StringPool.BLANK)) {
                query.append(_FINDER_COLUMN_FEDTAXID_FEDTAXID_3);
            } else {
                bindFedTaxId = true;

                query.append(_FINDER_COLUMN_FEDTAXID_FEDTAXID_2);
            }

            if (orderByComparator != null) {
                appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS,
                    orderByComparator);
            } else
             if (pagination) {
                query.append(VendrModelImpl.ORDER_BY_JPQL);
            }

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                if (bindFedTaxId) {
                    qPos.add(fedTaxId);
                }

                if (!pagination) {
                    list = (List<Vendr>) QueryUtil.list(q, getDialect(), start,
                            end, false);

                    Collections.sort(list);

                    list = new UnmodifiableList<Vendr>(list);
                } else {
                    list = (List<Vendr>) QueryUtil.list(q, getDialect(), start,
                            end);
                }

                cacheResult(list);

                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return list;
    }

    /**
     * Returns the first vendr in the ordered set where fedTaxId = &#63;.
     *
     * @param fedTaxId the fed tax ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching vendr
     * @throws gov.va.caret.NoSuchVendrException if a matching vendr could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Vendr findByFedTaxId_First(String fedTaxId,
        OrderByComparator orderByComparator)
        throws NoSuchVendrException, SystemException {
        Vendr vendr = fetchByFedTaxId_First(fedTaxId, orderByComparator);

        if (vendr != null) {
            return vendr;
        }

        StringBundler msg = new StringBundler(4);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("fedTaxId=");
        msg.append(fedTaxId);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchVendrException(msg.toString());
    }

    /**
     * Returns the first vendr in the ordered set where fedTaxId = &#63;.
     *
     * @param fedTaxId the fed tax ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching vendr, or <code>null</code> if a matching vendr could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Vendr fetchByFedTaxId_First(String fedTaxId,
        OrderByComparator orderByComparator) throws SystemException {
        List<Vendr> list = findByFedTaxId(fedTaxId, 0, 1, orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the last vendr in the ordered set where fedTaxId = &#63;.
     *
     * @param fedTaxId the fed tax ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching vendr
     * @throws gov.va.caret.NoSuchVendrException if a matching vendr could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Vendr findByFedTaxId_Last(String fedTaxId,
        OrderByComparator orderByComparator)
        throws NoSuchVendrException, SystemException {
        Vendr vendr = fetchByFedTaxId_Last(fedTaxId, orderByComparator);

        if (vendr != null) {
            return vendr;
        }

        StringBundler msg = new StringBundler(4);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("fedTaxId=");
        msg.append(fedTaxId);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchVendrException(msg.toString());
    }

    /**
     * Returns the last vendr in the ordered set where fedTaxId = &#63;.
     *
     * @param fedTaxId the fed tax ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching vendr, or <code>null</code> if a matching vendr could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Vendr fetchByFedTaxId_Last(String fedTaxId,
        OrderByComparator orderByComparator) throws SystemException {
        int count = countByFedTaxId(fedTaxId);

        if (count == 0) {
            return null;
        }

        List<Vendr> list = findByFedTaxId(fedTaxId, count - 1, count,
                orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the vendrs before and after the current vendr in the ordered set where fedTaxId = &#63;.
     *
     * @param vendrId the primary key of the current vendr
     * @param fedTaxId the fed tax ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the previous, current, and next vendr
     * @throws gov.va.caret.NoSuchVendrException if a vendr with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Vendr[] findByFedTaxId_PrevAndNext(long vendrId, String fedTaxId,
        OrderByComparator orderByComparator)
        throws NoSuchVendrException, SystemException {
        Vendr vendr = findByPrimaryKey(vendrId);

        Session session = null;

        try {
            session = openSession();

            Vendr[] array = new VendrImpl[3];

            array[0] = getByFedTaxId_PrevAndNext(session, vendr, fedTaxId,
                    orderByComparator, true);

            array[1] = vendr;

            array[2] = getByFedTaxId_PrevAndNext(session, vendr, fedTaxId,
                    orderByComparator, false);

            return array;
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }
    }

    protected Vendr getByFedTaxId_PrevAndNext(Session session, Vendr vendr,
        String fedTaxId, OrderByComparator orderByComparator, boolean previous) {
        StringBundler query = null;

        if (orderByComparator != null) {
            query = new StringBundler(6 +
                    (orderByComparator.getOrderByFields().length * 6));
        } else {
            query = new StringBundler(3);
        }

        query.append(_SQL_SELECT_VENDR_WHERE);

        boolean bindFedTaxId = false;

        if (fedTaxId == null) {
            query.append(_FINDER_COLUMN_FEDTAXID_FEDTAXID_1);
        } else if (fedTaxId.equals(StringPool.BLANK)) {
            query.append(_FINDER_COLUMN_FEDTAXID_FEDTAXID_3);
        } else {
            bindFedTaxId = true;

            query.append(_FINDER_COLUMN_FEDTAXID_FEDTAXID_2);
        }

        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();

            if (orderByConditionFields.length > 0) {
                query.append(WHERE_AND);
            }

            for (int i = 0; i < orderByConditionFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);

                if ((i + 1) < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN_HAS_NEXT);
                    } else {
                        query.append(WHERE_LESSER_THAN_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN);
                    } else {
                        query.append(WHERE_LESSER_THAN);
                    }
                }
            }

            query.append(ORDER_BY_CLAUSE);

            String[] orderByFields = orderByComparator.getOrderByFields();

            for (int i = 0; i < orderByFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);

                if ((i + 1) < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC_HAS_NEXT);
                    } else {
                        query.append(ORDER_BY_DESC_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC);
                    } else {
                        query.append(ORDER_BY_DESC);
                    }
                }
            }
        } else {
            query.append(VendrModelImpl.ORDER_BY_JPQL);
        }

        String sql = query.toString();

        Query q = session.createQuery(sql);

        q.setFirstResult(0);
        q.setMaxResults(2);

        QueryPos qPos = QueryPos.getInstance(q);

        if (bindFedTaxId) {
            qPos.add(fedTaxId);
        }

        if (orderByComparator != null) {
            Object[] values = orderByComparator.getOrderByConditionValues(vendr);

            for (Object value : values) {
                qPos.add(value);
            }
        }

        List<Vendr> list = q.list();

        if (list.size() == 2) {
            return list.get(1);
        } else {
            return null;
        }
    }

    /**
     * Removes all the vendrs where fedTaxId = &#63; from the database.
     *
     * @param fedTaxId the fed tax ID
     * @throws SystemException if a system exception occurred
     */
    @Override
    public void removeByFedTaxId(String fedTaxId) throws SystemException {
        for (Vendr vendr : findByFedTaxId(fedTaxId, QueryUtil.ALL_POS,
                QueryUtil.ALL_POS, null)) {
            remove(vendr);
        }
    }

    /**
     * Returns the number of vendrs where fedTaxId = &#63;.
     *
     * @param fedTaxId the fed tax ID
     * @return the number of matching vendrs
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int countByFedTaxId(String fedTaxId) throws SystemException {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_FEDTAXID;

        Object[] finderArgs = new Object[] { fedTaxId };

        Long count = (Long) FinderCacheUtil.getResult(finderPath, finderArgs,
                this);

        if (count == null) {
            StringBundler query = new StringBundler(2);

            query.append(_SQL_COUNT_VENDR_WHERE);

            boolean bindFedTaxId = false;

            if (fedTaxId == null) {
                query.append(_FINDER_COLUMN_FEDTAXID_FEDTAXID_1);
            } else if (fedTaxId.equals(StringPool.BLANK)) {
                query.append(_FINDER_COLUMN_FEDTAXID_FEDTAXID_3);
            } else {
                bindFedTaxId = true;

                query.append(_FINDER_COLUMN_FEDTAXID_FEDTAXID_2);
            }

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                if (bindFedTaxId) {
                    qPos.add(fedTaxId);
                }

                count = (Long) q.uniqueResult();

                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return count.intValue();
    }

    /**
     * Returns all the vendrs where lastName = &#63;.
     *
     * @param lastName the last name
     * @return the matching vendrs
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<Vendr> findByLastName(String lastName)
        throws SystemException {
        return findByLastName(lastName, QueryUtil.ALL_POS, QueryUtil.ALL_POS,
            null);
    }

    /**
     * Returns a range of all the vendrs where lastName = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.VendrModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param lastName the last name
     * @param start the lower bound of the range of vendrs
     * @param end the upper bound of the range of vendrs (not inclusive)
     * @return the range of matching vendrs
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<Vendr> findByLastName(String lastName, int start, int end)
        throws SystemException {
        return findByLastName(lastName, start, end, null);
    }

    /**
     * Returns an ordered range of all the vendrs where lastName = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.VendrModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param lastName the last name
     * @param start the lower bound of the range of vendrs
     * @param end the upper bound of the range of vendrs (not inclusive)
     * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
     * @return the ordered range of matching vendrs
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<Vendr> findByLastName(String lastName, int start, int end,
        OrderByComparator orderByComparator) throws SystemException {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;

        if ((start == QueryUtil.ALL_POS) && (end == QueryUtil.ALL_POS) &&
                (orderByComparator == null)) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_LASTNAME;
            finderArgs = new Object[] { lastName };
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_LASTNAME;
            finderArgs = new Object[] { lastName, start, end, orderByComparator };
        }

        List<Vendr> list = (List<Vendr>) FinderCacheUtil.getResult(finderPath,
                finderArgs, this);

        if ((list != null) && !list.isEmpty()) {
            for (Vendr vendr : list) {
                if (!Validator.equals(lastName, vendr.getLastName())) {
                    list = null;

                    break;
                }
            }
        }

        if (list == null) {
            StringBundler query = null;

            if (orderByComparator != null) {
                query = new StringBundler(3 +
                        (orderByComparator.getOrderByFields().length * 3));
            } else {
                query = new StringBundler(3);
            }

            query.append(_SQL_SELECT_VENDR_WHERE);

            boolean bindLastName = false;

            if (lastName == null) {
                query.append(_FINDER_COLUMN_LASTNAME_LASTNAME_1);
            } else if (lastName.equals(StringPool.BLANK)) {
                query.append(_FINDER_COLUMN_LASTNAME_LASTNAME_3);
            } else {
                bindLastName = true;

                query.append(_FINDER_COLUMN_LASTNAME_LASTNAME_2);
            }

            if (orderByComparator != null) {
                appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS,
                    orderByComparator);
            } else
             if (pagination) {
                query.append(VendrModelImpl.ORDER_BY_JPQL);
            }

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                if (bindLastName) {
                    qPos.add(lastName);
                }

                if (!pagination) {
                    list = (List<Vendr>) QueryUtil.list(q, getDialect(), start,
                            end, false);

                    Collections.sort(list);

                    list = new UnmodifiableList<Vendr>(list);
                } else {
                    list = (List<Vendr>) QueryUtil.list(q, getDialect(), start,
                            end);
                }

                cacheResult(list);

                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return list;
    }

    /**
     * Returns the first vendr in the ordered set where lastName = &#63;.
     *
     * @param lastName the last name
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching vendr
     * @throws gov.va.caret.NoSuchVendrException if a matching vendr could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Vendr findByLastName_First(String lastName,
        OrderByComparator orderByComparator)
        throws NoSuchVendrException, SystemException {
        Vendr vendr = fetchByLastName_First(lastName, orderByComparator);

        if (vendr != null) {
            return vendr;
        }

        StringBundler msg = new StringBundler(4);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("lastName=");
        msg.append(lastName);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchVendrException(msg.toString());
    }

    /**
     * Returns the first vendr in the ordered set where lastName = &#63;.
     *
     * @param lastName the last name
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching vendr, or <code>null</code> if a matching vendr could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Vendr fetchByLastName_First(String lastName,
        OrderByComparator orderByComparator) throws SystemException {
        List<Vendr> list = findByLastName(lastName, 0, 1, orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the last vendr in the ordered set where lastName = &#63;.
     *
     * @param lastName the last name
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching vendr
     * @throws gov.va.caret.NoSuchVendrException if a matching vendr could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Vendr findByLastName_Last(String lastName,
        OrderByComparator orderByComparator)
        throws NoSuchVendrException, SystemException {
        Vendr vendr = fetchByLastName_Last(lastName, orderByComparator);

        if (vendr != null) {
            return vendr;
        }

        StringBundler msg = new StringBundler(4);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("lastName=");
        msg.append(lastName);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchVendrException(msg.toString());
    }

    /**
     * Returns the last vendr in the ordered set where lastName = &#63;.
     *
     * @param lastName the last name
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching vendr, or <code>null</code> if a matching vendr could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Vendr fetchByLastName_Last(String lastName,
        OrderByComparator orderByComparator) throws SystemException {
        int count = countByLastName(lastName);

        if (count == 0) {
            return null;
        }

        List<Vendr> list = findByLastName(lastName, count - 1, count,
                orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the vendrs before and after the current vendr in the ordered set where lastName = &#63;.
     *
     * @param vendrId the primary key of the current vendr
     * @param lastName the last name
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the previous, current, and next vendr
     * @throws gov.va.caret.NoSuchVendrException if a vendr with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Vendr[] findByLastName_PrevAndNext(long vendrId, String lastName,
        OrderByComparator orderByComparator)
        throws NoSuchVendrException, SystemException {
        Vendr vendr = findByPrimaryKey(vendrId);

        Session session = null;

        try {
            session = openSession();

            Vendr[] array = new VendrImpl[3];

            array[0] = getByLastName_PrevAndNext(session, vendr, lastName,
                    orderByComparator, true);

            array[1] = vendr;

            array[2] = getByLastName_PrevAndNext(session, vendr, lastName,
                    orderByComparator, false);

            return array;
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }
    }

    protected Vendr getByLastName_PrevAndNext(Session session, Vendr vendr,
        String lastName, OrderByComparator orderByComparator, boolean previous) {
        StringBundler query = null;

        if (orderByComparator != null) {
            query = new StringBundler(6 +
                    (orderByComparator.getOrderByFields().length * 6));
        } else {
            query = new StringBundler(3);
        }

        query.append(_SQL_SELECT_VENDR_WHERE);

        boolean bindLastName = false;

        if (lastName == null) {
            query.append(_FINDER_COLUMN_LASTNAME_LASTNAME_1);
        } else if (lastName.equals(StringPool.BLANK)) {
            query.append(_FINDER_COLUMN_LASTNAME_LASTNAME_3);
        } else {
            bindLastName = true;

            query.append(_FINDER_COLUMN_LASTNAME_LASTNAME_2);
        }

        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();

            if (orderByConditionFields.length > 0) {
                query.append(WHERE_AND);
            }

            for (int i = 0; i < orderByConditionFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);

                if ((i + 1) < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN_HAS_NEXT);
                    } else {
                        query.append(WHERE_LESSER_THAN_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN);
                    } else {
                        query.append(WHERE_LESSER_THAN);
                    }
                }
            }

            query.append(ORDER_BY_CLAUSE);

            String[] orderByFields = orderByComparator.getOrderByFields();

            for (int i = 0; i < orderByFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);

                if ((i + 1) < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC_HAS_NEXT);
                    } else {
                        query.append(ORDER_BY_DESC_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC);
                    } else {
                        query.append(ORDER_BY_DESC);
                    }
                }
            }
        } else {
            query.append(VendrModelImpl.ORDER_BY_JPQL);
        }

        String sql = query.toString();

        Query q = session.createQuery(sql);

        q.setFirstResult(0);
        q.setMaxResults(2);

        QueryPos qPos = QueryPos.getInstance(q);

        if (bindLastName) {
            qPos.add(lastName);
        }

        if (orderByComparator != null) {
            Object[] values = orderByComparator.getOrderByConditionValues(vendr);

            for (Object value : values) {
                qPos.add(value);
            }
        }

        List<Vendr> list = q.list();

        if (list.size() == 2) {
            return list.get(1);
        } else {
            return null;
        }
    }

    /**
     * Removes all the vendrs where lastName = &#63; from the database.
     *
     * @param lastName the last name
     * @throws SystemException if a system exception occurred
     */
    @Override
    public void removeByLastName(String lastName) throws SystemException {
        for (Vendr vendr : findByLastName(lastName, QueryUtil.ALL_POS,
                QueryUtil.ALL_POS, null)) {
            remove(vendr);
        }
    }

    /**
     * Returns the number of vendrs where lastName = &#63;.
     *
     * @param lastName the last name
     * @return the number of matching vendrs
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int countByLastName(String lastName) throws SystemException {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_LASTNAME;

        Object[] finderArgs = new Object[] { lastName };

        Long count = (Long) FinderCacheUtil.getResult(finderPath, finderArgs,
                this);

        if (count == null) {
            StringBundler query = new StringBundler(2);

            query.append(_SQL_COUNT_VENDR_WHERE);

            boolean bindLastName = false;

            if (lastName == null) {
                query.append(_FINDER_COLUMN_LASTNAME_LASTNAME_1);
            } else if (lastName.equals(StringPool.BLANK)) {
                query.append(_FINDER_COLUMN_LASTNAME_LASTNAME_3);
            } else {
                bindLastName = true;

                query.append(_FINDER_COLUMN_LASTNAME_LASTNAME_2);
            }

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                if (bindLastName) {
                    qPos.add(lastName);
                }

                count = (Long) q.uniqueResult();

                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return count.intValue();
    }

    /**
     * Returns all the vendrs where firstName = &#63;.
     *
     * @param firstName the first name
     * @return the matching vendrs
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<Vendr> findByFirstName(String firstName)
        throws SystemException {
        return findByFirstName(firstName, QueryUtil.ALL_POS, QueryUtil.ALL_POS,
            null);
    }

    /**
     * Returns a range of all the vendrs where firstName = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.VendrModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param firstName the first name
     * @param start the lower bound of the range of vendrs
     * @param end the upper bound of the range of vendrs (not inclusive)
     * @return the range of matching vendrs
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<Vendr> findByFirstName(String firstName, int start, int end)
        throws SystemException {
        return findByFirstName(firstName, start, end, null);
    }

    /**
     * Returns an ordered range of all the vendrs where firstName = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.VendrModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param firstName the first name
     * @param start the lower bound of the range of vendrs
     * @param end the upper bound of the range of vendrs (not inclusive)
     * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
     * @return the ordered range of matching vendrs
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<Vendr> findByFirstName(String firstName, int start, int end,
        OrderByComparator orderByComparator) throws SystemException {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;

        if ((start == QueryUtil.ALL_POS) && (end == QueryUtil.ALL_POS) &&
                (orderByComparator == null)) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_FIRSTNAME;
            finderArgs = new Object[] { firstName };
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_FIRSTNAME;
            finderArgs = new Object[] { firstName, start, end, orderByComparator };
        }

        List<Vendr> list = (List<Vendr>) FinderCacheUtil.getResult(finderPath,
                finderArgs, this);

        if ((list != null) && !list.isEmpty()) {
            for (Vendr vendr : list) {
                if (!Validator.equals(firstName, vendr.getFirstName())) {
                    list = null;

                    break;
                }
            }
        }

        if (list == null) {
            StringBundler query = null;

            if (orderByComparator != null) {
                query = new StringBundler(3 +
                        (orderByComparator.getOrderByFields().length * 3));
            } else {
                query = new StringBundler(3);
            }

            query.append(_SQL_SELECT_VENDR_WHERE);

            boolean bindFirstName = false;

            if (firstName == null) {
                query.append(_FINDER_COLUMN_FIRSTNAME_FIRSTNAME_1);
            } else if (firstName.equals(StringPool.BLANK)) {
                query.append(_FINDER_COLUMN_FIRSTNAME_FIRSTNAME_3);
            } else {
                bindFirstName = true;

                query.append(_FINDER_COLUMN_FIRSTNAME_FIRSTNAME_2);
            }

            if (orderByComparator != null) {
                appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS,
                    orderByComparator);
            } else
             if (pagination) {
                query.append(VendrModelImpl.ORDER_BY_JPQL);
            }

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                if (bindFirstName) {
                    qPos.add(firstName);
                }

                if (!pagination) {
                    list = (List<Vendr>) QueryUtil.list(q, getDialect(), start,
                            end, false);

                    Collections.sort(list);

                    list = new UnmodifiableList<Vendr>(list);
                } else {
                    list = (List<Vendr>) QueryUtil.list(q, getDialect(), start,
                            end);
                }

                cacheResult(list);

                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return list;
    }

    /**
     * Returns the first vendr in the ordered set where firstName = &#63;.
     *
     * @param firstName the first name
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching vendr
     * @throws gov.va.caret.NoSuchVendrException if a matching vendr could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Vendr findByFirstName_First(String firstName,
        OrderByComparator orderByComparator)
        throws NoSuchVendrException, SystemException {
        Vendr vendr = fetchByFirstName_First(firstName, orderByComparator);

        if (vendr != null) {
            return vendr;
        }

        StringBundler msg = new StringBundler(4);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("firstName=");
        msg.append(firstName);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchVendrException(msg.toString());
    }

    /**
     * Returns the first vendr in the ordered set where firstName = &#63;.
     *
     * @param firstName the first name
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching vendr, or <code>null</code> if a matching vendr could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Vendr fetchByFirstName_First(String firstName,
        OrderByComparator orderByComparator) throws SystemException {
        List<Vendr> list = findByFirstName(firstName, 0, 1, orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the last vendr in the ordered set where firstName = &#63;.
     *
     * @param firstName the first name
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching vendr
     * @throws gov.va.caret.NoSuchVendrException if a matching vendr could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Vendr findByFirstName_Last(String firstName,
        OrderByComparator orderByComparator)
        throws NoSuchVendrException, SystemException {
        Vendr vendr = fetchByFirstName_Last(firstName, orderByComparator);

        if (vendr != null) {
            return vendr;
        }

        StringBundler msg = new StringBundler(4);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("firstName=");
        msg.append(firstName);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchVendrException(msg.toString());
    }

    /**
     * Returns the last vendr in the ordered set where firstName = &#63;.
     *
     * @param firstName the first name
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching vendr, or <code>null</code> if a matching vendr could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Vendr fetchByFirstName_Last(String firstName,
        OrderByComparator orderByComparator) throws SystemException {
        int count = countByFirstName(firstName);

        if (count == 0) {
            return null;
        }

        List<Vendr> list = findByFirstName(firstName, count - 1, count,
                orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the vendrs before and after the current vendr in the ordered set where firstName = &#63;.
     *
     * @param vendrId the primary key of the current vendr
     * @param firstName the first name
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the previous, current, and next vendr
     * @throws gov.va.caret.NoSuchVendrException if a vendr with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Vendr[] findByFirstName_PrevAndNext(long vendrId, String firstName,
        OrderByComparator orderByComparator)
        throws NoSuchVendrException, SystemException {
        Vendr vendr = findByPrimaryKey(vendrId);

        Session session = null;

        try {
            session = openSession();

            Vendr[] array = new VendrImpl[3];

            array[0] = getByFirstName_PrevAndNext(session, vendr, firstName,
                    orderByComparator, true);

            array[1] = vendr;

            array[2] = getByFirstName_PrevAndNext(session, vendr, firstName,
                    orderByComparator, false);

            return array;
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }
    }

    protected Vendr getByFirstName_PrevAndNext(Session session, Vendr vendr,
        String firstName, OrderByComparator orderByComparator, boolean previous) {
        StringBundler query = null;

        if (orderByComparator != null) {
            query = new StringBundler(6 +
                    (orderByComparator.getOrderByFields().length * 6));
        } else {
            query = new StringBundler(3);
        }

        query.append(_SQL_SELECT_VENDR_WHERE);

        boolean bindFirstName = false;

        if (firstName == null) {
            query.append(_FINDER_COLUMN_FIRSTNAME_FIRSTNAME_1);
        } else if (firstName.equals(StringPool.BLANK)) {
            query.append(_FINDER_COLUMN_FIRSTNAME_FIRSTNAME_3);
        } else {
            bindFirstName = true;

            query.append(_FINDER_COLUMN_FIRSTNAME_FIRSTNAME_2);
        }

        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();

            if (orderByConditionFields.length > 0) {
                query.append(WHERE_AND);
            }

            for (int i = 0; i < orderByConditionFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);

                if ((i + 1) < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN_HAS_NEXT);
                    } else {
                        query.append(WHERE_LESSER_THAN_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN);
                    } else {
                        query.append(WHERE_LESSER_THAN);
                    }
                }
            }

            query.append(ORDER_BY_CLAUSE);

            String[] orderByFields = orderByComparator.getOrderByFields();

            for (int i = 0; i < orderByFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);

                if ((i + 1) < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC_HAS_NEXT);
                    } else {
                        query.append(ORDER_BY_DESC_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC);
                    } else {
                        query.append(ORDER_BY_DESC);
                    }
                }
            }
        } else {
            query.append(VendrModelImpl.ORDER_BY_JPQL);
        }

        String sql = query.toString();

        Query q = session.createQuery(sql);

        q.setFirstResult(0);
        q.setMaxResults(2);

        QueryPos qPos = QueryPos.getInstance(q);

        if (bindFirstName) {
            qPos.add(firstName);
        }

        if (orderByComparator != null) {
            Object[] values = orderByComparator.getOrderByConditionValues(vendr);

            for (Object value : values) {
                qPos.add(value);
            }
        }

        List<Vendr> list = q.list();

        if (list.size() == 2) {
            return list.get(1);
        } else {
            return null;
        }
    }

    /**
     * Removes all the vendrs where firstName = &#63; from the database.
     *
     * @param firstName the first name
     * @throws SystemException if a system exception occurred
     */
    @Override
    public void removeByFirstName(String firstName) throws SystemException {
        for (Vendr vendr : findByFirstName(firstName, QueryUtil.ALL_POS,
                QueryUtil.ALL_POS, null)) {
            remove(vendr);
        }
    }

    /**
     * Returns the number of vendrs where firstName = &#63;.
     *
     * @param firstName the first name
     * @return the number of matching vendrs
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int countByFirstName(String firstName) throws SystemException {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_FIRSTNAME;

        Object[] finderArgs = new Object[] { firstName };

        Long count = (Long) FinderCacheUtil.getResult(finderPath, finderArgs,
                this);

        if (count == null) {
            StringBundler query = new StringBundler(2);

            query.append(_SQL_COUNT_VENDR_WHERE);

            boolean bindFirstName = false;

            if (firstName == null) {
                query.append(_FINDER_COLUMN_FIRSTNAME_FIRSTNAME_1);
            } else if (firstName.equals(StringPool.BLANK)) {
                query.append(_FINDER_COLUMN_FIRSTNAME_FIRSTNAME_3);
            } else {
                bindFirstName = true;

                query.append(_FINDER_COLUMN_FIRSTNAME_FIRSTNAME_2);
            }

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                if (bindFirstName) {
                    qPos.add(firstName);
                }

                count = (Long) q.uniqueResult();

                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return count.intValue();
    }

    /**
     * Caches the vendr in the entity cache if it is enabled.
     *
     * @param vendr the vendr
     */
    @Override
    public void cacheResult(Vendr vendr) {
        EntityCacheUtil.putResult(VendrModelImpl.ENTITY_CACHE_ENABLED,
            VendrImpl.class, vendr.getPrimaryKey(), vendr);

        vendr.resetOriginalValues();
    }

    /**
     * Caches the vendrs in the entity cache if it is enabled.
     *
     * @param vendrs the vendrs
     */
    @Override
    public void cacheResult(List<Vendr> vendrs) {
        for (Vendr vendr : vendrs) {
            if (EntityCacheUtil.getResult(VendrModelImpl.ENTITY_CACHE_ENABLED,
                        VendrImpl.class, vendr.getPrimaryKey()) == null) {
                cacheResult(vendr);
            } else {
                vendr.resetOriginalValues();
            }
        }
    }

    /**
     * Clears the cache for all vendrs.
     *
     * <p>
     * The {@link com.liferay.portal.kernel.dao.orm.EntityCache} and {@link com.liferay.portal.kernel.dao.orm.FinderCache} are both cleared by this method.
     * </p>
     */
    @Override
    public void clearCache() {
        if (_HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE) {
            CacheRegistryUtil.clear(VendrImpl.class.getName());
        }

        EntityCacheUtil.clearCache(VendrImpl.class.getName());

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    /**
     * Clears the cache for the vendr.
     *
     * <p>
     * The {@link com.liferay.portal.kernel.dao.orm.EntityCache} and {@link com.liferay.portal.kernel.dao.orm.FinderCache} are both cleared by this method.
     * </p>
     */
    @Override
    public void clearCache(Vendr vendr) {
        EntityCacheUtil.removeResult(VendrModelImpl.ENTITY_CACHE_ENABLED,
            VendrImpl.class, vendr.getPrimaryKey());

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    @Override
    public void clearCache(List<Vendr> vendrs) {
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);

        for (Vendr vendr : vendrs) {
            EntityCacheUtil.removeResult(VendrModelImpl.ENTITY_CACHE_ENABLED,
                VendrImpl.class, vendr.getPrimaryKey());
        }
    }

    /**
     * Creates a new vendr with the primary key. Does not add the vendr to the database.
     *
     * @param vendrId the primary key for the new vendr
     * @return the new vendr
     */
    @Override
    public Vendr create(long vendrId) {
        Vendr vendr = new VendrImpl();

        vendr.setNew(true);
        vendr.setPrimaryKey(vendrId);

        return vendr;
    }

    /**
     * Removes the vendr with the primary key from the database. Also notifies the appropriate model listeners.
     *
     * @param vendrId the primary key of the vendr
     * @return the vendr that was removed
     * @throws gov.va.caret.NoSuchVendrException if a vendr with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Vendr remove(long vendrId)
        throws NoSuchVendrException, SystemException {
        return remove((Serializable) vendrId);
    }

    /**
     * Removes the vendr with the primary key from the database. Also notifies the appropriate model listeners.
     *
     * @param primaryKey the primary key of the vendr
     * @return the vendr that was removed
     * @throws gov.va.caret.NoSuchVendrException if a vendr with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Vendr remove(Serializable primaryKey)
        throws NoSuchVendrException, SystemException {
        Session session = null;

        try {
            session = openSession();

            Vendr vendr = (Vendr) session.get(VendrImpl.class, primaryKey);

            if (vendr == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
                }

                throw new NoSuchVendrException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY +
                    primaryKey);
            }

            return remove(vendr);
        } catch (NoSuchVendrException nsee) {
            throw nsee;
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }
    }

    @Override
    protected Vendr removeImpl(Vendr vendr) throws SystemException {
        vendr = toUnwrappedModel(vendr);

        Session session = null;

        try {
            session = openSession();

            if (!session.contains(vendr)) {
                vendr = (Vendr) session.get(VendrImpl.class,
                        vendr.getPrimaryKeyObj());
            }

            if (vendr != null) {
                session.delete(vendr);
            }
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }

        if (vendr != null) {
            clearCache(vendr);
        }

        return vendr;
    }

    @Override
    public Vendr updateImpl(gov.va.caret.model.Vendr vendr)
        throws SystemException {
        vendr = toUnwrappedModel(vendr);

        boolean isNew = vendr.isNew();

        VendrModelImpl vendrModelImpl = (VendrModelImpl) vendr;

        Session session = null;

        try {
            session = openSession();

            if (vendr.isNew()) {
                session.save(vendr);

                vendr.setNew(false);
            } else {
                session.merge(vendr);
            }
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);

        if (isNew || !VendrModelImpl.COLUMN_BITMASK_ENABLED) {
            FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        }
        else {
            if ((vendrModelImpl.getColumnBitmask() &
                    FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_FEDTAXID.getColumnBitmask()) != 0) {
                Object[] args = new Object[] {
                        vendrModelImpl.getOriginalFedTaxId()
                    };

                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_FEDTAXID, args);
                FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_FEDTAXID,
                    args);

                args = new Object[] { vendrModelImpl.getFedTaxId() };

                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_FEDTAXID, args);
                FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_FEDTAXID,
                    args);
            }

            if ((vendrModelImpl.getColumnBitmask() &
                    FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_LASTNAME.getColumnBitmask()) != 0) {
                Object[] args = new Object[] {
                        vendrModelImpl.getOriginalLastName()
                    };

                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_LASTNAME, args);
                FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_LASTNAME,
                    args);

                args = new Object[] { vendrModelImpl.getLastName() };

                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_LASTNAME, args);
                FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_LASTNAME,
                    args);
            }

            if ((vendrModelImpl.getColumnBitmask() &
                    FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_FIRSTNAME.getColumnBitmask()) != 0) {
                Object[] args = new Object[] {
                        vendrModelImpl.getOriginalFirstName()
                    };

                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_FIRSTNAME,
                    args);
                FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_FIRSTNAME,
                    args);

                args = new Object[] { vendrModelImpl.getFirstName() };

                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_FIRSTNAME,
                    args);
                FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_FIRSTNAME,
                    args);
            }
        }

        EntityCacheUtil.putResult(VendrModelImpl.ENTITY_CACHE_ENABLED,
            VendrImpl.class, vendr.getPrimaryKey(), vendr);

        return vendr;
    }

    protected Vendr toUnwrappedModel(Vendr vendr) {
        if (vendr instanceof VendrImpl) {
            return vendr;
        }

        VendrImpl vendrImpl = new VendrImpl();

        vendrImpl.setNew(vendr.isNew());
        vendrImpl.setPrimaryKey(vendr.getPrimaryKey());

        vendrImpl.setVendrId(vendr.getVendrId());
        vendrImpl.setLastName(vendr.getLastName());
        vendrImpl.setFirstName(vendr.getFirstName());
        vendrImpl.setMiddleName(vendr.getMiddleName());
        vendrImpl.setFedTaxId(vendr.getFedTaxId());
        vendrImpl.setAddress(vendr.getAddress());
        vendrImpl.setAddress2(vendr.getAddress2());
        vendrImpl.setCity(vendr.getCity());
        vendrImpl.setState(vendr.getState());
        vendrImpl.setZip(vendr.getZip());
        vendrImpl.setPhone(vendr.getPhone());
        vendrImpl.setPhone2(vendr.getPhone2());
        vendrImpl.setGracePeriod(vendr.getGracePeriod());
        vendrImpl.setGracePeriodDuration(vendr.getGracePeriodDuration());
        vendrImpl.setDirectDepositInfo(vendr.getDirectDepositInfo());
        vendrImpl.setPaymentMethod(vendr.getPaymentMethod());
        vendrImpl.setCrypto1(vendr.getCrypto1());
        vendrImpl.setGroupId(vendr.getGroupId());

        return vendrImpl;
    }

    /**
     * Returns the vendr with the primary key or throws a {@link com.liferay.portal.NoSuchModelException} if it could not be found.
     *
     * @param primaryKey the primary key of the vendr
     * @return the vendr
     * @throws gov.va.caret.NoSuchVendrException if a vendr with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Vendr findByPrimaryKey(Serializable primaryKey)
        throws NoSuchVendrException, SystemException {
        Vendr vendr = fetchByPrimaryKey(primaryKey);

        if (vendr == null) {
            if (_log.isWarnEnabled()) {
                _log.warn(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }

            throw new NoSuchVendrException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY +
                primaryKey);
        }

        return vendr;
    }

    /**
     * Returns the vendr with the primary key or throws a {@link gov.va.caret.NoSuchVendrException} if it could not be found.
     *
     * @param vendrId the primary key of the vendr
     * @return the vendr
     * @throws gov.va.caret.NoSuchVendrException if a vendr with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Vendr findByPrimaryKey(long vendrId)
        throws NoSuchVendrException, SystemException {
        return findByPrimaryKey((Serializable) vendrId);
    }

    /**
     * Returns the vendr with the primary key or returns <code>null</code> if it could not be found.
     *
     * @param primaryKey the primary key of the vendr
     * @return the vendr, or <code>null</code> if a vendr with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Vendr fetchByPrimaryKey(Serializable primaryKey)
        throws SystemException {
        Vendr vendr = (Vendr) EntityCacheUtil.getResult(VendrModelImpl.ENTITY_CACHE_ENABLED,
                VendrImpl.class, primaryKey);

        if (vendr == _nullVendr) {
            return null;
        }

        if (vendr == null) {
            Session session = null;

            try {
                session = openSession();

                vendr = (Vendr) session.get(VendrImpl.class, primaryKey);

                if (vendr != null) {
                    cacheResult(vendr);
                } else {
                    EntityCacheUtil.putResult(VendrModelImpl.ENTITY_CACHE_ENABLED,
                        VendrImpl.class, primaryKey, _nullVendr);
                }
            } catch (Exception e) {
                EntityCacheUtil.removeResult(VendrModelImpl.ENTITY_CACHE_ENABLED,
                    VendrImpl.class, primaryKey);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return vendr;
    }

    /**
     * Returns the vendr with the primary key or returns <code>null</code> if it could not be found.
     *
     * @param vendrId the primary key of the vendr
     * @return the vendr, or <code>null</code> if a vendr with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Vendr fetchByPrimaryKey(long vendrId) throws SystemException {
        return fetchByPrimaryKey((Serializable) vendrId);
    }

    /**
     * Returns all the vendrs.
     *
     * @return the vendrs
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<Vendr> findAll() throws SystemException {
        return findAll(QueryUtil.ALL_POS, QueryUtil.ALL_POS, null);
    }

    /**
     * Returns a range of all the vendrs.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.VendrModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param start the lower bound of the range of vendrs
     * @param end the upper bound of the range of vendrs (not inclusive)
     * @return the range of vendrs
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<Vendr> findAll(int start, int end) throws SystemException {
        return findAll(start, end, null);
    }

    /**
     * Returns an ordered range of all the vendrs.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.VendrModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param start the lower bound of the range of vendrs
     * @param end the upper bound of the range of vendrs (not inclusive)
     * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
     * @return the ordered range of vendrs
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<Vendr> findAll(int start, int end,
        OrderByComparator orderByComparator) throws SystemException {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;

        if ((start == QueryUtil.ALL_POS) && (end == QueryUtil.ALL_POS) &&
                (orderByComparator == null)) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL;
            finderArgs = FINDER_ARGS_EMPTY;
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_ALL;
            finderArgs = new Object[] { start, end, orderByComparator };
        }

        List<Vendr> list = (List<Vendr>) FinderCacheUtil.getResult(finderPath,
                finderArgs, this);

        if (list == null) {
            StringBundler query = null;
            String sql = null;

            if (orderByComparator != null) {
                query = new StringBundler(2 +
                        (orderByComparator.getOrderByFields().length * 3));

                query.append(_SQL_SELECT_VENDR);

                appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS,
                    orderByComparator);

                sql = query.toString();
            } else {
                sql = _SQL_SELECT_VENDR;

                if (pagination) {
                    sql = sql.concat(VendrModelImpl.ORDER_BY_JPQL);
                }
            }

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                if (!pagination) {
                    list = (List<Vendr>) QueryUtil.list(q, getDialect(), start,
                            end, false);

                    Collections.sort(list);

                    list = new UnmodifiableList<Vendr>(list);
                } else {
                    list = (List<Vendr>) QueryUtil.list(q, getDialect(), start,
                            end);
                }

                cacheResult(list);

                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return list;
    }

    /**
     * Removes all the vendrs from the database.
     *
     * @throws SystemException if a system exception occurred
     */
    @Override
    public void removeAll() throws SystemException {
        for (Vendr vendr : findAll()) {
            remove(vendr);
        }
    }

    /**
     * Returns the number of vendrs.
     *
     * @return the number of vendrs
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int countAll() throws SystemException {
        Long count = (Long) FinderCacheUtil.getResult(FINDER_PATH_COUNT_ALL,
                FINDER_ARGS_EMPTY, this);

        if (count == null) {
            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(_SQL_COUNT_VENDR);

                count = (Long) q.uniqueResult();

                FinderCacheUtil.putResult(FINDER_PATH_COUNT_ALL,
                    FINDER_ARGS_EMPTY, count);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_ALL,
                    FINDER_ARGS_EMPTY);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return count.intValue();
    }

    @Override
    protected Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    /**
     * Initializes the vendr persistence.
     */
    public void afterPropertiesSet() {
        String[] listenerClassNames = StringUtil.split(GetterUtil.getString(
                    com.liferay.util.service.ServiceProps.get(
                        "value.object.listener.gov.va.caret.model.Vendr")));

        if (listenerClassNames.length > 0) {
            try {
                List<ModelListener<Vendr>> listenersList = new ArrayList<ModelListener<Vendr>>();

                for (String listenerClassName : listenerClassNames) {
                    listenersList.add((ModelListener<Vendr>) InstanceFactory.newInstance(
                            getClassLoader(), listenerClassName));
                }

                listeners = listenersList.toArray(new ModelListener[listenersList.size()]);
            } catch (Exception e) {
                _log.error(e);
            }
        }
    }

    public void destroy() {
        EntityCacheUtil.removeCache(VendrImpl.class.getName());
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}
