package gov.va.caret.service.persistence;

import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PropsKeys;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnmodifiableList;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.model.ModelListener;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;

import gov.va.caret.NoSuchVcgException;
import gov.va.caret.model.Vcg;
import gov.va.caret.model.impl.VcgImpl;
import gov.va.caret.model.impl.VcgModelImpl;

import java.io.Serializable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * The persistence implementation for the vcg service.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author caret
 * @see VcgPersistence
 * @see VcgUtil
 * @generated
 */
public class VcgPersistenceImpl extends BasePersistenceImpl<Vcg>
    implements VcgPersistence {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. Always use {@link VcgUtil} to access the vcg persistence. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this class.
     */
    public static final String FINDER_CLASS_NAME_ENTITY = VcgImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY +
        ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY +
        ".List2";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_ALL = new FinderPath(VcgModelImpl.ENTITY_CACHE_ENABLED,
            VcgModelImpl.FINDER_CACHE_ENABLED, VcgImpl.class,
            FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL = new FinderPath(VcgModelImpl.ENTITY_CACHE_ENABLED,
            VcgModelImpl.FINDER_CACHE_ENABLED, VcgImpl.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_COUNT_ALL = new FinderPath(VcgModelImpl.ENTITY_CACHE_ENABLED,
            VcgModelImpl.FINDER_CACHE_ENABLED, Long.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
    public static final FinderPath FINDER_PATH_FETCH_BY_VETERAN = new FinderPath(VcgModelImpl.ENTITY_CACHE_ENABLED,
            VcgModelImpl.FINDER_CACHE_ENABLED, VcgImpl.class,
            FINDER_CLASS_NAME_ENTITY, "fetchByVeteran",
            new String[] { Long.class.getName() },
            VcgModelImpl.VETERANID_COLUMN_BITMASK);
    public static final FinderPath FINDER_PATH_COUNT_BY_VETERAN = new FinderPath(VcgModelImpl.ENTITY_CACHE_ENABLED,
            VcgModelImpl.FINDER_CACHE_ENABLED, Long.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByVeteran",
            new String[] { Long.class.getName() });
    private static final String _FINDER_COLUMN_VETERAN_VETERANID_2 = "vcg.veteranId = ?";
    private static final String _SQL_SELECT_VCG = "SELECT vcg FROM Vcg vcg";
    private static final String _SQL_SELECT_VCG_WHERE = "SELECT vcg FROM Vcg vcg WHERE ";
    private static final String _SQL_COUNT_VCG = "SELECT COUNT(vcg) FROM Vcg vcg";
    private static final String _SQL_COUNT_VCG_WHERE = "SELECT COUNT(vcg) FROM Vcg vcg WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "vcg.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No Vcg exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No Vcg exists with the key {";
    private static final boolean _HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE = GetterUtil.getBoolean(PropsUtil.get(
                PropsKeys.HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE));
    private static Log _log = LogFactoryUtil.getLog(VcgPersistenceImpl.class);
    private static Vcg _nullVcg = new VcgImpl() {
            @Override
            public Object clone() {
                return this;
            }

            @Override
            public CacheModel<Vcg> toCacheModel() {
                return _nullVcgCacheModel;
            }
        };

    private static CacheModel<Vcg> _nullVcgCacheModel = new CacheModel<Vcg>() {
            @Override
            public Vcg toEntityModel() {
                return _nullVcg;
            }
        };

    public VcgPersistenceImpl() {
        setModelClass(Vcg.class);
    }

    /**
     * Returns the vcg where veteranId = &#63; or throws a {@link gov.va.caret.NoSuchVcgException} if it could not be found.
     *
     * @param veteranId the veteran ID
     * @return the matching vcg
     * @throws gov.va.caret.NoSuchVcgException if a matching vcg could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Vcg findByVeteran(long veteranId)
        throws NoSuchVcgException, SystemException {
        Vcg vcg = fetchByVeteran(veteranId);

        if (vcg == null) {
            StringBundler msg = new StringBundler(4);

            msg.append(_NO_SUCH_ENTITY_WITH_KEY);

            msg.append("veteranId=");
            msg.append(veteranId);

            msg.append(StringPool.CLOSE_CURLY_BRACE);

            if (_log.isWarnEnabled()) {
                _log.warn(msg.toString());
            }

            throw new NoSuchVcgException(msg.toString());
        }

        return vcg;
    }

    /**
     * Returns the vcg where veteranId = &#63; or returns <code>null</code> if it could not be found. Uses the finder cache.
     *
     * @param veteranId the veteran ID
     * @return the matching vcg, or <code>null</code> if a matching vcg could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Vcg fetchByVeteran(long veteranId) throws SystemException {
        return fetchByVeteran(veteranId, true);
    }

    /**
     * Returns the vcg where veteranId = &#63; or returns <code>null</code> if it could not be found, optionally using the finder cache.
     *
     * @param veteranId the veteran ID
     * @param retrieveFromCache whether to use the finder cache
     * @return the matching vcg, or <code>null</code> if a matching vcg could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Vcg fetchByVeteran(long veteranId, boolean retrieveFromCache)
        throws SystemException {
        Object[] finderArgs = new Object[] { veteranId };

        Object result = null;

        if (retrieveFromCache) {
            result = FinderCacheUtil.getResult(FINDER_PATH_FETCH_BY_VETERAN,
                    finderArgs, this);
        }

        if (result instanceof Vcg) {
            Vcg vcg = (Vcg) result;

            if ((veteranId != vcg.getVeteranId())) {
                result = null;
            }
        }

        if (result == null) {
            StringBundler query = new StringBundler(3);

            query.append(_SQL_SELECT_VCG_WHERE);

            query.append(_FINDER_COLUMN_VETERAN_VETERANID_2);

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                qPos.add(veteranId);

                List<Vcg> list = q.list();

                if (list.isEmpty()) {
                    FinderCacheUtil.putResult(FINDER_PATH_FETCH_BY_VETERAN,
                        finderArgs, list);
                } else {
                    if ((list.size() > 1) && _log.isWarnEnabled()) {
                        _log.warn(
                            "VcgPersistenceImpl.fetchByVeteran(long, boolean) with parameters (" +
                            StringUtil.merge(finderArgs) +
                            ") yields a result set with more than 1 result. This violates the logical unique restriction. There is no order guarantee on which result is returned by this finder.");
                    }

                    Vcg vcg = list.get(0);

                    result = vcg;

                    cacheResult(vcg);

                    if ((vcg.getVeteranId() != veteranId)) {
                        FinderCacheUtil.putResult(FINDER_PATH_FETCH_BY_VETERAN,
                            finderArgs, vcg);
                    }
                }
            } catch (Exception e) {
                FinderCacheUtil.removeResult(FINDER_PATH_FETCH_BY_VETERAN,
                    finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        if (result instanceof List<?>) {
            return null;
        } else {
            return (Vcg) result;
        }
    }

    /**
     * Removes the vcg where veteranId = &#63; from the database.
     *
     * @param veteranId the veteran ID
     * @return the vcg that was removed
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Vcg removeByVeteran(long veteranId)
        throws NoSuchVcgException, SystemException {
        Vcg vcg = findByVeteran(veteranId);

        return remove(vcg);
    }

    /**
     * Returns the number of vcgs where veteranId = &#63;.
     *
     * @param veteranId the veteran ID
     * @return the number of matching vcgs
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int countByVeteran(long veteranId) throws SystemException {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_VETERAN;

        Object[] finderArgs = new Object[] { veteranId };

        Long count = (Long) FinderCacheUtil.getResult(finderPath, finderArgs,
                this);

        if (count == null) {
            StringBundler query = new StringBundler(2);

            query.append(_SQL_COUNT_VCG_WHERE);

            query.append(_FINDER_COLUMN_VETERAN_VETERANID_2);

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                qPos.add(veteranId);

                count = (Long) q.uniqueResult();

                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return count.intValue();
    }

    /**
     * Caches the vcg in the entity cache if it is enabled.
     *
     * @param vcg the vcg
     */
    @Override
    public void cacheResult(Vcg vcg) {
        EntityCacheUtil.putResult(VcgModelImpl.ENTITY_CACHE_ENABLED,
            VcgImpl.class, vcg.getPrimaryKey(), vcg);

        FinderCacheUtil.putResult(FINDER_PATH_FETCH_BY_VETERAN,
            new Object[] { vcg.getVeteranId() }, vcg);

        vcg.resetOriginalValues();
    }

    /**
     * Caches the vcgs in the entity cache if it is enabled.
     *
     * @param vcgs the vcgs
     */
    @Override
    public void cacheResult(List<Vcg> vcgs) {
        for (Vcg vcg : vcgs) {
            if (EntityCacheUtil.getResult(VcgModelImpl.ENTITY_CACHE_ENABLED,
                        VcgImpl.class, vcg.getPrimaryKey()) == null) {
                cacheResult(vcg);
            } else {
                vcg.resetOriginalValues();
            }
        }
    }

    /**
     * Clears the cache for all vcgs.
     *
     * <p>
     * The {@link com.liferay.portal.kernel.dao.orm.EntityCache} and {@link com.liferay.portal.kernel.dao.orm.FinderCache} are both cleared by this method.
     * </p>
     */
    @Override
    public void clearCache() {
        if (_HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE) {
            CacheRegistryUtil.clear(VcgImpl.class.getName());
        }

        EntityCacheUtil.clearCache(VcgImpl.class.getName());

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    /**
     * Clears the cache for the vcg.
     *
     * <p>
     * The {@link com.liferay.portal.kernel.dao.orm.EntityCache} and {@link com.liferay.portal.kernel.dao.orm.FinderCache} are both cleared by this method.
     * </p>
     */
    @Override
    public void clearCache(Vcg vcg) {
        EntityCacheUtil.removeResult(VcgModelImpl.ENTITY_CACHE_ENABLED,
            VcgImpl.class, vcg.getPrimaryKey());

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);

        clearUniqueFindersCache(vcg);
    }

    @Override
    public void clearCache(List<Vcg> vcgs) {
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);

        for (Vcg vcg : vcgs) {
            EntityCacheUtil.removeResult(VcgModelImpl.ENTITY_CACHE_ENABLED,
                VcgImpl.class, vcg.getPrimaryKey());

            clearUniqueFindersCache(vcg);
        }
    }

    protected void cacheUniqueFindersCache(Vcg vcg) {
        if (vcg.isNew()) {
            Object[] args = new Object[] { vcg.getVeteranId() };

            FinderCacheUtil.putResult(FINDER_PATH_COUNT_BY_VETERAN, args,
                Long.valueOf(1));
            FinderCacheUtil.putResult(FINDER_PATH_FETCH_BY_VETERAN, args, vcg);
        } else {
            VcgModelImpl vcgModelImpl = (VcgModelImpl) vcg;

            if ((vcgModelImpl.getColumnBitmask() &
                    FINDER_PATH_FETCH_BY_VETERAN.getColumnBitmask()) != 0) {
                Object[] args = new Object[] { vcg.getVeteranId() };

                FinderCacheUtil.putResult(FINDER_PATH_COUNT_BY_VETERAN, args,
                    Long.valueOf(1));
                FinderCacheUtil.putResult(FINDER_PATH_FETCH_BY_VETERAN, args,
                    vcg);
            }
        }
    }

    protected void clearUniqueFindersCache(Vcg vcg) {
        VcgModelImpl vcgModelImpl = (VcgModelImpl) vcg;

        Object[] args = new Object[] { vcg.getVeteranId() };

        FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_VETERAN, args);
        FinderCacheUtil.removeResult(FINDER_PATH_FETCH_BY_VETERAN, args);

        if ((vcgModelImpl.getColumnBitmask() &
                FINDER_PATH_FETCH_BY_VETERAN.getColumnBitmask()) != 0) {
            args = new Object[] { vcgModelImpl.getOriginalVeteranId() };

            FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_VETERAN, args);
            FinderCacheUtil.removeResult(FINDER_PATH_FETCH_BY_VETERAN, args);
        }
    }

    /**
     * Creates a new vcg with the primary key. Does not add the vcg to the database.
     *
     * @param vcgId the primary key for the new vcg
     * @return the new vcg
     */
    @Override
    public Vcg create(long vcgId) {
        Vcg vcg = new VcgImpl();

        vcg.setNew(true);
        vcg.setPrimaryKey(vcgId);

        return vcg;
    }

    /**
     * Removes the vcg with the primary key from the database. Also notifies the appropriate model listeners.
     *
     * @param vcgId the primary key of the vcg
     * @return the vcg that was removed
     * @throws gov.va.caret.NoSuchVcgException if a vcg with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Vcg remove(long vcgId) throws NoSuchVcgException, SystemException {
        return remove((Serializable) vcgId);
    }

    /**
     * Removes the vcg with the primary key from the database. Also notifies the appropriate model listeners.
     *
     * @param primaryKey the primary key of the vcg
     * @return the vcg that was removed
     * @throws gov.va.caret.NoSuchVcgException if a vcg with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Vcg remove(Serializable primaryKey)
        throws NoSuchVcgException, SystemException {
        Session session = null;

        try {
            session = openSession();

            Vcg vcg = (Vcg) session.get(VcgImpl.class, primaryKey);

            if (vcg == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
                }

                throw new NoSuchVcgException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY +
                    primaryKey);
            }

            return remove(vcg);
        } catch (NoSuchVcgException nsee) {
            throw nsee;
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }
    }

    @Override
    protected Vcg removeImpl(Vcg vcg) throws SystemException {
        vcg = toUnwrappedModel(vcg);

        Session session = null;

        try {
            session = openSession();

            if (!session.contains(vcg)) {
                vcg = (Vcg) session.get(VcgImpl.class, vcg.getPrimaryKeyObj());
            }

            if (vcg != null) {
                session.delete(vcg);
            }
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }

        if (vcg != null) {
            clearCache(vcg);
        }

        return vcg;
    }

    @Override
    public Vcg updateImpl(gov.va.caret.model.Vcg vcg) throws SystemException {
        vcg = toUnwrappedModel(vcg);

        boolean isNew = vcg.isNew();

        Session session = null;

        try {
            session = openSession();

            if (vcg.isNew()) {
                session.save(vcg);

                vcg.setNew(false);
            } else {
                session.merge(vcg);
            }
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);

        if (isNew || !VcgModelImpl.COLUMN_BITMASK_ENABLED) {
            FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        }

        EntityCacheUtil.putResult(VcgModelImpl.ENTITY_CACHE_ENABLED,
            VcgImpl.class, vcg.getPrimaryKey(), vcg);

        clearUniqueFindersCache(vcg);
        cacheUniqueFindersCache(vcg);

        return vcg;
    }

    protected Vcg toUnwrappedModel(Vcg vcg) {
        if (vcg instanceof VcgImpl) {
            return vcg;
        }

        VcgImpl vcgImpl = new VcgImpl();

        vcgImpl.setNew(vcg.isNew());
        vcgImpl.setPrimaryKey(vcg.getPrimaryKey());

        vcgImpl.setVcgId(vcg.getVcgId());
        vcgImpl.setVeteranId(vcg.getVeteranId());
        vcgImpl.setStatus(vcg.getStatus());
        vcgImpl.setAssessCompletionDate(vcg.getAssessCompletionDate());
        vcgImpl.setPrimaryTrainedDate(vcg.getPrimaryTrainedDate());
        vcgImpl.setVisitationDate(vcg.getVisitationDate());
        vcgImpl.setPrimaryId(vcg.getPrimaryId());
        vcgImpl.setSecondaryId(vcg.getSecondaryId());
        vcgImpl.setSecondaryTwoId(vcg.getSecondaryTwoId());
        vcgImpl.setGeneralCaregiver(vcg.isGeneralCaregiver());
        vcgImpl.setPrimaryType(vcg.getPrimaryType());
        vcgImpl.setSecondaryType(vcg.getSecondaryType());
        vcgImpl.setSecondaryTwoType(vcg.getSecondaryTwoType());
        vcgImpl.setPrimaryDispositionDate(vcg.getPrimaryDispositionDate());
        vcgImpl.setSecondaryDispositionDate(vcg.getSecondaryDispositionDate());
        vcgImpl.setSecondaryTwoDispositionDate(vcg.getSecondaryTwoDispositionDate());
        vcgImpl.setTierLevel(vcg.getTierLevel());
        vcgImpl.setTierEffectiveDate(vcg.getTierEffectiveDate());
        vcgImpl.setVeteranDispReason(vcg.getVeteranDispReason());
        vcgImpl.setPrimaryDispReason(vcg.getPrimaryDispReason());
        vcgImpl.setSecondaryDispReason(vcg.getSecondaryDispReason());
        vcgImpl.setSecondaryTwoDispReason(vcg.getSecondaryTwoDispReason());
        vcgImpl.setPrimaryRevocationDate(vcg.getPrimaryRevocationDate());
        vcgImpl.setSecondaryRevocationDate(vcg.getSecondaryRevocationDate());
        vcgImpl.setSecondaryTwoRevocationDate(vcg.getSecondaryTwoRevocationDate());
        vcgImpl.setGroupId(vcg.getGroupId());

        return vcgImpl;
    }

    /**
     * Returns the vcg with the primary key or throws a {@link com.liferay.portal.NoSuchModelException} if it could not be found.
     *
     * @param primaryKey the primary key of the vcg
     * @return the vcg
     * @throws gov.va.caret.NoSuchVcgException if a vcg with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Vcg findByPrimaryKey(Serializable primaryKey)
        throws NoSuchVcgException, SystemException {
        Vcg vcg = fetchByPrimaryKey(primaryKey);

        if (vcg == null) {
            if (_log.isWarnEnabled()) {
                _log.warn(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }

            throw new NoSuchVcgException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY +
                primaryKey);
        }

        return vcg;
    }

    /**
     * Returns the vcg with the primary key or throws a {@link gov.va.caret.NoSuchVcgException} if it could not be found.
     *
     * @param vcgId the primary key of the vcg
     * @return the vcg
     * @throws gov.va.caret.NoSuchVcgException if a vcg with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Vcg findByPrimaryKey(long vcgId)
        throws NoSuchVcgException, SystemException {
        return findByPrimaryKey((Serializable) vcgId);
    }

    /**
     * Returns the vcg with the primary key or returns <code>null</code> if it could not be found.
     *
     * @param primaryKey the primary key of the vcg
     * @return the vcg, or <code>null</code> if a vcg with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Vcg fetchByPrimaryKey(Serializable primaryKey)
        throws SystemException {
        Vcg vcg = (Vcg) EntityCacheUtil.getResult(VcgModelImpl.ENTITY_CACHE_ENABLED,
                VcgImpl.class, primaryKey);

        if (vcg == _nullVcg) {
            return null;
        }

        if (vcg == null) {
            Session session = null;

            try {
                session = openSession();

                vcg = (Vcg) session.get(VcgImpl.class, primaryKey);

                if (vcg != null) {
                    cacheResult(vcg);
                } else {
                    EntityCacheUtil.putResult(VcgModelImpl.ENTITY_CACHE_ENABLED,
                        VcgImpl.class, primaryKey, _nullVcg);
                }
            } catch (Exception e) {
                EntityCacheUtil.removeResult(VcgModelImpl.ENTITY_CACHE_ENABLED,
                    VcgImpl.class, primaryKey);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return vcg;
    }

    /**
     * Returns the vcg with the primary key or returns <code>null</code> if it could not be found.
     *
     * @param vcgId the primary key of the vcg
     * @return the vcg, or <code>null</code> if a vcg with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Vcg fetchByPrimaryKey(long vcgId) throws SystemException {
        return fetchByPrimaryKey((Serializable) vcgId);
    }

    /**
     * Returns all the vcgs.
     *
     * @return the vcgs
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<Vcg> findAll() throws SystemException {
        return findAll(QueryUtil.ALL_POS, QueryUtil.ALL_POS, null);
    }

    /**
     * Returns a range of all the vcgs.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.VcgModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param start the lower bound of the range of vcgs
     * @param end the upper bound of the range of vcgs (not inclusive)
     * @return the range of vcgs
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<Vcg> findAll(int start, int end) throws SystemException {
        return findAll(start, end, null);
    }

    /**
     * Returns an ordered range of all the vcgs.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.VcgModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param start the lower bound of the range of vcgs
     * @param end the upper bound of the range of vcgs (not inclusive)
     * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
     * @return the ordered range of vcgs
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<Vcg> findAll(int start, int end,
        OrderByComparator orderByComparator) throws SystemException {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;

        if ((start == QueryUtil.ALL_POS) && (end == QueryUtil.ALL_POS) &&
                (orderByComparator == null)) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL;
            finderArgs = FINDER_ARGS_EMPTY;
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_ALL;
            finderArgs = new Object[] { start, end, orderByComparator };
        }

        List<Vcg> list = (List<Vcg>) FinderCacheUtil.getResult(finderPath,
                finderArgs, this);

        if (list == null) {
            StringBundler query = null;
            String sql = null;

            if (orderByComparator != null) {
                query = new StringBundler(2 +
                        (orderByComparator.getOrderByFields().length * 3));

                query.append(_SQL_SELECT_VCG);

                appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS,
                    orderByComparator);

                sql = query.toString();
            } else {
                sql = _SQL_SELECT_VCG;

                if (pagination) {
                    sql = sql.concat(VcgModelImpl.ORDER_BY_JPQL);
                }
            }

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                if (!pagination) {
                    list = (List<Vcg>) QueryUtil.list(q, getDialect(), start,
                            end, false);

                    Collections.sort(list);

                    list = new UnmodifiableList<Vcg>(list);
                } else {
                    list = (List<Vcg>) QueryUtil.list(q, getDialect(), start,
                            end);
                }

                cacheResult(list);

                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return list;
    }

    /**
     * Removes all the vcgs from the database.
     *
     * @throws SystemException if a system exception occurred
     */
    @Override
    public void removeAll() throws SystemException {
        for (Vcg vcg : findAll()) {
            remove(vcg);
        }
    }

    /**
     * Returns the number of vcgs.
     *
     * @return the number of vcgs
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int countAll() throws SystemException {
        Long count = (Long) FinderCacheUtil.getResult(FINDER_PATH_COUNT_ALL,
                FINDER_ARGS_EMPTY, this);

        if (count == null) {
            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(_SQL_COUNT_VCG);

                count = (Long) q.uniqueResult();

                FinderCacheUtil.putResult(FINDER_PATH_COUNT_ALL,
                    FINDER_ARGS_EMPTY, count);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_ALL,
                    FINDER_ARGS_EMPTY);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return count.intValue();
    }

    /**
     * Initializes the vcg persistence.
     */
    public void afterPropertiesSet() {
        String[] listenerClassNames = StringUtil.split(GetterUtil.getString(
                    com.liferay.util.service.ServiceProps.get(
                        "value.object.listener.gov.va.caret.model.Vcg")));

        if (listenerClassNames.length > 0) {
            try {
                List<ModelListener<Vcg>> listenersList = new ArrayList<ModelListener<Vcg>>();

                for (String listenerClassName : listenerClassNames) {
                    listenersList.add((ModelListener<Vcg>) InstanceFactory.newInstance(
                            getClassLoader(), listenerClassName));
                }

                listeners = listenersList.toArray(new ModelListener[listenersList.size()]);
            } catch (Exception e) {
                _log.error(e);
            }
        }
    }

    public void destroy() {
        EntityCacheUtil.removeCache(VcgImpl.class.getName());
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}
