package gov.va.caret.service.persistence;

import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.CalendarUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PropsKeys;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnmodifiableList;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.model.ModelListener;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;

import gov.va.caret.NoSuchPersnException;
import gov.va.caret.model.Persn;
import gov.va.caret.model.impl.PersnImpl;
import gov.va.caret.model.impl.PersnModelImpl;

import java.io.Serializable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;

/**
 * The persistence implementation for the persn service.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author caret
 * @see PersnPersistence
 * @see PersnUtil
 * @generated
 */
public class PersnPersistenceImpl extends BasePersistenceImpl<Persn>
    implements PersnPersistence {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. Always use {@link PersnUtil} to access the persn persistence. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this class.
     */
    public static final String FINDER_CLASS_NAME_ENTITY = PersnImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY +
        ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY +
        ".List2";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_ALL = new FinderPath(PersnModelImpl.ENTITY_CACHE_ENABLED,
            PersnModelImpl.FINDER_CACHE_ENABLED, PersnImpl.class,
            FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL = new FinderPath(PersnModelImpl.ENTITY_CACHE_ENABLED,
            PersnModelImpl.FINDER_CACHE_ENABLED, PersnImpl.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_COUNT_ALL = new FinderPath(PersnModelImpl.ENTITY_CACHE_ENABLED,
            PersnModelImpl.FINDER_CACHE_ENABLED, Long.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_FIRSTNAME =
        new FinderPath(PersnModelImpl.ENTITY_CACHE_ENABLED,
            PersnModelImpl.FINDER_CACHE_ENABLED, PersnImpl.class,
            FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByFirstName",
            new String[] {
                String.class.getName(),
                
            Integer.class.getName(), Integer.class.getName(),
                OrderByComparator.class.getName()
            });
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_FIRSTNAME =
        new FinderPath(PersnModelImpl.ENTITY_CACHE_ENABLED,
            PersnModelImpl.FINDER_CACHE_ENABLED, PersnImpl.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByFirstName",
            new String[] { String.class.getName() },
            PersnModelImpl.FIRSTNAME_COLUMN_BITMASK);
    public static final FinderPath FINDER_PATH_COUNT_BY_FIRSTNAME = new FinderPath(PersnModelImpl.ENTITY_CACHE_ENABLED,
            PersnModelImpl.FINDER_CACHE_ENABLED, Long.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByFirstName",
            new String[] { String.class.getName() });
    private static final String _FINDER_COLUMN_FIRSTNAME_FIRSTNAME_1 = "persn.firstName IS NULL";
    private static final String _FINDER_COLUMN_FIRSTNAME_FIRSTNAME_2 = "persn.firstName = ?";
    private static final String _FINDER_COLUMN_FIRSTNAME_FIRSTNAME_3 = "(persn.firstName IS NULL OR persn.firstName = '')";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_LASTNAME = new FinderPath(PersnModelImpl.ENTITY_CACHE_ENABLED,
            PersnModelImpl.FINDER_CACHE_ENABLED, PersnImpl.class,
            FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByLastName",
            new String[] {
                String.class.getName(),
                
            Integer.class.getName(), Integer.class.getName(),
                OrderByComparator.class.getName()
            });
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_LASTNAME =
        new FinderPath(PersnModelImpl.ENTITY_CACHE_ENABLED,
            PersnModelImpl.FINDER_CACHE_ENABLED, PersnImpl.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByLastName",
            new String[] { String.class.getName() },
            PersnModelImpl.LASTNAME_COLUMN_BITMASK);
    public static final FinderPath FINDER_PATH_COUNT_BY_LASTNAME = new FinderPath(PersnModelImpl.ENTITY_CACHE_ENABLED,
            PersnModelImpl.FINDER_CACHE_ENABLED, Long.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByLastName",
            new String[] { String.class.getName() });
    private static final String _FINDER_COLUMN_LASTNAME_LASTNAME_1 = "persn.lastName IS NULL";
    private static final String _FINDER_COLUMN_LASTNAME_LASTNAME_2 = "persn.lastName = ?";
    private static final String _FINDER_COLUMN_LASTNAME_LASTNAME_3 = "(persn.lastName IS NULL OR persn.lastName = '')";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_BIRTHDATE =
        new FinderPath(PersnModelImpl.ENTITY_CACHE_ENABLED,
            PersnModelImpl.FINDER_CACHE_ENABLED, PersnImpl.class,
            FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByBirthDate",
            new String[] {
                Date.class.getName(),
                
            Integer.class.getName(), Integer.class.getName(),
                OrderByComparator.class.getName()
            });
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_BIRTHDATE =
        new FinderPath(PersnModelImpl.ENTITY_CACHE_ENABLED,
            PersnModelImpl.FINDER_CACHE_ENABLED, PersnImpl.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByBirthDate",
            new String[] { Date.class.getName() },
            PersnModelImpl.BIRTHDATE_COLUMN_BITMASK);
    public static final FinderPath FINDER_PATH_COUNT_BY_BIRTHDATE = new FinderPath(PersnModelImpl.ENTITY_CACHE_ENABLED,
            PersnModelImpl.FINDER_CACHE_ENABLED, Long.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByBirthDate",
            new String[] { Date.class.getName() });
    private static final String _FINDER_COLUMN_BIRTHDATE_BIRTHDATE_1 = "persn.birthDate IS NULL";
    private static final String _FINDER_COLUMN_BIRTHDATE_BIRTHDATE_2 = "persn.birthDate = ?";
    public static final FinderPath FINDER_PATH_FETCH_BY_USER = new FinderPath(PersnModelImpl.ENTITY_CACHE_ENABLED,
            PersnModelImpl.FINDER_CACHE_ENABLED, PersnImpl.class,
            FINDER_CLASS_NAME_ENTITY, "fetchByUser",
            new String[] { Long.class.getName() },
            PersnModelImpl.PERSNUSERID_COLUMN_BITMASK);
    public static final FinderPath FINDER_PATH_COUNT_BY_USER = new FinderPath(PersnModelImpl.ENTITY_CACHE_ENABLED,
            PersnModelImpl.FINDER_CACHE_ENABLED, Long.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUser",
            new String[] { Long.class.getName() });
    private static final String _FINDER_COLUMN_USER_PERSNUSERID_2 = "persn.persnUserId = ?";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_GENDER = new FinderPath(PersnModelImpl.ENTITY_CACHE_ENABLED,
            PersnModelImpl.FINDER_CACHE_ENABLED, PersnImpl.class,
            FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByGender",
            new String[] {
                String.class.getName(),
                
            Integer.class.getName(), Integer.class.getName(),
                OrderByComparator.class.getName()
            });
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_GENDER =
        new FinderPath(PersnModelImpl.ENTITY_CACHE_ENABLED,
            PersnModelImpl.FINDER_CACHE_ENABLED, PersnImpl.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByGender",
            new String[] { String.class.getName() },
            PersnModelImpl.GENDER_COLUMN_BITMASK);
    public static final FinderPath FINDER_PATH_COUNT_BY_GENDER = new FinderPath(PersnModelImpl.ENTITY_CACHE_ENABLED,
            PersnModelImpl.FINDER_CACHE_ENABLED, Long.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByGender",
            new String[] { String.class.getName() });
    private static final String _FINDER_COLUMN_GENDER_GENDER_1 = "persn.gender IS NULL";
    private static final String _FINDER_COLUMN_GENDER_GENDER_2 = "persn.gender = ?";
    private static final String _FINDER_COLUMN_GENDER_GENDER_3 = "(persn.gender IS NULL OR persn.gender = '')";
    public static final FinderPath FINDER_PATH_FETCH_BY_EXTERNALID = new FinderPath(PersnModelImpl.ENTITY_CACHE_ENABLED,
            PersnModelImpl.FINDER_CACHE_ENABLED, PersnImpl.class,
            FINDER_CLASS_NAME_ENTITY, "fetchByExternalId",
            new String[] { String.class.getName() },
            PersnModelImpl.EXTERNALID_COLUMN_BITMASK);
    public static final FinderPath FINDER_PATH_COUNT_BY_EXTERNALID = new FinderPath(PersnModelImpl.ENTITY_CACHE_ENABLED,
            PersnModelImpl.FINDER_CACHE_ENABLED, Long.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByExternalId",
            new String[] { String.class.getName() });
    private static final String _FINDER_COLUMN_EXTERNALID_EXTERNALID_1 = "persn.externalId IS NULL";
    private static final String _FINDER_COLUMN_EXTERNALID_EXTERNALID_2 = "persn.externalId = ?";
    private static final String _FINDER_COLUMN_EXTERNALID_EXTERNALID_3 = "(persn.externalId IS NULL OR persn.externalId = '')";
    private static final String _SQL_SELECT_PERSN = "SELECT persn FROM Persn persn";
    private static final String _SQL_SELECT_PERSN_WHERE = "SELECT persn FROM Persn persn WHERE ";
    private static final String _SQL_COUNT_PERSN = "SELECT COUNT(persn) FROM Persn persn";
    private static final String _SQL_COUNT_PERSN_WHERE = "SELECT COUNT(persn) FROM Persn persn WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "persn.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No Persn exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No Persn exists with the key {";
    private static final boolean _HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE = GetterUtil.getBoolean(PropsUtil.get(
                PropsKeys.HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE));
    private static Log _log = LogFactoryUtil.getLog(PersnPersistenceImpl.class);
    private static Set<String> _badColumnNames = SetUtil.fromArray(new String[] {
                "state", "externalId"
            });
    private static Persn _nullPersn = new PersnImpl() {
            @Override
            public Object clone() {
                return this;
            }

            @Override
            public CacheModel<Persn> toCacheModel() {
                return _nullPersnCacheModel;
            }
        };

    private static CacheModel<Persn> _nullPersnCacheModel = new CacheModel<Persn>() {
            @Override
            public Persn toEntityModel() {
                return _nullPersn;
            }
        };

    public PersnPersistenceImpl() {
        setModelClass(Persn.class);
    }

    /**
     * Returns all the persns where firstName = &#63;.
     *
     * @param firstName the first name
     * @return the matching persns
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<Persn> findByFirstName(String firstName)
        throws SystemException {
        return findByFirstName(firstName, QueryUtil.ALL_POS, QueryUtil.ALL_POS,
            null);
    }

    /**
     * Returns a range of all the persns where firstName = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.PersnModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param firstName the first name
     * @param start the lower bound of the range of persns
     * @param end the upper bound of the range of persns (not inclusive)
     * @return the range of matching persns
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<Persn> findByFirstName(String firstName, int start, int end)
        throws SystemException {
        return findByFirstName(firstName, start, end, null);
    }

    /**
     * Returns an ordered range of all the persns where firstName = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.PersnModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param firstName the first name
     * @param start the lower bound of the range of persns
     * @param end the upper bound of the range of persns (not inclusive)
     * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
     * @return the ordered range of matching persns
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<Persn> findByFirstName(String firstName, int start, int end,
        OrderByComparator orderByComparator) throws SystemException {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;

        if ((start == QueryUtil.ALL_POS) && (end == QueryUtil.ALL_POS) &&
                (orderByComparator == null)) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_FIRSTNAME;
            finderArgs = new Object[] { firstName };
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_FIRSTNAME;
            finderArgs = new Object[] { firstName, start, end, orderByComparator };
        }

        List<Persn> list = (List<Persn>) FinderCacheUtil.getResult(finderPath,
                finderArgs, this);

        if ((list != null) && !list.isEmpty()) {
            for (Persn persn : list) {
                if (!Validator.equals(firstName, persn.getFirstName())) {
                    list = null;

                    break;
                }
            }
        }

        if (list == null) {
            StringBundler query = null;

            if (orderByComparator != null) {
                query = new StringBundler(3 +
                        (orderByComparator.getOrderByFields().length * 3));
            } else {
                query = new StringBundler(3);
            }

            query.append(_SQL_SELECT_PERSN_WHERE);

            boolean bindFirstName = false;

            if (firstName == null) {
                query.append(_FINDER_COLUMN_FIRSTNAME_FIRSTNAME_1);
            } else if (firstName.equals(StringPool.BLANK)) {
                query.append(_FINDER_COLUMN_FIRSTNAME_FIRSTNAME_3);
            } else {
                bindFirstName = true;

                query.append(_FINDER_COLUMN_FIRSTNAME_FIRSTNAME_2);
            }

            if (orderByComparator != null) {
                appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS,
                    orderByComparator);
            } else
             if (pagination) {
                query.append(PersnModelImpl.ORDER_BY_JPQL);
            }

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                if (bindFirstName) {
                    qPos.add(firstName);
                }

                if (!pagination) {
                    list = (List<Persn>) QueryUtil.list(q, getDialect(), start,
                            end, false);

                    Collections.sort(list);

                    list = new UnmodifiableList<Persn>(list);
                } else {
                    list = (List<Persn>) QueryUtil.list(q, getDialect(), start,
                            end);
                }

                cacheResult(list);

                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return list;
    }

    /**
     * Returns the first persn in the ordered set where firstName = &#63;.
     *
     * @param firstName the first name
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching persn
     * @throws gov.va.caret.NoSuchPersnException if a matching persn could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Persn findByFirstName_First(String firstName,
        OrderByComparator orderByComparator)
        throws NoSuchPersnException, SystemException {
        Persn persn = fetchByFirstName_First(firstName, orderByComparator);

        if (persn != null) {
            return persn;
        }

        StringBundler msg = new StringBundler(4);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("firstName=");
        msg.append(firstName);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchPersnException(msg.toString());
    }

    /**
     * Returns the first persn in the ordered set where firstName = &#63;.
     *
     * @param firstName the first name
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching persn, or <code>null</code> if a matching persn could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Persn fetchByFirstName_First(String firstName,
        OrderByComparator orderByComparator) throws SystemException {
        List<Persn> list = findByFirstName(firstName, 0, 1, orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the last persn in the ordered set where firstName = &#63;.
     *
     * @param firstName the first name
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching persn
     * @throws gov.va.caret.NoSuchPersnException if a matching persn could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Persn findByFirstName_Last(String firstName,
        OrderByComparator orderByComparator)
        throws NoSuchPersnException, SystemException {
        Persn persn = fetchByFirstName_Last(firstName, orderByComparator);

        if (persn != null) {
            return persn;
        }

        StringBundler msg = new StringBundler(4);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("firstName=");
        msg.append(firstName);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchPersnException(msg.toString());
    }

    /**
     * Returns the last persn in the ordered set where firstName = &#63;.
     *
     * @param firstName the first name
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching persn, or <code>null</code> if a matching persn could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Persn fetchByFirstName_Last(String firstName,
        OrderByComparator orderByComparator) throws SystemException {
        int count = countByFirstName(firstName);

        if (count == 0) {
            return null;
        }

        List<Persn> list = findByFirstName(firstName, count - 1, count,
                orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the persns before and after the current persn in the ordered set where firstName = &#63;.
     *
     * @param persnId the primary key of the current persn
     * @param firstName the first name
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the previous, current, and next persn
     * @throws gov.va.caret.NoSuchPersnException if a persn with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Persn[] findByFirstName_PrevAndNext(long persnId, String firstName,
        OrderByComparator orderByComparator)
        throws NoSuchPersnException, SystemException {
        Persn persn = findByPrimaryKey(persnId);

        Session session = null;

        try {
            session = openSession();

            Persn[] array = new PersnImpl[3];

            array[0] = getByFirstName_PrevAndNext(session, persn, firstName,
                    orderByComparator, true);

            array[1] = persn;

            array[2] = getByFirstName_PrevAndNext(session, persn, firstName,
                    orderByComparator, false);

            return array;
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }
    }

    protected Persn getByFirstName_PrevAndNext(Session session, Persn persn,
        String firstName, OrderByComparator orderByComparator, boolean previous) {
        StringBundler query = null;

        if (orderByComparator != null) {
            query = new StringBundler(6 +
                    (orderByComparator.getOrderByFields().length * 6));
        } else {
            query = new StringBundler(3);
        }

        query.append(_SQL_SELECT_PERSN_WHERE);

        boolean bindFirstName = false;

        if (firstName == null) {
            query.append(_FINDER_COLUMN_FIRSTNAME_FIRSTNAME_1);
        } else if (firstName.equals(StringPool.BLANK)) {
            query.append(_FINDER_COLUMN_FIRSTNAME_FIRSTNAME_3);
        } else {
            bindFirstName = true;

            query.append(_FINDER_COLUMN_FIRSTNAME_FIRSTNAME_2);
        }

        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();

            if (orderByConditionFields.length > 0) {
                query.append(WHERE_AND);
            }

            for (int i = 0; i < orderByConditionFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);

                if ((i + 1) < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN_HAS_NEXT);
                    } else {
                        query.append(WHERE_LESSER_THAN_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN);
                    } else {
                        query.append(WHERE_LESSER_THAN);
                    }
                }
            }

            query.append(ORDER_BY_CLAUSE);

            String[] orderByFields = orderByComparator.getOrderByFields();

            for (int i = 0; i < orderByFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);

                if ((i + 1) < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC_HAS_NEXT);
                    } else {
                        query.append(ORDER_BY_DESC_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC);
                    } else {
                        query.append(ORDER_BY_DESC);
                    }
                }
            }
        } else {
            query.append(PersnModelImpl.ORDER_BY_JPQL);
        }

        String sql = query.toString();

        Query q = session.createQuery(sql);

        q.setFirstResult(0);
        q.setMaxResults(2);

        QueryPos qPos = QueryPos.getInstance(q);

        if (bindFirstName) {
            qPos.add(firstName);
        }

        if (orderByComparator != null) {
            Object[] values = orderByComparator.getOrderByConditionValues(persn);

            for (Object value : values) {
                qPos.add(value);
            }
        }

        List<Persn> list = q.list();

        if (list.size() == 2) {
            return list.get(1);
        } else {
            return null;
        }
    }

    /**
     * Removes all the persns where firstName = &#63; from the database.
     *
     * @param firstName the first name
     * @throws SystemException if a system exception occurred
     */
    @Override
    public void removeByFirstName(String firstName) throws SystemException {
        for (Persn persn : findByFirstName(firstName, QueryUtil.ALL_POS,
                QueryUtil.ALL_POS, null)) {
            remove(persn);
        }
    }

    /**
     * Returns the number of persns where firstName = &#63;.
     *
     * @param firstName the first name
     * @return the number of matching persns
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int countByFirstName(String firstName) throws SystemException {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_FIRSTNAME;

        Object[] finderArgs = new Object[] { firstName };

        Long count = (Long) FinderCacheUtil.getResult(finderPath, finderArgs,
                this);

        if (count == null) {
            StringBundler query = new StringBundler(2);

            query.append(_SQL_COUNT_PERSN_WHERE);

            boolean bindFirstName = false;

            if (firstName == null) {
                query.append(_FINDER_COLUMN_FIRSTNAME_FIRSTNAME_1);
            } else if (firstName.equals(StringPool.BLANK)) {
                query.append(_FINDER_COLUMN_FIRSTNAME_FIRSTNAME_3);
            } else {
                bindFirstName = true;

                query.append(_FINDER_COLUMN_FIRSTNAME_FIRSTNAME_2);
            }

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                if (bindFirstName) {
                    qPos.add(firstName);
                }

                count = (Long) q.uniqueResult();

                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return count.intValue();
    }

    /**
     * Returns all the persns where lastName = &#63;.
     *
     * @param lastName the last name
     * @return the matching persns
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<Persn> findByLastName(String lastName)
        throws SystemException {
        return findByLastName(lastName, QueryUtil.ALL_POS, QueryUtil.ALL_POS,
            null);
    }

    /**
     * Returns a range of all the persns where lastName = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.PersnModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param lastName the last name
     * @param start the lower bound of the range of persns
     * @param end the upper bound of the range of persns (not inclusive)
     * @return the range of matching persns
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<Persn> findByLastName(String lastName, int start, int end)
        throws SystemException {
        return findByLastName(lastName, start, end, null);
    }

    /**
     * Returns an ordered range of all the persns where lastName = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.PersnModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param lastName the last name
     * @param start the lower bound of the range of persns
     * @param end the upper bound of the range of persns (not inclusive)
     * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
     * @return the ordered range of matching persns
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<Persn> findByLastName(String lastName, int start, int end,
        OrderByComparator orderByComparator) throws SystemException {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;

        if ((start == QueryUtil.ALL_POS) && (end == QueryUtil.ALL_POS) &&
                (orderByComparator == null)) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_LASTNAME;
            finderArgs = new Object[] { lastName };
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_LASTNAME;
            finderArgs = new Object[] { lastName, start, end, orderByComparator };
        }

        List<Persn> list = (List<Persn>) FinderCacheUtil.getResult(finderPath,
                finderArgs, this);

        if ((list != null) && !list.isEmpty()) {
            for (Persn persn : list) {
                if (!Validator.equals(lastName, persn.getLastName())) {
                    list = null;

                    break;
                }
            }
        }

        if (list == null) {
            StringBundler query = null;

            if (orderByComparator != null) {
                query = new StringBundler(3 +
                        (orderByComparator.getOrderByFields().length * 3));
            } else {
                query = new StringBundler(3);
            }

            query.append(_SQL_SELECT_PERSN_WHERE);

            boolean bindLastName = false;

            if (lastName == null) {
                query.append(_FINDER_COLUMN_LASTNAME_LASTNAME_1);
            } else if (lastName.equals(StringPool.BLANK)) {
                query.append(_FINDER_COLUMN_LASTNAME_LASTNAME_3);
            } else {
                bindLastName = true;

                query.append(_FINDER_COLUMN_LASTNAME_LASTNAME_2);
            }

            if (orderByComparator != null) {
                appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS,
                    orderByComparator);
            } else
             if (pagination) {
                query.append(PersnModelImpl.ORDER_BY_JPQL);
            }

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                if (bindLastName) {
                    qPos.add(lastName);
                }

                if (!pagination) {
                    list = (List<Persn>) QueryUtil.list(q, getDialect(), start,
                            end, false);

                    Collections.sort(list);

                    list = new UnmodifiableList<Persn>(list);
                } else {
                    list = (List<Persn>) QueryUtil.list(q, getDialect(), start,
                            end);
                }

                cacheResult(list);

                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return list;
    }

    /**
     * Returns the first persn in the ordered set where lastName = &#63;.
     *
     * @param lastName the last name
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching persn
     * @throws gov.va.caret.NoSuchPersnException if a matching persn could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Persn findByLastName_First(String lastName,
        OrderByComparator orderByComparator)
        throws NoSuchPersnException, SystemException {
        Persn persn = fetchByLastName_First(lastName, orderByComparator);

        if (persn != null) {
            return persn;
        }

        StringBundler msg = new StringBundler(4);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("lastName=");
        msg.append(lastName);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchPersnException(msg.toString());
    }

    /**
     * Returns the first persn in the ordered set where lastName = &#63;.
     *
     * @param lastName the last name
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching persn, or <code>null</code> if a matching persn could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Persn fetchByLastName_First(String lastName,
        OrderByComparator orderByComparator) throws SystemException {
        List<Persn> list = findByLastName(lastName, 0, 1, orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the last persn in the ordered set where lastName = &#63;.
     *
     * @param lastName the last name
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching persn
     * @throws gov.va.caret.NoSuchPersnException if a matching persn could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Persn findByLastName_Last(String lastName,
        OrderByComparator orderByComparator)
        throws NoSuchPersnException, SystemException {
        Persn persn = fetchByLastName_Last(lastName, orderByComparator);

        if (persn != null) {
            return persn;
        }

        StringBundler msg = new StringBundler(4);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("lastName=");
        msg.append(lastName);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchPersnException(msg.toString());
    }

    /**
     * Returns the last persn in the ordered set where lastName = &#63;.
     *
     * @param lastName the last name
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching persn, or <code>null</code> if a matching persn could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Persn fetchByLastName_Last(String lastName,
        OrderByComparator orderByComparator) throws SystemException {
        int count = countByLastName(lastName);

        if (count == 0) {
            return null;
        }

        List<Persn> list = findByLastName(lastName, count - 1, count,
                orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the persns before and after the current persn in the ordered set where lastName = &#63;.
     *
     * @param persnId the primary key of the current persn
     * @param lastName the last name
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the previous, current, and next persn
     * @throws gov.va.caret.NoSuchPersnException if a persn with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Persn[] findByLastName_PrevAndNext(long persnId, String lastName,
        OrderByComparator orderByComparator)
        throws NoSuchPersnException, SystemException {
        Persn persn = findByPrimaryKey(persnId);

        Session session = null;

        try {
            session = openSession();

            Persn[] array = new PersnImpl[3];

            array[0] = getByLastName_PrevAndNext(session, persn, lastName,
                    orderByComparator, true);

            array[1] = persn;

            array[2] = getByLastName_PrevAndNext(session, persn, lastName,
                    orderByComparator, false);

            return array;
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }
    }

    protected Persn getByLastName_PrevAndNext(Session session, Persn persn,
        String lastName, OrderByComparator orderByComparator, boolean previous) {
        StringBundler query = null;

        if (orderByComparator != null) {
            query = new StringBundler(6 +
                    (orderByComparator.getOrderByFields().length * 6));
        } else {
            query = new StringBundler(3);
        }

        query.append(_SQL_SELECT_PERSN_WHERE);

        boolean bindLastName = false;

        if (lastName == null) {
            query.append(_FINDER_COLUMN_LASTNAME_LASTNAME_1);
        } else if (lastName.equals(StringPool.BLANK)) {
            query.append(_FINDER_COLUMN_LASTNAME_LASTNAME_3);
        } else {
            bindLastName = true;

            query.append(_FINDER_COLUMN_LASTNAME_LASTNAME_2);
        }

        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();

            if (orderByConditionFields.length > 0) {
                query.append(WHERE_AND);
            }

            for (int i = 0; i < orderByConditionFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);

                if ((i + 1) < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN_HAS_NEXT);
                    } else {
                        query.append(WHERE_LESSER_THAN_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN);
                    } else {
                        query.append(WHERE_LESSER_THAN);
                    }
                }
            }

            query.append(ORDER_BY_CLAUSE);

            String[] orderByFields = orderByComparator.getOrderByFields();

            for (int i = 0; i < orderByFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);

                if ((i + 1) < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC_HAS_NEXT);
                    } else {
                        query.append(ORDER_BY_DESC_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC);
                    } else {
                        query.append(ORDER_BY_DESC);
                    }
                }
            }
        } else {
            query.append(PersnModelImpl.ORDER_BY_JPQL);
        }

        String sql = query.toString();

        Query q = session.createQuery(sql);

        q.setFirstResult(0);
        q.setMaxResults(2);

        QueryPos qPos = QueryPos.getInstance(q);

        if (bindLastName) {
            qPos.add(lastName);
        }

        if (orderByComparator != null) {
            Object[] values = orderByComparator.getOrderByConditionValues(persn);

            for (Object value : values) {
                qPos.add(value);
            }
        }

        List<Persn> list = q.list();

        if (list.size() == 2) {
            return list.get(1);
        } else {
            return null;
        }
    }

    /**
     * Removes all the persns where lastName = &#63; from the database.
     *
     * @param lastName the last name
     * @throws SystemException if a system exception occurred
     */
    @Override
    public void removeByLastName(String lastName) throws SystemException {
        for (Persn persn : findByLastName(lastName, QueryUtil.ALL_POS,
                QueryUtil.ALL_POS, null)) {
            remove(persn);
        }
    }

    /**
     * Returns the number of persns where lastName = &#63;.
     *
     * @param lastName the last name
     * @return the number of matching persns
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int countByLastName(String lastName) throws SystemException {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_LASTNAME;

        Object[] finderArgs = new Object[] { lastName };

        Long count = (Long) FinderCacheUtil.getResult(finderPath, finderArgs,
                this);

        if (count == null) {
            StringBundler query = new StringBundler(2);

            query.append(_SQL_COUNT_PERSN_WHERE);

            boolean bindLastName = false;

            if (lastName == null) {
                query.append(_FINDER_COLUMN_LASTNAME_LASTNAME_1);
            } else if (lastName.equals(StringPool.BLANK)) {
                query.append(_FINDER_COLUMN_LASTNAME_LASTNAME_3);
            } else {
                bindLastName = true;

                query.append(_FINDER_COLUMN_LASTNAME_LASTNAME_2);
            }

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                if (bindLastName) {
                    qPos.add(lastName);
                }

                count = (Long) q.uniqueResult();

                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return count.intValue();
    }

    /**
     * Returns all the persns where birthDate = &#63;.
     *
     * @param birthDate the birth date
     * @return the matching persns
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<Persn> findByBirthDate(Date birthDate)
        throws SystemException {
        return findByBirthDate(birthDate, QueryUtil.ALL_POS, QueryUtil.ALL_POS,
            null);
    }

    /**
     * Returns a range of all the persns where birthDate = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.PersnModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param birthDate the birth date
     * @param start the lower bound of the range of persns
     * @param end the upper bound of the range of persns (not inclusive)
     * @return the range of matching persns
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<Persn> findByBirthDate(Date birthDate, int start, int end)
        throws SystemException {
        return findByBirthDate(birthDate, start, end, null);
    }

    /**
     * Returns an ordered range of all the persns where birthDate = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.PersnModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param birthDate the birth date
     * @param start the lower bound of the range of persns
     * @param end the upper bound of the range of persns (not inclusive)
     * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
     * @return the ordered range of matching persns
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<Persn> findByBirthDate(Date birthDate, int start, int end,
        OrderByComparator orderByComparator) throws SystemException {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;

        if ((start == QueryUtil.ALL_POS) && (end == QueryUtil.ALL_POS) &&
                (orderByComparator == null)) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_BIRTHDATE;
            finderArgs = new Object[] { birthDate };
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_BIRTHDATE;
            finderArgs = new Object[] { birthDate, start, end, orderByComparator };
        }

        List<Persn> list = (List<Persn>) FinderCacheUtil.getResult(finderPath,
                finderArgs, this);

        if ((list != null) && !list.isEmpty()) {
            for (Persn persn : list) {
                if (!Validator.equals(birthDate, persn.getBirthDate())) {
                    list = null;

                    break;
                }
            }
        }

        if (list == null) {
            StringBundler query = null;

            if (orderByComparator != null) {
                query = new StringBundler(3 +
                        (orderByComparator.getOrderByFields().length * 3));
            } else {
                query = new StringBundler(3);
            }

            query.append(_SQL_SELECT_PERSN_WHERE);

            boolean bindBirthDate = false;

            if (birthDate == null) {
                query.append(_FINDER_COLUMN_BIRTHDATE_BIRTHDATE_1);
            } else {
                bindBirthDate = true;

                query.append(_FINDER_COLUMN_BIRTHDATE_BIRTHDATE_2);
            }

            if (orderByComparator != null) {
                appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS,
                    orderByComparator);
            } else
             if (pagination) {
                query.append(PersnModelImpl.ORDER_BY_JPQL);
            }

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                if (bindBirthDate) {
                    qPos.add(CalendarUtil.getTimestamp(birthDate));
                }

                if (!pagination) {
                    list = (List<Persn>) QueryUtil.list(q, getDialect(), start,
                            end, false);

                    Collections.sort(list);

                    list = new UnmodifiableList<Persn>(list);
                } else {
                    list = (List<Persn>) QueryUtil.list(q, getDialect(), start,
                            end);
                }

                cacheResult(list);

                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return list;
    }

    /**
     * Returns the first persn in the ordered set where birthDate = &#63;.
     *
     * @param birthDate the birth date
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching persn
     * @throws gov.va.caret.NoSuchPersnException if a matching persn could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Persn findByBirthDate_First(Date birthDate,
        OrderByComparator orderByComparator)
        throws NoSuchPersnException, SystemException {
        Persn persn = fetchByBirthDate_First(birthDate, orderByComparator);

        if (persn != null) {
            return persn;
        }

        StringBundler msg = new StringBundler(4);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("birthDate=");
        msg.append(birthDate);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchPersnException(msg.toString());
    }

    /**
     * Returns the first persn in the ordered set where birthDate = &#63;.
     *
     * @param birthDate the birth date
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching persn, or <code>null</code> if a matching persn could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Persn fetchByBirthDate_First(Date birthDate,
        OrderByComparator orderByComparator) throws SystemException {
        List<Persn> list = findByBirthDate(birthDate, 0, 1, orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the last persn in the ordered set where birthDate = &#63;.
     *
     * @param birthDate the birth date
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching persn
     * @throws gov.va.caret.NoSuchPersnException if a matching persn could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Persn findByBirthDate_Last(Date birthDate,
        OrderByComparator orderByComparator)
        throws NoSuchPersnException, SystemException {
        Persn persn = fetchByBirthDate_Last(birthDate, orderByComparator);

        if (persn != null) {
            return persn;
        }

        StringBundler msg = new StringBundler(4);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("birthDate=");
        msg.append(birthDate);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchPersnException(msg.toString());
    }

    /**
     * Returns the last persn in the ordered set where birthDate = &#63;.
     *
     * @param birthDate the birth date
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching persn, or <code>null</code> if a matching persn could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Persn fetchByBirthDate_Last(Date birthDate,
        OrderByComparator orderByComparator) throws SystemException {
        int count = countByBirthDate(birthDate);

        if (count == 0) {
            return null;
        }

        List<Persn> list = findByBirthDate(birthDate, count - 1, count,
                orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the persns before and after the current persn in the ordered set where birthDate = &#63;.
     *
     * @param persnId the primary key of the current persn
     * @param birthDate the birth date
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the previous, current, and next persn
     * @throws gov.va.caret.NoSuchPersnException if a persn with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Persn[] findByBirthDate_PrevAndNext(long persnId, Date birthDate,
        OrderByComparator orderByComparator)
        throws NoSuchPersnException, SystemException {
        Persn persn = findByPrimaryKey(persnId);

        Session session = null;

        try {
            session = openSession();

            Persn[] array = new PersnImpl[3];

            array[0] = getByBirthDate_PrevAndNext(session, persn, birthDate,
                    orderByComparator, true);

            array[1] = persn;

            array[2] = getByBirthDate_PrevAndNext(session, persn, birthDate,
                    orderByComparator, false);

            return array;
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }
    }

    protected Persn getByBirthDate_PrevAndNext(Session session, Persn persn,
        Date birthDate, OrderByComparator orderByComparator, boolean previous) {
        StringBundler query = null;

        if (orderByComparator != null) {
            query = new StringBundler(6 +
                    (orderByComparator.getOrderByFields().length * 6));
        } else {
            query = new StringBundler(3);
        }

        query.append(_SQL_SELECT_PERSN_WHERE);

        boolean bindBirthDate = false;

        if (birthDate == null) {
            query.append(_FINDER_COLUMN_BIRTHDATE_BIRTHDATE_1);
        } else {
            bindBirthDate = true;

            query.append(_FINDER_COLUMN_BIRTHDATE_BIRTHDATE_2);
        }

        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();

            if (orderByConditionFields.length > 0) {
                query.append(WHERE_AND);
            }

            for (int i = 0; i < orderByConditionFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);

                if ((i + 1) < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN_HAS_NEXT);
                    } else {
                        query.append(WHERE_LESSER_THAN_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN);
                    } else {
                        query.append(WHERE_LESSER_THAN);
                    }
                }
            }

            query.append(ORDER_BY_CLAUSE);

            String[] orderByFields = orderByComparator.getOrderByFields();

            for (int i = 0; i < orderByFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);

                if ((i + 1) < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC_HAS_NEXT);
                    } else {
                        query.append(ORDER_BY_DESC_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC);
                    } else {
                        query.append(ORDER_BY_DESC);
                    }
                }
            }
        } else {
            query.append(PersnModelImpl.ORDER_BY_JPQL);
        }

        String sql = query.toString();

        Query q = session.createQuery(sql);

        q.setFirstResult(0);
        q.setMaxResults(2);

        QueryPos qPos = QueryPos.getInstance(q);

        if (bindBirthDate) {
            qPos.add(CalendarUtil.getTimestamp(birthDate));
        }

        if (orderByComparator != null) {
            Object[] values = orderByComparator.getOrderByConditionValues(persn);

            for (Object value : values) {
                qPos.add(value);
            }
        }

        List<Persn> list = q.list();

        if (list.size() == 2) {
            return list.get(1);
        } else {
            return null;
        }
    }

    /**
     * Removes all the persns where birthDate = &#63; from the database.
     *
     * @param birthDate the birth date
     * @throws SystemException if a system exception occurred
     */
    @Override
    public void removeByBirthDate(Date birthDate) throws SystemException {
        for (Persn persn : findByBirthDate(birthDate, QueryUtil.ALL_POS,
                QueryUtil.ALL_POS, null)) {
            remove(persn);
        }
    }

    /**
     * Returns the number of persns where birthDate = &#63;.
     *
     * @param birthDate the birth date
     * @return the number of matching persns
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int countByBirthDate(Date birthDate) throws SystemException {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_BIRTHDATE;

        Object[] finderArgs = new Object[] { birthDate };

        Long count = (Long) FinderCacheUtil.getResult(finderPath, finderArgs,
                this);

        if (count == null) {
            StringBundler query = new StringBundler(2);

            query.append(_SQL_COUNT_PERSN_WHERE);

            boolean bindBirthDate = false;

            if (birthDate == null) {
                query.append(_FINDER_COLUMN_BIRTHDATE_BIRTHDATE_1);
            } else {
                bindBirthDate = true;

                query.append(_FINDER_COLUMN_BIRTHDATE_BIRTHDATE_2);
            }

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                if (bindBirthDate) {
                    qPos.add(CalendarUtil.getTimestamp(birthDate));
                }

                count = (Long) q.uniqueResult();

                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return count.intValue();
    }

    /**
     * Returns the persn where persnUserId = &#63; or throws a {@link gov.va.caret.NoSuchPersnException} if it could not be found.
     *
     * @param persnUserId the persn user ID
     * @return the matching persn
     * @throws gov.va.caret.NoSuchPersnException if a matching persn could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Persn findByUser(long persnUserId)
        throws NoSuchPersnException, SystemException {
        Persn persn = fetchByUser(persnUserId);

        if (persn == null) {
            StringBundler msg = new StringBundler(4);

            msg.append(_NO_SUCH_ENTITY_WITH_KEY);

            msg.append("persnUserId=");
            msg.append(persnUserId);

            msg.append(StringPool.CLOSE_CURLY_BRACE);

            if (_log.isWarnEnabled()) {
                _log.warn(msg.toString());
            }

            throw new NoSuchPersnException(msg.toString());
        }

        return persn;
    }

    /**
     * Returns the persn where persnUserId = &#63; or returns <code>null</code> if it could not be found. Uses the finder cache.
     *
     * @param persnUserId the persn user ID
     * @return the matching persn, or <code>null</code> if a matching persn could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Persn fetchByUser(long persnUserId) throws SystemException {
        return fetchByUser(persnUserId, true);
    }

    /**
     * Returns the persn where persnUserId = &#63; or returns <code>null</code> if it could not be found, optionally using the finder cache.
     *
     * @param persnUserId the persn user ID
     * @param retrieveFromCache whether to use the finder cache
     * @return the matching persn, or <code>null</code> if a matching persn could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Persn fetchByUser(long persnUserId, boolean retrieveFromCache)
        throws SystemException {
        Object[] finderArgs = new Object[] { persnUserId };

        Object result = null;

        if (retrieveFromCache) {
            result = FinderCacheUtil.getResult(FINDER_PATH_FETCH_BY_USER,
                    finderArgs, this);
        }

        if (result instanceof Persn) {
            Persn persn = (Persn) result;

            if ((persnUserId != persn.getPersnUserId())) {
                result = null;
            }
        }

        if (result == null) {
            StringBundler query = new StringBundler(3);

            query.append(_SQL_SELECT_PERSN_WHERE);

            query.append(_FINDER_COLUMN_USER_PERSNUSERID_2);

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                qPos.add(persnUserId);

                List<Persn> list = q.list();

                if (list.isEmpty()) {
                    FinderCacheUtil.putResult(FINDER_PATH_FETCH_BY_USER,
                        finderArgs, list);
                } else {
                    if ((list.size() > 1) && _log.isWarnEnabled()) {
                        _log.warn(
                            "PersnPersistenceImpl.fetchByUser(long, boolean) with parameters (" +
                            StringUtil.merge(finderArgs) +
                            ") yields a result set with more than 1 result. This violates the logical unique restriction. There is no order guarantee on which result is returned by this finder.");
                    }

                    Persn persn = list.get(0);

                    result = persn;

                    cacheResult(persn);

                    if ((persn.getPersnUserId() != persnUserId)) {
                        FinderCacheUtil.putResult(FINDER_PATH_FETCH_BY_USER,
                            finderArgs, persn);
                    }
                }
            } catch (Exception e) {
                FinderCacheUtil.removeResult(FINDER_PATH_FETCH_BY_USER,
                    finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        if (result instanceof List<?>) {
            return null;
        } else {
            return (Persn) result;
        }
    }

    /**
     * Removes the persn where persnUserId = &#63; from the database.
     *
     * @param persnUserId the persn user ID
     * @return the persn that was removed
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Persn removeByUser(long persnUserId)
        throws NoSuchPersnException, SystemException {
        Persn persn = findByUser(persnUserId);

        return remove(persn);
    }

    /**
     * Returns the number of persns where persnUserId = &#63;.
     *
     * @param persnUserId the persn user ID
     * @return the number of matching persns
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int countByUser(long persnUserId) throws SystemException {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_USER;

        Object[] finderArgs = new Object[] { persnUserId };

        Long count = (Long) FinderCacheUtil.getResult(finderPath, finderArgs,
                this);

        if (count == null) {
            StringBundler query = new StringBundler(2);

            query.append(_SQL_COUNT_PERSN_WHERE);

            query.append(_FINDER_COLUMN_USER_PERSNUSERID_2);

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                qPos.add(persnUserId);

                count = (Long) q.uniqueResult();

                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return count.intValue();
    }

    /**
     * Returns all the persns where gender = &#63;.
     *
     * @param gender the gender
     * @return the matching persns
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<Persn> findByGender(String gender) throws SystemException {
        return findByGender(gender, QueryUtil.ALL_POS, QueryUtil.ALL_POS, null);
    }

    /**
     * Returns a range of all the persns where gender = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.PersnModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param gender the gender
     * @param start the lower bound of the range of persns
     * @param end the upper bound of the range of persns (not inclusive)
     * @return the range of matching persns
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<Persn> findByGender(String gender, int start, int end)
        throws SystemException {
        return findByGender(gender, start, end, null);
    }

    /**
     * Returns an ordered range of all the persns where gender = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.PersnModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param gender the gender
     * @param start the lower bound of the range of persns
     * @param end the upper bound of the range of persns (not inclusive)
     * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
     * @return the ordered range of matching persns
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<Persn> findByGender(String gender, int start, int end,
        OrderByComparator orderByComparator) throws SystemException {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;

        if ((start == QueryUtil.ALL_POS) && (end == QueryUtil.ALL_POS) &&
                (orderByComparator == null)) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_GENDER;
            finderArgs = new Object[] { gender };
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_GENDER;
            finderArgs = new Object[] { gender, start, end, orderByComparator };
        }

        List<Persn> list = (List<Persn>) FinderCacheUtil.getResult(finderPath,
                finderArgs, this);

        if ((list != null) && !list.isEmpty()) {
            for (Persn persn : list) {
                if (!Validator.equals(gender, persn.getGender())) {
                    list = null;

                    break;
                }
            }
        }

        if (list == null) {
            StringBundler query = null;

            if (orderByComparator != null) {
                query = new StringBundler(3 +
                        (orderByComparator.getOrderByFields().length * 3));
            } else {
                query = new StringBundler(3);
            }

            query.append(_SQL_SELECT_PERSN_WHERE);

            boolean bindGender = false;

            if (gender == null) {
                query.append(_FINDER_COLUMN_GENDER_GENDER_1);
            } else if (gender.equals(StringPool.BLANK)) {
                query.append(_FINDER_COLUMN_GENDER_GENDER_3);
            } else {
                bindGender = true;

                query.append(_FINDER_COLUMN_GENDER_GENDER_2);
            }

            if (orderByComparator != null) {
                appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS,
                    orderByComparator);
            } else
             if (pagination) {
                query.append(PersnModelImpl.ORDER_BY_JPQL);
            }

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                if (bindGender) {
                    qPos.add(gender);
                }

                if (!pagination) {
                    list = (List<Persn>) QueryUtil.list(q, getDialect(), start,
                            end, false);

                    Collections.sort(list);

                    list = new UnmodifiableList<Persn>(list);
                } else {
                    list = (List<Persn>) QueryUtil.list(q, getDialect(), start,
                            end);
                }

                cacheResult(list);

                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return list;
    }

    /**
     * Returns the first persn in the ordered set where gender = &#63;.
     *
     * @param gender the gender
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching persn
     * @throws gov.va.caret.NoSuchPersnException if a matching persn could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Persn findByGender_First(String gender,
        OrderByComparator orderByComparator)
        throws NoSuchPersnException, SystemException {
        Persn persn = fetchByGender_First(gender, orderByComparator);

        if (persn != null) {
            return persn;
        }

        StringBundler msg = new StringBundler(4);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("gender=");
        msg.append(gender);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchPersnException(msg.toString());
    }

    /**
     * Returns the first persn in the ordered set where gender = &#63;.
     *
     * @param gender the gender
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching persn, or <code>null</code> if a matching persn could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Persn fetchByGender_First(String gender,
        OrderByComparator orderByComparator) throws SystemException {
        List<Persn> list = findByGender(gender, 0, 1, orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the last persn in the ordered set where gender = &#63;.
     *
     * @param gender the gender
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching persn
     * @throws gov.va.caret.NoSuchPersnException if a matching persn could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Persn findByGender_Last(String gender,
        OrderByComparator orderByComparator)
        throws NoSuchPersnException, SystemException {
        Persn persn = fetchByGender_Last(gender, orderByComparator);

        if (persn != null) {
            return persn;
        }

        StringBundler msg = new StringBundler(4);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("gender=");
        msg.append(gender);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchPersnException(msg.toString());
    }

    /**
     * Returns the last persn in the ordered set where gender = &#63;.
     *
     * @param gender the gender
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching persn, or <code>null</code> if a matching persn could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Persn fetchByGender_Last(String gender,
        OrderByComparator orderByComparator) throws SystemException {
        int count = countByGender(gender);

        if (count == 0) {
            return null;
        }

        List<Persn> list = findByGender(gender, count - 1, count,
                orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the persns before and after the current persn in the ordered set where gender = &#63;.
     *
     * @param persnId the primary key of the current persn
     * @param gender the gender
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the previous, current, and next persn
     * @throws gov.va.caret.NoSuchPersnException if a persn with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Persn[] findByGender_PrevAndNext(long persnId, String gender,
        OrderByComparator orderByComparator)
        throws NoSuchPersnException, SystemException {
        Persn persn = findByPrimaryKey(persnId);

        Session session = null;

        try {
            session = openSession();

            Persn[] array = new PersnImpl[3];

            array[0] = getByGender_PrevAndNext(session, persn, gender,
                    orderByComparator, true);

            array[1] = persn;

            array[2] = getByGender_PrevAndNext(session, persn, gender,
                    orderByComparator, false);

            return array;
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }
    }

    protected Persn getByGender_PrevAndNext(Session session, Persn persn,
        String gender, OrderByComparator orderByComparator, boolean previous) {
        StringBundler query = null;

        if (orderByComparator != null) {
            query = new StringBundler(6 +
                    (orderByComparator.getOrderByFields().length * 6));
        } else {
            query = new StringBundler(3);
        }

        query.append(_SQL_SELECT_PERSN_WHERE);

        boolean bindGender = false;

        if (gender == null) {
            query.append(_FINDER_COLUMN_GENDER_GENDER_1);
        } else if (gender.equals(StringPool.BLANK)) {
            query.append(_FINDER_COLUMN_GENDER_GENDER_3);
        } else {
            bindGender = true;

            query.append(_FINDER_COLUMN_GENDER_GENDER_2);
        }

        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();

            if (orderByConditionFields.length > 0) {
                query.append(WHERE_AND);
            }

            for (int i = 0; i < orderByConditionFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);

                if ((i + 1) < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN_HAS_NEXT);
                    } else {
                        query.append(WHERE_LESSER_THAN_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN);
                    } else {
                        query.append(WHERE_LESSER_THAN);
                    }
                }
            }

            query.append(ORDER_BY_CLAUSE);

            String[] orderByFields = orderByComparator.getOrderByFields();

            for (int i = 0; i < orderByFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);

                if ((i + 1) < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC_HAS_NEXT);
                    } else {
                        query.append(ORDER_BY_DESC_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC);
                    } else {
                        query.append(ORDER_BY_DESC);
                    }
                }
            }
        } else {
            query.append(PersnModelImpl.ORDER_BY_JPQL);
        }

        String sql = query.toString();

        Query q = session.createQuery(sql);

        q.setFirstResult(0);
        q.setMaxResults(2);

        QueryPos qPos = QueryPos.getInstance(q);

        if (bindGender) {
            qPos.add(gender);
        }

        if (orderByComparator != null) {
            Object[] values = orderByComparator.getOrderByConditionValues(persn);

            for (Object value : values) {
                qPos.add(value);
            }
        }

        List<Persn> list = q.list();

        if (list.size() == 2) {
            return list.get(1);
        } else {
            return null;
        }
    }

    /**
     * Removes all the persns where gender = &#63; from the database.
     *
     * @param gender the gender
     * @throws SystemException if a system exception occurred
     */
    @Override
    public void removeByGender(String gender) throws SystemException {
        for (Persn persn : findByGender(gender, QueryUtil.ALL_POS,
                QueryUtil.ALL_POS, null)) {
            remove(persn);
        }
    }

    /**
     * Returns the number of persns where gender = &#63;.
     *
     * @param gender the gender
     * @return the number of matching persns
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int countByGender(String gender) throws SystemException {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_GENDER;

        Object[] finderArgs = new Object[] { gender };

        Long count = (Long) FinderCacheUtil.getResult(finderPath, finderArgs,
                this);

        if (count == null) {
            StringBundler query = new StringBundler(2);

            query.append(_SQL_COUNT_PERSN_WHERE);

            boolean bindGender = false;

            if (gender == null) {
                query.append(_FINDER_COLUMN_GENDER_GENDER_1);
            } else if (gender.equals(StringPool.BLANK)) {
                query.append(_FINDER_COLUMN_GENDER_GENDER_3);
            } else {
                bindGender = true;

                query.append(_FINDER_COLUMN_GENDER_GENDER_2);
            }

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                if (bindGender) {
                    qPos.add(gender);
                }

                count = (Long) q.uniqueResult();

                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return count.intValue();
    }

    /**
     * Returns the persn where externalId = &#63; or throws a {@link gov.va.caret.NoSuchPersnException} if it could not be found.
     *
     * @param externalId the external ID
     * @return the matching persn
     * @throws gov.va.caret.NoSuchPersnException if a matching persn could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Persn findByExternalId(String externalId)
        throws NoSuchPersnException, SystemException {
        Persn persn = fetchByExternalId(externalId);

        if (persn == null) {
            StringBundler msg = new StringBundler(4);

            msg.append(_NO_SUCH_ENTITY_WITH_KEY);

            msg.append("externalId=");
            msg.append(externalId);

            msg.append(StringPool.CLOSE_CURLY_BRACE);

            if (_log.isWarnEnabled()) {
                _log.warn(msg.toString());
            }

            throw new NoSuchPersnException(msg.toString());
        }

        return persn;
    }

    /**
     * Returns the persn where externalId = &#63; or returns <code>null</code> if it could not be found. Uses the finder cache.
     *
     * @param externalId the external ID
     * @return the matching persn, or <code>null</code> if a matching persn could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Persn fetchByExternalId(String externalId) throws SystemException {
        return fetchByExternalId(externalId, true);
    }

    /**
     * Returns the persn where externalId = &#63; or returns <code>null</code> if it could not be found, optionally using the finder cache.
     *
     * @param externalId the external ID
     * @param retrieveFromCache whether to use the finder cache
     * @return the matching persn, or <code>null</code> if a matching persn could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Persn fetchByExternalId(String externalId, boolean retrieveFromCache)
        throws SystemException {
        Object[] finderArgs = new Object[] { externalId };

        Object result = null;

        if (retrieveFromCache) {
            result = FinderCacheUtil.getResult(FINDER_PATH_FETCH_BY_EXTERNALID,
                    finderArgs, this);
        }

        if (result instanceof Persn) {
            Persn persn = (Persn) result;

            if (!Validator.equals(externalId, persn.getExternalId())) {
                result = null;
            }
        }

        if (result == null) {
            StringBundler query = new StringBundler(3);

            query.append(_SQL_SELECT_PERSN_WHERE);

            boolean bindExternalId = false;

            if (externalId == null) {
                query.append(_FINDER_COLUMN_EXTERNALID_EXTERNALID_1);
            } else if (externalId.equals(StringPool.BLANK)) {
                query.append(_FINDER_COLUMN_EXTERNALID_EXTERNALID_3);
            } else {
                bindExternalId = true;

                query.append(_FINDER_COLUMN_EXTERNALID_EXTERNALID_2);
            }

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                if (bindExternalId) {
                    qPos.add(externalId);
                }

                List<Persn> list = q.list();

                if (list.isEmpty()) {
                    FinderCacheUtil.putResult(FINDER_PATH_FETCH_BY_EXTERNALID,
                        finderArgs, list);
                } else {
                    if ((list.size() > 1) && _log.isWarnEnabled()) {
                        _log.warn(
                            "PersnPersistenceImpl.fetchByExternalId(String, boolean) with parameters (" +
                            StringUtil.merge(finderArgs) +
                            ") yields a result set with more than 1 result. This violates the logical unique restriction. There is no order guarantee on which result is returned by this finder.");
                    }

                    Persn persn = list.get(0);

                    result = persn;

                    cacheResult(persn);

                    if ((persn.getExternalId() == null) ||
                            !persn.getExternalId().equals(externalId)) {
                        FinderCacheUtil.putResult(FINDER_PATH_FETCH_BY_EXTERNALID,
                            finderArgs, persn);
                    }
                }
            } catch (Exception e) {
                FinderCacheUtil.removeResult(FINDER_PATH_FETCH_BY_EXTERNALID,
                    finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        if (result instanceof List<?>) {
            return null;
        } else {
            return (Persn) result;
        }
    }

    /**
     * Removes the persn where externalId = &#63; from the database.
     *
     * @param externalId the external ID
     * @return the persn that was removed
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Persn removeByExternalId(String externalId)
        throws NoSuchPersnException, SystemException {
        Persn persn = findByExternalId(externalId);

        return remove(persn);
    }

    /**
     * Returns the number of persns where externalId = &#63;.
     *
     * @param externalId the external ID
     * @return the number of matching persns
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int countByExternalId(String externalId) throws SystemException {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_EXTERNALID;

        Object[] finderArgs = new Object[] { externalId };

        Long count = (Long) FinderCacheUtil.getResult(finderPath, finderArgs,
                this);

        if (count == null) {
            StringBundler query = new StringBundler(2);

            query.append(_SQL_COUNT_PERSN_WHERE);

            boolean bindExternalId = false;

            if (externalId == null) {
                query.append(_FINDER_COLUMN_EXTERNALID_EXTERNALID_1);
            } else if (externalId.equals(StringPool.BLANK)) {
                query.append(_FINDER_COLUMN_EXTERNALID_EXTERNALID_3);
            } else {
                bindExternalId = true;

                query.append(_FINDER_COLUMN_EXTERNALID_EXTERNALID_2);
            }

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                if (bindExternalId) {
                    qPos.add(externalId);
                }

                count = (Long) q.uniqueResult();

                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return count.intValue();
    }

    /**
     * Caches the persn in the entity cache if it is enabled.
     *
     * @param persn the persn
     */
    @Override
    public void cacheResult(Persn persn) {
        EntityCacheUtil.putResult(PersnModelImpl.ENTITY_CACHE_ENABLED,
            PersnImpl.class, persn.getPrimaryKey(), persn);

        FinderCacheUtil.putResult(FINDER_PATH_FETCH_BY_USER,
            new Object[] { persn.getPersnUserId() }, persn);

        FinderCacheUtil.putResult(FINDER_PATH_FETCH_BY_EXTERNALID,
            new Object[] { persn.getExternalId() }, persn);

        persn.resetOriginalValues();
    }

    /**
     * Caches the persns in the entity cache if it is enabled.
     *
     * @param persns the persns
     */
    @Override
    public void cacheResult(List<Persn> persns) {
        for (Persn persn : persns) {
            if (EntityCacheUtil.getResult(PersnModelImpl.ENTITY_CACHE_ENABLED,
                        PersnImpl.class, persn.getPrimaryKey()) == null) {
                cacheResult(persn);
            } else {
                persn.resetOriginalValues();
            }
        }
    }

    /**
     * Clears the cache for all persns.
     *
     * <p>
     * The {@link com.liferay.portal.kernel.dao.orm.EntityCache} and {@link com.liferay.portal.kernel.dao.orm.FinderCache} are both cleared by this method.
     * </p>
     */
    @Override
    public void clearCache() {
        if (_HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE) {
            CacheRegistryUtil.clear(PersnImpl.class.getName());
        }

        EntityCacheUtil.clearCache(PersnImpl.class.getName());

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    /**
     * Clears the cache for the persn.
     *
     * <p>
     * The {@link com.liferay.portal.kernel.dao.orm.EntityCache} and {@link com.liferay.portal.kernel.dao.orm.FinderCache} are both cleared by this method.
     * </p>
     */
    @Override
    public void clearCache(Persn persn) {
        EntityCacheUtil.removeResult(PersnModelImpl.ENTITY_CACHE_ENABLED,
            PersnImpl.class, persn.getPrimaryKey());

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);

        clearUniqueFindersCache(persn);
    }

    @Override
    public void clearCache(List<Persn> persns) {
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);

        for (Persn persn : persns) {
            EntityCacheUtil.removeResult(PersnModelImpl.ENTITY_CACHE_ENABLED,
                PersnImpl.class, persn.getPrimaryKey());

            clearUniqueFindersCache(persn);
        }
    }

    protected void cacheUniqueFindersCache(Persn persn) {
        if (persn.isNew()) {
            Object[] args = new Object[] { persn.getPersnUserId() };

            FinderCacheUtil.putResult(FINDER_PATH_COUNT_BY_USER, args,
                Long.valueOf(1));
            FinderCacheUtil.putResult(FINDER_PATH_FETCH_BY_USER, args, persn);

            args = new Object[] { persn.getExternalId() };

            FinderCacheUtil.putResult(FINDER_PATH_COUNT_BY_EXTERNALID, args,
                Long.valueOf(1));
            FinderCacheUtil.putResult(FINDER_PATH_FETCH_BY_EXTERNALID, args,
                persn);
        } else {
            PersnModelImpl persnModelImpl = (PersnModelImpl) persn;

            if ((persnModelImpl.getColumnBitmask() &
                    FINDER_PATH_FETCH_BY_USER.getColumnBitmask()) != 0) {
                Object[] args = new Object[] { persn.getPersnUserId() };

                FinderCacheUtil.putResult(FINDER_PATH_COUNT_BY_USER, args,
                    Long.valueOf(1));
                FinderCacheUtil.putResult(FINDER_PATH_FETCH_BY_USER, args, persn);
            }

            if ((persnModelImpl.getColumnBitmask() &
                    FINDER_PATH_FETCH_BY_EXTERNALID.getColumnBitmask()) != 0) {
                Object[] args = new Object[] { persn.getExternalId() };

                FinderCacheUtil.putResult(FINDER_PATH_COUNT_BY_EXTERNALID,
                    args, Long.valueOf(1));
                FinderCacheUtil.putResult(FINDER_PATH_FETCH_BY_EXTERNALID,
                    args, persn);
            }
        }
    }

    protected void clearUniqueFindersCache(Persn persn) {
        PersnModelImpl persnModelImpl = (PersnModelImpl) persn;

        Object[] args = new Object[] { persn.getPersnUserId() };

        FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_USER, args);
        FinderCacheUtil.removeResult(FINDER_PATH_FETCH_BY_USER, args);

        if ((persnModelImpl.getColumnBitmask() &
                FINDER_PATH_FETCH_BY_USER.getColumnBitmask()) != 0) {
            args = new Object[] { persnModelImpl.getOriginalPersnUserId() };

            FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_USER, args);
            FinderCacheUtil.removeResult(FINDER_PATH_FETCH_BY_USER, args);
        }

        args = new Object[] { persn.getExternalId() };

        FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_EXTERNALID, args);
        FinderCacheUtil.removeResult(FINDER_PATH_FETCH_BY_EXTERNALID, args);

        if ((persnModelImpl.getColumnBitmask() &
                FINDER_PATH_FETCH_BY_EXTERNALID.getColumnBitmask()) != 0) {
            args = new Object[] { persnModelImpl.getOriginalExternalId() };

            FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_EXTERNALID, args);
            FinderCacheUtil.removeResult(FINDER_PATH_FETCH_BY_EXTERNALID, args);
        }
    }

    /**
     * Creates a new persn with the primary key. Does not add the persn to the database.
     *
     * @param persnId the primary key for the new persn
     * @return the new persn
     */
    @Override
    public Persn create(long persnId) {
        Persn persn = new PersnImpl();

        persn.setNew(true);
        persn.setPrimaryKey(persnId);

        return persn;
    }

    /**
     * Removes the persn with the primary key from the database. Also notifies the appropriate model listeners.
     *
     * @param persnId the primary key of the persn
     * @return the persn that was removed
     * @throws gov.va.caret.NoSuchPersnException if a persn with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Persn remove(long persnId)
        throws NoSuchPersnException, SystemException {
        return remove((Serializable) persnId);
    }

    /**
     * Removes the persn with the primary key from the database. Also notifies the appropriate model listeners.
     *
     * @param primaryKey the primary key of the persn
     * @return the persn that was removed
     * @throws gov.va.caret.NoSuchPersnException if a persn with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Persn remove(Serializable primaryKey)
        throws NoSuchPersnException, SystemException {
        Session session = null;

        try {
            session = openSession();

            Persn persn = (Persn) session.get(PersnImpl.class, primaryKey);

            if (persn == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
                }

                throw new NoSuchPersnException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY +
                    primaryKey);
            }

            return remove(persn);
        } catch (NoSuchPersnException nsee) {
            throw nsee;
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }
    }

    @Override
    protected Persn removeImpl(Persn persn) throws SystemException {
        persn = toUnwrappedModel(persn);

        Session session = null;

        try {
            session = openSession();

            if (!session.contains(persn)) {
                persn = (Persn) session.get(PersnImpl.class,
                        persn.getPrimaryKeyObj());
            }

            if (persn != null) {
                session.delete(persn);
            }
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }

        if (persn != null) {
            clearCache(persn);
        }

        return persn;
    }

    @Override
    public Persn updateImpl(gov.va.caret.model.Persn persn)
        throws SystemException {
        persn = toUnwrappedModel(persn);

        boolean isNew = persn.isNew();

        PersnModelImpl persnModelImpl = (PersnModelImpl) persn;

        Session session = null;

        try {
            session = openSession();

            if (persn.isNew()) {
                session.save(persn);

                persn.setNew(false);
            } else {
                session.merge(persn);
            }
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);

        if (isNew || !PersnModelImpl.COLUMN_BITMASK_ENABLED) {
            FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        }
        else {
            if ((persnModelImpl.getColumnBitmask() &
                    FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_FIRSTNAME.getColumnBitmask()) != 0) {
                Object[] args = new Object[] {
                        persnModelImpl.getOriginalFirstName()
                    };

                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_FIRSTNAME,
                    args);
                FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_FIRSTNAME,
                    args);

                args = new Object[] { persnModelImpl.getFirstName() };

                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_FIRSTNAME,
                    args);
                FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_FIRSTNAME,
                    args);
            }

            if ((persnModelImpl.getColumnBitmask() &
                    FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_LASTNAME.getColumnBitmask()) != 0) {
                Object[] args = new Object[] {
                        persnModelImpl.getOriginalLastName()
                    };

                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_LASTNAME, args);
                FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_LASTNAME,
                    args);

                args = new Object[] { persnModelImpl.getLastName() };

                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_LASTNAME, args);
                FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_LASTNAME,
                    args);
            }

            if ((persnModelImpl.getColumnBitmask() &
                    FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_BIRTHDATE.getColumnBitmask()) != 0) {
                Object[] args = new Object[] {
                        persnModelImpl.getOriginalBirthDate()
                    };

                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_BIRTHDATE,
                    args);
                FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_BIRTHDATE,
                    args);

                args = new Object[] { persnModelImpl.getBirthDate() };

                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_BIRTHDATE,
                    args);
                FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_BIRTHDATE,
                    args);
            }

            if ((persnModelImpl.getColumnBitmask() &
                    FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_GENDER.getColumnBitmask()) != 0) {
                Object[] args = new Object[] { persnModelImpl.getOriginalGender() };

                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_GENDER, args);
                FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_GENDER,
                    args);

                args = new Object[] { persnModelImpl.getGender() };

                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_GENDER, args);
                FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_GENDER,
                    args);
            }
        }

        EntityCacheUtil.putResult(PersnModelImpl.ENTITY_CACHE_ENABLED,
            PersnImpl.class, persn.getPrimaryKey(), persn);

        clearUniqueFindersCache(persn);
        cacheUniqueFindersCache(persn);

        return persn;
    }

    protected Persn toUnwrappedModel(Persn persn) {
        if (persn instanceof PersnImpl) {
            return persn;
        }

        PersnImpl persnImpl = new PersnImpl();

        persnImpl.setNew(persn.isNew());
        persnImpl.setPrimaryKey(persn.getPrimaryKey());

        persnImpl.setPersnId(persn.getPersnId());
        persnImpl.setPersnUserId(persn.getPersnUserId());
        persnImpl.setLastName(persn.getLastName());
        persnImpl.setFirstName(persn.getFirstName());
        persnImpl.setMiddleName(persn.getMiddleName());
        persnImpl.setPrefix(persn.getPrefix());
        persnImpl.setSuffix(persn.getSuffix());
        persnImpl.setBirthDate(persn.getBirthDate());
        persnImpl.setDeceasedDate(persn.getDeceasedDate());
        persnImpl.setGender(persn.getGender());
        persnImpl.setAddress(persn.getAddress());
        persnImpl.setAddress2(persn.getAddress2());
        persnImpl.setCity(persn.getCity());
        persnImpl.setState(persn.getState());
        persnImpl.setCountry(persn.getCountry());
        persnImpl.setZip(persn.getZip());
        persnImpl.setPhone(persn.getPhone());
        persnImpl.setPhone2(persn.getPhone2());
        persnImpl.setEmail(persn.getEmail());
        persnImpl.setEmail2(persn.getEmail2());
        persnImpl.setStatus(persn.getStatus());
        persnImpl.setSource(persn.getSource());
        persnImpl.setExternalId(persn.getExternalId());
        persnImpl.setOtherHealthInsurance(persn.getOtherHealthInsurance());
        persnImpl.setUserId(persn.getUserId());
        persnImpl.setGroupId(persn.getGroupId());

        return persnImpl;
    }

    /**
     * Returns the persn with the primary key or throws a {@link com.liferay.portal.NoSuchModelException} if it could not be found.
     *
     * @param primaryKey the primary key of the persn
     * @return the persn
     * @throws gov.va.caret.NoSuchPersnException if a persn with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Persn findByPrimaryKey(Serializable primaryKey)
        throws NoSuchPersnException, SystemException {
        Persn persn = fetchByPrimaryKey(primaryKey);

        if (persn == null) {
            if (_log.isWarnEnabled()) {
                _log.warn(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }

            throw new NoSuchPersnException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY +
                primaryKey);
        }

        return persn;
    }

    /**
     * Returns the persn with the primary key or throws a {@link gov.va.caret.NoSuchPersnException} if it could not be found.
     *
     * @param persnId the primary key of the persn
     * @return the persn
     * @throws gov.va.caret.NoSuchPersnException if a persn with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Persn findByPrimaryKey(long persnId)
        throws NoSuchPersnException, SystemException {
        return findByPrimaryKey((Serializable) persnId);
    }

    /**
     * Returns the persn with the primary key or returns <code>null</code> if it could not be found.
     *
     * @param primaryKey the primary key of the persn
     * @return the persn, or <code>null</code> if a persn with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Persn fetchByPrimaryKey(Serializable primaryKey)
        throws SystemException {
        Persn persn = (Persn) EntityCacheUtil.getResult(PersnModelImpl.ENTITY_CACHE_ENABLED,
                PersnImpl.class, primaryKey);

        if (persn == _nullPersn) {
            return null;
        }

        if (persn == null) {
            Session session = null;

            try {
                session = openSession();

                persn = (Persn) session.get(PersnImpl.class, primaryKey);

                if (persn != null) {
                    cacheResult(persn);
                } else {
                    EntityCacheUtil.putResult(PersnModelImpl.ENTITY_CACHE_ENABLED,
                        PersnImpl.class, primaryKey, _nullPersn);
                }
            } catch (Exception e) {
                EntityCacheUtil.removeResult(PersnModelImpl.ENTITY_CACHE_ENABLED,
                    PersnImpl.class, primaryKey);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return persn;
    }

    /**
     * Returns the persn with the primary key or returns <code>null</code> if it could not be found.
     *
     * @param persnId the primary key of the persn
     * @return the persn, or <code>null</code> if a persn with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Persn fetchByPrimaryKey(long persnId) throws SystemException {
        return fetchByPrimaryKey((Serializable) persnId);
    }

    /**
     * Returns all the persns.
     *
     * @return the persns
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<Persn> findAll() throws SystemException {
        return findAll(QueryUtil.ALL_POS, QueryUtil.ALL_POS, null);
    }

    /**
     * Returns a range of all the persns.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.PersnModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param start the lower bound of the range of persns
     * @param end the upper bound of the range of persns (not inclusive)
     * @return the range of persns
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<Persn> findAll(int start, int end) throws SystemException {
        return findAll(start, end, null);
    }

    /**
     * Returns an ordered range of all the persns.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.PersnModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param start the lower bound of the range of persns
     * @param end the upper bound of the range of persns (not inclusive)
     * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
     * @return the ordered range of persns
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<Persn> findAll(int start, int end,
        OrderByComparator orderByComparator) throws SystemException {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;

        if ((start == QueryUtil.ALL_POS) && (end == QueryUtil.ALL_POS) &&
                (orderByComparator == null)) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL;
            finderArgs = FINDER_ARGS_EMPTY;
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_ALL;
            finderArgs = new Object[] { start, end, orderByComparator };
        }

        List<Persn> list = (List<Persn>) FinderCacheUtil.getResult(finderPath,
                finderArgs, this);

        if (list == null) {
            StringBundler query = null;
            String sql = null;

            if (orderByComparator != null) {
                query = new StringBundler(2 +
                        (orderByComparator.getOrderByFields().length * 3));

                query.append(_SQL_SELECT_PERSN);

                appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS,
                    orderByComparator);

                sql = query.toString();
            } else {
                sql = _SQL_SELECT_PERSN;

                if (pagination) {
                    sql = sql.concat(PersnModelImpl.ORDER_BY_JPQL);
                }
            }

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                if (!pagination) {
                    list = (List<Persn>) QueryUtil.list(q, getDialect(), start,
                            end, false);

                    Collections.sort(list);

                    list = new UnmodifiableList<Persn>(list);
                } else {
                    list = (List<Persn>) QueryUtil.list(q, getDialect(), start,
                            end);
                }

                cacheResult(list);

                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return list;
    }

    /**
     * Removes all the persns from the database.
     *
     * @throws SystemException if a system exception occurred
     */
    @Override
    public void removeAll() throws SystemException {
        for (Persn persn : findAll()) {
            remove(persn);
        }
    }

    /**
     * Returns the number of persns.
     *
     * @return the number of persns
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int countAll() throws SystemException {
        Long count = (Long) FinderCacheUtil.getResult(FINDER_PATH_COUNT_ALL,
                FINDER_ARGS_EMPTY, this);

        if (count == null) {
            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(_SQL_COUNT_PERSN);

                count = (Long) q.uniqueResult();

                FinderCacheUtil.putResult(FINDER_PATH_COUNT_ALL,
                    FINDER_ARGS_EMPTY, count);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_ALL,
                    FINDER_ARGS_EMPTY);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return count.intValue();
    }

    @Override
    protected Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    /**
     * Initializes the persn persistence.
     */
    public void afterPropertiesSet() {
        String[] listenerClassNames = StringUtil.split(GetterUtil.getString(
                    com.liferay.util.service.ServiceProps.get(
                        "value.object.listener.gov.va.caret.model.Persn")));

        if (listenerClassNames.length > 0) {
            try {
                List<ModelListener<Persn>> listenersList = new ArrayList<ModelListener<Persn>>();

                for (String listenerClassName : listenerClassNames) {
                    listenersList.add((ModelListener<Persn>) InstanceFactory.newInstance(
                            getClassLoader(), listenerClassName));
                }

                listeners = listenersList.toArray(new ModelListener[listenersList.size()]);
            } catch (Exception e) {
                _log.error(e);
            }
        }
    }

    public void destroy() {
        EntityCacheUtil.removeCache(PersnImpl.class.getName());
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}
