package gov.va.caret.service.persistence;

import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PropsKeys;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnmodifiableList;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.model.ModelListener;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;

import gov.va.caret.NoSuchBlsAeException;
import gov.va.caret.model.BlsAe;
import gov.va.caret.model.impl.BlsAeImpl;
import gov.va.caret.model.impl.BlsAeModelImpl;

import java.io.Serializable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * The persistence implementation for the bls ae service.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author caret
 * @see BlsAePersistence
 * @see BlsAeUtil
 * @generated
 */
public class BlsAePersistenceImpl extends BasePersistenceImpl<BlsAe>
    implements BlsAePersistence {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. Always use {@link BlsAeUtil} to access the bls ae persistence. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this class.
     */
    public static final String FINDER_CLASS_NAME_ENTITY = BlsAeImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY +
        ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY +
        ".List2";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_ALL = new FinderPath(BlsAeModelImpl.ENTITY_CACHE_ENABLED,
            BlsAeModelImpl.FINDER_CACHE_ENABLED, BlsAeImpl.class,
            FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL = new FinderPath(BlsAeModelImpl.ENTITY_CACHE_ENABLED,
            BlsAeModelImpl.FINDER_CACHE_ENABLED, BlsAeImpl.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_COUNT_ALL = new FinderPath(BlsAeModelImpl.ENTITY_CACHE_ENABLED,
            BlsAeModelImpl.FINDER_CACHE_ENABLED, Long.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
    public static final FinderPath FINDER_PATH_FETCH_BY_NUMBER = new FinderPath(BlsAeModelImpl.ENTITY_CACHE_ENABLED,
            BlsAeModelImpl.FINDER_CACHE_ENABLED, BlsAeImpl.class,
            FINDER_CLASS_NAME_ENTITY, "fetchByNumber",
            new String[] { Integer.class.getName() },
            BlsAeModelImpl.AREANUMBER_COLUMN_BITMASK);
    public static final FinderPath FINDER_PATH_COUNT_BY_NUMBER = new FinderPath(BlsAeModelImpl.ENTITY_CACHE_ENABLED,
            BlsAeModelImpl.FINDER_CACHE_ENABLED, Long.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByNumber",
            new String[] { Integer.class.getName() });
    private static final String _FINDER_COLUMN_NUMBER_AREANUMBER_2 = "blsAe.areaNumber = ?";
    private static final String _SQL_SELECT_BLSAE = "SELECT blsAe FROM BlsAe blsAe";
    private static final String _SQL_SELECT_BLSAE_WHERE = "SELECT blsAe FROM BlsAe blsAe WHERE ";
    private static final String _SQL_COUNT_BLSAE = "SELECT COUNT(blsAe) FROM BlsAe blsAe";
    private static final String _SQL_COUNT_BLSAE_WHERE = "SELECT COUNT(blsAe) FROM BlsAe blsAe WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "blsAe.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No BlsAe exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No BlsAe exists with the key {";
    private static final boolean _HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE = GetterUtil.getBoolean(PropsUtil.get(
                PropsKeys.HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE));
    private static Log _log = LogFactoryUtil.getLog(BlsAePersistenceImpl.class);
    private static BlsAe _nullBlsAe = new BlsAeImpl() {
            @Override
            public Object clone() {
                return this;
            }

            @Override
            public CacheModel<BlsAe> toCacheModel() {
                return _nullBlsAeCacheModel;
            }
        };

    private static CacheModel<BlsAe> _nullBlsAeCacheModel = new CacheModel<BlsAe>() {
            @Override
            public BlsAe toEntityModel() {
                return _nullBlsAe;
            }
        };

    public BlsAePersistenceImpl() {
        setModelClass(BlsAe.class);
    }

    /**
     * Returns the bls ae where areaNumber = &#63; or throws a {@link gov.va.caret.NoSuchBlsAeException} if it could not be found.
     *
     * @param areaNumber the area number
     * @return the matching bls ae
     * @throws gov.va.caret.NoSuchBlsAeException if a matching bls ae could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BlsAe findByNumber(int areaNumber)
        throws NoSuchBlsAeException, SystemException {
        BlsAe blsAe = fetchByNumber(areaNumber);

        if (blsAe == null) {
            StringBundler msg = new StringBundler(4);

            msg.append(_NO_SUCH_ENTITY_WITH_KEY);

            msg.append("areaNumber=");
            msg.append(areaNumber);

            msg.append(StringPool.CLOSE_CURLY_BRACE);

            if (_log.isWarnEnabled()) {
                _log.warn(msg.toString());
            }

            throw new NoSuchBlsAeException(msg.toString());
        }

        return blsAe;
    }

    /**
     * Returns the bls ae where areaNumber = &#63; or returns <code>null</code> if it could not be found. Uses the finder cache.
     *
     * @param areaNumber the area number
     * @return the matching bls ae, or <code>null</code> if a matching bls ae could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BlsAe fetchByNumber(int areaNumber) throws SystemException {
        return fetchByNumber(areaNumber, true);
    }

    /**
     * Returns the bls ae where areaNumber = &#63; or returns <code>null</code> if it could not be found, optionally using the finder cache.
     *
     * @param areaNumber the area number
     * @param retrieveFromCache whether to use the finder cache
     * @return the matching bls ae, or <code>null</code> if a matching bls ae could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BlsAe fetchByNumber(int areaNumber, boolean retrieveFromCache)
        throws SystemException {
        Object[] finderArgs = new Object[] { areaNumber };

        Object result = null;

        if (retrieveFromCache) {
            result = FinderCacheUtil.getResult(FINDER_PATH_FETCH_BY_NUMBER,
                    finderArgs, this);
        }

        if (result instanceof BlsAe) {
            BlsAe blsAe = (BlsAe) result;

            if ((areaNumber != blsAe.getAreaNumber())) {
                result = null;
            }
        }

        if (result == null) {
            StringBundler query = new StringBundler(3);

            query.append(_SQL_SELECT_BLSAE_WHERE);

            query.append(_FINDER_COLUMN_NUMBER_AREANUMBER_2);

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                qPos.add(areaNumber);

                List<BlsAe> list = q.list();

                if (list.isEmpty()) {
                    FinderCacheUtil.putResult(FINDER_PATH_FETCH_BY_NUMBER,
                        finderArgs, list);
                } else {
                    if ((list.size() > 1) && _log.isWarnEnabled()) {
                        _log.warn(
                            "BlsAePersistenceImpl.fetchByNumber(int, boolean) with parameters (" +
                            StringUtil.merge(finderArgs) +
                            ") yields a result set with more than 1 result. This violates the logical unique restriction. There is no order guarantee on which result is returned by this finder.");
                    }

                    BlsAe blsAe = list.get(0);

                    result = blsAe;

                    cacheResult(blsAe);

                    if ((blsAe.getAreaNumber() != areaNumber)) {
                        FinderCacheUtil.putResult(FINDER_PATH_FETCH_BY_NUMBER,
                            finderArgs, blsAe);
                    }
                }
            } catch (Exception e) {
                FinderCacheUtil.removeResult(FINDER_PATH_FETCH_BY_NUMBER,
                    finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        if (result instanceof List<?>) {
            return null;
        } else {
            return (BlsAe) result;
        }
    }

    /**
     * Removes the bls ae where areaNumber = &#63; from the database.
     *
     * @param areaNumber the area number
     * @return the bls ae that was removed
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BlsAe removeByNumber(int areaNumber)
        throws NoSuchBlsAeException, SystemException {
        BlsAe blsAe = findByNumber(areaNumber);

        return remove(blsAe);
    }

    /**
     * Returns the number of bls aes where areaNumber = &#63;.
     *
     * @param areaNumber the area number
     * @return the number of matching bls aes
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int countByNumber(int areaNumber) throws SystemException {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_NUMBER;

        Object[] finderArgs = new Object[] { areaNumber };

        Long count = (Long) FinderCacheUtil.getResult(finderPath, finderArgs,
                this);

        if (count == null) {
            StringBundler query = new StringBundler(2);

            query.append(_SQL_COUNT_BLSAE_WHERE);

            query.append(_FINDER_COLUMN_NUMBER_AREANUMBER_2);

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                qPos.add(areaNumber);

                count = (Long) q.uniqueResult();

                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return count.intValue();
    }

    /**
     * Caches the bls ae in the entity cache if it is enabled.
     *
     * @param blsAe the bls ae
     */
    @Override
    public void cacheResult(BlsAe blsAe) {
        EntityCacheUtil.putResult(BlsAeModelImpl.ENTITY_CACHE_ENABLED,
            BlsAeImpl.class, blsAe.getPrimaryKey(), blsAe);

        FinderCacheUtil.putResult(FINDER_PATH_FETCH_BY_NUMBER,
            new Object[] { blsAe.getAreaNumber() }, blsAe);

        blsAe.resetOriginalValues();
    }

    /**
     * Caches the bls aes in the entity cache if it is enabled.
     *
     * @param blsAes the bls aes
     */
    @Override
    public void cacheResult(List<BlsAe> blsAes) {
        for (BlsAe blsAe : blsAes) {
            if (EntityCacheUtil.getResult(BlsAeModelImpl.ENTITY_CACHE_ENABLED,
                        BlsAeImpl.class, blsAe.getPrimaryKey()) == null) {
                cacheResult(blsAe);
            } else {
                blsAe.resetOriginalValues();
            }
        }
    }

    /**
     * Clears the cache for all bls aes.
     *
     * <p>
     * The {@link com.liferay.portal.kernel.dao.orm.EntityCache} and {@link com.liferay.portal.kernel.dao.orm.FinderCache} are both cleared by this method.
     * </p>
     */
    @Override
    public void clearCache() {
        if (_HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE) {
            CacheRegistryUtil.clear(BlsAeImpl.class.getName());
        }

        EntityCacheUtil.clearCache(BlsAeImpl.class.getName());

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    /**
     * Clears the cache for the bls ae.
     *
     * <p>
     * The {@link com.liferay.portal.kernel.dao.orm.EntityCache} and {@link com.liferay.portal.kernel.dao.orm.FinderCache} are both cleared by this method.
     * </p>
     */
    @Override
    public void clearCache(BlsAe blsAe) {
        EntityCacheUtil.removeResult(BlsAeModelImpl.ENTITY_CACHE_ENABLED,
            BlsAeImpl.class, blsAe.getPrimaryKey());

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);

        clearUniqueFindersCache(blsAe);
    }

    @Override
    public void clearCache(List<BlsAe> blsAes) {
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);

        for (BlsAe blsAe : blsAes) {
            EntityCacheUtil.removeResult(BlsAeModelImpl.ENTITY_CACHE_ENABLED,
                BlsAeImpl.class, blsAe.getPrimaryKey());

            clearUniqueFindersCache(blsAe);
        }
    }

    protected void cacheUniqueFindersCache(BlsAe blsAe) {
        if (blsAe.isNew()) {
            Object[] args = new Object[] { blsAe.getAreaNumber() };

            FinderCacheUtil.putResult(FINDER_PATH_COUNT_BY_NUMBER, args,
                Long.valueOf(1));
            FinderCacheUtil.putResult(FINDER_PATH_FETCH_BY_NUMBER, args, blsAe);
        } else {
            BlsAeModelImpl blsAeModelImpl = (BlsAeModelImpl) blsAe;

            if ((blsAeModelImpl.getColumnBitmask() &
                    FINDER_PATH_FETCH_BY_NUMBER.getColumnBitmask()) != 0) {
                Object[] args = new Object[] { blsAe.getAreaNumber() };

                FinderCacheUtil.putResult(FINDER_PATH_COUNT_BY_NUMBER, args,
                    Long.valueOf(1));
                FinderCacheUtil.putResult(FINDER_PATH_FETCH_BY_NUMBER, args,
                    blsAe);
            }
        }
    }

    protected void clearUniqueFindersCache(BlsAe blsAe) {
        BlsAeModelImpl blsAeModelImpl = (BlsAeModelImpl) blsAe;

        Object[] args = new Object[] { blsAe.getAreaNumber() };

        FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_NUMBER, args);
        FinderCacheUtil.removeResult(FINDER_PATH_FETCH_BY_NUMBER, args);

        if ((blsAeModelImpl.getColumnBitmask() &
                FINDER_PATH_FETCH_BY_NUMBER.getColumnBitmask()) != 0) {
            args = new Object[] { blsAeModelImpl.getOriginalAreaNumber() };

            FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_NUMBER, args);
            FinderCacheUtil.removeResult(FINDER_PATH_FETCH_BY_NUMBER, args);
        }
    }

    /**
     * Creates a new bls ae with the primary key. Does not add the bls ae to the database.
     *
     * @param blsAeId the primary key for the new bls ae
     * @return the new bls ae
     */
    @Override
    public BlsAe create(long blsAeId) {
        BlsAe blsAe = new BlsAeImpl();

        blsAe.setNew(true);
        blsAe.setPrimaryKey(blsAeId);

        return blsAe;
    }

    /**
     * Removes the bls ae with the primary key from the database. Also notifies the appropriate model listeners.
     *
     * @param blsAeId the primary key of the bls ae
     * @return the bls ae that was removed
     * @throws gov.va.caret.NoSuchBlsAeException if a bls ae with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BlsAe remove(long blsAeId)
        throws NoSuchBlsAeException, SystemException {
        return remove((Serializable) blsAeId);
    }

    /**
     * Removes the bls ae with the primary key from the database. Also notifies the appropriate model listeners.
     *
     * @param primaryKey the primary key of the bls ae
     * @return the bls ae that was removed
     * @throws gov.va.caret.NoSuchBlsAeException if a bls ae with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BlsAe remove(Serializable primaryKey)
        throws NoSuchBlsAeException, SystemException {
        Session session = null;

        try {
            session = openSession();

            BlsAe blsAe = (BlsAe) session.get(BlsAeImpl.class, primaryKey);

            if (blsAe == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
                }

                throw new NoSuchBlsAeException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY +
                    primaryKey);
            }

            return remove(blsAe);
        } catch (NoSuchBlsAeException nsee) {
            throw nsee;
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }
    }

    @Override
    protected BlsAe removeImpl(BlsAe blsAe) throws SystemException {
        blsAe = toUnwrappedModel(blsAe);

        Session session = null;

        try {
            session = openSession();

            if (!session.contains(blsAe)) {
                blsAe = (BlsAe) session.get(BlsAeImpl.class,
                        blsAe.getPrimaryKeyObj());
            }

            if (blsAe != null) {
                session.delete(blsAe);
            }
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }

        if (blsAe != null) {
            clearCache(blsAe);
        }

        return blsAe;
    }

    @Override
    public BlsAe updateImpl(gov.va.caret.model.BlsAe blsAe)
        throws SystemException {
        blsAe = toUnwrappedModel(blsAe);

        boolean isNew = blsAe.isNew();

        Session session = null;

        try {
            session = openSession();

            if (blsAe.isNew()) {
                session.save(blsAe);

                blsAe.setNew(false);
            } else {
                session.merge(blsAe);
            }
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);

        if (isNew || !BlsAeModelImpl.COLUMN_BITMASK_ENABLED) {
            FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        }

        EntityCacheUtil.putResult(BlsAeModelImpl.ENTITY_CACHE_ENABLED,
            BlsAeImpl.class, blsAe.getPrimaryKey(), blsAe);

        clearUniqueFindersCache(blsAe);
        cacheUniqueFindersCache(blsAe);

        return blsAe;
    }

    protected BlsAe toUnwrappedModel(BlsAe blsAe) {
        if (blsAe instanceof BlsAeImpl) {
            return blsAe;
        }

        BlsAeImpl blsAeImpl = new BlsAeImpl();

        blsAeImpl.setNew(blsAe.isNew());
        blsAeImpl.setPrimaryKey(blsAe.getPrimaryKey());

        blsAeImpl.setBlsAeId(blsAe.getBlsAeId());
        blsAeImpl.setAreaName(blsAe.getAreaName());
        blsAeImpl.setAreaNumber(blsAe.getAreaNumber());

        return blsAeImpl;
    }

    /**
     * Returns the bls ae with the primary key or throws a {@link com.liferay.portal.NoSuchModelException} if it could not be found.
     *
     * @param primaryKey the primary key of the bls ae
     * @return the bls ae
     * @throws gov.va.caret.NoSuchBlsAeException if a bls ae with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BlsAe findByPrimaryKey(Serializable primaryKey)
        throws NoSuchBlsAeException, SystemException {
        BlsAe blsAe = fetchByPrimaryKey(primaryKey);

        if (blsAe == null) {
            if (_log.isWarnEnabled()) {
                _log.warn(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }

            throw new NoSuchBlsAeException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY +
                primaryKey);
        }

        return blsAe;
    }

    /**
     * Returns the bls ae with the primary key or throws a {@link gov.va.caret.NoSuchBlsAeException} if it could not be found.
     *
     * @param blsAeId the primary key of the bls ae
     * @return the bls ae
     * @throws gov.va.caret.NoSuchBlsAeException if a bls ae with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BlsAe findByPrimaryKey(long blsAeId)
        throws NoSuchBlsAeException, SystemException {
        return findByPrimaryKey((Serializable) blsAeId);
    }

    /**
     * Returns the bls ae with the primary key or returns <code>null</code> if it could not be found.
     *
     * @param primaryKey the primary key of the bls ae
     * @return the bls ae, or <code>null</code> if a bls ae with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BlsAe fetchByPrimaryKey(Serializable primaryKey)
        throws SystemException {
        BlsAe blsAe = (BlsAe) EntityCacheUtil.getResult(BlsAeModelImpl.ENTITY_CACHE_ENABLED,
                BlsAeImpl.class, primaryKey);

        if (blsAe == _nullBlsAe) {
            return null;
        }

        if (blsAe == null) {
            Session session = null;

            try {
                session = openSession();

                blsAe = (BlsAe) session.get(BlsAeImpl.class, primaryKey);

                if (blsAe != null) {
                    cacheResult(blsAe);
                } else {
                    EntityCacheUtil.putResult(BlsAeModelImpl.ENTITY_CACHE_ENABLED,
                        BlsAeImpl.class, primaryKey, _nullBlsAe);
                }
            } catch (Exception e) {
                EntityCacheUtil.removeResult(BlsAeModelImpl.ENTITY_CACHE_ENABLED,
                    BlsAeImpl.class, primaryKey);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return blsAe;
    }

    /**
     * Returns the bls ae with the primary key or returns <code>null</code> if it could not be found.
     *
     * @param blsAeId the primary key of the bls ae
     * @return the bls ae, or <code>null</code> if a bls ae with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BlsAe fetchByPrimaryKey(long blsAeId) throws SystemException {
        return fetchByPrimaryKey((Serializable) blsAeId);
    }

    /**
     * Returns all the bls aes.
     *
     * @return the bls aes
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<BlsAe> findAll() throws SystemException {
        return findAll(QueryUtil.ALL_POS, QueryUtil.ALL_POS, null);
    }

    /**
     * Returns a range of all the bls aes.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BlsAeModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param start the lower bound of the range of bls aes
     * @param end the upper bound of the range of bls aes (not inclusive)
     * @return the range of bls aes
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<BlsAe> findAll(int start, int end) throws SystemException {
        return findAll(start, end, null);
    }

    /**
     * Returns an ordered range of all the bls aes.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BlsAeModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param start the lower bound of the range of bls aes
     * @param end the upper bound of the range of bls aes (not inclusive)
     * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
     * @return the ordered range of bls aes
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<BlsAe> findAll(int start, int end,
        OrderByComparator orderByComparator) throws SystemException {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;

        if ((start == QueryUtil.ALL_POS) && (end == QueryUtil.ALL_POS) &&
                (orderByComparator == null)) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL;
            finderArgs = FINDER_ARGS_EMPTY;
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_ALL;
            finderArgs = new Object[] { start, end, orderByComparator };
        }

        List<BlsAe> list = (List<BlsAe>) FinderCacheUtil.getResult(finderPath,
                finderArgs, this);

        if (list == null) {
            StringBundler query = null;
            String sql = null;

            if (orderByComparator != null) {
                query = new StringBundler(2 +
                        (orderByComparator.getOrderByFields().length * 3));

                query.append(_SQL_SELECT_BLSAE);

                appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS,
                    orderByComparator);

                sql = query.toString();
            } else {
                sql = _SQL_SELECT_BLSAE;

                if (pagination) {
                    sql = sql.concat(BlsAeModelImpl.ORDER_BY_JPQL);
                }
            }

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                if (!pagination) {
                    list = (List<BlsAe>) QueryUtil.list(q, getDialect(), start,
                            end, false);

                    Collections.sort(list);

                    list = new UnmodifiableList<BlsAe>(list);
                } else {
                    list = (List<BlsAe>) QueryUtil.list(q, getDialect(), start,
                            end);
                }

                cacheResult(list);

                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return list;
    }

    /**
     * Removes all the bls aes from the database.
     *
     * @throws SystemException if a system exception occurred
     */
    @Override
    public void removeAll() throws SystemException {
        for (BlsAe blsAe : findAll()) {
            remove(blsAe);
        }
    }

    /**
     * Returns the number of bls aes.
     *
     * @return the number of bls aes
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int countAll() throws SystemException {
        Long count = (Long) FinderCacheUtil.getResult(FINDER_PATH_COUNT_ALL,
                FINDER_ARGS_EMPTY, this);

        if (count == null) {
            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(_SQL_COUNT_BLSAE);

                count = (Long) q.uniqueResult();

                FinderCacheUtil.putResult(FINDER_PATH_COUNT_ALL,
                    FINDER_ARGS_EMPTY, count);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_ALL,
                    FINDER_ARGS_EMPTY);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return count.intValue();
    }

    /**
     * Initializes the bls ae persistence.
     */
    public void afterPropertiesSet() {
        String[] listenerClassNames = StringUtil.split(GetterUtil.getString(
                    com.liferay.util.service.ServiceProps.get(
                        "value.object.listener.gov.va.caret.model.BlsAe")));

        if (listenerClassNames.length > 0) {
            try {
                List<ModelListener<BlsAe>> listenersList = new ArrayList<ModelListener<BlsAe>>();

                for (String listenerClassName : listenerClassNames) {
                    listenersList.add((ModelListener<BlsAe>) InstanceFactory.newInstance(
                            getClassLoader(), listenerClassName));
                }

                listeners = listenersList.toArray(new ModelListener[listenersList.size()]);
            } catch (Exception e) {
                _log.error(e);
            }
        }
    }

    public void destroy() {
        EntityCacheUtil.removeCache(BlsAeImpl.class.getName());
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}
