/**
 * Copyright (c) 2000-2013 Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package gov.va.caret.service.impl;

import java.util.Collections;
import java.util.List;

import com.liferay.portal.kernel.exception.SystemException;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.model.StiPt;
import gov.va.caret.service.base.StiPtLocalServiceBaseImpl;

/**
 * The implementation of the sti pt local service.
 *
 * <p>
 * All custom service methods should be put in this class. Whenever methods are added, rerun ServiceBuilder to copy their definitions into the {@link gov.va.caret.service.StiPtLocalService} interface.
 *
 * <p>
 * This is a local service. Methods of this service will not have security checks based on the propagated JAAS credentials because this service can only be accessed from within the same VM.
 * </p>
 *
 * @author caret
 * @see gov.va.caret.service.base.StiPtLocalServiceBaseImpl
 * @see gov.va.caret.service.StiPtLocalServiceUtil
 */
public class StiPtLocalServiceImpl extends StiPtLocalServiceBaseImpl {
	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never reference this interface directly. Always use {@link gov.va.caret.service.StiPtLocalServiceUtil} to access the sti pt local service.
	 */
	
	public List<StiPt> findByWorkItem ( long worImId ) throws ApplicationWorkFlowException{
		try {
			return stiPtPersistence.findByWorkId( worImId );
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		return Collections.emptyList();
	}
	
	public List<StiPt> findByVendorId ( long vendorId ) throws ApplicationWorkFlowException{
		try {
			return stiPtPersistence.findByVendrId( vendorId );
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		return Collections.emptyList();
	}
	
	public List<StiPt> findByICN ( String ICN ) throws ApplicationWorkFlowException{
		try {
			return stiPtPersistence.findByICN( ICN );
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		return Collections.emptyList();
	}
	
}