/**
 * Copyright (c) 2000-2013 Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package gov.va.caret.service.impl;

import com.liferay.portal.kernel.exception.SystemException;

import java.util.List;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.model.ClSoc;
import gov.va.caret.service.base.ClSocLocalServiceBaseImpl;

/**
 * The implementation of the cl soc local service.
 *
 * <p>
 * All custom service methods should be put in this class. Whenever methods are added, rerun ServiceBuilder to copy their definitions into the {@link gov.va.caret.service.ClSocLocalService} interface.
 *
 * <p>
 * This is a local service. Methods of this service will not have security checks based on the propagated JAAS credentials because this service can only be accessed from within the same VM.
 * </p>
 *
 * @author caret
 * @see gov.va.caret.service.base.ClSocLocalServiceBaseImpl
 * @see gov.va.caret.service.ClSocLocalServiceUtil
 */
public class ClSocLocalServiceImpl extends ClSocLocalServiceBaseImpl {
	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never reference this interface directly. Always use {@link gov.va.caret.service.ClSocLocalServiceUtil} to access the cl soc local service.
	 */
	public List<ClSoc> findByCallId(long callId) throws ApplicationWorkFlowException {
		try{
			return this.clSocPersistence.findByCallId(callId);
		} catch (SystemException e) {
			throw new ApplicationWorkFlowException(e);
		}
	}

	
}