package gov.va.caret.service.ctssh.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.net.URLConnection;
import java.security.SecureRandom;
import java.util.UUID;

import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPathConstants;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;


public class AppHelper {

	// this has to be a sngleton because I am tracking the run times
	/**
	 * 
	 */
	private static AppHelper sngleton;
	/**
	 * @return
	 */
	public static AppHelper i()
	{
		if(sngleton == null)
			sngleton = new AppHelper();
		
		return sngleton;
	}

	/**
	 * 
	 */
	int _env = -1;
	/**
	 * @param env
	 */
	public void setEnv(int env)
	{
		_env = env;
	}
	
	/**
	 * @return
	 */
	public int getEnv()
	{
		return _env;
	}
	/**
	 * @return
	 */
	public static String generateKey() {
		return UUID.randomUUID().toString();
	}

	/**
	 * @param _xpath_key
	 * @param _parent_doc
	 * @return
	 * @throws Exception
	 */
	public static String getStringValue(String _xpath_key, Document _parent_doc) throws Exception {
		return (String) CacheHandler.instance().getXPath(_xpath_key).evaluate(_parent_doc, XPathConstants.STRING);
	}

	/**
	 * @param _xpath_key
	 * @param _parent_node
	 * @return
	 * @throws Exception
	 */
	public static String getStringValue(String _xpath_key, Node _parent_node) throws Exception {
		return (String) CacheHandler.instance().getXPath(_xpath_key).evaluate(_parent_node, XPathConstants.STRING);
	}

	/**
	 * @param _xpath_key
	 * @param _parent_node
	 * @return
	 * @throws Exception
	 */
	public static NodeList getNodeList(String _xpath_key, Node _parent_node) throws Exception {
		return (NodeList) CacheHandler.instance().getXPath(_xpath_key).evaluate(_parent_node, XPathConstants.NODESET);
	}

	/**
	 * @param _xpath_key
	 * @param _parent_doc
	 * @return
	 * @throws Exception
	 */
	public static NodeList getNodeList(String _xpath_key, Document _parent_doc) throws Exception {
		return (NodeList) CacheHandler.instance().getXPath(_xpath_key).evaluate(_parent_doc, XPathConstants.NODESET);
	}

	/**
	 * @param _xpath_key
	 * @param _parent_node
	 * @return
	 * @throws Exception
	 */
	public static Node getNode(String _xpath_key, Node _parent_node) throws Exception {
		return (Node) CacheHandler.instance().getXPath(_xpath_key).evaluate(_parent_node, XPathConstants.NODE);
	}

	
	/**
	 * @param message
	 */
	public static void log(String message) {
		// replace this with liferay logging
		System.out.println(message);

	}

	/**
	 * @param urlstring
	 * @return
	 * @throws Exception
	 */
	public URLConnection getServiceConnection(String urlstring) throws Exception {

		
		URLConnection return_connection = null;

		AppHelper.log("CREATING CONNECTION TO : " + urlstring);
		AppHelper.log("ENV FLAG : " + AppHelper.i().getEnv());
		if (urlstring.toLowerCase().startsWith("https:")) {

			
			
			//Class.forName can get expensive - run it once to see which env we are in
			if(AppHelper.i().getEnv() == -1)//uninitialized
			{
				try{
					
					Class.forName("weblogic.net.http.HttpsURLConnection");
					AppHelper.i().setEnv(1); 	//didn't throw an error - so set env to 1
					
				}catch(Exception xxx)
				{
					AppHelper.i().setEnv(2);  //threw and error - so set env to 2
				}
			}
			
			AppHelper.log("ENV FLAG : " + AppHelper.i().getEnv());
			
			if(AppHelper.i().getEnv() == 1)			//this is a weblogic connection
			{
			
					//this is a weblogic server
					javax.net.ssl.SSLContext ctx = javax.net.ssl.SSLContext.getInstance("TLS");//.getInstance("SSL");
					ctx.init(new javax.net.ssl.KeyManager[0], new javax.net.ssl.TrustManager[] {new DefaultTrustManager()}, new SecureRandom());
					javax.net.ssl.SSLContext.setDefault(ctx);
		        
					java.net.URL url = new URL(null,urlstring ,new sun.net.www.protocol.https.Handler());
		        
					javax.net.ssl.HttpsURLConnection conn = (javax.net.ssl.HttpsURLConnection) url.openConnection();
					conn.setHostnameVerifier(new javax.net.ssl.HostnameVerifier() {
		            @Override
		            public boolean verify(String arg0, SSLSession arg1) {
		                return true;
		            }
					});
		        
		        return_connection = conn;
		        
				    //URL url = new URL(null, urlstring, new sun.net.www.protocol.https.Handler());
				//	HttpsURLConnection conn = (HttpsURLConnection) url.openConnection();
			     //   return_connection = conn;
			        
			        
			}else
			{
				
				//this is either stand alone or running on tomcat
				SSLContext ctx = SSLContext.getInstance("TLS");// .getInstance("SSL");
				ctx.init(new KeyManager[0], new TrustManager[] { new DefaultTrustManager() }, new SecureRandom());
				SSLContext.setDefault(ctx);
			
				URL url = new URL(urlstring);
				HttpsURLConnection conn = (HttpsURLConnection) url.openConnection();
				
				//caret runs on old jdk - no lambda allowed - dumbing down my code conn.setHostnameVerifier((String arg0, SSLSession arg1) -> true);
		        conn.setHostnameVerifier(new HostnameVerifier() {
		            @Override
		            public boolean verify(String arg0, SSLSession arg1) {
		                return true;
		            }
		        });
		        
				
				
				return_connection = conn;
			}
			
		} else if (urlstring.toLowerCase().startsWith("http:")) {
			return_connection = new URL(urlstring).openConnection();
		} else
			throw new Exception("Protocol unsupported");

		return return_connection;
	}

	/**
	 * @param xml
	 * @return
	 */
	public static String getPrettyPrintXML(String xml) {

		// this just formats the incomming xml so it's readable.
		String rval = "";
		int indentation = 4;

		try {

			Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder()
					.parse(new InputSource(new StringReader(xml)));
			TransformerFactory transformerFactory = TransformerFactory.newInstance();
			transformerFactory.setAttribute("indent-number", indentation);
			Transformer transformer = transformerFactory.newTransformer();
			transformer.setOutputProperty(OutputKeys.ENCODING, "UTF-8");
			transformer.setOutputProperty(OutputKeys.OMIT_XML_DECLARATION, "yes");
			transformer.setOutputProperty(OutputKeys.INDENT, "yes");

			// Return pretty print xml string
			StringWriter stringWriter = new StringWriter();
			transformer.transform(new DOMSource(document), new StreamResult(stringWriter));
			rval = stringWriter.toString();

		} catch (Exception e) {
			throw new RuntimeException(e);
		}

		return rval;
	}

	/**
	 * @param doc
	 * @return
	 */
	public static String getPrettyPrintXML(Document doc) {

		// this just formats the incomming xml so it's readable.
		String rval = "";
		int indentation = 4;

		try {

			TransformerFactory transformerFactory = TransformerFactory.newInstance();
			transformerFactory.setAttribute("indent-number", indentation);
			Transformer transformer = transformerFactory.newTransformer();
			transformer.setOutputProperty(OutputKeys.ENCODING, "UTF-8");
			transformer.setOutputProperty(OutputKeys.OMIT_XML_DECLARATION, "yes");
			transformer.setOutputProperty(OutputKeys.INDENT, "yes");

			// Return pretty print xml string
			StringWriter stringWriter = new StringWriter();
			transformer.transform(new DOMSource(doc), new StreamResult(stringWriter));
			rval = stringWriter.toString();

		} catch (Exception e) {
			throw new RuntimeException(e);
		}

		return rval;
	}

	/**
	 * @param n
	 * @return
	 */
	public static String getPrettyPrintXML(Node n) {

		// this just formats the incomming xml so it's readable.
		String rval = "";
		int indentation = 4;

		try {

			TransformerFactory transformerFactory = TransformerFactory.newInstance();
			transformerFactory.setAttribute("indent-number", indentation);
			Transformer transformer = transformerFactory.newTransformer();
			transformer.setOutputProperty(OutputKeys.ENCODING, "UTF-8");
			transformer.setOutputProperty(OutputKeys.OMIT_XML_DECLARATION, "yes");
			transformer.setOutputProperty(OutputKeys.INDENT, "yes");

			// Return pretty print xml string
			StringWriter stringWriter = new StringWriter();
			transformer.transform(new DOMSource(n), new StreamResult(stringWriter));
			rval = stringWriter.toString();

		} catch (Exception e) {
			throw new RuntimeException(e);
		}

		return rval;
	}

	/**
	 * @param time
	 * @return
	 */
	public static String getTimeText(long time) {

		long secondsInMilli = 1000;
		long minutesInMilli = secondsInMilli * 60;

		StringBuilder sb = new StringBuilder();
		if (time > minutesInMilli) {

			sb.append("MIN : " + (time / minutesInMilli));
			time = time - ((time / minutesInMilli) * minutesInMilli);
		} else
			sb.append("MIN : 00");

		if (time > secondsInMilli) {

			sb.append("SEC : " + (time / secondsInMilli));
			time = time - ((time / secondsInMilli) * secondsInMilli);
		} else
			sb.append("SEC : 00");

		if (time > 0) {

			sb.append("MS : " + time);
		} else
			sb.append("MS : 00");

		return sb.toString();

	}

	/**
	 * @param e
	 */
	public static void log(Exception e) {
		// replace this with liferay logging
		e.printStackTrace();

	}

	/**
	 * @param string
	 * @param size
	 * @return
	 */
	public static String make_string(String string, int size) {
		StringBuilder sb = new StringBuilder();

		for (int x = 0; x < size; x++)
			sb.append(string);

		return sb.toString();

	}

	/**
	 * @param string
	 * @param size
	 * @return
	 */
	public static String make_string_size(String string, int size) {

		if (string == null)
			return make_string(" ", size);

		if (string.length() >= size)
			return string;
		else
			return string + String.format("%1$" + (size - string.length()) + "s", " ");

	}

	/**
	 * @param value
	 * @param size
	 * @return
	 */
	public static String make_string_size(Long value, int size) {

		String v = value.toString();
		if (v.length() >= size) {
			return v;
		} else
			return v + String.format("%1$" + (size - v.length()) + "s", " ");

	}

	

	/**
	 * @param fname
	 * @return
	 * @throws Exception
	 */
	public static byte[] loadBytesFromFile(String fname) throws Exception {
		byte[] returnBuff = null;

		File f = new File(fname);
		if (f.exists()) {
			FileInputStream fis = new FileInputStream(f);
			returnBuff = new byte[(int) f.length()];
			fis.read(returnBuff);
			fis.close();
		}

		return returnBuff;

	}

	/**
	 * @param fname
	 * @param array
	 * @throws Exception
	 */
	public static void saveBytesToFile(String fname, byte[] array) throws Exception {

		File f = new File(fname);
		if (f.exists())
			f.delete();

		FileOutputStream fos = new FileOutputStream(f);
		fos.write(array);
		fos.flush();
		fos.close();

	}

	/**
	 * @param value
	 * @param places
	 * @return
	 */
	public static double roundDouble(double value, int places) {
		if (places < 0)
			throw new IllegalArgumentException();

		BigDecimal bd = new BigDecimal(value);
		bd = bd.setScale(places, RoundingMode.HALF_UP);
		return bd.doubleValue();
	}

	/**
	 * @param size
	 * @param fill
	 * @param count
	 * @return
	 */
	public static String makeCenteredString(int size, String fill, int count) {

		String rval = "";

		for (int x = 1; x <= count; x++) {
			rval = rval + fill;
		}

		int l = (size - rval.length()) / 2;

		for (int x = 1; x <= l; x++) {
			rval = " " + rval;
		}

		while (rval.length() < size) {
			rval = rval + " ";
		}

		return rval;

	}

	/**
	 * @param value
	 * @param size
	 * @return
	 */
	public static String makeCenteredString(String value, int size) {

		int padsz = (size - value.length()) / 2;
		String pad = makeString(" ", padsz);

		return pad + value + pad;

	}

	/**
	 * @param s
	 * @param sz
	 * @param align
	 * @return
	 */
	public static String makeStringSize(String s, int sz, String align) {

		String rval = "";

		if (align.intern() == "L") {
			rval = s;
			while (rval.length() < sz) {
				rval = rval + " ";
			}
		} else {
			int spcnt = sz - s.length();
			while (rval.length() < spcnt) {
				rval = rval + " ";
			}
			rval = rval + s;

		}

		return rval;

	}
	
	/**
	 * @param b
	 * @param sz
	 * @param align
	 * @return
	 */
	public static String makeStringSize(boolean b, int sz, String align) {

		String rval = "";
		String s;
		if(b)
			s = "true";
		else
			s = "false";
		
		
		if (align.intern() == "L") {
			rval = s;
			while (rval.length() < sz) {
				rval = rval + " ";
			}
		} else {
			int spcnt = sz - s.length();
			while (rval.length() < spcnt) {
				rval = rval + " ";
			}
			rval = rval + s;

		}

		return rval;

	}

	/**
	 * @param s
	 * @param sz
	 * @param align
	 * @return
	 */
	public static String makeStringSize(int s, int sz, String align) {

		return makeStringSize(String.valueOf(s), sz, align);

	}

	/**
	 * @param s
	 * @param sz
	 * @param align
	 * @return
	 */
	public static String makeStringSize(double s, int sz, String align) {

		return makeStringSize(String.valueOf(s), sz, align);

	}

	/**
	 * @param s
	 * @param sz
	 * @param align
	 * @return
	 */
	public static String makeStringSize(byte s, int sz, String align) {

		return makeStringSize(String.valueOf(s), sz, align);

	}

	/**
	 * @param string
	 * @param length
	 * @return
	 */
	public static String makeString(String string, int length) {

		String rval = "";

		while (rval.length() < length) {
			rval = rval + string;
		}

		return rval;
	}

	/**
	 * @param c
	 * @param length
	 * @return
	 */
	public static String makeString(char c, int length) {

		String rval = "";

		while (rval.length() < length) {
			rval = rval + c;
		}

		return rval;
	}

	/**
	 * @param e
	 * @return
	 */
	public static String throwableToString(Exception e) {
		StringWriter sw = new StringWriter();
		PrintWriter pw = new PrintWriter(sw);
		e.printStackTrace(pw);
		return sw.toString(); // stack trace as a string

	}

	/**
	 * @param file_path
	 * @return
	 * @throws Exception
	 */
	public static String loadFile(String file_path) throws Exception {

		StringBuilder sb = new StringBuilder();
		
		File f = new File(file_path);
		if(f.exists())
		{
		
			BufferedReader in = new BufferedReader(new FileReader(f));
			
			String line = in.readLine();
			
			while((line = in.readLine()) != null)
			{
				sb.append(line);
			}
			
			in.close();
		}
		return sb.toString();
	}

	/**
	 * @param item
	 * @param attr_name
	 * @param default_value
	 * @return
	 */
	public static String getAttributeValue(Node item, String attr_name, String default_value) {

		String return_value = default_value;
		
		if(item != null && item.getAttributes() != null && item.getAttributes().getNamedItem(attr_name) != null)
			return_value = item.getAttributes().getNamedItem(attr_name).getNodeValue();
		
		
		return return_value;
		
	}

	/**
	 * @param item
	 * @param default_value
	 * @return
	 */
	public static String getNodeValue(Node item, String default_value) {
		
		
		String return_value = default_value;
		
		if(item != null && item.hasChildNodes())
			return_value = item.getFirstChild().getNodeValue();
		
		
		return return_value;
		
		
	}

	
	
	
}
