package gov.va.caret.security.sso;

import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.struts.LastPath;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.kernel.util.WebKeys;
import com.liferay.portal.model.RoleConstants;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.AutoLogin;
import com.liferay.portal.security.auth.AutoLoginException;
import com.liferay.portal.security.auth.CompanyThreadLocal;
import com.liferay.portal.security.auth.PrincipalThreadLocal;
import com.liferay.portal.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.service.UserServiceUtil;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.model.Persn;
import gov.va.caret.service.CaretLocalServiceUtil;
import gov.va.caret.service.PersnLocalServiceUtil;
import gov.va.caret.util.CaretStrPool;
import gov.va.caret.util.CaretUtil;
import gov.va.caret.util.Toolbox;


public class SecuredHeaderLogin implements AutoLogin  {
	
	private static final Log _log = LogFactoryUtil.getLog( SecuredHeaderLogin.class );
	private static final String CARET_SITEMINDER_HEADER = "caret.siteminder.user.header";
	private static final String VAAFI_HEADER = PropsUtil.get( "vaafi.user.header" );
	private static final String NOT_FOUND = "NOT_FOUND";
	
	private void debugHeaders(HttpServletRequest request, HttpServletResponse response) {
		Enumeration<String> headerNames = request.getHeaderNames();
		int count = 0;
		while (headerNames.hasMoreElements()) {
			count++;
			String header = (String) headerNames.nextElement();
			if ( _log.isInfoEnabled() ){
				_log.info("header >>> " +header);
				_log.debug(header + " >>> " + request.getHeader(header) );
			}
		}
		_log.info("count >>> " + count);
	}

	private long getCompanyId() {
		return CompanyThreadLocal.getCompanyId();
	}
	
	@Override
	public String[] login( HttpServletRequest request, HttpServletResponse response ) throws AutoLoginException {
		if ( _log.isInfoEnabled() ){
			debugHeaders(request,response);
		}
		try {
			User user = null;
			Object lastPath = ((HttpServletRequest) request).getSession().getAttribute(WebKeys.LAST_PATH);
			if ( lastPath != null ){
				_log.info("lastPath info:" + ((LastPath) lastPath).getContextPath() + ((LastPath) lastPath).getPath() );
			}
			if ( !Toolbox.isEmpty( request.getHeader( PropsUtil.get( CARET_SITEMINDER_HEADER ) ) ) ){ //SSOi
				_log.info("SSOi login...");
				user = findUser( request.getHeader( PropsUtil.get( CARET_SITEMINDER_HEADER ) ), null );
				_log.info("AUTO_LOGIN_REDIRECT_AND_CONTINUE: /group/clinic" );
				request.setAttribute(AutoLogin.AUTO_LOGIN_REDIRECT_AND_CONTINUE, "/group/clinic" );
			} else if ( !Toolbox.isEmpty( request.getHeader( VAAFI_HEADER ) ) ){
				_log.info("SSOe login...");
				user = vaafiHeaders(request);
				Object completeUrl = ((HttpServletRequest) request).getRequestURL();
				_log.info("completeUrl:" + completeUrl );
				if ( completeUrl != null && completeUrl.toString().endsWith("444/web/guest/home") ){
					request.setAttribute(AutoLogin.AUTO_LOGIN_REDIRECT_AND_CONTINUE, "/group/online" );
					_log.info("AUTO_LOGIN_REDIRECT_AND_CONTINUE: /group/online" );
				}
				for ( Enumeration<String> enu = request.getParameterNames(); enu.hasMoreElements(); ){
					String name = enu.nextElement();
					_log.info( name + ":" + request.getParameter(name) );
				}
				
			} else {
				_log.info("Standard login...");
			}
			if ( user != null){
				return new String[] { String.valueOf(user.getUserId()), user.getPassword(), String.valueOf( user.isPasswordEncrypted() ) };
			}
		} catch (SystemException e) {
			e.printStackTrace();
		}
		return null;
	}
	
	private User vaafiHeaders ( HttpServletRequest request ) throws SystemException{
		String screenNameHeader = request.getHeader( VAAFI_HEADER );
		if ( NOT_FOUND.equals( screenNameHeader) ){
			_log.error("\n ================== \n SEC_ID IS NOT_FOUND \n =========================");
			return null;
		}
		
		String firstNameHeader = safeGet( request, "va_eauth_firstname" );
		String lastNameHeader = safeGet( request, "va_eauth_lastname" );
		
		String emailHeader = safeGet( request, "va_eauth_email" );
		User user = findUser( screenNameHeader, emailHeader );
		
		if ( user != null ){
			return user;
		}
		
		if ( Toolbox.isEmpty(firstNameHeader) || Toolbox.isEmpty(lastNameHeader) ){
			_log.error("Users' Firstname and Lastname are required for activation");
			return null;
		}
		
		String middleNameHeader =  safeGet( request, "va_eauth_middlename" );
		String birthdayHeader = safeGet(request, "va_eauth_birthdate" );//YYYY-MM-DDT00:00:00-00:00
		int[] bDay = null;
		if ( !Toolbox.isEmpty( birthdayHeader) && birthdayHeader.length() >= 10){ 
			try {
				birthdayHeader = birthdayHeader.substring(0, 10);
				_log.info("date parse:" + birthdayHeader );
				Date birthday = (Date)Toolbox.getDateFormatVaafi().parseObject( birthdayHeader );
				Calendar c = Calendar.getInstance();
				c.setTime(birthday);
				bDay = new int[]{c.get(Calendar.MONTH), c.get(Calendar.DAY_OF_MONTH), c.get(Calendar.YEAR)};
			} catch (Exception e) {
				ApplicationWorkFlowException.handleException(e);
				bDay = new int[]{10,15,1899};
			}
		} 
		if ( bDay == null ){
			bDay = new int[]{10,15,1899};
			_log.warn("couldnt obtain birthday, using one that would require user input");
		}
		if ( user == null ){
			String icn = safeGet( request, "va_eauth_icn" );
			_log.info("SSOe: user activation...");
			if ( ( user = setUser( CaretUtil.getOnlineSite( ), screenNameHeader, emailHeader, firstNameHeader, middleNameHeader, lastNameHeader, true, new long[]{}, new long[]{}, bDay, icn ) ) != null )
			try {
				Persn persn = null;
				if ( !icn.isEmpty() ){
					persn = PersnLocalServiceUtil.getByIcn( icn );				
				}
				if ( persn == null ){
					persn = PersnLocalServiceUtil.getByUser( user.getUserId() );
					persn.setICN( icn );
					persn.setAddress( safeGet( request, "va_eauth_street" ) );
					persn.setAddress2( safeGet( request, "va_eauth_street1" ) );
					persn.setSuffix( safeGet( request, "va_eauth_suffix" ) );
					persn.setPrefix ( safeGet( request, "va_eauth_prefix" ) );
					persn.setGender( safeGet( request, "va_eauth_gender" ) );
					persn.setCity(  safeGet( request, "va_eauth_city" ) );
					persn.setState( safeGet( request, "va_eauth_state" ) );
					persn.setZip( safeGet( request, "va_eauth_postalcode" ) );
					persn.setCountry( safeGet( request, "va_eauth_country" ) );
					persn.setPhone( safeGet( request, "va_eauth_phone" ) );
					persn.setExternalId( screenNameHeader );
				} else {
					persn.setExternalId( screenNameHeader );
					persn.setPersnUserId( user.getPrimaryKey() );
				}
				CaretLocalServiceUtil.save(persn);
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		return user;
	}

	private String safeGet( HttpServletRequest request, String header ) {
		String value = request.getHeader( header );
		return Toolbox.isEmpty(value) || NOT_FOUND.equals(value) ? StringPool.BLANK: value;
	}

	private User findUser( String screenNameHeader, String emailHeader ) throws SystemException {
		User user = null;
		try {
			user = UserLocalServiceUtil.getUserByScreenName( getCompanyId(), screenNameHeader );
		} catch (Exception e) {
			_log.warn( e.getMessage() );
		} 
		return user;
	}
	
	private User setUser( String site, String screenNameHeader, String emailHeader, String firstName, String middleName, String lastName, 
				boolean isMale, long[] roleIds, long[] orgId, int[] bday, String icn  ) throws SystemException {

		_log.info("SSOe: user creation..." );
		
		String password = screenNameHeader+".";
		try {
			User adm = UserLocalServiceUtil.getRoleUsers(RoleLocalServiceUtil.getRole(getCompanyId(), RoleConstants.ADMINISTRATOR).getRoleId()).get(0);
			PrincipalThreadLocal.setName( adm.getUserId() );
			PermissionThreadLocal.setPermissionChecker( PermissionCheckerFactoryUtil.create(adm) );
			if ( !Toolbox.isEmpty( emailHeader) ) try {
				UserLocalServiceUtil.getUserByEmailAddress( getCompanyId(), emailHeader );
				emailHeader = StringPool.BLANK;
			} catch ( PortalException pe ){}
			ServiceContext sc = new ServiceContext();
			sc.setAttribute( CaretStrPool.ICN, icn);
			User user = UserServiceUtil.addUser(getCompanyId(), true, password,
					password, false, screenNameHeader, emailHeader, 
					0l, StringPool.BLANK, LocaleUtil.getDefault(), firstName, middleName, 
					lastName, 0, 0, isMale, bday[0], bday[1], bday[2], "CareT User", 
					new long[]{ GroupLocalServiceUtil.getGroup( getCompanyId(), site ).getGroupId() }, orgId, 
					roleIds, new long[]{}, false, sc );
			_log.info( "SSO: user creation finished..." + user.getScreenName() );
			return user;
		} catch (Exception e) {
			e.printStackTrace();
		}
		_log.info( "SSO: user creation failed..." );
		return null;
	}


	@Override
	public String[] handleException( HttpServletRequest request, HttpServletResponse response, Exception e )
			throws AutoLoginException {
		return new String[]{ "S-H-L Erred...",  e.getLocalizedMessage() };
	}

}
