package gov.va.caret.pdf;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.pdfbox.pdmodel.PDDocument;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.Organization;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextThreadLocal;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.model.VcgAn;
import gov.va.caret.model.support.Person;
import gov.va.caret.model.support.Primary;
import gov.va.caret.model.support.Secondary;
import gov.va.caret.model.support.SecondaryTwo;
import gov.va.caret.util.Toolbox;

public class VaForm1010cgSection {

	Map<String, Object> extraFields;

	private Person intent;
	private PDDocument pdfDoc = null;
	private long applicationId = 0;
	private boolean isFinal = false;
	List<Person> blanks = new ArrayList<Person>();
	
	public VaForm1010cgSection(Person intent, VcgAn vcgAn, PDDocument pdfDoc ) {
		super();
		
		ServiceContext sc = ServiceContextThreadLocal.getServiceContext();
		this.intent = intent;
		this.pdfDoc = pdfDoc;
		this.applicationId = vcgAn.getVcgAnId();
		extraFields = new HashMap<String, Object>();
		
		if ( intent.isVeteranRole() ) try {
			Organization org = OrganizationLocalServiceUtil.getOrganization( intent.getGroupId() );
			extraFields.put("preferredFacility", org.getName() );
		
			extraFields.put("enrolledYes", vcgAn.getVaHealthEnrolled() );
			extraFields.put("enrolledNo", !vcgAn.getVaHealthEnrolled() );
			
			extraFields.put("hospital", vcgAn.getHospital() );
			extraFields.put("clinic",  vcgAn.getClinic() );
			extraFields.put("lastTreatment", vcgAn.getLastTreatmentPlace( ) );
		} catch (PortalException | SystemException e2) {
			ApplicationWorkFlowException.handleException(e2);
			
		} else {
			if ( intent.isPrimaryRole() ) {
				extraFields.put("mediEnrolledYes", vcgAn.getMediEnrolled() );
				extraFields.put("mediEnrolledNo", !vcgAn.getMediEnrolled() ); 

				extraFields.put("otherHealthInsurance", ((Primary) intent).getOtherHealthInsurance()  );
				extraFields.put("otherHealthYes", ((Primary)intent).isOtherInsChecked() );
				extraFields.put("otherHealthNo", !((Primary)intent).isOtherInsChecked() );
			}
			setFinal( vcgAn );
			
			
		}
		extraFields.put("signedDate", Toolbox.formatDatePdf( sc.getCreateDate() ) );
	}
	
	private void setFinal( VcgAn vcgAn ) {
		if ( intent.getRole() == Person.Role.VETERAN ) {
			return;
		}
		int i = 3;
		if ( vcgAn.getPrimarySignDate() != null ) {
			i--;
		} else if ( vcgAn.getPrimaryId() == 0 ){
			i--;
			blanks.add( new Primary(Person.DEFAULT_PERSON) );
		}
		if ( vcgAn.getSecondarySignDate() != null ) {
			i--;
		} else if ( vcgAn.getSecondaryId() == 0 ){
			i--;
			blanks.add( new Secondary(Person.DEFAULT_PERSON) );
		}
		if ( vcgAn.getSecondaryTwoSignDate() != null ) {
			i--;
		} else if ( vcgAn.getSecondaryTwoId() == 0 ){
			i--;
			blanks.add( new SecondaryTwo(Person.DEFAULT_PERSON) );
		}
		isFinal = i == 0;
	}

	public List<Person> getBlanks(){
		return blanks;
	}
	
	public Map<String, Object> getExtraFields(){
		return extraFields;
	}
	
	public long getApplicationId(){
		return applicationId;
	}
	
	public Person getIntent(){
		return intent;
	}

	public PDDocument getPdfDoc() {
		return pdfDoc;
	}
	
	public void setPdfDoc(PDDocument pdfDoc) {
		this.pdfDoc = pdfDoc;
	}
	
	public boolean isFinal (){
		return isFinal;
	}
}
