package gov.va.caret.model.support.occ;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Calendar;
import java.util.Date;

import gov.va.caret.model.StiPt;


public class FinalPayment extends CalculationWrapper {
	
	BigDecimal backPay = null;				//[Number of Retro Months] * [Monthly Amount]
	

	public FinalPayment(StiPt config, int month, int year ) {
		super(config, month, year);
	}
	
	public Date getPaymentDate( ){
		Calendar calendar = Calendar.getInstance();
		calendar.set( Calendar.MONTH, getPaymentMonth() );
		calendar.set( Calendar.YEAR, getPaymentYear() );
		calendar.set( Calendar.DAY_OF_MONTH, calendar.getActualMaximum(Calendar.DAY_OF_MONTH) );
		calendar.roll( Calendar.DAY_OF_YEAR, true);
		return calendar.getTime();
	}
	
	public Date getPaymentMonthDate(  ){
		Calendar calendar = Calendar.getInstance();
		calendar.set( Calendar.MONTH, getPaymentMonth() );
		calendar.set( Calendar.YEAR, getPaymentYear() );
		calendar.set( Calendar.DAY_OF_MONTH, calendar.getActualMaximum(Calendar.DAY_OF_MONTH) );
		return calendar.getTime();
	}

	public BigDecimal getMonthlyAmount (  ) {
		return getMonthlyRate();
	}
	
	public double getRecoupmentDays(  ) {
		Calendar calendar = Calendar.getInstance();
		calendar.setTime( config.getStipendStartDate() );
		return calendar.getActualMaximum( Calendar.DAY_OF_MONTH ) - calendar.get(Calendar.DAY_OF_MONTH);
	}
	
	public BigDecimal getProratedAmount(){
		return new BigDecimal( getRecoupmentDays( ) ).multiply( getDailyRate() );
	}
	
	
	public int getRecoupMonths( ){
		int totalMonths = 0;
		Calendar calendar = Calendar.getInstance();
		calendar.setTime( config.getStipendStartDate() );
		while ( calendar.getTime().before( getPaymentMonthDate(  ) ) ) {
			int days = calendar.getActualMaximum( Calendar.DAY_OF_MONTH ) - calendar.get(Calendar.DAY_OF_MONTH) + 1;
			if ( days == calendar.getActualMaximum( Calendar.DAY_OF_MONTH ) ){
				totalMonths++;
			}
			calendar.set( Calendar.DAY_OF_MONTH, 1);
			if ( calendar.get(Calendar.MONTH ) == Calendar.DECEMBER ){
				calendar.roll( Calendar.YEAR, true );
				calendar.roll( Calendar.MONTH, true );
			} else {
				calendar.roll( Calendar.MONTH, true );
			}
		}
		return totalMonths;
	}
	
	public BigDecimal getDailyRate(){
		if ( dailyRate == null ){
			dailyRate = new BigDecimal( config.getBlsRateHourly() ).multiply( StipendConfig.getTierLevelMonthlyHours( config.getTier() ) ).multiply( new BigDecimal(12) ).divide( new BigDecimal(365), 2, RoundingMode.HALF_UP );
		}
		return dailyRate;
	}
	
	public Date getBenefitsEndDate() {
		Calendar calendar = Calendar.getInstance();
		calendar.setTime( config.getStipendStartDate() );
		Calendar offset = Calendar.getInstance();
		offset.setTime( config.getStipendStartDate() );
		offset.roll(Calendar.DAY_OF_YEAR, config.getEntitledDays() );
		if ( offset.get(Calendar.MONTH ) < calendar.get(Calendar.MONTH ) ){
			offset.roll(Calendar.YEAR, true);
		}
		return offset.getTime();
	}
	
	public BigDecimal getRecoupmentDaysAmount() {
		BigDecimal monthlyAmount = new BigDecimal( getRecoupmentDays() ).multiply( getDailyRate() );
		monthlyAmount = new BigDecimal( String.valueOf( monthlyAmount.doubleValue() ) ).setScale( 2, RoundingMode.HALF_UP );
		return monthlyAmount;
	}

	public BigDecimal getEntitlementAmount(){
		if ( config.getEntitledDays() == 0 ) return BigDecimal.ZERO;
		return new BigDecimal( config.getEntitledDays()/30 ).multiply( getMonthlyAmount() );
	}
	
	public BigDecimal getBackPayAmount(){
		if ( backPay == null ){
			backPay = new BigDecimal( getRecoupMonths() ).multiply( getMonthlyAmount() );
		}
		return backPay;
	}
	

	//Final Payment (if Termination Date falls within the current Payment Month) = [Entitlement Amount] + Prorated Amount]
	//[Entitlement Amount]  Recoupment Amount]
	public BigDecimal getPayment() {
		return getEntitlementAmount().subtract( getProratedAmount() ).subtract( getMonthlyAmount(  ).add( getEntitlementAmount() ) );
	}
	
	public BigDecimal getFinalAmount(){
		return getPayment( ).signum() == -1? BigDecimal.ZERO : getPayment( ).abs();
	}
	
	public BigDecimal getRecoupmentAmount(){
		return getPayment( ).signum() == -1? getPayment( ).abs() : BigDecimal.ZERO;
	}

//	public static void main ( String[] args ) throws ParseException{
//		StipendConfig config = new StipendConfig( 3, 18.11, format.parse("10/15/2016"), 90 );
//		System.out.println( new FinalPayment( config, Calendar.FEBRUARY, 2017 ) );
//	}

	public String toString () {
		return   "            Payment Date: " + formatDate( getPaymentDate() ) + 
				"\n   With Revocation Date: " + formatDate( config.getStipendStartDate() ) +
				"\n       Days Entitled of: " + config.getEntitledDays() +
				"\n         Monthly Amount: " + getMonthlyAmount(  ) +
				"\n  Entitlement Amount of: " + getEntitlementAmount() +

				
				"\n   Local hourly Rate of: " + StipendConfig.getTierLevelMonthlyHours( config.getTier() ) +
				"\n          Daily Rate of: " + getDailyRate() +
				"\n          Tier Level of: " + config.getTier() + 
				"\n         Recoup Days of: " + getRecoupmentDays( ) +
				"\n  Recoup Days Amount of: " + getRecoupmentDaysAmount( ) +
				"\nRecoup Months Amount of: " + getMonthlyAmount().add( getEntitlementAmount() ) +
				"\n   Benefits End Date of: " + formatDate(  getBenefitsEndDate( ) ) +

				
				"\n        Recoup Months of: " + getRecoupMonths(  ) +
				
				"\n          Final Payment: " + getFinalAmount() +
				"\n      Recoupment Amount: " + getRecoupmentAmount() +
				"\n------------------------------------------------" +
				"\n MonthlyRecurringAmount: " + getMonthlyRecurringAmount()+
				"\n          BackPayAmount: " + getBackPayAmount()+
				"\n            FinalAmount: " + getFinalAmount()+
				//getRecoupmentAmount();
				"\n         ProratedAmount: " + getProratedAmount()+
				"\n            MonthlyRate: " + getMonthlyRate()+
				"\n              DailyRate: " + getDailyRate()+
				"\n             HourlyRate: " + getHourlyRate()+
				"\n           ProratedDate: " + getProratedDate()+
				"\n      RetroactiveMonths: " + getRetroactiveMonths();
	}
	
}

