package gov.va.caret.model.support.occ;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Calendar;

import gov.va.caret.model.StiPt;


public class AddressChange extends CalculationWrapper implements CalculationChange {

	private StiPt oldConfig;
	private BigDecimal oldDailyRate = null;			//( ( [Tier Level Monthly Hours] * [Local Hourly Wage] ) * 12) / 365
	private BigDecimal totalStipend;  				//[Monthly Amount] + [Prorated Amount] + [Back Pay] OCC Super must review if > 35k

	public AddressChange(StiPt config, StiPt oldConfig, int month, int year ) {
		super(config, month, year);
		this.oldConfig = oldConfig;
	}
	
	public BigDecimal getTotalStipend(){
		if ( totalStipend == null ){
			totalStipend = getMonthlyRate().subtract( getOldMonthlyRate() );
			totalStipend = new BigDecimal( String.valueOf( totalStipend.doubleValue() ) ).setScale( 2, RoundingMode.HALF_UP );
		}
		return totalStipend;
	}
	
	//( [Total Days] * ([Old Daily Rate]  [New Daily Rate]) ) + ([Number of Retro Months * ([Old Monthly Amount]  [New Monthly Amount]))
	public BigDecimal getRecoupmentAmount(){
		return (new BigDecimal( getTotalDays() ).multiply( getOldDailyRate().subtract( getDailyRate() ) ) )
				.add( new BigDecimal( getRetroactiveMonths() ).multiply( getOldPartialMonthlyAmount().subtract( getPartialMonthlyAmount() ) ) );
	}
	
	public double getTotalDays(  ) {
		Calendar calendar = Calendar.getInstance();
		calendar.setTime( config.getStipendStartDate() );
		return calendar.getActualMaximum( Calendar.DAY_OF_MONTH ) - calendar.get(Calendar.DAY_OF_MONTH) + 1;
	}
	
	public BigDecimal getPartialMonthlyAmount (  ) {
		Calendar effectiveDate = Calendar.getInstance();
		effectiveDate.setTime( config.getStipendStartDate() );
		int count = effectiveDate.getActualMaximum( Calendar.DAY_OF_MONTH ) - effectiveDate.get(Calendar.DAY_OF_MONTH) + 1;
		return new BigDecimal ( count ).multiply( getDailyRate() );
	}
	
	public BigDecimal getOldPartialMonthlyAmount( ){
		Calendar effectiveDate = Calendar.getInstance();
		effectiveDate.setTime( config.getStipendStartDate() );
		return new BigDecimal ( effectiveDate.get( Calendar.DAY_OF_MONTH )).multiply( getOldDailyRate() );
	}
	
	public BigDecimal getOldMonthlyRate (  ) {
		return new BigDecimal( oldConfig.getMonthlyPayment() );
	}
	
	public BigDecimal getOldDailyRate(){
		if ( oldDailyRate == null ){
			oldDailyRate = new BigDecimal( oldConfig.getBlsRateHourly() ).multiply( StipendConfig.getTierLevelMonthlyHours( config.getTier() ) ).multiply( new BigDecimal(12) ).divide( new BigDecimal(365), 2, RoundingMode.HALF_UP );
		}
		return oldDailyRate;
	}
	
	@Override
	public BigDecimal getOldHourlyRate() {
		return new BigDecimal( oldConfig.getBlsRateHourly() );
	}
	
	public boolean isCalculationChange(){
		return true;
	}

//	public static void main ( String[] args ) throws ParseException{
//		StipendConfig oldConfig = new StipendConfig( 2, 11.92, format.parse("10/15/2016") );
//		StipendConfig config = new StipendConfig( 2, 18.11, format.parse("02/05/2017") );		
//		System.out.println( new AddressChange( config, oldConfig, Calendar.MARCH, 2017 ) );
//	}
	

	public String toString () {
		return   "    Stipend Payment Date: " + formatDate( getPaymentDate() ) + 
				"\n Tier Change Start Date: " + formatDate( config.getStipendStartDate() ) +
				"\n Current Monthly Amount: " + getOldMonthlyRate() +
				"\n     New Monthly Amount: " + getMonthlyRate(  ) +

				"\n  Current Daily Rate of: " + oldConfig.getBlsRateHourly() +
				"\n      New Daily Rate of: " + config.getBlsRateHourly() +
				"\n             Pay Change: " + getOldMonthlyRate() +
				"\n      Recoupment Amount: " + getRecoupmentAmount()  +
				"\n      Total Payment Due: " + getTotalStipend(  )  +
				"\n------------------------------------------------" +
				"\n MonthlyRecurringAmount: " + getMonthlyRecurringAmount()+
				"\n          BackPayAmount: " + getBackPayAmount()+
				"\n            FinalAmount: " + getFinalAmount()+
				//getRecoupmentAmount();
				"\n         ProratedAmount: " + getProratedAmount()+
				"\n            MonthlyRate: " + getMonthlyRate()+
				"\n              DailyRate: " + getDailyRate()+
				"\n             HourlyRate: " + getHourlyRate()+
				"\n           ProratedDate: " + getProratedDate()+
				"\n      RetroactiveMonths: " + getRetroactiveMonths();
	}

	
}

