package gov.va.caret.model.support;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.model.BgLae;
import gov.va.caret.model.BoxGp;
import gov.va.caret.model.Docum;
import gov.va.caret.model.Note;
import gov.va.caret.model.StiPt;
import gov.va.caret.model.VcgAn;
import gov.va.caret.model.WorImWrapper;
import gov.va.caret.model.impl.BgLaeImpl;
import gov.va.caret.model.impl.BoxGpImpl;
import gov.va.caret.model.support.occ.AddressChange;
import gov.va.caret.model.support.occ.CalculationInfo;
import gov.va.caret.model.support.occ.FinalPayment;
import gov.va.caret.model.support.occ.InitialPayment;
import gov.va.caret.model.support.occ.Reinstatement;
import gov.va.caret.model.support.occ.TierChange;
import gov.va.caret.service.BgLaeLocalServiceUtil;
import gov.va.caret.service.BoxGpLocalServiceUtil;
import gov.va.caret.service.CaretLocalServiceUtil;
import gov.va.caret.service.DocumLocalServiceUtil;
import gov.va.caret.service.StiPtLocalServiceUtil;
import gov.va.caret.service.VcgAnLocalServiceUtil;
import gov.va.caret.util.CaretUtil;
import gov.va.caret.util.Toolbox;
import gov.va.caret.workflow.OwnerQueue;
import gov.va.caret.workflow.QueAction;

public class WorkItemSupport extends WorImWrapper {

	private static Log _log = LogFactoryUtil.getLog( WorkItemSupport.class );
	String personName = null;
	String caregiverName = null;
	private Map<String,BgLae> customAttributes = new HashMap<String,BgLae>();
	private Boolean docLoaded = null;
	private WorkType workType = null;
	private Map<String,Note> notes = new HashMap<String,Note>();
	private Person caregiver = null;
	private Veteran veteran = null;
	private VcgSupport vcgSupport = null;
	private CalculationInfo calcInfo = null;
	
	private static final long serialVersionUID = 1L;
	private static final int NOTE_FIELD_LENGTH = 75;
	private static final int BG_LEA_FIELD_LENGTH = 75;
	
	public static long getSerialversionuid() {
		return serialVersionUID;
	}
	
	public WorkItemSupport(gov.va.caret.model.WorIm WorIm) {
		super(WorIm);
	}
	
	public Veteran getVeteran(){
		if ( veteran == null ){
			veteran = getVcgSupport().getVeteran();
		}
		return veteran;
	}

	public String getPersonName() {
		if ( personName == null ){
			this.personName = getFullName( getPersnId() );
		}
		return personName;
	}

	public String getCaregiverName() {
		if ( caregiverName == null ){
			this.caregiverName = getFullName( getCaregiverId() );
		}
		return caregiverName;
	}
	
	public VcgSupport getVcgSupport(){
		if ( vcgSupport == null ){
			vcgSupport = VcgSupport.getVcgSupport( getVcgId() );
		}
		return vcgSupport;
	}
	
	public Person getCaregiver(){
		if ( caregiver == null ){
			caregiver = getVcgSupport().getPersonRole( getCaregiverId() );
		}
		return caregiver;
	}
	
	public List<Docum> getDocuments(){
		try{
			if ( isDocType() ){
				return DocumLocalServiceUtil.getByPrimaryKey( getClassPk() );
			}
		} catch (ApplicationWorkFlowException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		return Collections.emptyList();
	}
	
	public WorkType getWorkType(){
		try {
			if ( workType == null ){
//				String type = getType();
//				if ( type.endsWith("_DISPOSITION") ){
//					type= type.substring(0, type.length()-12 );
//				}
				workType = WorkType.valueOf( getType() );
			}
		} catch ( Exception e ){
			_log.error("Couldnt load workTye:" + getType() );
		}
		return workType;
	}
	
	public List<QueAction> getReviewActions(){
		List<QueAction> queActions = Collections.emptyList();
		if ( getQueueId() > 0 ){
			if ( isCscCorrection() ){
				queActions = OwnerQueue.CORRECTION_Q.getActions();
			} else try {
				queActions = OwnerQueue.getOwnerQue( getQueueId() ).getActions();
				QueAction review = QueAction.valueOf(getStatus());
				int ndx = queActions.indexOf(review);
				if ( ndx >= 0 ){
					List<QueAction> queActionsCopy = new ArrayList<>();
					for ( int i = 0; i < queActions.size(); i++ ){
						if ( i == ndx ) continue;
						queActionsCopy.add(queActions.get(i));
					}
					return queActionsCopy;
				}
			} catch( Exception e){}
		}
		return queActions;
	}
	
	public boolean isCscCorrection(){ 
		return OwnerQueue.CORRECTION_Q.name().equals(getStatus()); 
	}
	
	public boolean isDocType(){
		return getWorkType().isDocType;
	}
	
	public boolean isDocLoaded(){
		if ( docLoaded == null ){
			try {
				docLoaded = isDocType() && DocumLocalServiceUtil.getByPrimaryKeyCount( getClassPk() ) > 0;
			} catch (ApplicationWorkFlowException e) {
				ApplicationWorkFlowException.handleException(e);
			}
		}
		return docLoaded;
	}
	
	public boolean isTransferable(){
		switch (getWorkType()){
			case ONLINE_APP:
			case CSC_APP:
			case REFERRAL:
			case HEC_REFERRAL:
			case HRC_REFERRAL:
			case CSL_REFERRAL:
			case CALL_REFERRAL:
				return true;
			default:
				return false;
		}
	}
	
	public boolean isAssignable(){
		switch (getWorkType()){
			case ONLINE_APP:
			case CSC_APP:
			case REFERRAL:
			case HEC_REFERRAL:
			case HRC_REFERRAL:
			case CSL_REFERRAL:
			case CALL_REFERRAL:
				return true;
			default:
				return false;
		}
	}
	
	public String getDueDateStr ( ){
		if ( getDueDate() != null ){
			return Toolbox.formatDateCprs( getDueDate() );
		}
		return StringPool.BLANK;
	}
	
	public String getCreateDateStr ( ){
		if ( getCreationDate() != null ){
			return Toolbox.formatDateCprs( getCreationDate() );
		}
		return StringPool.BLANK;
	}

	public String getFullName ( long persnId ){
		if ( persnId > 0 ){
			return CaretUtil.getPersnFullName ( persnId );
		}
		return StringPool.BLANK;
	}
	
	public String getFacilityName (){
		if ( getGroupId() == 0 ){
			return StringPool.BLANK;
		} else {
			try {
				return OrganizationLocalServiceUtil.getOrganization( getGroupId() ).getName();
			} catch (PortalException e) {
			} catch (SystemException e) {
			}
		}
		return StringPool.BLANK;
	}
	
	public String getUserQueue(){
		if ( getUserId() > 0 ){
			return CaretUtil.getUserFullName ( getUserId() );
		}
		return StringPool.BLANK;
	}
	
	public String getQueueName(){
		if ( getQueueId() > 0 ){
			try {
				OwnerQueue ownerQue = OwnerQueue.getOwnerQue( getQueueId() );
				if ( ownerQue != null ){
					return ownerQue.name();
				}
			} catch ( Exception e ){
				e.printStackTrace();
			}
		}
		return null;
	}
	

	public boolean isCompletable ( VcgSupport vcgSupport ) throws SystemException, PortalException {
		if ( WorkType.CSC_APP.name().equals( getType() ) || WorkType.ONLINE_APP.name().equals( getType() ) ){
			
			_log.debug("WorkStatus : (" + getClassPk() + ") " + getStatus()  );
			if ( getVcgId() == 0 || WorkStatus.COMPLETE.name().equals( getStatus() ) ){
				return false;
			}
			VcgApplication vcgApp = new VcgApplication( VcgAnLocalServiceUtil.getVcgAn( getClassPk() ) );
			int i = 0;
			_log.debug("------------------------AppStatus--" + vcgApp.getStatus() + "-----------------------------------" );
			_log.debug( "vcgApplication - Primary - vcg-closed:" + vcgSupport.getPrimaryDispReason()  );
			_log.debug("vcgApplication - Primary - invalid:" + vcgApp.isInvalidPrimary() );
			_log.debug("vcgApplication - Primary - isInProcess:" + vcgSupport.isInProcess( vcgSupport.getPrimaryDispReason() ) );
			if ( vcgApp.getPrimaryId() == 0 || vcgApp.isInvalidPrimary() || 
					( vcgSupport.getPrimaryDispositionDate() != null && vcgApp.getVcgAnId() == vcgSupport.getPrimaryVcgAnId() ) ||
					vcgSupport.getPrimaryVcgAnId() != getClassPk() ){
				i ++;
			}
			_log.debug("vcgApplication - Secondary - vcg-closed:" + vcgSupport.getSecondaryDispReason()  );
			_log.debug("vcgApplication - Secondary - invalid:" + vcgApp.isInvalidSecondary() );
			_log.debug("vcgApplication - Secondary - isInProcess:" + vcgSupport.isInProcess( vcgSupport.getSecondaryDispReason() ) );
			if ( vcgApp.getSecondaryId() == 0 || vcgApp.isInvalidSecondary() || 
					( vcgSupport.getSecondaryDispositionDate() != null && vcgApp.getVcgAnId() == vcgSupport.getSecondaryVcgAnId() )  ||
					vcgSupport.getSecondaryVcgAnId() != getClassPk() ){
				i ++;
			}
			_log.debug("vcgApplication - Secondary2 - vcg-closed:" + vcgSupport.getSecondaryTwoDispReason()  );
			_log.debug("vcgApplication - Secondary2 - invalid:" + vcgApp.isInvalidSecondaryTwo() );
			_log.debug("vcgApplication - Secondary2 - isInProcess:" + vcgSupport.isInProcess( vcgSupport.getSecondaryTwoDispReason() ) );
			if ( vcgApp.getSecondaryTwoId() == 0 || vcgApp.isInvalidSecondaryTwo() || 
					( vcgSupport.getSecondaryTwoDispositionDate() != null && vcgApp.getVcgAnId() == vcgSupport.getSecondaryTwoVcgAnId() )  ||
					vcgSupport.getSecondaryTwoVcgAnId() != getClassPk() ){
				i ++;
			}
			return i == 3;
		}
		return false;
	}
	
	@Override
	public void persist()
		throws com.liferay.portal.kernel.exception.SystemException {
		if ( getPersnId() == 0 ){
			throw new com.liferay.portal.kernel.exception.SystemException("Person ID cannot be 0");
		}
		super.persist();
		saveCustomAttributes();
	}
	
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> modelAttributes = super.getModelAttributes();  
		if ( !customAttributes.isEmpty() ) {
			for ( String key : customAttributes.keySet() ){
				String text = customAttributes.get(key).getLargeText();
				modelAttributes.put(key, text.substring(0, Math.min(text.length(), BG_LEA_FIELD_LENGTH )) );
			}
		}
		for ( String attribute: notes.keySet() ){
			Note note = notes.get(attribute);
			String text = note.getValue();
			modelAttributes.put( attribute, text.substring(0, Math.min(text.length(), NOTE_FIELD_LENGTH )) );
		}
		if ( getCompletionDate() != null ) {
			modelAttributes.put( "completionDate", Toolbox.getDateFormatCprs().format( getCompletionDate() ) );
		}
		return modelAttributes;
	}
	
	private BoxGp initCustomAttribute( String attribute ) throws ApplicationWorkFlowException{
		BoxGp custom = new BoxGpImpl();
		custom.setBoxGroup( WorkItemSupport.class.getName() );
		custom.setBoxSubGroup( String.valueOf( getWorImId() ) );
		custom.setLabel( attribute );  //attribute
//		custom.setViewSequence( sequence );
		try {
			return BoxGpLocalServiceUtil.addBoxGp( custom );
		} catch (SystemException e) {
			throw new ApplicationWorkFlowException ( e );
		}
	}
	private BoxGp getCustomAttribute ( String attribute  ) throws ApplicationWorkFlowException {
		List<BoxGp> attributes = BoxGpLocalServiceUtil.getBoxGroups( WorkItemSupport.class.getName(), String.valueOf( getWorImId() )  );
		BoxGp custom = null;
		if ( attributes.isEmpty() ){
			custom = initCustomAttribute ( attribute );
		} else {
			for ( BoxGp bgAtt : attributes ){
				if ( attribute.equals( bgAtt.getLabel() ) ){
					custom = bgAtt;
				}
			}
		}
		if ( custom == null ){
			custom = initCustomAttribute ( attribute );
		}
		return custom;
	}
	
	public long getApplicationId(){
		if ( getClassId() == PortalUtil.getClassNameId( VcgAn.class ) ){
			return getClassPk();
		}
		return 0;
	}
	
	private void saveCustomAttributes() {
		if ( !customAttributes.isEmpty() ){
			for ( BgLae value : customAttributes.values() ){
				try {
					value.setOwnerId(getWorImId());
					CaretLocalServiceUtil.save(value);
				} catch (ApplicationWorkFlowException e) {
					ApplicationWorkFlowException.handleException(e);
				}
			}
		}
		for ( String attribute: notes.keySet() ){
			Note note = notes.get(attribute);
			if ( note.getNoteId() == 0 ) try {
				note.setVcgId( getVcgId() );
				notes.put(attribute, CaretLocalServiceUtil.addNote(note));
			} catch (ApplicationWorkFlowException e) {
				ApplicationWorkFlowException.handleException(e);
			}
		}
		if ( hasAutomaticWork() ){
			doAutomaticAction();
		}
	}
	
	public void setNote ( String attribute, String comment, long userId, Date createDate, long groupId ){
		 notes.put( attribute, CaretUtil.createNote( createDate, getWorImId(), groupId, userId, comment ) );
	}
	
	public void useNote( String attribute, Note note ) {
		notes.put( attribute, note );
	}
	
	public Note getNote ( String attribute ){
		if ( notes.containsKey(attribute) ){
			return notes.get(attribute); 
		}
		return null;
	}
	
//	public void setTransferComment ( String comment, long userId, Date createDate ){
//		this.note = Toolbox.createNote( createDate, getWorImId(), getGroupId(), userId, comment );
//	}

	private BgLae getLeaAttr ( String attribute  ) throws ApplicationWorkFlowException {
		BoxGp custom = getCustomAttribute ( attribute );
		BgLae value = BgLaeLocalServiceUtil.getBgLaeAssociation( getWorImId(), custom.getBoxGpId() );
		if ( value == null ){
			value = new BgLaeImpl();
			value.setBoxGpId( custom.getBoxGpId() );
		}
		return value;
	}
	
	public void setLeaAttr ( String attribute, String value ) throws ApplicationWorkFlowException{
		BgLae bgLea = getLeaAttr(attribute);
		bgLea.setLargeText(  value.substring(0, Math.min( value.length(), BG_LEA_FIELD_LENGTH ))  );
		customAttributes.put(attribute, bgLea);
	}
	
	Map automaticWork = null;
	private boolean hasAutomaticWork() {
		if ( automaticWork != null && !automaticWork.isEmpty() ){
			//do automatic work...
		}
		return false;
	}
	
	public void setupAutomaticWork ( Map automaticWork ){
		this.automaticWork = automaticWork;
	}
	
	public void doAutomaticAction ( ){
		_log.info("Do Automatic work...");
	}
	
	public void setCalculationInfoCalendar ( Date date ){
		calendar.setTime(date);
	}
	
	private Calendar calendar = Calendar.getInstance();
	
	
//	List<StiPt> configs = new ArrayList<StiPt>();
//	public void createStipendConfig(){
//		_log.info(" createStipendConfig... ");
//		for ( StiPt config: configs ){
//			config.setWorImId( getWorImId() );
//			try {
//				CaretLocalServiceUtil.save(config);
//			} catch (ApplicationWorkFlowException e) {
//				e.printStackTrace();
//			}
//		}
//		if ( wasNew ){
//			StiCg rawStiCg = null;
//			switch( getWorkType() ){
//			case ADDRESS_CHANGE:
//				rawStiCg = getRawStiCg();
//				rawStiCg.setEffectiveDate( calendar.getTime() );
//				rawStiCg.setTierLevel( getVcgSupport().getTierLevel() );
//				rawStiCg.setEntitledDays(entitledDays);
//				rawStiCg.setLocalHourlyWage(localHourlyWage);
//				break;
//			case APPROVED:
//				break;
//			case REINSTATED:
//				break;
//			case REVOKED:
//				break;
//			case TIER_UPDATE:
//				calcInfo = new TierChange( list.get(0), list.get(1), calendar.get(Calendar.MONTH), calendar.get(Calendar.YEAR) );
//				break;
//			}
//		}
//	}
	
//	boolean wasNew = false;
//	private StiPt getRawStiCg(){
//		StiPt stiCg = new StiPtImpl();
//		stiCg.setWorImId( getWorImId() );
//		return stiCg;
//	}

	public CalculationInfo getCalcInfo() {
		if ( calcInfo == null ){
			try {
				List<StiPt> list = StiPtLocalServiceUtil.findByWorkItem( getWorImId() );
				switch( getWorkType() ){
				case ADDRESS_CHANGE:
					calcInfo = new AddressChange( list.get(0), list.get(1), calendar.get(Calendar.MONTH), calendar.get(Calendar.YEAR) );
					break;
				case APPROVED_DISPOSITION:
					calcInfo = new InitialPayment( list.get(0), calendar.get(Calendar.MONTH), calendar.get(Calendar.YEAR) );
					break;
				case REINSTATED_DISPOSITION:
					calcInfo = new Reinstatement( list.get(0), calendar.get(Calendar.MONTH), calendar.get(Calendar.YEAR) );
					break;
				case REVOKED_DISPOSITION:
					calcInfo = new FinalPayment( list.get(0), calendar.get(Calendar.MONTH), calendar.get(Calendar.YEAR) );
					break;
				case TIER_UPDATE:
					calcInfo = new TierChange( list.get(0), list.get(1), calendar.get(Calendar.MONTH), calendar.get(Calendar.YEAR) );
					break;
				}
			} catch ( Exception e ){
				_log.error("Couldnt load WorkType / calculation Info");
			}
		}
		return calcInfo;
	}
	
}
