package gov.va.caret.model.impl;

import com.liferay.portal.kernel.exception.SystemException;

import gov.va.caret.model.Waivr;
import gov.va.caret.service.WaivrLocalServiceUtil;

/**
 * The extended model base implementation for the Waivr service. Represents a row in the &quot;CARET_WAIVER&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link WaivrImpl}.
 * </p>
 *
 * @author caret
 * @see WaivrImpl
 * @see gov.va.caret.model.Waivr
 * @generated
 */
public abstract class WaivrBaseImpl extends WaivrModelImpl implements Waivr {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. All methods that expect a waivr model instance should use the {@link Waivr} interface instead.
     */
    @Override
    public void persist() throws SystemException {
        if (this.isNew()) {
            WaivrLocalServiceUtil.addWaivr(this);
        } else {
            WaivrLocalServiceUtil.updateWaivr(this);
        }
    }
}
