package gov.va.caret.model.impl;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.CacheModel;

import gov.va.caret.model.Vendr;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

/**
 * The cache model class for representing Vendr in entity cache.
 *
 * @author caret
 * @see Vendr
 * @generated
 */
public class VendrCacheModel implements CacheModel<Vendr>, Externalizable {
    public long vendrId;
    public String lastName;
    public String firstName;
    public String middleName;
    public String fedTaxId;
    public String address;
    public String address2;
    public String city;
    public String state;
    public String zip;
    public String phone;
    public String phone2;
    public String gracePeriod;
    public String gracePeriodDuration;
    public String directDepositInfo;
    public String paymentMethod;
    public String crypto1;
    public long groupId;

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(37);

        sb.append("{vendrId=");
        sb.append(vendrId);
        sb.append(", lastName=");
        sb.append(lastName);
        sb.append(", firstName=");
        sb.append(firstName);
        sb.append(", middleName=");
        sb.append(middleName);
        sb.append(", fedTaxId=");
        sb.append(fedTaxId);
        sb.append(", address=");
        sb.append(address);
        sb.append(", address2=");
        sb.append(address2);
        sb.append(", city=");
        sb.append(city);
        sb.append(", state=");
        sb.append(state);
        sb.append(", zip=");
        sb.append(zip);
        sb.append(", phone=");
        sb.append(phone);
        sb.append(", phone2=");
        sb.append(phone2);
        sb.append(", gracePeriod=");
        sb.append(gracePeriod);
        sb.append(", gracePeriodDuration=");
        sb.append(gracePeriodDuration);
        sb.append(", directDepositInfo=");
        sb.append(directDepositInfo);
        sb.append(", paymentMethod=");
        sb.append(paymentMethod);
        sb.append(", crypto1=");
        sb.append(crypto1);
        sb.append(", groupId=");
        sb.append(groupId);
        sb.append("}");

        return sb.toString();
    }

    @Override
    public Vendr toEntityModel() {
        VendrImpl vendrImpl = new VendrImpl();

        vendrImpl.setVendrId(vendrId);

        if (lastName == null) {
            vendrImpl.setLastName(StringPool.BLANK);
        } else {
            vendrImpl.setLastName(lastName);
        }

        if (firstName == null) {
            vendrImpl.setFirstName(StringPool.BLANK);
        } else {
            vendrImpl.setFirstName(firstName);
        }

        if (middleName == null) {
            vendrImpl.setMiddleName(StringPool.BLANK);
        } else {
            vendrImpl.setMiddleName(middleName);
        }

        if (fedTaxId == null) {
            vendrImpl.setFedTaxId(StringPool.BLANK);
        } else {
            vendrImpl.setFedTaxId(fedTaxId);
        }

        if (address == null) {
            vendrImpl.setAddress(StringPool.BLANK);
        } else {
            vendrImpl.setAddress(address);
        }

        if (address2 == null) {
            vendrImpl.setAddress2(StringPool.BLANK);
        } else {
            vendrImpl.setAddress2(address2);
        }

        if (city == null) {
            vendrImpl.setCity(StringPool.BLANK);
        } else {
            vendrImpl.setCity(city);
        }

        if (state == null) {
            vendrImpl.setState(StringPool.BLANK);
        } else {
            vendrImpl.setState(state);
        }

        if (zip == null) {
            vendrImpl.setZip(StringPool.BLANK);
        } else {
            vendrImpl.setZip(zip);
        }

        if (phone == null) {
            vendrImpl.setPhone(StringPool.BLANK);
        } else {
            vendrImpl.setPhone(phone);
        }

        if (phone2 == null) {
            vendrImpl.setPhone2(StringPool.BLANK);
        } else {
            vendrImpl.setPhone2(phone2);
        }

        if (gracePeriod == null) {
            vendrImpl.setGracePeriod(StringPool.BLANK);
        } else {
            vendrImpl.setGracePeriod(gracePeriod);
        }

        if (gracePeriodDuration == null) {
            vendrImpl.setGracePeriodDuration(StringPool.BLANK);
        } else {
            vendrImpl.setGracePeriodDuration(gracePeriodDuration);
        }

        if (directDepositInfo == null) {
            vendrImpl.setDirectDepositInfo(StringPool.BLANK);
        } else {
            vendrImpl.setDirectDepositInfo(directDepositInfo);
        }

        if (paymentMethod == null) {
            vendrImpl.setPaymentMethod(StringPool.BLANK);
        } else {
            vendrImpl.setPaymentMethod(paymentMethod);
        }

        if (crypto1 == null) {
            vendrImpl.setCrypto1(StringPool.BLANK);
        } else {
            vendrImpl.setCrypto1(crypto1);
        }

        vendrImpl.setGroupId(groupId);

        vendrImpl.resetOriginalValues();

        return vendrImpl;
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        vendrId = objectInput.readLong();
        lastName = objectInput.readUTF();
        firstName = objectInput.readUTF();
        middleName = objectInput.readUTF();
        fedTaxId = objectInput.readUTF();
        address = objectInput.readUTF();
        address2 = objectInput.readUTF();
        city = objectInput.readUTF();
        state = objectInput.readUTF();
        zip = objectInput.readUTF();
        phone = objectInput.readUTF();
        phone2 = objectInput.readUTF();
        gracePeriod = objectInput.readUTF();
        gracePeriodDuration = objectInput.readUTF();
        directDepositInfo = objectInput.readUTF();
        paymentMethod = objectInput.readUTF();
        crypto1 = objectInput.readUTF();
        groupId = objectInput.readLong();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput)
        throws IOException {
        objectOutput.writeLong(vendrId);

        if (lastName == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(lastName);
        }

        if (firstName == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(firstName);
        }

        if (middleName == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(middleName);
        }

        if (fedTaxId == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(fedTaxId);
        }

        if (address == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(address);
        }

        if (address2 == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(address2);
        }

        if (city == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(city);
        }

        if (state == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(state);
        }

        if (zip == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(zip);
        }

        if (phone == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(phone);
        }

        if (phone2 == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(phone2);
        }

        if (gracePeriod == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(gracePeriod);
        }

        if (gracePeriodDuration == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(gracePeriodDuration);
        }

        if (directDepositInfo == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(directDepositInfo);
        }

        if (paymentMethod == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(paymentMethod);
        }

        if (crypto1 == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(crypto1);
        }

        objectOutput.writeLong(groupId);
    }
}
