package gov.va.caret.model.impl;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.model.impl.BaseModelImpl;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PortalUtil;

import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.expando.util.ExpandoBridgeFactoryUtil;

import gov.va.caret.model.StiRd;
import gov.va.caret.model.StiRdModel;

import java.io.Serializable;

import java.sql.Types;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * The base model implementation for the StiRd service. Represents a row in the &quot;CARET_STIPEND&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface {@link gov.va.caret.model.StiRdModel} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link StiRdImpl}.
 * </p>
 *
 * @author caret
 * @see StiRdImpl
 * @see gov.va.caret.model.StiRd
 * @see gov.va.caret.model.StiRdModel
 * @generated
 */
public class StiRdModelImpl extends BaseModelImpl<StiRd> implements StiRdModel {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. All methods that expect a sti rd model instance should use the {@link gov.va.caret.model.StiRd} interface instead.
     */
    public static final String TABLE_NAME = "CARET_STIPEND";
    public static final Object[][] TABLE_COLUMNS = {
            { "stiRdId", Types.BIGINT },
            { "vcgAnId", Types.BIGINT },
            { "cscStatus", Types.VARCHAR },
            { "cscStatusDate", Types.TIMESTAMP },
            { "cbopcStatus", Types.VARCHAR },
            { "cbopcStatusDate", Types.TIMESTAMP },
            { "creationDate", Types.TIMESTAMP },
            { "userId", Types.BIGINT },
            { "groupId", Types.BIGINT }
        };
    public static final String TABLE_SQL_CREATE = "create table CARET_STIPEND (stiRdId LONG not null primary key,vcgAnId LONG,cscStatus VARCHAR(75) null,cscStatusDate DATE null,cbopcStatus VARCHAR(75) null,cbopcStatusDate DATE null,creationDate DATE null,userId LONG,groupId LONG)";
    public static final String TABLE_SQL_DROP = "drop table CARET_STIPEND";
    public static final String ORDER_BY_JPQL = " ORDER BY stiRd.stiRdId ASC";
    public static final String ORDER_BY_SQL = " ORDER BY CARET_STIPEND.stiRdId ASC";
    public static final String DATA_SOURCE = "liferayDataSource";
    public static final String SESSION_FACTORY = "liferaySessionFactory";
    public static final String TX_MANAGER = "liferayTransactionManager";
    public static final boolean ENTITY_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.entity.cache.enabled.gov.va.caret.model.StiRd"),
            true);
    public static final boolean FINDER_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.finder.cache.enabled.gov.va.caret.model.StiRd"),
            true);
    public static final boolean COLUMN_BITMASK_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.column.bitmask.enabled.gov.va.caret.model.StiRd"),
            true);
    public static long VCGANID_COLUMN_BITMASK = 1L;
    public static long STIRDID_COLUMN_BITMASK = 2L;
    public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(com.liferay.util.service.ServiceProps.get(
                "lock.expiration.time.gov.va.caret.model.StiRd"));
    private static ClassLoader _classLoader = StiRd.class.getClassLoader();
    private static Class<?>[] _escapedModelInterfaces = new Class[] { StiRd.class };
    private long _stiRdId;
    private long _vcgAnId;
    private long _originalVcgAnId;
    private boolean _setOriginalVcgAnId;
    private String _cscStatus;
    private Date _cscStatusDate;
    private String _cbopcStatus;
    private Date _cbopcStatusDate;
    private Date _creationDate;
    private long _userId;
    private String _userUuid;
    private long _groupId;
    private long _columnBitmask;
    private StiRd _escapedModel;

    public StiRdModelImpl() {
    }

    @Override
    public long getPrimaryKey() {
        return _stiRdId;
    }

    @Override
    public void setPrimaryKey(long primaryKey) {
        setStiRdId(primaryKey);
    }

    @Override
    public Serializable getPrimaryKeyObj() {
        return _stiRdId;
    }

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        setPrimaryKey(((Long) primaryKeyObj).longValue());
    }

    @Override
    public Class<?> getModelClass() {
        return StiRd.class;
    }

    @Override
    public String getModelClassName() {
        return StiRd.class.getName();
    }

    @Override
    public Map<String, Object> getModelAttributes() {
        Map<String, Object> attributes = new HashMap<String, Object>();

        attributes.put("stiRdId", getStiRdId());
        attributes.put("vcgAnId", getVcgAnId());
        attributes.put("cscStatus", getCscStatus());
        attributes.put("cscStatusDate", getCscStatusDate());
        attributes.put("cbopcStatus", getCbopcStatus());
        attributes.put("cbopcStatusDate", getCbopcStatusDate());
        attributes.put("creationDate", getCreationDate());
        attributes.put("userId", getUserId());
        attributes.put("groupId", getGroupId());

        return attributes;
    }

    @Override
    public void setModelAttributes(Map<String, Object> attributes) {
        Long stiRdId = (Long) attributes.get("stiRdId");

        if (stiRdId != null) {
            setStiRdId(stiRdId);
        }

        Long vcgAnId = (Long) attributes.get("vcgAnId");

        if (vcgAnId != null) {
            setVcgAnId(vcgAnId);
        }

        String cscStatus = (String) attributes.get("cscStatus");

        if (cscStatus != null) {
            setCscStatus(cscStatus);
        }

        Date cscStatusDate = (Date) attributes.get("cscStatusDate");

        if (cscStatusDate != null) {
            setCscStatusDate(cscStatusDate);
        }

        String cbopcStatus = (String) attributes.get("cbopcStatus");

        if (cbopcStatus != null) {
            setCbopcStatus(cbopcStatus);
        }

        Date cbopcStatusDate = (Date) attributes.get("cbopcStatusDate");

        if (cbopcStatusDate != null) {
            setCbopcStatusDate(cbopcStatusDate);
        }

        Date creationDate = (Date) attributes.get("creationDate");

        if (creationDate != null) {
            setCreationDate(creationDate);
        }

        Long userId = (Long) attributes.get("userId");

        if (userId != null) {
            setUserId(userId);
        }

        Long groupId = (Long) attributes.get("groupId");

        if (groupId != null) {
            setGroupId(groupId);
        }
    }

    @Override
    public long getStiRdId() {
        return _stiRdId;
    }

    @Override
    public void setStiRdId(long stiRdId) {
        _stiRdId = stiRdId;
    }

    @Override
    public long getVcgAnId() {
        return _vcgAnId;
    }

    @Override
    public void setVcgAnId(long vcgAnId) {
        _columnBitmask |= VCGANID_COLUMN_BITMASK;

        if (!_setOriginalVcgAnId) {
            _setOriginalVcgAnId = true;

            _originalVcgAnId = _vcgAnId;
        }

        _vcgAnId = vcgAnId;
    }

    public long getOriginalVcgAnId() {
        return _originalVcgAnId;
    }

    @Override
    public String getCscStatus() {
        if (_cscStatus == null) {
            return StringPool.BLANK;
        } else {
            return _cscStatus;
        }
    }

    @Override
    public void setCscStatus(String cscStatus) {
        _cscStatus = cscStatus;
    }

    @Override
    public Date getCscStatusDate() {
        return _cscStatusDate;
    }

    @Override
    public void setCscStatusDate(Date cscStatusDate) {
        _cscStatusDate = cscStatusDate;
    }

    @Override
    public String getCbopcStatus() {
        if (_cbopcStatus == null) {
            return StringPool.BLANK;
        } else {
            return _cbopcStatus;
        }
    }

    @Override
    public void setCbopcStatus(String cbopcStatus) {
        _cbopcStatus = cbopcStatus;
    }

    @Override
    public Date getCbopcStatusDate() {
        return _cbopcStatusDate;
    }

    @Override
    public void setCbopcStatusDate(Date cbopcStatusDate) {
        _cbopcStatusDate = cbopcStatusDate;
    }

    @Override
    public Date getCreationDate() {
        return _creationDate;
    }

    @Override
    public void setCreationDate(Date creationDate) {
        _creationDate = creationDate;
    }

    @Override
    public long getUserId() {
        return _userId;
    }

    @Override
    public void setUserId(long userId) {
        _userId = userId;
    }

    @Override
    public String getUserUuid() throws SystemException {
        return PortalUtil.getUserValue(getUserId(), "uuid", _userUuid);
    }

    @Override
    public void setUserUuid(String userUuid) {
        _userUuid = userUuid;
    }

    @Override
    public long getGroupId() {
        return _groupId;
    }

    @Override
    public void setGroupId(long groupId) {
        _groupId = groupId;
    }

    public long getColumnBitmask() {
        return _columnBitmask;
    }

    @Override
    public ExpandoBridge getExpandoBridge() {
        return ExpandoBridgeFactoryUtil.getExpandoBridge(0,
            StiRd.class.getName(), getPrimaryKey());
    }

    @Override
    public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
        ExpandoBridge expandoBridge = getExpandoBridge();

        expandoBridge.setAttributes(serviceContext);
    }

    @Override
    public StiRd toEscapedModel() {
        if (_escapedModel == null) {
            _escapedModel = (StiRd) ProxyUtil.newProxyInstance(_classLoader,
                    _escapedModelInterfaces, new AutoEscapeBeanHandler(this));
        }

        return _escapedModel;
    }

    @Override
    public Object clone() {
        StiRdImpl stiRdImpl = new StiRdImpl();

        stiRdImpl.setStiRdId(getStiRdId());
        stiRdImpl.setVcgAnId(getVcgAnId());
        stiRdImpl.setCscStatus(getCscStatus());
        stiRdImpl.setCscStatusDate(getCscStatusDate());
        stiRdImpl.setCbopcStatus(getCbopcStatus());
        stiRdImpl.setCbopcStatusDate(getCbopcStatusDate());
        stiRdImpl.setCreationDate(getCreationDate());
        stiRdImpl.setUserId(getUserId());
        stiRdImpl.setGroupId(getGroupId());

        stiRdImpl.resetOriginalValues();

        return stiRdImpl;
    }

    @Override
    public int compareTo(StiRd stiRd) {
        long primaryKey = stiRd.getPrimaryKey();

        if (getPrimaryKey() < primaryKey) {
            return -1;
        } else if (getPrimaryKey() > primaryKey) {
            return 1;
        } else {
            return 0;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (!(obj instanceof StiRd)) {
            return false;
        }

        StiRd stiRd = (StiRd) obj;

        long primaryKey = stiRd.getPrimaryKey();

        if (getPrimaryKey() == primaryKey) {
            return true;
        } else {
            return false;
        }
    }

    @Override
    public int hashCode() {
        return (int) getPrimaryKey();
    }

    @Override
    public void resetOriginalValues() {
        StiRdModelImpl stiRdModelImpl = this;

        stiRdModelImpl._originalVcgAnId = stiRdModelImpl._vcgAnId;

        stiRdModelImpl._setOriginalVcgAnId = false;

        stiRdModelImpl._columnBitmask = 0;
    }

    @Override
    public CacheModel<StiRd> toCacheModel() {
        StiRdCacheModel stiRdCacheModel = new StiRdCacheModel();

        stiRdCacheModel.stiRdId = getStiRdId();

        stiRdCacheModel.vcgAnId = getVcgAnId();

        stiRdCacheModel.cscStatus = getCscStatus();

        String cscStatus = stiRdCacheModel.cscStatus;

        if ((cscStatus != null) && (cscStatus.length() == 0)) {
            stiRdCacheModel.cscStatus = null;
        }

        Date cscStatusDate = getCscStatusDate();

        if (cscStatusDate != null) {
            stiRdCacheModel.cscStatusDate = cscStatusDate.getTime();
        } else {
            stiRdCacheModel.cscStatusDate = Long.MIN_VALUE;
        }

        stiRdCacheModel.cbopcStatus = getCbopcStatus();

        String cbopcStatus = stiRdCacheModel.cbopcStatus;

        if ((cbopcStatus != null) && (cbopcStatus.length() == 0)) {
            stiRdCacheModel.cbopcStatus = null;
        }

        Date cbopcStatusDate = getCbopcStatusDate();

        if (cbopcStatusDate != null) {
            stiRdCacheModel.cbopcStatusDate = cbopcStatusDate.getTime();
        } else {
            stiRdCacheModel.cbopcStatusDate = Long.MIN_VALUE;
        }

        Date creationDate = getCreationDate();

        if (creationDate != null) {
            stiRdCacheModel.creationDate = creationDate.getTime();
        } else {
            stiRdCacheModel.creationDate = Long.MIN_VALUE;
        }

        stiRdCacheModel.userId = getUserId();

        stiRdCacheModel.groupId = getGroupId();

        return stiRdCacheModel;
    }

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(19);

        sb.append("{stiRdId=");
        sb.append(getStiRdId());
        sb.append(", vcgAnId=");
        sb.append(getVcgAnId());
        sb.append(", cscStatus=");
        sb.append(getCscStatus());
        sb.append(", cscStatusDate=");
        sb.append(getCscStatusDate());
        sb.append(", cbopcStatus=");
        sb.append(getCbopcStatus());
        sb.append(", cbopcStatusDate=");
        sb.append(getCbopcStatusDate());
        sb.append(", creationDate=");
        sb.append(getCreationDate());
        sb.append(", userId=");
        sb.append(getUserId());
        sb.append(", groupId=");
        sb.append(getGroupId());
        sb.append("}");

        return sb.toString();
    }

    @Override
    public String toXmlString() {
        StringBundler sb = new StringBundler(31);

        sb.append("<model><model-name>");
        sb.append("gov.va.caret.model.StiRd");
        sb.append("</model-name>");

        sb.append(
            "<column><column-name>stiRdId</column-name><column-value><![CDATA[");
        sb.append(getStiRdId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>vcgAnId</column-name><column-value><![CDATA[");
        sb.append(getVcgAnId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>cscStatus</column-name><column-value><![CDATA[");
        sb.append(getCscStatus());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>cscStatusDate</column-name><column-value><![CDATA[");
        sb.append(getCscStatusDate());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>cbopcStatus</column-name><column-value><![CDATA[");
        sb.append(getCbopcStatus());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>cbopcStatusDate</column-name><column-value><![CDATA[");
        sb.append(getCbopcStatusDate());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>creationDate</column-name><column-value><![CDATA[");
        sb.append(getCreationDate());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>userId</column-name><column-value><![CDATA[");
        sb.append(getUserId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>groupId</column-name><column-value><![CDATA[");
        sb.append(getGroupId());
        sb.append("]]></column-value></column>");

        sb.append("</model>");

        return sb.toString();
    }
}
