package gov.va.caret.model.impl;

import com.liferay.portal.kernel.exception.SystemException;

import gov.va.caret.model.Persn;
import gov.va.caret.service.PersnLocalServiceUtil;

/**
 * The extended model base implementation for the Persn service. Represents a row in the &quot;CARET_PERSON&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link PersnImpl}.
 * </p>
 *
 * @author caret
 * @see PersnImpl
 * @see gov.va.caret.model.Persn
 * @generated
 */
public abstract class PersnBaseImpl extends PersnModelImpl implements Persn {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. All methods that expect a persn model instance should use the {@link Persn} interface instead.
     */
    @Override
    public void persist() throws SystemException {
        if (this.isNew()) {
            PersnLocalServiceUtil.addPersn(this);
        } else {
            PersnLocalServiceUtil.updatePersn(this);
        }
    }
}
