package gov.va.caret.model.impl;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.model.impl.BaseModelImpl;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PortalUtil;

import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.expando.util.ExpandoBridgeFactoryUtil;

import gov.va.caret.model.PayLg;
import gov.va.caret.model.PayLgModel;

import java.io.Serializable;

import java.sql.Types;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * The base model implementation for the PayLg service. Represents a row in the &quot;CARET_PAYMENT_LOG&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface {@link gov.va.caret.model.PayLgModel} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link PayLgImpl}.
 * </p>
 *
 * @author caret
 * @see PayLgImpl
 * @see gov.va.caret.model.PayLg
 * @see gov.va.caret.model.PayLgModel
 * @generated
 */
public class PayLgModelImpl extends BaseModelImpl<PayLg> implements PayLgModel {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. All methods that expect a pay lg model instance should use the {@link gov.va.caret.model.PayLg} interface instead.
     */
    public static final String TABLE_NAME = "CARET_PAYMENT_LOG";
    public static final Object[][] TABLE_COLUMNS = {
            { "paymentLogId", Types.BIGINT },
            { "stiPtId", Types.BIGINT },
            { "amount", Types.DOUBLE },
            { "paymentDate", Types.TIMESTAMP },
            { "status", Types.VARCHAR },
            { "reason", Types.VARCHAR },
            { "creationDate", Types.TIMESTAMP },
            { "userId", Types.BIGINT }
        };
    public static final String TABLE_SQL_CREATE = "create table CARET_PAYMENT_LOG (paymentLogId LONG not null primary key,stiPtId LONG,amount DOUBLE,paymentDate DATE null,status VARCHAR(75) null,reason VARCHAR(75) null,creationDate DATE null,userId LONG)";
    public static final String TABLE_SQL_DROP = "drop table CARET_PAYMENT_LOG";
    public static final String ORDER_BY_JPQL = " ORDER BY payLg.paymentDate DESC";
    public static final String ORDER_BY_SQL = " ORDER BY CARET_PAYMENT_LOG.paymentDate DESC";
    public static final String DATA_SOURCE = "liferayDataSource";
    public static final String SESSION_FACTORY = "liferaySessionFactory";
    public static final String TX_MANAGER = "liferayTransactionManager";
    public static final boolean ENTITY_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.entity.cache.enabled.gov.va.caret.model.PayLg"),
            true);
    public static final boolean FINDER_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.finder.cache.enabled.gov.va.caret.model.PayLg"),
            true);
    public static final boolean COLUMN_BITMASK_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.column.bitmask.enabled.gov.va.caret.model.PayLg"),
            true);
    public static long PAYMENTDATE_COLUMN_BITMASK = 1L;
    public static long STIPTID_COLUMN_BITMASK = 2L;
    public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(com.liferay.util.service.ServiceProps.get(
                "lock.expiration.time.gov.va.caret.model.PayLg"));
    private static ClassLoader _classLoader = PayLg.class.getClassLoader();
    private static Class<?>[] _escapedModelInterfaces = new Class[] { PayLg.class };
    private long _paymentLogId;
    private long _stiPtId;
    private long _originalStiPtId;
    private boolean _setOriginalStiPtId;
    private Double _amount;
    private Date _paymentDate;
    private Date _originalPaymentDate;
    private String _status;
    private String _reason;
    private Date _creationDate;
    private long _userId;
    private String _userUuid;
    private long _columnBitmask;
    private PayLg _escapedModel;

    public PayLgModelImpl() {
    }

    @Override
    public long getPrimaryKey() {
        return _paymentLogId;
    }

    @Override
    public void setPrimaryKey(long primaryKey) {
        setPaymentLogId(primaryKey);
    }

    @Override
    public Serializable getPrimaryKeyObj() {
        return _paymentLogId;
    }

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        setPrimaryKey(((Long) primaryKeyObj).longValue());
    }

    @Override
    public Class<?> getModelClass() {
        return PayLg.class;
    }

    @Override
    public String getModelClassName() {
        return PayLg.class.getName();
    }

    @Override
    public Map<String, Object> getModelAttributes() {
        Map<String, Object> attributes = new HashMap<String, Object>();

        attributes.put("paymentLogId", getPaymentLogId());
        attributes.put("stiPtId", getStiPtId());
        attributes.put("amount", getAmount());
        attributes.put("paymentDate", getPaymentDate());
        attributes.put("status", getStatus());
        attributes.put("reason", getReason());
        attributes.put("creationDate", getCreationDate());
        attributes.put("userId", getUserId());

        return attributes;
    }

    @Override
    public void setModelAttributes(Map<String, Object> attributes) {
        Long paymentLogId = (Long) attributes.get("paymentLogId");

        if (paymentLogId != null) {
            setPaymentLogId(paymentLogId);
        }

        Long stiPtId = (Long) attributes.get("stiPtId");

        if (stiPtId != null) {
            setStiPtId(stiPtId);
        }

        Double amount = (Double) attributes.get("amount");

        if (amount != null) {
            setAmount(amount);
        }

        Date paymentDate = (Date) attributes.get("paymentDate");

        if (paymentDate != null) {
            setPaymentDate(paymentDate);
        }

        String status = (String) attributes.get("status");

        if (status != null) {
            setStatus(status);
        }

        String reason = (String) attributes.get("reason");

        if (reason != null) {
            setReason(reason);
        }

        Date creationDate = (Date) attributes.get("creationDate");

        if (creationDate != null) {
            setCreationDate(creationDate);
        }

        Long userId = (Long) attributes.get("userId");

        if (userId != null) {
            setUserId(userId);
        }
    }

    @Override
    public long getPaymentLogId() {
        return _paymentLogId;
    }

    @Override
    public void setPaymentLogId(long paymentLogId) {
        _paymentLogId = paymentLogId;
    }

    @Override
    public long getStiPtId() {
        return _stiPtId;
    }

    @Override
    public void setStiPtId(long stiPtId) {
        _columnBitmask |= STIPTID_COLUMN_BITMASK;

        if (!_setOriginalStiPtId) {
            _setOriginalStiPtId = true;

            _originalStiPtId = _stiPtId;
        }

        _stiPtId = stiPtId;
    }

    public long getOriginalStiPtId() {
        return _originalStiPtId;
    }

    @Override
    public Double getAmount() {
        return _amount;
    }

    @Override
    public void setAmount(Double amount) {
        _amount = amount;
    }

    @Override
    public Date getPaymentDate() {
        return _paymentDate;
    }

    @Override
    public void setPaymentDate(Date paymentDate) {
        _columnBitmask = -1L;

        if (_originalPaymentDate == null) {
            _originalPaymentDate = _paymentDate;
        }

        _paymentDate = paymentDate;
    }

    public Date getOriginalPaymentDate() {
        return _originalPaymentDate;
    }

    @Override
    public String getStatus() {
        if (_status == null) {
            return StringPool.BLANK;
        } else {
            return _status;
        }
    }

    @Override
    public void setStatus(String status) {
        _status = status;
    }

    @Override
    public String getReason() {
        if (_reason == null) {
            return StringPool.BLANK;
        } else {
            return _reason;
        }
    }

    @Override
    public void setReason(String reason) {
        _reason = reason;
    }

    @Override
    public Date getCreationDate() {
        return _creationDate;
    }

    @Override
    public void setCreationDate(Date creationDate) {
        _creationDate = creationDate;
    }

    @Override
    public long getUserId() {
        return _userId;
    }

    @Override
    public void setUserId(long userId) {
        _userId = userId;
    }

    @Override
    public String getUserUuid() throws SystemException {
        return PortalUtil.getUserValue(getUserId(), "uuid", _userUuid);
    }

    @Override
    public void setUserUuid(String userUuid) {
        _userUuid = userUuid;
    }

    public long getColumnBitmask() {
        return _columnBitmask;
    }

    @Override
    public ExpandoBridge getExpandoBridge() {
        return ExpandoBridgeFactoryUtil.getExpandoBridge(0,
            PayLg.class.getName(), getPrimaryKey());
    }

    @Override
    public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
        ExpandoBridge expandoBridge = getExpandoBridge();

        expandoBridge.setAttributes(serviceContext);
    }

    @Override
    public PayLg toEscapedModel() {
        if (_escapedModel == null) {
            _escapedModel = (PayLg) ProxyUtil.newProxyInstance(_classLoader,
                    _escapedModelInterfaces, new AutoEscapeBeanHandler(this));
        }

        return _escapedModel;
    }

    @Override
    public Object clone() {
        PayLgImpl payLgImpl = new PayLgImpl();

        payLgImpl.setPaymentLogId(getPaymentLogId());
        payLgImpl.setStiPtId(getStiPtId());
        payLgImpl.setAmount(getAmount());
        payLgImpl.setPaymentDate(getPaymentDate());
        payLgImpl.setStatus(getStatus());
        payLgImpl.setReason(getReason());
        payLgImpl.setCreationDate(getCreationDate());
        payLgImpl.setUserId(getUserId());

        payLgImpl.resetOriginalValues();

        return payLgImpl;
    }

    @Override
    public int compareTo(PayLg payLg) {
        int value = 0;

        value = DateUtil.compareTo(getPaymentDate(), payLg.getPaymentDate());

        value = value * -1;

        if (value != 0) {
            return value;
        }

        return 0;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (!(obj instanceof PayLg)) {
            return false;
        }

        PayLg payLg = (PayLg) obj;

        long primaryKey = payLg.getPrimaryKey();

        if (getPrimaryKey() == primaryKey) {
            return true;
        } else {
            return false;
        }
    }

    @Override
    public int hashCode() {
        return (int) getPrimaryKey();
    }

    @Override
    public void resetOriginalValues() {
        PayLgModelImpl payLgModelImpl = this;

        payLgModelImpl._originalStiPtId = payLgModelImpl._stiPtId;

        payLgModelImpl._setOriginalStiPtId = false;

        payLgModelImpl._originalPaymentDate = payLgModelImpl._paymentDate;

        payLgModelImpl._columnBitmask = 0;
    }

    @Override
    public CacheModel<PayLg> toCacheModel() {
        PayLgCacheModel payLgCacheModel = new PayLgCacheModel();

        payLgCacheModel.paymentLogId = getPaymentLogId();

        payLgCacheModel.stiPtId = getStiPtId();

        payLgCacheModel.amount = getAmount();

        Date paymentDate = getPaymentDate();

        if (paymentDate != null) {
            payLgCacheModel.paymentDate = paymentDate.getTime();
        } else {
            payLgCacheModel.paymentDate = Long.MIN_VALUE;
        }

        payLgCacheModel.status = getStatus();

        String status = payLgCacheModel.status;

        if ((status != null) && (status.length() == 0)) {
            payLgCacheModel.status = null;
        }

        payLgCacheModel.reason = getReason();

        String reason = payLgCacheModel.reason;

        if ((reason != null) && (reason.length() == 0)) {
            payLgCacheModel.reason = null;
        }

        Date creationDate = getCreationDate();

        if (creationDate != null) {
            payLgCacheModel.creationDate = creationDate.getTime();
        } else {
            payLgCacheModel.creationDate = Long.MIN_VALUE;
        }

        payLgCacheModel.userId = getUserId();

        return payLgCacheModel;
    }

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(17);

        sb.append("{paymentLogId=");
        sb.append(getPaymentLogId());
        sb.append(", stiPtId=");
        sb.append(getStiPtId());
        sb.append(", amount=");
        sb.append(getAmount());
        sb.append(", paymentDate=");
        sb.append(getPaymentDate());
        sb.append(", status=");
        sb.append(getStatus());
        sb.append(", reason=");
        sb.append(getReason());
        sb.append(", creationDate=");
        sb.append(getCreationDate());
        sb.append(", userId=");
        sb.append(getUserId());
        sb.append("}");

        return sb.toString();
    }

    @Override
    public String toXmlString() {
        StringBundler sb = new StringBundler(28);

        sb.append("<model><model-name>");
        sb.append("gov.va.caret.model.PayLg");
        sb.append("</model-name>");

        sb.append(
            "<column><column-name>paymentLogId</column-name><column-value><![CDATA[");
        sb.append(getPaymentLogId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>stiPtId</column-name><column-value><![CDATA[");
        sb.append(getStiPtId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>amount</column-name><column-value><![CDATA[");
        sb.append(getAmount());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>paymentDate</column-name><column-value><![CDATA[");
        sb.append(getPaymentDate());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>status</column-name><column-value><![CDATA[");
        sb.append(getStatus());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>reason</column-name><column-value><![CDATA[");
        sb.append(getReason());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>creationDate</column-name><column-value><![CDATA[");
        sb.append(getCreationDate());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>userId</column-name><column-value><![CDATA[");
        sb.append(getUserId());
        sb.append("]]></column-value></column>");

        sb.append("</model>");

        return sb.toString();
    }
}
