package gov.va.caret.model.impl;

import com.liferay.portal.kernel.exception.SystemException;

import gov.va.caret.model.PayLg;
import gov.va.caret.service.PayLgLocalServiceUtil;

/**
 * The extended model base implementation for the PayLg service. Represents a row in the &quot;CARET_PAYMENT_LOG&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link PayLgImpl}.
 * </p>
 *
 * @author caret
 * @see PayLgImpl
 * @see gov.va.caret.model.PayLg
 * @generated
 */
public abstract class PayLgBaseImpl extends PayLgModelImpl implements PayLg {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. All methods that expect a pay lg model instance should use the {@link PayLg} interface instead.
     */
    @Override
    public void persist() throws SystemException {
        if (this.isNew()) {
            PayLgLocalServiceUtil.addPayLg(this);
        } else {
            PayLgLocalServiceUtil.updatePayLg(this);
        }
    }
}
