package gov.va.caret.model.impl;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.CacheModel;

import gov.va.caret.model.Notif;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

import java.util.Date;

/**
 * The cache model class for representing Notif in entity cache.
 *
 * @author caret
 * @see Notif
 * @generated
 */
public class NotifCacheModel implements CacheModel<Notif>, Externalizable {
    public long notifId;
    public long ownerId;
    public String type;
    public long discontinueDate;

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(9);

        sb.append("{notifId=");
        sb.append(notifId);
        sb.append(", ownerId=");
        sb.append(ownerId);
        sb.append(", type=");
        sb.append(type);
        sb.append(", discontinueDate=");
        sb.append(discontinueDate);
        sb.append("}");

        return sb.toString();
    }

    @Override
    public Notif toEntityModel() {
        NotifImpl notifImpl = new NotifImpl();

        notifImpl.setNotifId(notifId);
        notifImpl.setOwnerId(ownerId);

        if (type == null) {
            notifImpl.setType(StringPool.BLANK);
        } else {
            notifImpl.setType(type);
        }

        if (discontinueDate == Long.MIN_VALUE) {
            notifImpl.setDiscontinueDate(null);
        } else {
            notifImpl.setDiscontinueDate(new Date(discontinueDate));
        }

        notifImpl.resetOriginalValues();

        return notifImpl;
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        notifId = objectInput.readLong();
        ownerId = objectInput.readLong();
        type = objectInput.readUTF();
        discontinueDate = objectInput.readLong();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput)
        throws IOException {
        objectOutput.writeLong(notifId);
        objectOutput.writeLong(ownerId);

        if (type == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(type);
        }

        objectOutput.writeLong(discontinueDate);
    }
}
