package gov.va.caret.model.impl;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.model.impl.BaseModelImpl;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PortalUtil;

import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.expando.util.ExpandoBridgeFactoryUtil;

import gov.va.caret.model.Note;
import gov.va.caret.model.NoteModel;

import java.io.Serializable;

import java.sql.Types;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * The base model implementation for the Note service. Represents a row in the &quot;CARET_NOTE&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface {@link gov.va.caret.model.NoteModel} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link NoteImpl}.
 * </p>
 *
 * @author caret
 * @see NoteImpl
 * @see gov.va.caret.model.Note
 * @see gov.va.caret.model.NoteModel
 * @generated
 */
public class NoteModelImpl extends BaseModelImpl<Note> implements NoteModel {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. All methods that expect a note model instance should use the {@link gov.va.caret.model.Note} interface instead.
     */
    public static final String TABLE_NAME = "CARET_NOTE";
    public static final Object[][] TABLE_COLUMNS = {
            { "uuid_", Types.VARCHAR },
            { "noteId", Types.BIGINT },
            { "value", Types.VARCHAR },
            { "userId", Types.BIGINT },
            { "creationDate", Types.TIMESTAMP },
            { "groupId", Types.BIGINT },
            { "chainId", Types.BIGINT }
        };
    public static final String TABLE_SQL_CREATE = "create table CARET_NOTE (uuid_ VARCHAR(75) null,noteId LONG not null primary key,value VARCHAR(400) null,userId LONG,creationDate DATE null,groupId LONG,chainId LONG)";
    public static final String TABLE_SQL_DROP = "drop table CARET_NOTE";
    public static final String ORDER_BY_JPQL = " ORDER BY note.creationDate ASC";
    public static final String ORDER_BY_SQL = " ORDER BY CARET_NOTE.creationDate ASC";
    public static final String DATA_SOURCE = "liferayDataSource";
    public static final String SESSION_FACTORY = "liferaySessionFactory";
    public static final String TX_MANAGER = "liferayTransactionManager";
    public static final boolean ENTITY_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.entity.cache.enabled.gov.va.caret.model.Note"),
            true);
    public static final boolean FINDER_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.finder.cache.enabled.gov.va.caret.model.Note"),
            true);
    public static final boolean COLUMN_BITMASK_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.column.bitmask.enabled.gov.va.caret.model.Note"),
            true);
    public static long CHAINID_COLUMN_BITMASK = 1L;
    public static long GROUPID_COLUMN_BITMASK = 2L;
    public static long USERID_COLUMN_BITMASK = 4L;
    public static long UUID_COLUMN_BITMASK = 8L;
    public static long CREATIONDATE_COLUMN_BITMASK = 16L;
    public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(com.liferay.util.service.ServiceProps.get(
                "lock.expiration.time.gov.va.caret.model.Note"));
    private static ClassLoader _classLoader = Note.class.getClassLoader();
    private static Class<?>[] _escapedModelInterfaces = new Class[] { Note.class };
    private String _uuid;
    private String _originalUuid;
    private long _noteId;
    private String _value;
    private long _userId;
    private String _userUuid;
    private long _originalUserId;
    private boolean _setOriginalUserId;
    private Date _creationDate;
    private long _groupId;
    private long _originalGroupId;
    private boolean _setOriginalGroupId;
    private long _chainId;
    private long _originalChainId;
    private boolean _setOriginalChainId;
    private long _columnBitmask;
    private Note _escapedModel;

    public NoteModelImpl() {
    }

    @Override
    public long getPrimaryKey() {
        return _noteId;
    }

    @Override
    public void setPrimaryKey(long primaryKey) {
        setNoteId(primaryKey);
    }

    @Override
    public Serializable getPrimaryKeyObj() {
        return _noteId;
    }

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        setPrimaryKey(((Long) primaryKeyObj).longValue());
    }

    @Override
    public Class<?> getModelClass() {
        return Note.class;
    }

    @Override
    public String getModelClassName() {
        return Note.class.getName();
    }

    @Override
    public Map<String, Object> getModelAttributes() {
        Map<String, Object> attributes = new HashMap<String, Object>();

        attributes.put("uuid", getUuid());
        attributes.put("noteId", getNoteId());
        attributes.put("value", getValue());
        attributes.put("userId", getUserId());
        attributes.put("creationDate", getCreationDate());
        attributes.put("groupId", getGroupId());
        attributes.put("chainId", getChainId());

        return attributes;
    }

    @Override
    public void setModelAttributes(Map<String, Object> attributes) {
        String uuid = (String) attributes.get("uuid");

        if (uuid != null) {
            setUuid(uuid);
        }

        Long noteId = (Long) attributes.get("noteId");

        if (noteId != null) {
            setNoteId(noteId);
        }

        String value = (String) attributes.get("value");

        if (value != null) {
            setValue(value);
        }

        Long userId = (Long) attributes.get("userId");

        if (userId != null) {
            setUserId(userId);
        }

        Date creationDate = (Date) attributes.get("creationDate");

        if (creationDate != null) {
            setCreationDate(creationDate);
        }

        Long groupId = (Long) attributes.get("groupId");

        if (groupId != null) {
            setGroupId(groupId);
        }

        Long chainId = (Long) attributes.get("chainId");

        if (chainId != null) {
            setChainId(chainId);
        }
    }

    @Override
    public String getUuid() {
        if (_uuid == null) {
            return StringPool.BLANK;
        } else {
            return _uuid;
        }
    }

    @Override
    public void setUuid(String uuid) {
        if (_originalUuid == null) {
            _originalUuid = _uuid;
        }

        _uuid = uuid;
    }

    public String getOriginalUuid() {
        return GetterUtil.getString(_originalUuid);
    }

    @Override
    public long getNoteId() {
        return _noteId;
    }

    @Override
    public void setNoteId(long noteId) {
        _noteId = noteId;
    }

    @Override
    public String getValue() {
        if (_value == null) {
            return StringPool.BLANK;
        } else {
            return _value;
        }
    }

    @Override
    public void setValue(String value) {
        _value = value;
    }

    @Override
    public long getUserId() {
        return _userId;
    }

    @Override
    public void setUserId(long userId) {
        _columnBitmask |= USERID_COLUMN_BITMASK;

        if (!_setOriginalUserId) {
            _setOriginalUserId = true;

            _originalUserId = _userId;
        }

        _userId = userId;
    }

    @Override
    public String getUserUuid() throws SystemException {
        return PortalUtil.getUserValue(getUserId(), "uuid", _userUuid);
    }

    @Override
    public void setUserUuid(String userUuid) {
        _userUuid = userUuid;
    }

    public long getOriginalUserId() {
        return _originalUserId;
    }

    @Override
    public Date getCreationDate() {
        return _creationDate;
    }

    @Override
    public void setCreationDate(Date creationDate) {
        _columnBitmask = -1L;

        _creationDate = creationDate;
    }

    @Override
    public long getGroupId() {
        return _groupId;
    }

    @Override
    public void setGroupId(long groupId) {
        _columnBitmask |= GROUPID_COLUMN_BITMASK;

        if (!_setOriginalGroupId) {
            _setOriginalGroupId = true;

            _originalGroupId = _groupId;
        }

        _groupId = groupId;
    }

    public long getOriginalGroupId() {
        return _originalGroupId;
    }

    @Override
    public long getChainId() {
        return _chainId;
    }

    @Override
    public void setChainId(long chainId) {
        _columnBitmask |= CHAINID_COLUMN_BITMASK;

        if (!_setOriginalChainId) {
            _setOriginalChainId = true;

            _originalChainId = _chainId;
        }

        _chainId = chainId;
    }

    public long getOriginalChainId() {
        return _originalChainId;
    }

    public long getColumnBitmask() {
        return _columnBitmask;
    }

    @Override
    public ExpandoBridge getExpandoBridge() {
        return ExpandoBridgeFactoryUtil.getExpandoBridge(0,
            Note.class.getName(), getPrimaryKey());
    }

    @Override
    public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
        ExpandoBridge expandoBridge = getExpandoBridge();

        expandoBridge.setAttributes(serviceContext);
    }

    @Override
    public Note toEscapedModel() {
        if (_escapedModel == null) {
            _escapedModel = (Note) ProxyUtil.newProxyInstance(_classLoader,
                    _escapedModelInterfaces, new AutoEscapeBeanHandler(this));
        }

        return _escapedModel;
    }

    @Override
    public Object clone() {
        NoteImpl noteImpl = new NoteImpl();

        noteImpl.setUuid(getUuid());
        noteImpl.setNoteId(getNoteId());
        noteImpl.setValue(getValue());
        noteImpl.setUserId(getUserId());
        noteImpl.setCreationDate(getCreationDate());
        noteImpl.setGroupId(getGroupId());
        noteImpl.setChainId(getChainId());

        noteImpl.resetOriginalValues();

        return noteImpl;
    }

    @Override
    public int compareTo(Note note) {
        int value = 0;

        value = DateUtil.compareTo(getCreationDate(), note.getCreationDate());

        if (value != 0) {
            return value;
        }

        return 0;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (!(obj instanceof Note)) {
            return false;
        }

        Note note = (Note) obj;

        long primaryKey = note.getPrimaryKey();

        if (getPrimaryKey() == primaryKey) {
            return true;
        } else {
            return false;
        }
    }

    @Override
    public int hashCode() {
        return (int) getPrimaryKey();
    }

    @Override
    public void resetOriginalValues() {
        NoteModelImpl noteModelImpl = this;

        noteModelImpl._originalUuid = noteModelImpl._uuid;

        noteModelImpl._originalUserId = noteModelImpl._userId;

        noteModelImpl._setOriginalUserId = false;

        noteModelImpl._originalGroupId = noteModelImpl._groupId;

        noteModelImpl._setOriginalGroupId = false;

        noteModelImpl._originalChainId = noteModelImpl._chainId;

        noteModelImpl._setOriginalChainId = false;

        noteModelImpl._columnBitmask = 0;
    }

    @Override
    public CacheModel<Note> toCacheModel() {
        NoteCacheModel noteCacheModel = new NoteCacheModel();

        noteCacheModel.uuid = getUuid();

        String uuid = noteCacheModel.uuid;

        if ((uuid != null) && (uuid.length() == 0)) {
            noteCacheModel.uuid = null;
        }

        noteCacheModel.noteId = getNoteId();

        noteCacheModel.value = getValue();

        String value = noteCacheModel.value;

        if ((value != null) && (value.length() == 0)) {
            noteCacheModel.value = null;
        }

        noteCacheModel.userId = getUserId();

        Date creationDate = getCreationDate();

        if (creationDate != null) {
            noteCacheModel.creationDate = creationDate.getTime();
        } else {
            noteCacheModel.creationDate = Long.MIN_VALUE;
        }

        noteCacheModel.groupId = getGroupId();

        noteCacheModel.chainId = getChainId();

        return noteCacheModel;
    }

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(15);

        sb.append("{uuid=");
        sb.append(getUuid());
        sb.append(", noteId=");
        sb.append(getNoteId());
        sb.append(", value=");
        sb.append(getValue());
        sb.append(", userId=");
        sb.append(getUserId());
        sb.append(", creationDate=");
        sb.append(getCreationDate());
        sb.append(", groupId=");
        sb.append(getGroupId());
        sb.append(", chainId=");
        sb.append(getChainId());
        sb.append("}");

        return sb.toString();
    }

    @Override
    public String toXmlString() {
        StringBundler sb = new StringBundler(25);

        sb.append("<model><model-name>");
        sb.append("gov.va.caret.model.Note");
        sb.append("</model-name>");

        sb.append(
            "<column><column-name>uuid</column-name><column-value><![CDATA[");
        sb.append(getUuid());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>noteId</column-name><column-value><![CDATA[");
        sb.append(getNoteId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>value</column-name><column-value><![CDATA[");
        sb.append(getValue());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>userId</column-name><column-value><![CDATA[");
        sb.append(getUserId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>creationDate</column-name><column-value><![CDATA[");
        sb.append(getCreationDate());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>groupId</column-name><column-value><![CDATA[");
        sb.append(getGroupId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>chainId</column-name><column-value><![CDATA[");
        sb.append(getChainId());
        sb.append("]]></column-value></column>");

        sb.append("</model>");

        return sb.toString();
    }
}
