package gov.va.caret.model.impl;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.model.impl.BaseModelImpl;
import com.liferay.portal.service.ServiceContext;

import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.expando.util.ExpandoBridgeFactoryUtil;

import gov.va.caret.model.Facil;
import gov.va.caret.model.FacilModel;

import java.io.Serializable;

import java.sql.Types;

import java.util.HashMap;
import java.util.Map;

/**
 * The base model implementation for the Facil service. Represents a row in the &quot;CARET_FACILITY&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface {@link gov.va.caret.model.FacilModel} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link FacilImpl}.
 * </p>
 *
 * @author caret
 * @see FacilImpl
 * @see gov.va.caret.model.Facil
 * @see gov.va.caret.model.FacilModel
 * @generated
 */
public class FacilModelImpl extends BaseModelImpl<Facil> implements FacilModel {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. All methods that expect a facil model instance should use the {@link gov.va.caret.model.Facil} interface instead.
     */
    public static final String TABLE_NAME = "CARET_FACILITY";
    public static final Object[][] TABLE_COLUMNS = {
            { "facilId", Types.BIGINT },
            { "facilityNumber", Types.VARCHAR },
            { "location", Types.VARCHAR },
            { "groupId", Types.BIGINT }
        };
    public static final String TABLE_SQL_CREATE = "create table CARET_FACILITY (facilId LONG not null primary key,facilityNumber VARCHAR(75) null,location VARCHAR(75) null,groupId LONG)";
    public static final String TABLE_SQL_DROP = "drop table CARET_FACILITY";
    public static final String ORDER_BY_JPQL = " ORDER BY facil.facilId ASC";
    public static final String ORDER_BY_SQL = " ORDER BY CARET_FACILITY.facilId ASC";
    public static final String DATA_SOURCE = "liferayDataSource";
    public static final String SESSION_FACTORY = "liferaySessionFactory";
    public static final String TX_MANAGER = "liferayTransactionManager";
    public static final boolean ENTITY_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.entity.cache.enabled.gov.va.caret.model.Facil"),
            true);
    public static final boolean FINDER_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.finder.cache.enabled.gov.va.caret.model.Facil"),
            true);
    public static final boolean COLUMN_BITMASK_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.column.bitmask.enabled.gov.va.caret.model.Facil"),
            true);
    public static long FACILITYNUMBER_COLUMN_BITMASK = 1L;
    public static long GROUPID_COLUMN_BITMASK = 2L;
    public static long FACILID_COLUMN_BITMASK = 4L;
    public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(com.liferay.util.service.ServiceProps.get(
                "lock.expiration.time.gov.va.caret.model.Facil"));
    private static ClassLoader _classLoader = Facil.class.getClassLoader();
    private static Class<?>[] _escapedModelInterfaces = new Class[] { Facil.class };
    private long _facilId;
    private String _facilityNumber;
    private String _originalFacilityNumber;
    private String _location;
    private long _groupId;
    private long _originalGroupId;
    private boolean _setOriginalGroupId;
    private long _columnBitmask;
    private Facil _escapedModel;

    public FacilModelImpl() {
    }

    @Override
    public long getPrimaryKey() {
        return _facilId;
    }

    @Override
    public void setPrimaryKey(long primaryKey) {
        setFacilId(primaryKey);
    }

    @Override
    public Serializable getPrimaryKeyObj() {
        return _facilId;
    }

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        setPrimaryKey(((Long) primaryKeyObj).longValue());
    }

    @Override
    public Class<?> getModelClass() {
        return Facil.class;
    }

    @Override
    public String getModelClassName() {
        return Facil.class.getName();
    }

    @Override
    public Map<String, Object> getModelAttributes() {
        Map<String, Object> attributes = new HashMap<String, Object>();

        attributes.put("facilId", getFacilId());
        attributes.put("facilityNumber", getFacilityNumber());
        attributes.put("location", getLocation());
        attributes.put("groupId", getGroupId());

        return attributes;
    }

    @Override
    public void setModelAttributes(Map<String, Object> attributes) {
        Long facilId = (Long) attributes.get("facilId");

        if (facilId != null) {
            setFacilId(facilId);
        }

        String facilityNumber = (String) attributes.get("facilityNumber");

        if (facilityNumber != null) {
            setFacilityNumber(facilityNumber);
        }

        String location = (String) attributes.get("location");

        if (location != null) {
            setLocation(location);
        }

        Long groupId = (Long) attributes.get("groupId");

        if (groupId != null) {
            setGroupId(groupId);
        }
    }

    @Override
    public long getFacilId() {
        return _facilId;
    }

    @Override
    public void setFacilId(long facilId) {
        _facilId = facilId;
    }

    @Override
    public String getFacilityNumber() {
        if (_facilityNumber == null) {
            return StringPool.BLANK;
        } else {
            return _facilityNumber;
        }
    }

    @Override
    public void setFacilityNumber(String facilityNumber) {
        _columnBitmask |= FACILITYNUMBER_COLUMN_BITMASK;

        if (_originalFacilityNumber == null) {
            _originalFacilityNumber = _facilityNumber;
        }

        _facilityNumber = facilityNumber;
    }

    public String getOriginalFacilityNumber() {
        return GetterUtil.getString(_originalFacilityNumber);
    }

    @Override
    public String getLocation() {
        if (_location == null) {
            return StringPool.BLANK;
        } else {
            return _location;
        }
    }

    @Override
    public void setLocation(String location) {
        _location = location;
    }

    @Override
    public long getGroupId() {
        return _groupId;
    }

    @Override
    public void setGroupId(long groupId) {
        _columnBitmask |= GROUPID_COLUMN_BITMASK;

        if (!_setOriginalGroupId) {
            _setOriginalGroupId = true;

            _originalGroupId = _groupId;
        }

        _groupId = groupId;
    }

    public long getOriginalGroupId() {
        return _originalGroupId;
    }

    public long getColumnBitmask() {
        return _columnBitmask;
    }

    @Override
    public ExpandoBridge getExpandoBridge() {
        return ExpandoBridgeFactoryUtil.getExpandoBridge(0,
            Facil.class.getName(), getPrimaryKey());
    }

    @Override
    public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
        ExpandoBridge expandoBridge = getExpandoBridge();

        expandoBridge.setAttributes(serviceContext);
    }

    @Override
    public Facil toEscapedModel() {
        if (_escapedModel == null) {
            _escapedModel = (Facil) ProxyUtil.newProxyInstance(_classLoader,
                    _escapedModelInterfaces, new AutoEscapeBeanHandler(this));
        }

        return _escapedModel;
    }

    @Override
    public Object clone() {
        FacilImpl facilImpl = new FacilImpl();

        facilImpl.setFacilId(getFacilId());
        facilImpl.setFacilityNumber(getFacilityNumber());
        facilImpl.setLocation(getLocation());
        facilImpl.setGroupId(getGroupId());

        facilImpl.resetOriginalValues();

        return facilImpl;
    }

    @Override
    public int compareTo(Facil facil) {
        long primaryKey = facil.getPrimaryKey();

        if (getPrimaryKey() < primaryKey) {
            return -1;
        } else if (getPrimaryKey() > primaryKey) {
            return 1;
        } else {
            return 0;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (!(obj instanceof Facil)) {
            return false;
        }

        Facil facil = (Facil) obj;

        long primaryKey = facil.getPrimaryKey();

        if (getPrimaryKey() == primaryKey) {
            return true;
        } else {
            return false;
        }
    }

    @Override
    public int hashCode() {
        return (int) getPrimaryKey();
    }

    @Override
    public void resetOriginalValues() {
        FacilModelImpl facilModelImpl = this;

        facilModelImpl._originalFacilityNumber = facilModelImpl._facilityNumber;

        facilModelImpl._originalGroupId = facilModelImpl._groupId;

        facilModelImpl._setOriginalGroupId = false;

        facilModelImpl._columnBitmask = 0;
    }

    @Override
    public CacheModel<Facil> toCacheModel() {
        FacilCacheModel facilCacheModel = new FacilCacheModel();

        facilCacheModel.facilId = getFacilId();

        facilCacheModel.facilityNumber = getFacilityNumber();

        String facilityNumber = facilCacheModel.facilityNumber;

        if ((facilityNumber != null) && (facilityNumber.length() == 0)) {
            facilCacheModel.facilityNumber = null;
        }

        facilCacheModel.location = getLocation();

        String location = facilCacheModel.location;

        if ((location != null) && (location.length() == 0)) {
            facilCacheModel.location = null;
        }

        facilCacheModel.groupId = getGroupId();

        return facilCacheModel;
    }

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(9);

        sb.append("{facilId=");
        sb.append(getFacilId());
        sb.append(", facilityNumber=");
        sb.append(getFacilityNumber());
        sb.append(", location=");
        sb.append(getLocation());
        sb.append(", groupId=");
        sb.append(getGroupId());
        sb.append("}");

        return sb.toString();
    }

    @Override
    public String toXmlString() {
        StringBundler sb = new StringBundler(16);

        sb.append("<model><model-name>");
        sb.append("gov.va.caret.model.Facil");
        sb.append("</model-name>");

        sb.append(
            "<column><column-name>facilId</column-name><column-value><![CDATA[");
        sb.append(getFacilId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>facilityNumber</column-name><column-value><![CDATA[");
        sb.append(getFacilityNumber());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>location</column-name><column-value><![CDATA[");
        sb.append(getLocation());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>groupId</column-name><column-value><![CDATA[");
        sb.append(getGroupId());
        sb.append("]]></column-value></column>");

        sb.append("</model>");

        return sb.toString();
    }
}
