package gov.va.caret.model.impl;

import com.liferay.portal.kernel.exception.SystemException;

import gov.va.caret.model.ClSoc;
import gov.va.caret.service.ClSocLocalServiceUtil;

/**
 * The extended model base implementation for the ClSoc service. Represents a row in the &quot;CARET_SOC&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link ClSocImpl}.
 * </p>
 *
 * @author caret
 * @see ClSocImpl
 * @see gov.va.caret.model.ClSoc
 * @generated
 */
public abstract class ClSocBaseImpl extends ClSocModelImpl implements ClSoc {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. All methods that expect a cl soc model instance should use the {@link ClSoc} interface instead.
     */
    @Override
    public void persist() throws SystemException {
        if (this.isNew()) {
            ClSocLocalServiceUtil.addClSoc(this);
        } else {
            ClSocLocalServiceUtil.updateClSoc(this);
        }
    }
}
