package gov.va.caret.model.impl;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.model.impl.BaseModelImpl;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PortalUtil;

import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.expando.util.ExpandoBridgeFactoryUtil;

import gov.va.caret.model.CalEt;
import gov.va.caret.model.CalEtModel;

import java.io.Serializable;

import java.sql.Types;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * The base model implementation for the CalEt service. Represents a row in the &quot;CARET_CALL_EVENT&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface {@link gov.va.caret.model.CalEtModel} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CalEtImpl}.
 * </p>
 *
 * @author caret
 * @see CalEtImpl
 * @see gov.va.caret.model.CalEt
 * @see gov.va.caret.model.CalEtModel
 * @generated
 */
public class CalEtModelImpl extends BaseModelImpl<CalEt> implements CalEtModel {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. All methods that expect a cal et model instance should use the {@link gov.va.caret.model.CalEt} interface instead.
     */
    public static final String TABLE_NAME = "CARET_CALL_EVENT";
    public static final Object[][] TABLE_COLUMNS = {
            { "calEtId", Types.BIGINT },
            { "callId", Types.BIGINT },
            { "event", Types.VARCHAR },
            { "comment_", Types.VARCHAR },
            { "creationDate", Types.TIMESTAMP },
            { "userId", Types.BIGINT }
        };
    public static final String TABLE_SQL_CREATE = "create table CARET_CALL_EVENT (calEtId LONG not null primary key,callId LONG,event VARCHAR(75) null,comment_ VARCHAR(75) null,creationDate DATE null,userId LONG)";
    public static final String TABLE_SQL_DROP = "drop table CARET_CALL_EVENT";
    public static final String ORDER_BY_JPQL = " ORDER BY calEt.calEtId ASC";
    public static final String ORDER_BY_SQL = " ORDER BY CARET_CALL_EVENT.calEtId ASC";
    public static final String DATA_SOURCE = "liferayDataSource";
    public static final String SESSION_FACTORY = "liferaySessionFactory";
    public static final String TX_MANAGER = "liferayTransactionManager";
    public static final boolean ENTITY_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.entity.cache.enabled.gov.va.caret.model.CalEt"),
            true);
    public static final boolean FINDER_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.finder.cache.enabled.gov.va.caret.model.CalEt"),
            true);
    public static final boolean COLUMN_BITMASK_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.column.bitmask.enabled.gov.va.caret.model.CalEt"),
            true);
    public static long CALLID_COLUMN_BITMASK = 1L;
    public static long CALETID_COLUMN_BITMASK = 2L;
    public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(com.liferay.util.service.ServiceProps.get(
                "lock.expiration.time.gov.va.caret.model.CalEt"));
    private static ClassLoader _classLoader = CalEt.class.getClassLoader();
    private static Class<?>[] _escapedModelInterfaces = new Class[] { CalEt.class };
    private long _calEtId;
    private long _callId;
    private long _originalCallId;
    private boolean _setOriginalCallId;
    private String _event;
    private String _comment;
    private Date _creationDate;
    private long _userId;
    private String _userUuid;
    private long _columnBitmask;
    private CalEt _escapedModel;

    public CalEtModelImpl() {
    }

    @Override
    public long getPrimaryKey() {
        return _calEtId;
    }

    @Override
    public void setPrimaryKey(long primaryKey) {
        setCalEtId(primaryKey);
    }

    @Override
    public Serializable getPrimaryKeyObj() {
        return _calEtId;
    }

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        setPrimaryKey(((Long) primaryKeyObj).longValue());
    }

    @Override
    public Class<?> getModelClass() {
        return CalEt.class;
    }

    @Override
    public String getModelClassName() {
        return CalEt.class.getName();
    }

    @Override
    public Map<String, Object> getModelAttributes() {
        Map<String, Object> attributes = new HashMap<String, Object>();

        attributes.put("calEtId", getCalEtId());
        attributes.put("callId", getCallId());
        attributes.put("event", getEvent());
        attributes.put("comment", getComment());
        attributes.put("creationDate", getCreationDate());
        attributes.put("userId", getUserId());

        return attributes;
    }

    @Override
    public void setModelAttributes(Map<String, Object> attributes) {
        Long calEtId = (Long) attributes.get("calEtId");

        if (calEtId != null) {
            setCalEtId(calEtId);
        }

        Long callId = (Long) attributes.get("callId");

        if (callId != null) {
            setCallId(callId);
        }

        String event = (String) attributes.get("event");

        if (event != null) {
            setEvent(event);
        }

        String comment = (String) attributes.get("comment");

        if (comment != null) {
            setComment(comment);
        }

        Date creationDate = (Date) attributes.get("creationDate");

        if (creationDate != null) {
            setCreationDate(creationDate);
        }

        Long userId = (Long) attributes.get("userId");

        if (userId != null) {
            setUserId(userId);
        }
    }

    @Override
    public long getCalEtId() {
        return _calEtId;
    }

    @Override
    public void setCalEtId(long calEtId) {
        _calEtId = calEtId;
    }

    @Override
    public long getCallId() {
        return _callId;
    }

    @Override
    public void setCallId(long callId) {
        _columnBitmask |= CALLID_COLUMN_BITMASK;

        if (!_setOriginalCallId) {
            _setOriginalCallId = true;

            _originalCallId = _callId;
        }

        _callId = callId;
    }

    public long getOriginalCallId() {
        return _originalCallId;
    }

    @Override
    public String getEvent() {
        if (_event == null) {
            return StringPool.BLANK;
        } else {
            return _event;
        }
    }

    @Override
    public void setEvent(String event) {
        _event = event;
    }

    @Override
    public String getComment() {
        if (_comment == null) {
            return StringPool.BLANK;
        } else {
            return _comment;
        }
    }

    @Override
    public void setComment(String comment) {
        _comment = comment;
    }

    @Override
    public Date getCreationDate() {
        return _creationDate;
    }

    @Override
    public void setCreationDate(Date creationDate) {
        _creationDate = creationDate;
    }

    @Override
    public long getUserId() {
        return _userId;
    }

    @Override
    public void setUserId(long userId) {
        _userId = userId;
    }

    @Override
    public String getUserUuid() throws SystemException {
        return PortalUtil.getUserValue(getUserId(), "uuid", _userUuid);
    }

    @Override
    public void setUserUuid(String userUuid) {
        _userUuid = userUuid;
    }

    public long getColumnBitmask() {
        return _columnBitmask;
    }

    @Override
    public ExpandoBridge getExpandoBridge() {
        return ExpandoBridgeFactoryUtil.getExpandoBridge(0,
            CalEt.class.getName(), getPrimaryKey());
    }

    @Override
    public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
        ExpandoBridge expandoBridge = getExpandoBridge();

        expandoBridge.setAttributes(serviceContext);
    }

    @Override
    public CalEt toEscapedModel() {
        if (_escapedModel == null) {
            _escapedModel = (CalEt) ProxyUtil.newProxyInstance(_classLoader,
                    _escapedModelInterfaces, new AutoEscapeBeanHandler(this));
        }

        return _escapedModel;
    }

    @Override
    public Object clone() {
        CalEtImpl calEtImpl = new CalEtImpl();

        calEtImpl.setCalEtId(getCalEtId());
        calEtImpl.setCallId(getCallId());
        calEtImpl.setEvent(getEvent());
        calEtImpl.setComment(getComment());
        calEtImpl.setCreationDate(getCreationDate());
        calEtImpl.setUserId(getUserId());

        calEtImpl.resetOriginalValues();

        return calEtImpl;
    }

    @Override
    public int compareTo(CalEt calEt) {
        long primaryKey = calEt.getPrimaryKey();

        if (getPrimaryKey() < primaryKey) {
            return -1;
        } else if (getPrimaryKey() > primaryKey) {
            return 1;
        } else {
            return 0;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (!(obj instanceof CalEt)) {
            return false;
        }

        CalEt calEt = (CalEt) obj;

        long primaryKey = calEt.getPrimaryKey();

        if (getPrimaryKey() == primaryKey) {
            return true;
        } else {
            return false;
        }
    }

    @Override
    public int hashCode() {
        return (int) getPrimaryKey();
    }

    @Override
    public void resetOriginalValues() {
        CalEtModelImpl calEtModelImpl = this;

        calEtModelImpl._originalCallId = calEtModelImpl._callId;

        calEtModelImpl._setOriginalCallId = false;

        calEtModelImpl._columnBitmask = 0;
    }

    @Override
    public CacheModel<CalEt> toCacheModel() {
        CalEtCacheModel calEtCacheModel = new CalEtCacheModel();

        calEtCacheModel.calEtId = getCalEtId();

        calEtCacheModel.callId = getCallId();

        calEtCacheModel.event = getEvent();

        String event = calEtCacheModel.event;

        if ((event != null) && (event.length() == 0)) {
            calEtCacheModel.event = null;
        }

        calEtCacheModel.comment = getComment();

        String comment = calEtCacheModel.comment;

        if ((comment != null) && (comment.length() == 0)) {
            calEtCacheModel.comment = null;
        }

        Date creationDate = getCreationDate();

        if (creationDate != null) {
            calEtCacheModel.creationDate = creationDate.getTime();
        } else {
            calEtCacheModel.creationDate = Long.MIN_VALUE;
        }

        calEtCacheModel.userId = getUserId();

        return calEtCacheModel;
    }

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(13);

        sb.append("{calEtId=");
        sb.append(getCalEtId());
        sb.append(", callId=");
        sb.append(getCallId());
        sb.append(", event=");
        sb.append(getEvent());
        sb.append(", comment=");
        sb.append(getComment());
        sb.append(", creationDate=");
        sb.append(getCreationDate());
        sb.append(", userId=");
        sb.append(getUserId());
        sb.append("}");

        return sb.toString();
    }

    @Override
    public String toXmlString() {
        StringBundler sb = new StringBundler(22);

        sb.append("<model><model-name>");
        sb.append("gov.va.caret.model.CalEt");
        sb.append("</model-name>");

        sb.append(
            "<column><column-name>calEtId</column-name><column-value><![CDATA[");
        sb.append(getCalEtId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>callId</column-name><column-value><![CDATA[");
        sb.append(getCallId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>event</column-name><column-value><![CDATA[");
        sb.append(getEvent());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>comment</column-name><column-value><![CDATA[");
        sb.append(getComment());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>creationDate</column-name><column-value><![CDATA[");
        sb.append(getCreationDate());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>userId</column-name><column-value><![CDATA[");
        sb.append(getUserId());
        sb.append("]]></column-value></column>");

        sb.append("</model>");

        return sb.toString();
    }
}
