package gov.va.caret.model.impl;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.model.impl.BaseModelImpl;
import com.liferay.portal.service.ServiceContext;

import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.expando.util.ExpandoBridgeFactoryUtil;

import gov.va.caret.model.BoxGp;
import gov.va.caret.model.BoxGpModel;

import java.io.Serializable;

import java.sql.Types;

import java.util.HashMap;
import java.util.Map;

/**
 * The base model implementation for the BoxGp service. Represents a row in the &quot;CARET_BOXED_GROUP&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface {@link gov.va.caret.model.BoxGpModel} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link BoxGpImpl}.
 * </p>
 *
 * @author caret
 * @see BoxGpImpl
 * @see gov.va.caret.model.BoxGp
 * @see gov.va.caret.model.BoxGpModel
 * @generated
 */
public class BoxGpModelImpl extends BaseModelImpl<BoxGp> implements BoxGpModel {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. All methods that expect a box gp model instance should use the {@link gov.va.caret.model.BoxGp} interface instead.
     */
    public static final String TABLE_NAME = "CARET_BOXED_GROUP";
    public static final Object[][] TABLE_COLUMNS = {
            { "boxGpId", Types.BIGINT },
            { "boxGroup", Types.VARCHAR },
            { "boxSubGroup", Types.VARCHAR },
            { "label", Types.VARCHAR },
            { "viewSequence", Types.INTEGER }
        };
    public static final String TABLE_SQL_CREATE = "create table CARET_BOXED_GROUP (boxGpId LONG not null primary key,boxGroup VARCHAR(75) null,boxSubGroup VARCHAR(75) null,label VARCHAR(255) null,viewSequence INTEGER)";
    public static final String TABLE_SQL_DROP = "drop table CARET_BOXED_GROUP";
    public static final String ORDER_BY_JPQL = " ORDER BY boxGp.viewSequence ASC";
    public static final String ORDER_BY_SQL = " ORDER BY CARET_BOXED_GROUP.viewSequence ASC";
    public static final String DATA_SOURCE = "liferayDataSource";
    public static final String SESSION_FACTORY = "liferaySessionFactory";
    public static final String TX_MANAGER = "liferayTransactionManager";
    public static final boolean ENTITY_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.entity.cache.enabled.gov.va.caret.model.BoxGp"),
            true);
    public static final boolean FINDER_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.finder.cache.enabled.gov.va.caret.model.BoxGp"),
            true);
    public static final boolean COLUMN_BITMASK_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.column.bitmask.enabled.gov.va.caret.model.BoxGp"),
            true);
    public static long BOXGROUP_COLUMN_BITMASK = 1L;
    public static long BOXSUBGROUP_COLUMN_BITMASK = 2L;
    public static long VIEWSEQUENCE_COLUMN_BITMASK = 4L;
    public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(com.liferay.util.service.ServiceProps.get(
                "lock.expiration.time.gov.va.caret.model.BoxGp"));
    private static ClassLoader _classLoader = BoxGp.class.getClassLoader();
    private static Class<?>[] _escapedModelInterfaces = new Class[] { BoxGp.class };
    private long _boxGpId;
    private String _boxGroup;
    private String _originalBoxGroup;
    private String _boxSubGroup;
    private String _originalBoxSubGroup;
    private String _label;
    private int _viewSequence;
    private long _columnBitmask;
    private BoxGp _escapedModel;

    public BoxGpModelImpl() {
    }

    @Override
    public long getPrimaryKey() {
        return _boxGpId;
    }

    @Override
    public void setPrimaryKey(long primaryKey) {
        setBoxGpId(primaryKey);
    }

    @Override
    public Serializable getPrimaryKeyObj() {
        return _boxGpId;
    }

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        setPrimaryKey(((Long) primaryKeyObj).longValue());
    }

    @Override
    public Class<?> getModelClass() {
        return BoxGp.class;
    }

    @Override
    public String getModelClassName() {
        return BoxGp.class.getName();
    }

    @Override
    public Map<String, Object> getModelAttributes() {
        Map<String, Object> attributes = new HashMap<String, Object>();

        attributes.put("boxGpId", getBoxGpId());
        attributes.put("boxGroup", getBoxGroup());
        attributes.put("boxSubGroup", getBoxSubGroup());
        attributes.put("label", getLabel());
        attributes.put("viewSequence", getViewSequence());

        return attributes;
    }

    @Override
    public void setModelAttributes(Map<String, Object> attributes) {
        Long boxGpId = (Long) attributes.get("boxGpId");

        if (boxGpId != null) {
            setBoxGpId(boxGpId);
        }

        String boxGroup = (String) attributes.get("boxGroup");

        if (boxGroup != null) {
            setBoxGroup(boxGroup);
        }

        String boxSubGroup = (String) attributes.get("boxSubGroup");

        if (boxSubGroup != null) {
            setBoxSubGroup(boxSubGroup);
        }

        String label = (String) attributes.get("label");

        if (label != null) {
            setLabel(label);
        }

        Integer viewSequence = (Integer) attributes.get("viewSequence");

        if (viewSequence != null) {
            setViewSequence(viewSequence);
        }
    }

    @Override
    public long getBoxGpId() {
        return _boxGpId;
    }

    @Override
    public void setBoxGpId(long boxGpId) {
        _boxGpId = boxGpId;
    }

    @Override
    public String getBoxGroup() {
        if (_boxGroup == null) {
            return StringPool.BLANK;
        } else {
            return _boxGroup;
        }
    }

    @Override
    public void setBoxGroup(String boxGroup) {
        _columnBitmask |= BOXGROUP_COLUMN_BITMASK;

        if (_originalBoxGroup == null) {
            _originalBoxGroup = _boxGroup;
        }

        _boxGroup = boxGroup;
    }

    public String getOriginalBoxGroup() {
        return GetterUtil.getString(_originalBoxGroup);
    }

    @Override
    public String getBoxSubGroup() {
        if (_boxSubGroup == null) {
            return StringPool.BLANK;
        } else {
            return _boxSubGroup;
        }
    }

    @Override
    public void setBoxSubGroup(String boxSubGroup) {
        _columnBitmask |= BOXSUBGROUP_COLUMN_BITMASK;

        if (_originalBoxSubGroup == null) {
            _originalBoxSubGroup = _boxSubGroup;
        }

        _boxSubGroup = boxSubGroup;
    }

    public String getOriginalBoxSubGroup() {
        return GetterUtil.getString(_originalBoxSubGroup);
    }

    @Override
    public String getLabel() {
        if (_label == null) {
            return StringPool.BLANK;
        } else {
            return _label;
        }
    }

    @Override
    public void setLabel(String label) {
        _label = label;
    }

    @Override
    public int getViewSequence() {
        return _viewSequence;
    }

    @Override
    public void setViewSequence(int viewSequence) {
        _columnBitmask = -1L;

        _viewSequence = viewSequence;
    }

    public long getColumnBitmask() {
        return _columnBitmask;
    }

    @Override
    public ExpandoBridge getExpandoBridge() {
        return ExpandoBridgeFactoryUtil.getExpandoBridge(0,
            BoxGp.class.getName(), getPrimaryKey());
    }

    @Override
    public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
        ExpandoBridge expandoBridge = getExpandoBridge();

        expandoBridge.setAttributes(serviceContext);
    }

    @Override
    public BoxGp toEscapedModel() {
        if (_escapedModel == null) {
            _escapedModel = (BoxGp) ProxyUtil.newProxyInstance(_classLoader,
                    _escapedModelInterfaces, new AutoEscapeBeanHandler(this));
        }

        return _escapedModel;
    }

    @Override
    public Object clone() {
        BoxGpImpl boxGpImpl = new BoxGpImpl();

        boxGpImpl.setBoxGpId(getBoxGpId());
        boxGpImpl.setBoxGroup(getBoxGroup());
        boxGpImpl.setBoxSubGroup(getBoxSubGroup());
        boxGpImpl.setLabel(getLabel());
        boxGpImpl.setViewSequence(getViewSequence());

        boxGpImpl.resetOriginalValues();

        return boxGpImpl;
    }

    @Override
    public int compareTo(BoxGp boxGp) {
        int value = 0;

        if (getViewSequence() < boxGp.getViewSequence()) {
            value = -1;
        } else if (getViewSequence() > boxGp.getViewSequence()) {
            value = 1;
        } else {
            value = 0;
        }

        if (value != 0) {
            return value;
        }

        return 0;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (!(obj instanceof BoxGp)) {
            return false;
        }

        BoxGp boxGp = (BoxGp) obj;

        long primaryKey = boxGp.getPrimaryKey();

        if (getPrimaryKey() == primaryKey) {
            return true;
        } else {
            return false;
        }
    }

    @Override
    public int hashCode() {
        return (int) getPrimaryKey();
    }

    @Override
    public void resetOriginalValues() {
        BoxGpModelImpl boxGpModelImpl = this;

        boxGpModelImpl._originalBoxGroup = boxGpModelImpl._boxGroup;

        boxGpModelImpl._originalBoxSubGroup = boxGpModelImpl._boxSubGroup;

        boxGpModelImpl._columnBitmask = 0;
    }

    @Override
    public CacheModel<BoxGp> toCacheModel() {
        BoxGpCacheModel boxGpCacheModel = new BoxGpCacheModel();

        boxGpCacheModel.boxGpId = getBoxGpId();

        boxGpCacheModel.boxGroup = getBoxGroup();

        String boxGroup = boxGpCacheModel.boxGroup;

        if ((boxGroup != null) && (boxGroup.length() == 0)) {
            boxGpCacheModel.boxGroup = null;
        }

        boxGpCacheModel.boxSubGroup = getBoxSubGroup();

        String boxSubGroup = boxGpCacheModel.boxSubGroup;

        if ((boxSubGroup != null) && (boxSubGroup.length() == 0)) {
            boxGpCacheModel.boxSubGroup = null;
        }

        boxGpCacheModel.label = getLabel();

        String label = boxGpCacheModel.label;

        if ((label != null) && (label.length() == 0)) {
            boxGpCacheModel.label = null;
        }

        boxGpCacheModel.viewSequence = getViewSequence();

        return boxGpCacheModel;
    }

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(11);

        sb.append("{boxGpId=");
        sb.append(getBoxGpId());
        sb.append(", boxGroup=");
        sb.append(getBoxGroup());
        sb.append(", boxSubGroup=");
        sb.append(getBoxSubGroup());
        sb.append(", label=");
        sb.append(getLabel());
        sb.append(", viewSequence=");
        sb.append(getViewSequence());
        sb.append("}");

        return sb.toString();
    }

    @Override
    public String toXmlString() {
        StringBundler sb = new StringBundler(19);

        sb.append("<model><model-name>");
        sb.append("gov.va.caret.model.BoxGp");
        sb.append("</model-name>");

        sb.append(
            "<column><column-name>boxGpId</column-name><column-value><![CDATA[");
        sb.append(getBoxGpId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>boxGroup</column-name><column-value><![CDATA[");
        sb.append(getBoxGroup());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>boxSubGroup</column-name><column-value><![CDATA[");
        sb.append(getBoxSubGroup());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>label</column-name><column-value><![CDATA[");
        sb.append(getLabel());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>viewSequence</column-name><column-value><![CDATA[");
        sb.append(getViewSequence());
        sb.append("]]></column-value></column>");

        sb.append("</model>");

        return sb.toString();
    }
}
