package gov.va.caret.model.impl;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.model.impl.BaseModelImpl;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PortalUtil;

import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.expando.util.ExpandoBridgeFactoryUtil;

import gov.va.caret.model.AudLg;
import gov.va.caret.model.AudLgModel;

import java.io.Serializable;

import java.sql.Types;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * The base model implementation for the AudLg service. Represents a row in the &quot;CARET_AUDIT_LOG&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface {@link gov.va.caret.model.AudLgModel} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link AudLgImpl}.
 * </p>
 *
 * @author caret
 * @see AudLgImpl
 * @see gov.va.caret.model.AudLg
 * @see gov.va.caret.model.AudLgModel
 * @generated
 */
public class AudLgModelImpl extends BaseModelImpl<AudLg> implements AudLgModel {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. All methods that expect a aud lg model instance should use the {@link gov.va.caret.model.AudLg} interface instead.
     */
    public static final String TABLE_NAME = "CARET_AUDIT_LOG";
    public static final Object[][] TABLE_COLUMNS = {
            { "audLgId", Types.BIGINT },
            { "classPk", Types.BIGINT },
            { "classId", Types.BIGINT },
            { "attribute", Types.VARCHAR },
            { "oldValue", Types.VARCHAR },
            { "newValue", Types.VARCHAR },
            { "coverUserId", Types.BIGINT },
            { "modifiedById", Types.BIGINT },
            { "modifiedDate", Types.TIMESTAMP },
            { "groupId", Types.BIGINT },
            { "roleName", Types.VARCHAR },
            { "SYS_DATETIME", Types.BIGINT }
        };
    public static final String TABLE_SQL_CREATE = "create table CARET_AUDIT_LOG (audLgId LONG not null primary key,classPk LONG,classId LONG,attribute VARCHAR(75) null,oldValue VARCHAR(75) null,newValue VARCHAR(75) null,coverUserId LONG,modifiedById LONG,modifiedDate DATE null,groupId LONG,roleName VARCHAR(75) null,SYS_DATETIME LONG)";
    public static final String TABLE_SQL_DROP = "drop table CARET_AUDIT_LOG";
    public static final String ORDER_BY_JPQL = " ORDER BY audLg.modifiedDate ASC";
    public static final String ORDER_BY_SQL = " ORDER BY CARET_AUDIT_LOG.modifiedDate ASC";
    public static final String DATA_SOURCE = "liferayDataSource";
    public static final String SESSION_FACTORY = "liferaySessionFactory";
    public static final String TX_MANAGER = "liferayTransactionManager";
    public static final boolean ENTITY_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.entity.cache.enabled.gov.va.caret.model.AudLg"),
            true);
    public static final boolean FINDER_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.finder.cache.enabled.gov.va.caret.model.AudLg"),
            true);
    public static final boolean COLUMN_BITMASK_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.column.bitmask.enabled.gov.va.caret.model.AudLg"),
            true);
    public static long ATTRIBUTE_COLUMN_BITMASK = 1L;
    public static long CLASSID_COLUMN_BITMASK = 2L;
    public static long CLASSPK_COLUMN_BITMASK = 4L;
    public static long MODIFIEDDATE_COLUMN_BITMASK = 8L;
    public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(com.liferay.util.service.ServiceProps.get(
                "lock.expiration.time.gov.va.caret.model.AudLg"));
    private static ClassLoader _classLoader = AudLg.class.getClassLoader();
    private static Class<?>[] _escapedModelInterfaces = new Class[] { AudLg.class };
    private long _audLgId;
    private long _classPk;
    private long _originalClassPk;
    private boolean _setOriginalClassPk;
    private long _classId;
    private long _originalClassId;
    private boolean _setOriginalClassId;
    private String _attribute;
    private String _originalAttribute;
    private String _oldValue;
    private String _newValue;
    private long _coverUserId;
    private String _coverUserUuid;
    private long _modifiedById;
    private Date _modifiedDate;
    private long _groupId;
    private String _roleName;
    private long _sysDateTime;
    private long _columnBitmask;
    private AudLg _escapedModel;

    public AudLgModelImpl() {
    }

    @Override
    public long getPrimaryKey() {
        return _audLgId;
    }

    @Override
    public void setPrimaryKey(long primaryKey) {
        setAudLgId(primaryKey);
    }

    @Override
    public Serializable getPrimaryKeyObj() {
        return _audLgId;
    }

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        setPrimaryKey(((Long) primaryKeyObj).longValue());
    }

    @Override
    public Class<?> getModelClass() {
        return AudLg.class;
    }

    @Override
    public String getModelClassName() {
        return AudLg.class.getName();
    }

    @Override
    public Map<String, Object> getModelAttributes() {
        Map<String, Object> attributes = new HashMap<String, Object>();

        attributes.put("audLgId", getAudLgId());
        attributes.put("classPk", getClassPk());
        attributes.put("classId", getClassId());
        attributes.put("attribute", getAttribute());
        attributes.put("oldValue", getOldValue());
        attributes.put("newValue", getNewValue());
        attributes.put("coverUserId", getCoverUserId());
        attributes.put("modifiedById", getModifiedById());
        attributes.put("modifiedDate", getModifiedDate());
        attributes.put("groupId", getGroupId());
        attributes.put("roleName", getRoleName());
        attributes.put("sysDateTime", getSysDateTime());

        return attributes;
    }

    @Override
    public void setModelAttributes(Map<String, Object> attributes) {
        Long audLgId = (Long) attributes.get("audLgId");

        if (audLgId != null) {
            setAudLgId(audLgId);
        }

        Long classPk = (Long) attributes.get("classPk");

        if (classPk != null) {
            setClassPk(classPk);
        }

        Long classId = (Long) attributes.get("classId");

        if (classId != null) {
            setClassId(classId);
        }

        String attribute = (String) attributes.get("attribute");

        if (attribute != null) {
            setAttribute(attribute);
        }

        String oldValue = (String) attributes.get("oldValue");

        if (oldValue != null) {
            setOldValue(oldValue);
        }

        String newValue = (String) attributes.get("newValue");

        if (newValue != null) {
            setNewValue(newValue);
        }

        Long coverUserId = (Long) attributes.get("coverUserId");

        if (coverUserId != null) {
            setCoverUserId(coverUserId);
        }

        Long modifiedById = (Long) attributes.get("modifiedById");

        if (modifiedById != null) {
            setModifiedById(modifiedById);
        }

        Date modifiedDate = (Date) attributes.get("modifiedDate");

        if (modifiedDate != null) {
            setModifiedDate(modifiedDate);
        }

        Long groupId = (Long) attributes.get("groupId");

        if (groupId != null) {
            setGroupId(groupId);
        }

        String roleName = (String) attributes.get("roleName");

        if (roleName != null) {
            setRoleName(roleName);
        }

        Long sysDateTime = (Long) attributes.get("sysDateTime");

        if (sysDateTime != null) {
            setSysDateTime(sysDateTime);
        }
    }

    @Override
    public long getAudLgId() {
        return _audLgId;
    }

    @Override
    public void setAudLgId(long audLgId) {
        _audLgId = audLgId;
    }

    @Override
    public long getClassPk() {
        return _classPk;
    }

    @Override
    public void setClassPk(long classPk) {
        _columnBitmask |= CLASSPK_COLUMN_BITMASK;

        if (!_setOriginalClassPk) {
            _setOriginalClassPk = true;

            _originalClassPk = _classPk;
        }

        _classPk = classPk;
    }

    public long getOriginalClassPk() {
        return _originalClassPk;
    }

    @Override
    public long getClassId() {
        return _classId;
    }

    @Override
    public void setClassId(long classId) {
        _columnBitmask |= CLASSID_COLUMN_BITMASK;

        if (!_setOriginalClassId) {
            _setOriginalClassId = true;

            _originalClassId = _classId;
        }

        _classId = classId;
    }

    public long getOriginalClassId() {
        return _originalClassId;
    }

    @Override
    public String getAttribute() {
        if (_attribute == null) {
            return StringPool.BLANK;
        } else {
            return _attribute;
        }
    }

    @Override
    public void setAttribute(String attribute) {
        _columnBitmask |= ATTRIBUTE_COLUMN_BITMASK;

        if (_originalAttribute == null) {
            _originalAttribute = _attribute;
        }

        _attribute = attribute;
    }

    public String getOriginalAttribute() {
        return GetterUtil.getString(_originalAttribute);
    }

    @Override
    public String getOldValue() {
        if (_oldValue == null) {
            return StringPool.BLANK;
        } else {
            return _oldValue;
        }
    }

    @Override
    public void setOldValue(String oldValue) {
        _oldValue = oldValue;
    }

    @Override
    public String getNewValue() {
        if (_newValue == null) {
            return StringPool.BLANK;
        } else {
            return _newValue;
        }
    }

    @Override
    public void setNewValue(String newValue) {
        _newValue = newValue;
    }

    @Override
    public long getCoverUserId() {
        return _coverUserId;
    }

    @Override
    public void setCoverUserId(long coverUserId) {
        _coverUserId = coverUserId;
    }

    @Override
    public String getCoverUserUuid() throws SystemException {
        return PortalUtil.getUserValue(getCoverUserId(), "uuid", _coverUserUuid);
    }

    @Override
    public void setCoverUserUuid(String coverUserUuid) {
        _coverUserUuid = coverUserUuid;
    }

    @Override
    public long getModifiedById() {
        return _modifiedById;
    }

    @Override
    public void setModifiedById(long modifiedById) {
        _modifiedById = modifiedById;
    }

    @Override
    public Date getModifiedDate() {
        return _modifiedDate;
    }

    @Override
    public void setModifiedDate(Date modifiedDate) {
        _columnBitmask = -1L;

        _modifiedDate = modifiedDate;
    }

    @Override
    public long getGroupId() {
        return _groupId;
    }

    @Override
    public void setGroupId(long groupId) {
        _groupId = groupId;
    }

    @Override
    public String getRoleName() {
        if (_roleName == null) {
            return StringPool.BLANK;
        } else {
            return _roleName;
        }
    }

    @Override
    public void setRoleName(String roleName) {
        _roleName = roleName;
    }

    @Override
    public long getSysDateTime() {
        return _sysDateTime;
    }

    @Override
    public void setSysDateTime(long sysDateTime) {
        _sysDateTime = sysDateTime;
    }

    public long getColumnBitmask() {
        return _columnBitmask;
    }

    @Override
    public ExpandoBridge getExpandoBridge() {
        return ExpandoBridgeFactoryUtil.getExpandoBridge(0,
            AudLg.class.getName(), getPrimaryKey());
    }

    @Override
    public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
        ExpandoBridge expandoBridge = getExpandoBridge();

        expandoBridge.setAttributes(serviceContext);
    }

    @Override
    public AudLg toEscapedModel() {
        if (_escapedModel == null) {
            _escapedModel = (AudLg) ProxyUtil.newProxyInstance(_classLoader,
                    _escapedModelInterfaces, new AutoEscapeBeanHandler(this));
        }

        return _escapedModel;
    }

    @Override
    public Object clone() {
        AudLgImpl audLgImpl = new AudLgImpl();

        audLgImpl.setAudLgId(getAudLgId());
        audLgImpl.setClassPk(getClassPk());
        audLgImpl.setClassId(getClassId());
        audLgImpl.setAttribute(getAttribute());
        audLgImpl.setOldValue(getOldValue());
        audLgImpl.setNewValue(getNewValue());
        audLgImpl.setCoverUserId(getCoverUserId());
        audLgImpl.setModifiedById(getModifiedById());
        audLgImpl.setModifiedDate(getModifiedDate());
        audLgImpl.setGroupId(getGroupId());
        audLgImpl.setRoleName(getRoleName());
        audLgImpl.setSysDateTime(getSysDateTime());

        audLgImpl.resetOriginalValues();

        return audLgImpl;
    }

    @Override
    public int compareTo(AudLg audLg) {
        int value = 0;

        value = DateUtil.compareTo(getModifiedDate(), audLg.getModifiedDate());

        if (value != 0) {
            return value;
        }

        return 0;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (!(obj instanceof AudLg)) {
            return false;
        }

        AudLg audLg = (AudLg) obj;

        long primaryKey = audLg.getPrimaryKey();

        if (getPrimaryKey() == primaryKey) {
            return true;
        } else {
            return false;
        }
    }

    @Override
    public int hashCode() {
        return (int) getPrimaryKey();
    }

    @Override
    public void resetOriginalValues() {
        AudLgModelImpl audLgModelImpl = this;

        audLgModelImpl._originalClassPk = audLgModelImpl._classPk;

        audLgModelImpl._setOriginalClassPk = false;

        audLgModelImpl._originalClassId = audLgModelImpl._classId;

        audLgModelImpl._setOriginalClassId = false;

        audLgModelImpl._originalAttribute = audLgModelImpl._attribute;

        audLgModelImpl._columnBitmask = 0;
    }

    @Override
    public CacheModel<AudLg> toCacheModel() {
        AudLgCacheModel audLgCacheModel = new AudLgCacheModel();

        audLgCacheModel.audLgId = getAudLgId();

        audLgCacheModel.classPk = getClassPk();

        audLgCacheModel.classId = getClassId();

        audLgCacheModel.attribute = getAttribute();

        String attribute = audLgCacheModel.attribute;

        if ((attribute != null) && (attribute.length() == 0)) {
            audLgCacheModel.attribute = null;
        }

        audLgCacheModel.oldValue = getOldValue();

        String oldValue = audLgCacheModel.oldValue;

        if ((oldValue != null) && (oldValue.length() == 0)) {
            audLgCacheModel.oldValue = null;
        }

        audLgCacheModel.newValue = getNewValue();

        String newValue = audLgCacheModel.newValue;

        if ((newValue != null) && (newValue.length() == 0)) {
            audLgCacheModel.newValue = null;
        }

        audLgCacheModel.coverUserId = getCoverUserId();

        audLgCacheModel.modifiedById = getModifiedById();

        Date modifiedDate = getModifiedDate();

        if (modifiedDate != null) {
            audLgCacheModel.modifiedDate = modifiedDate.getTime();
        } else {
            audLgCacheModel.modifiedDate = Long.MIN_VALUE;
        }

        audLgCacheModel.groupId = getGroupId();

        audLgCacheModel.roleName = getRoleName();

        String roleName = audLgCacheModel.roleName;

        if ((roleName != null) && (roleName.length() == 0)) {
            audLgCacheModel.roleName = null;
        }

        audLgCacheModel.sysDateTime = getSysDateTime();

        return audLgCacheModel;
    }

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(25);

        sb.append("{audLgId=");
        sb.append(getAudLgId());
        sb.append(", classPk=");
        sb.append(getClassPk());
        sb.append(", classId=");
        sb.append(getClassId());
        sb.append(", attribute=");
        sb.append(getAttribute());
        sb.append(", oldValue=");
        sb.append(getOldValue());
        sb.append(", newValue=");
        sb.append(getNewValue());
        sb.append(", coverUserId=");
        sb.append(getCoverUserId());
        sb.append(", modifiedById=");
        sb.append(getModifiedById());
        sb.append(", modifiedDate=");
        sb.append(getModifiedDate());
        sb.append(", groupId=");
        sb.append(getGroupId());
        sb.append(", roleName=");
        sb.append(getRoleName());
        sb.append(", sysDateTime=");
        sb.append(getSysDateTime());
        sb.append("}");

        return sb.toString();
    }

    @Override
    public String toXmlString() {
        StringBundler sb = new StringBundler(40);

        sb.append("<model><model-name>");
        sb.append("gov.va.caret.model.AudLg");
        sb.append("</model-name>");

        sb.append(
            "<column><column-name>audLgId</column-name><column-value><![CDATA[");
        sb.append(getAudLgId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>classPk</column-name><column-value><![CDATA[");
        sb.append(getClassPk());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>classId</column-name><column-value><![CDATA[");
        sb.append(getClassId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>attribute</column-name><column-value><![CDATA[");
        sb.append(getAttribute());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>oldValue</column-name><column-value><![CDATA[");
        sb.append(getOldValue());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>newValue</column-name><column-value><![CDATA[");
        sb.append(getNewValue());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>coverUserId</column-name><column-value><![CDATA[");
        sb.append(getCoverUserId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>modifiedById</column-name><column-value><![CDATA[");
        sb.append(getModifiedById());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>modifiedDate</column-name><column-value><![CDATA[");
        sb.append(getModifiedDate());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>groupId</column-name><column-value><![CDATA[");
        sb.append(getGroupId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>roleName</column-name><column-value><![CDATA[");
        sb.append(getRoleName());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>sysDateTime</column-name><column-value><![CDATA[");
        sb.append(getSysDateTime());
        sb.append("]]></column-value></column>");

        sb.append("</model>");

        return sb.toString();
    }
}
