package gov.va.caret.controller.dashboard.config;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.User;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.util.portlet.PortletProps;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.letters.CscLetterType;
import gov.va.caret.model.Facil;
import gov.va.caret.model.support.WorkType;
import gov.va.caret.security.CAction;
import gov.va.caret.security.CAction.CaretCan;
import gov.va.caret.util.CaretStrPool;
import gov.va.caret.util.CaretUtil;
import gov.va.caret.view.AdhocReport;
import gov.va.caret.view.CachedReport;
import gov.va.caret.view.CaretParam;
import gov.va.caret.view.EnabledSearch;
import gov.va.caret.view.GenericReport;
import gov.va.caret.view.ReportParameter;
import gov.va.caret.view.ResultMap;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

import javax.portlet.PortletRequest;

public class CscDashboardConfig extends FacilityDashboardConfig {

	/**
	 * 
	 */
	private static final long serialVersionUID = -6732888370712702769L;
	public final String VIEW = "/jsp/dashboard/csc.jsp";
	protected Map<Long,Facil> facilities;
	
	public CscDashboardConfig() {
		super();
		
		this.reports = new GenericReport[]{ 
				new GenericReport("unassignedWork", true, "creationDate", true, ReportParameter.userOrgIds, ReportParameter.queId ), 
				new GenericReport("myApplicationWork", true, "creationDate", true, ReportParameter.userId, ReportParameter.queId ),

				new GenericReport("correctionWork", true, "creationDate", true, ReportParameter.userOrgIds ),
				new GenericReport("myNotes", true, "creationDate", true, GenericReport.NOTES_QUERY_NDX, ReportParameter.userId ),
				
				new GenericReport("newApplications", true, "creationDate", true, ReportParameter.userOrgIds, ReportParameter.queId ) ,
				new GenericReport("inProcess", true, "creationDate", true, ReportParameter.userOrgIds, ReportParameter.queId  ),
				new GenericReport("transferred", true, "creationDate", true, ReportParameter.userOrgIds ) ,
				new GenericReport("dueTodayWork", true, "creationDate", true, ReportParameter.userOrgIds, ReportParameter.queId ), 
				new GenericReport("overdueApps", true, "creationDate", true, ReportParameter.userOrgIds ) ,
				new GenericReport("overdueInProcess", true, "creationDate", true, ReportParameter.userOrgIds, ReportParameter.queId ),
				new GenericReport("homeVisit", true, "creationDate", true, ReportParameter.userOrgIds ),
				//new GenericReport("homeVisit", true, "creationDate", true ),
				new GenericReport("deathNotice", true, "creationDate", true, ReportParameter.userOrgIds ),
				new AdhocReport("vcgNotes", ReportParameter.classPk ),
				new GenericReport("referralWork", true, "creationDate", true, ReportParameter.userOrgIds ) ,
				new GenericReport("vcgNotifications", true, "creationDate", true, ReportParameter.userOrgIds ),
				new GenericReport("tiuNoteRewrite", true, "creationDate", true, ReportParameter.userOrgIds ),
				new GenericReport("periodicAssessments", true, "scheduleDate", true, 4, ReportParameter.userOrgIds ),
				new CachedReport("persnAudit"),
				new CachedReport("persn"),
				new CachedReport("workAudit"),
				new CachedReport("vcgAudit"),
				new CachedReport("assmtAudit"),
				new CachedReport("assmtAuditAll"),
				new CachedReport("assmtAuditPeriodicAll"),
				new CachedReport("periodicAssessmentsAll"),
				new CachedReport("vcgSupportingDocsAll"),
				new CachedReport("vcgDocsHistoryAll")
			};
		
		this.enabledSearch = new EnabledSearch( new CachedReport("vcgs"), new CachedReport("workItems") );
	}
	
	public CAction.CaretCan[] getCreateActions(){
		return new CAction.CaretCan[]{
			//CAction.CaretCan.CREATE_MESSAGES,
			CAction.CaretCan.CREATE_APPLICATIONS,
			CAction.CaretCan.SET_GENERAL_CG
		};
	}
	
	@Override
	public CaretCan[] getToolsActions() {
		return new CAction.CaretCan[]{
				CAction.CaretCan.STIPEND_CALCULATOR,
				CAction.CaretCan.IDENTITY_MATCHING
			};
	}
	
	public final CAction.CaretCan[] getMessageActions(){
		return new CAction.CaretCan[]{
			CAction.CaretCan.INTERNAL_MESSAGE
		};
	}
	

	@Override
	public String getView() {
		return VIEW;
	}
	public void setFacilityId( long facilityId ){}
	
	public long getGroupId(){
		return groupId;
	}
	public Map<Long,Facil> getFacilities(){
		return facilities;
	}
	public void setFacilities(Map<Long,Facil> facilities){
		this.facilities = facilities;
	}
	
	public void setUsers(PortletRequest request, List<Role> roles ) throws ApplicationWorkFlowException {
		@SuppressWarnings("unchecked")
		Map<String,Long> userMap = (Map<String,Long>)request.getPortletSession().getAttribute(CaretStrPool.USERMAP);
		if ( userMap == null ) {
			userMap = new TreeMap<String,Long>();
		}
		
		if ( userMap.isEmpty() ){
			List<String> list = Arrays.asList(PortletProps.getArray( CaretStrPool.CSC_ASSIGNABLE_ROLES ) ); 
			for ( Role role: roles ){
				if ( list.contains( role.getName() ) ){
					try {
						List<User> users = UserLocalServiceUtil.getRoleUsers( role.getRoleId() );
						for ( User user: users ){
//							if ( userIds.contains( user.getUserId() ) ){
								userMap.put(user.getFullName(), user.getUserId() );
//							}
						}
					} catch (SystemException e) {
						ApplicationWorkFlowException.handleException(e);
					}
				}
			}
			request.getPortletSession().setAttribute(CaretStrPool.USERMAP, userMap);
		}
	}

	@Override
	public void initDashBoard(PortletRequest request) throws ApplicationWorkFlowException {
		List<Role> roles;
		try {
			roles = RoleLocalServiceUtil.getSubtypeRoles( PropsUtil.get( "roles.regular.subtypes" ) );
		} catch (SystemException e1) {
			ApplicationWorkFlowException.handleException(e1);
			_log.error("unable to init(2)");
			return;
		}
		setFacilities( CaretParam.getFacilities(request) );
		setUsers( request, roles );
		request.setAttribute("cgRoles", new String[]{"caller"});
	}

	@Override
	public void configureFacility(PortletRequest request) throws ApplicationWorkFlowException {
		Map<Long,Facil> facilities = CaretParam.getFacilities(request);
		String facility = "";
		if ( facilities != null && !facilities.isEmpty() ){
			for ( Iterator<Facil> iter = facilities.values().iterator(); iter.hasNext(); ){
				Facil facil = iter.next();
				if ( facility.isEmpty() ){
					try {
						Organization org = OrganizationLocalServiceUtil.getOrganization( facil.getGroupId() );
						facility = facil.getFacilityNumber() + StringPool.COMMA_AND_SPACE + org.getName();
						this.groupId = facil.getGroupId();
					} catch (PortalException e) {
						ApplicationWorkFlowException.handleException(e);
					} catch (SystemException e) {
						ApplicationWorkFlowException.handleException(e);
					}
				}
			}
			if ( facilities.size() > 1 ){
				Organization org = ( Organization ) request.getAttribute("visn");
				this.groupId = org.getOrganizationId();
				facility = org.getName() + StringPool.COMMA_AND_SPACE + org.getComments();
			}
			request.setAttribute("facilityName", facility );
		}
		Map<String,Object> caret = ResultMap.getCaretMap(request);
		caret.put( CaretStrPool.GROUP_ID, groupId );
		caret.put( CaretStrPool.VHA_SYSTEM, CaretUtil.getVhaOrgTree( PortalUtil.getCompanyId( request ), true ) );
		caret.put( CaretStrPool.USERMAP, request.getPortletSession().getAttribute(CaretStrPool.USERMAP) );
		caret.put( CaretStrPool.WORKITEM_TYPES, WorkType.getFilterRegistered() );
	}

	public void loadReports( PortletRequest request ) throws ApplicationWorkFlowException{
		super.loadReports( request );
		ResultMap.getCaretMap(request).put(CaretStrPool.USE_WORKTYPES, true);
		ResultMap.getCaretMap(request).put( "cgRoles", new String[]{"primary-cg", "secondary-cg", "secondary-two-cg"} );
		ResultMap.getCaretMap(request).put(CaretStrPool.CSC_LETTER_NAMES, Arrays.asList(CscLetterType.values()));
	}
	
	public Collection<String> workItemTypes() {
		return searchableWork;
	}
	
	private static Log _log = LogFactoryUtil.getLog( CscDashboardConfig.class );


}
