package gov.va.caret.controller.dashboard.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

import javax.portlet.PortletRequest;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.User;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.util.portlet.PortletProps;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.letters.CbopcLetterType;
import gov.va.caret.model.support.WorkType;
import gov.va.caret.security.CAction;
import gov.va.caret.security.CAction.CaretCan;
import gov.va.caret.security.CodifiedRole;
import gov.va.caret.util.CaretStrPool;
import gov.va.caret.util.CaretUtil;
import gov.va.caret.view.AdhocReport;
import gov.va.caret.view.CachedReport;
import gov.va.caret.view.EnabledSearch;
import gov.va.caret.view.GenericReport;
import gov.va.caret.view.ReportParameter;
import gov.va.caret.view.ResultMap;
import gov.va.caret.workflow.OwnerQueue;


public class CbopcDashboardConfig extends DashboardConfig {

	/**
	 * 
	 */
	private static final long serialVersionUID = -5910038587835405338L;
	public final String VIEW = "/jsp/dashboard/cbopc.jsp";
	final static GenericReport MY_OCC_WORK = new GenericReport("myOccWork", true, "creationDate", true, GenericReport.CBOPC_QUERY_NDX, ReportParameter.userId );
	final static GenericReport MY_NOTES = new GenericReport("myNotes", true, "creationDate", true, GenericReport.NOTES_QUERY_NDX, ReportParameter.userId );
	private GenericReport[] cbopcReports;
	private String queueIds;
	
	private static GenericReport[] allCbopcQues =  new GenericReport[]{ 
			
			new GenericReport("myCscWork", true, "creationDate", true, GenericReport.CBOPC_QUERY_NDX, ReportParameter.queueIds ),
			new GenericReport("cbopcChampva", true, "creationDate", true, GenericReport.CBOPC_QUERY_NDX ),
			new GenericReport("insuranceChange", true, "creationDate", true, GenericReport.CBOPC_QUERY_NDX ),
			new GenericReport("cbopcVendor", true, "creationDate", true, GenericReport.CBOPC_QUERY_NDX ),
			new GenericReport("cbopcReview", true, "creationDate", true, GenericReport.CBOPC_QUERY_NDX ),
			new GenericReport("tierChange", true, "creationDate", true, GenericReport.CBOPC_QUERY_NDX ),
			new GenericReport("revocations", true, "creationDate", true, GenericReport.CBOPC_QUERY_NDX ),
			new GenericReport("reinstatements", true, "creationDate", true, GenericReport.CBOPC_QUERY_NDX ),
			new GenericReport("vcgInfoChange", true, "creationDate", true  ),
			new GenericReport("occVerify", true, "creationDate", true, GenericReport.CBOPC_QUERY_NDX ),
			new GenericReport("occSupervisor", true, "creationDate", true, GenericReport.CBOPC_QUERY_NDX ),
			new GenericReport("recoupments", true, "creationDate", true, GenericReport.CBOPC_QUERY_NDX ),
			new GenericReport("rejectedPayments", true, "creationDate", true, GenericReport.CBOPC_QUERY_NDX ),
			new GenericReport("lostChecks", true, "creationDate", true, GenericReport.CBOPC_QUERY_NDX ),
			new GenericReport("heldPayments", true, "creationDate", true, GenericReport.CBOPC_QUERY_NDX ),
			new GenericReport("duplicatePayments", true, "creationDate", true, GenericReport.CBOPC_QUERY_NDX ),
			
			new GenericReport("occVerify", true, "creationDate", true, GenericReport.CBOPC_QUERY_NDX )
			}; 
	
	private static GenericReport[] otherReports = new GenericReport[]{
			new GenericReport("vendors"),
			new GenericReport("blsRates", true, "county, city", false ),
			new AdhocReport("vcgNotes", ReportParameter.classPk ),
			new AdhocReport("workNotes", ReportParameter.classPk ),
			new CachedReport("persnAudit"),
			new CachedReport("persn"),
			new CachedReport("workAudit"),
			new CachedReport("vcgAudit"),
			new CachedReport("assmtAudit"),
			new CachedReport("assmtAuditAll"),
			new CachedReport("assmtAuditPeriodicAll"),
			new CachedReport("periodicAssessmentsAll"),
			new CachedReport("vcgSupportingDocsAll"),
			new CachedReport("vcgDocsHistoryAll")
	};
	
	Collection<String> searchableWork = new HashSet<String>(Arrays.asList(new String[]{
			WorkType.ADDRESS_CHANGE.name(), 
//			WorkType.CBOPC_WI.name(), 
			WorkType.APPROVED_DISPOSITION.name(),
//			WorkType.DISP_REINSTATED.name(),
//			WorkType.DISP_REVOKED.name(),
//			WorkType.DUPLICATE_PAYMENT.name(), 
//			WorkType.FACILITY_CHANGE.name(), 
//			WorkType.INSURANCE_CHANGE.name(),
//			WorkType.NAME_CHANGE.name(), 
//			WorkType.PII_CHANGE.name(), 
			WorkType.TIER_UPDATE.name()
//			WorkType.RECOUPMENT.name(),
//			WorkType.HELD_PAYMENT.name(),
//			WorkType.CSC_WORK.name(),
//			WorkType.VETERAN_CG_INFO_CHANGE.name(),
//			WorkType.LOST_CHECK.name(),
//			WorkType.REJECTED_PAYMENT.name()
			}) );
	
	private long getQueueId( String queueName ){
		try{
			return OwnerQueue.valueOf( queueName.substring( 6, queueName.length() ) ).queueId;
		} catch (IllegalArgumentException e){}
		return -1;
	}
	
	public String getQueueIds(){
		return queueIds.isEmpty()? "-1": queueIds;
	}
	
	public CbopcDashboardConfig() {
		super();
		this.reports = new GenericReport[0];
		this.enabledSearch = new EnabledSearch( new CachedReport("vcgs"), new CachedReport("workItems"), new CachedReport("vendors"), new CachedReport("payments") );
	}
	
	public GenericReport[] initDashboardQus ( PortletRequest request ){
		
		Set<GenericReport> reportQues = new LinkedHashSet<GenericReport>();
		
		StringBuilder sb = new StringBuilder();
		
		for ( CaretCan cbopcQueAction : CaretCan.CBOPC_FUNCTION.getCbopcQues () ){
			if ( CAction.canDoCaret ( request, cbopcQueAction ) ){
				String[] ques = PortletProps.getArray( cbopcQueAction.name() );
				sb.append( getQueueId( cbopcQueAction.name() ) ).append(StringPool.COMMA_AND_SPACE);
				if ( ques.length > 0 ){
					for ( String que: ques ){
						GenericReport report = getCbopcQue( que );
						if ( report!= null ){
							reportQues.add( report );
						}
					}
				}
			}
		}
		this.queueIds = sb.length() == 0? "-1": sb.substring( 0, sb.length()-2 );
		this.cbopcReports = reportQues.toArray(new GenericReport[reportQues.size()]);
		reportQues.add(MY_OCC_WORK);
		reportQues.add(MY_NOTES);
		reportQues.addAll( Arrays.asList( otherReports ) );
		this.reports = reportQues.toArray(new GenericReport[reportQues.size()]);
		
		List<Role> roles = null;
		try {
			roles = RoleLocalServiceUtil.getSubtypeRoles( PropsUtil.get( "roles.regular.subtypes" ) );
		} catch (SystemException e1) {
			ApplicationWorkFlowException.handleException(e1);
		}
		setUsers( request, roles );
		ResultMap.getCaretMap(request).put( CaretStrPool.USERMAP, request.getPortletSession().getAttribute(CaretStrPool.USERMAP) );
		return this.reports;
	}

	
	public void setUsers(PortletRequest request, List<Role> roles )  {
		if ( roles == null ) return;
		@SuppressWarnings("unchecked")
		Map<String,Long> userMap = (Map<String,Long>)request.getPortletSession().getAttribute(CaretStrPool.USERMAP);
		if ( userMap == null ) {
			userMap = new TreeMap<String,Long>();
		}
		
		if ( userMap.isEmpty() ){
			List<String> codes = Arrays.asList(PortletProps.getArray( CaretStrPool.OCC_ASSIGNABLE_ROLES ) );
			List<String> list = new ArrayList<>();
			for ( String code: codes ){
				String roleName = CodifiedRole.getRoleName(code);
				if ( roleName == null ) continue;
				list.add( roleName );
			}
			
			for ( Role role: roles ){
				if ( list.contains( role.getName() ) ){
					try {
						List<User> users = UserLocalServiceUtil.getRoleUsers( role.getRoleId() );
						for ( User user: users ){
							userMap.put(user.getFullName(), user.getUserId() );
						}
					} catch (SystemException e) {
						ApplicationWorkFlowException.handleException(e);
					}
				}
			}
			request.getPortletSession().setAttribute(CaretStrPool.USERMAP, userMap);
		}
	}
	
	private GenericReport getCbopcQue( String queName ) {
		for ( GenericReport que: allCbopcQues ){
			if ( que.getPageName().equals( queName ) ){
				return que;
			}
		}
		return null;
	}

	public final CAction.CaretCan[] getCreateActions(){
		return new CAction.CaretCan[]{
				CAction.CaretCan.CREATE_VENDORS,
				CAction.CaretCan.CREATE_RECOUPMENT,
				CAction.CaretCan.CREATE_LOST_CHECK,
				CAction.CaretCan.CREATE_HELD_PAYMENT
		};
	}
/*
 * (non-Javadoc)
 * @see gov.va.caret.controller.dashboard.config.DashboardConfig#getToolsActions()
 */
	@Override
	public CaretCan[] getToolsActions() {
		return new CAction.CaretCan[]{
				CAction.CaretCan.STIPEND_CALCULATOR
			};
	}
	
	public final CAction.CaretCan[] getMessageActions(){
		return new CAction.CaretCan[]{
			CAction.CaretCan.INTERNAL_MESSAGE
		};
	}
	
	@Override
	public String getView() {
		return VIEW;
	}
	
	public void loadReports( PortletRequest request ) throws ApplicationWorkFlowException{
		initDashboardQus(request);
		super.loadReports( request );
		Map<String,Object> caret = ResultMap.getCaretMap(request);
		caret.put(CaretStrPool.USE_WORKTYPES, true);
		caret.put( CaretStrPool.WORKITEM_TYPES, workItemTypes() );
		caret.put( "cgRoles", new String[]{"primary-cg", "secondary-cg", "secondary-two-cg"} );
		caret.put( CaretStrPool.VHA_SYSTEM, CaretUtil.getVhaOrgTree( PortalUtil.getCompanyId( request ), true ) );
		caret.put("cbopcQue", cbopcReports);
		caret.put(CaretStrPool.CBOPC_LETTER_NAMES, Arrays.asList(CbopcLetterType.values()));

	}
	
	public Collection<String> workItemTypes() {
		return searchableWork;
	}

}
