package gov.va.caret.controller;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.kernel.util.PropsKeys;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.model.CountryConstants;
import com.liferay.portal.service.RegionServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PortalUtil;
import com.liferay.util.portlet.PortletProps;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.controller.dashboard.config.OnlineDashboardConfig;
import gov.va.caret.model.BgAsn;
import gov.va.caret.model.BoxGp;
import gov.va.caret.model.Persn;
import gov.va.caret.model.VcgAn;
import gov.va.caret.model.impl.VcgAnImpl;
import gov.va.caret.model.support.ApplicationStatus;
import gov.va.caret.model.support.Person;
import gov.va.caret.model.support.Primary;
import gov.va.caret.model.support.Secondary;
import gov.va.caret.model.support.SecondaryTwo;
import gov.va.caret.model.support.VcgApplication;
import gov.va.caret.model.support.Veteran;
import gov.va.caret.security.CAction;
import gov.va.caret.service.BoxGpLocalServiceUtil;
import gov.va.caret.service.CaretLocalServiceUtil;
import gov.va.caret.service.PersnLocalServiceUtil;
import gov.va.caret.service.VcgAnLocalServiceUtil;
import gov.va.caret.util.CaretMap;
import gov.va.caret.util.CaretStrPool;
import gov.va.caret.util.CaretUtil;
import gov.va.caret.util.OnlineUtil;
import gov.va.caret.view.CaretParam;
import gov.va.caret.view.GenericReport;
import gov.va.caret.view.ResultMap;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

import javax.portlet.BaseURL;
import javax.portlet.MimeResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;


/*
 * Central controller for CareT Online... shared between ResourceCommand and ActionCommand
 * 
 */

public class OnlineViewController extends CaretBaseViewController implements Serializable {
	
	private static final long serialVersionUID = 1L;
//	private static final String INFORMATION_VIEW = "/jsp/online/information.jsp";
//	private static final String APPLICATION_VIEW = "/jsp/online/edit1010cg.jsp";
//	private static final String PRIMARY_VIEW = "/jsp/online/primary.jsp";
//	private static final String SECONDARY_VIEW = "/jsp/online/secondary.jsp";
//	private static final String SECONDARY_TWO_VIEW = "/jsp/online/secondaryTwo.jsp";
	
	public static Log _log = LogFactoryUtil.getLog(  OnlineViewController.class );
	
	private static OnlineViewController viewController = null;
	
	public static OnlineViewController get(){
		if ( viewController == null ){
			viewController = new OnlineViewController();
		}
		return viewController;
	}
	
	@Override
	public String loadDefaultView( PortletRequest request, MimeResponse response ){
		
		String mvcPath = ParamUtil.get( request, CaretStrPool.MVC_PATH, StringPool.BLANK );
		_log.info("mvcPath..." + mvcPath);
		
		if ( StringPool.BLANK.equals( mvcPath ) && request.getAttribute( CaretStrPool.MVC_PATH ) != null ){
			mvcPath = (String) request.getAttribute( CaretStrPool.MVC_PATH );
		}
		if ( StringPool.BLANK.equals( mvcPath ) ){
			try {
				mvcPath = loadRoleView( request, response ); 
			} catch (PortalException e) {
				ApplicationWorkFlowException.handleException(e);
			} catch (SystemException e) {
				ApplicationWorkFlowException.handleException(e);
			}
		}
		return mvcPath;
	}
	
	@SuppressWarnings({ "unused", "rawtypes", "unchecked" })
	public String loadRoleView ( PortletRequest request, MimeResponse response ) throws PortalException, SystemException{
		
		OnlineDashboardConfig dashboard = CAction.loadOnlineRoleId( request );
		if ( dashboard == null ){
			return CaretBaseViewController.INVALID_ACCESS_VIEW;
		}
		
		long userId = PortalUtil.getUserId( request );
//		long siteId = PortalUtil.getScopeGroupId( request );
		request.setAttribute( "isDemoEnabled", StringPool.TRUE.equals( PortletProps.get(CaretStrPool.DEMO_FEATURES_ENABLED) ) ); 
		PortletSession session = request.getPortletSession();
		
		List<Long> persnRevisionIds = new ArrayList<Long>();
		long persnId = CaretParam.getPersnId(request);
		Person person = null;
		
		Set<Long> caregiverIds = new HashSet<Long>();
		if ( dashboard.isVeteran() ){
			person = new Veteran ( PersnLocalServiceUtil.getPersn( persnId ) );
			for ( Persn persn: person.getPersnSet() ){
				persnRevisionIds.add( persn.getPersnId() );
			}
			if ( !((Veteran)person).isPrimaryAvailable() ){
				caregiverIds.add( ((Veteran)person).getPrimaryId() );
			}
			if ( !((Veteran)person).isSecondaryAvailable() ){
				caregiverIds.add( ((Veteran)person).getSecondaryId() );
			}
			if ( !((Veteran)person).isSecondaryTwoAvailable() ){
				caregiverIds.add( ((Veteran)person).getSecondaryTwoId() );
			}
			OnlineViewController.get().getForm(request).put(CaretStrPool.CAREGIVER_IDS, caregiverIds.size() );
//			request.getPortletSession().setAttribute(CaretStrPool.CAREGIVER_IDS, caregiverIds);
		} else {
			person = new Person ( PersnLocalServiceUtil.getPersn( persnId ) );
			for ( Persn persn: person.getPersnSet() ){
				persnRevisionIds.add( persn.getPersnId() );
			}
		}
		
		Map persnIdMap = Collections.singletonMap(CaretStrPool.PERSN_ID, persnRevisionIds );
		
		int count = CaretLocalServiceUtil.getReportCount (dashboard.getDashboardReport(), persnIdMap);
		
		Map<String,List<?>> results = ResultMap.getResultListMap( request );
		Map<String,Integer> total = ResultMap.getResultTotalMap( request );
		Map<String,BaseURL> urlMap = ResultMap.getResultUrlMap( request, response.createRenderURL() );

		request.setAttribute(CaretStrPool.VA_CG_HREF, PortletProps.get(CaretStrPool.VA_CAREGIVER_SITE) );
		
		if ( count == 0 ){
			getForm(request).put(CaretStrPool.SHOW_ALL_TABS, true);
			loadOnlineQuestionaire(request);
			OnlineViewController.get().getForm(request).put(CaretStrPool.CAREGIVER_IDS, 99 );//disables 
		} else {
			total.put( GenericReport.MY_APPLICATIONS, count );
			List[] myApplications = new List[]{CaretLocalServiceUtil.getReport( dashboard.getDashboardReport(), persnIdMap )};
			
			List myVcgStatus;
			if ( dashboard.isVeteran() ){
				myVcgStatus = OnlineUtil.myCaregivers( myApplications[0], request );
			} else {
				getForm(request).put(CaretStrPool.CAREGIVER, true);
				myVcgStatus = OnlineUtil.myVeterans( persnRevisionIds, myApplications, request);

				results.put( GenericReport.MY_STIPENDS, CaretLocalServiceUtil.getReport( GenericReport.MY_STIPENDS, userId ) );
				total.put( GenericReport.MY_STIPENDS, CaretLocalServiceUtil.getReportCount( GenericReport.MY_STIPENDS, userId ) );
			}
			
			results.put( GenericReport.MY_APPLICATIONS, myApplications[0] );
			results.put( GenericReport.MY_VCG_STATUS, myVcgStatus );
			total.put( GenericReport.MY_VCG_STATUS, myVcgStatus.size() );
			
			results.put( GenericReport.MY_MESSAGES, CaretLocalServiceUtil.getReport( GenericReport.MY_MESSAGES, Collections.singletonMap(CaretStrPool.PERSN_ID, person.getRootUserId() ) ) );
			total.put( GenericReport.MY_MESSAGES, CaretLocalServiceUtil.getReportCount( GenericReport.MY_MESSAGES , Collections.singletonMap(CaretStrPool.PERSN_ID, person.getRootUserId() ) ) );
		}
		
		return "/jsp/online/" + dashboard.getJsp();
	}
	
	@SuppressWarnings({ "unchecked", "rawtypes" })
	private void loadOnlineQuestionaire(PortletRequest request) throws ApplicationWorkFlowException {
		
		List<BoxGp> groups = BoxGpLocalServiceUtil.getBoxGroups(CaretStrPool.ONLINE_QUESTIONAIRE_YN);
		
		if ( groups.isEmpty() ){
			groups = new ArrayList<BoxGp>();
			int i = 0;
			for ( String subgroup: PortletProps.get( CaretStrPool.ONLINE_QUESTIONAIRE_YN ).split( StringPool.SEMICOLON ) ){
				CaretUtil.initYesNoBoxGp(subgroup, CaretStrPool.ONLINE_QUESTIONAIRE_YN, groups, i);
				i = i + 2;
			}
		}
		
		Map<String, Object> form =  getForm(request);
		
		form.put(CaretStrPool.BOX_GROUP, groups );
		
		Map boxGrp = new CaretMap( false );
		form.put(CaretStrPool.BOX_GROUP_ASSN, boxGrp);
		for ( BgAsn bgAsn0: BoxGpLocalServiceUtil.getBoxGroupAssociations( CaretParam.getPersnId(request), true ) ) {
			boxGrp.put( bgAsn0.getBoxGpId(), true );
		}
		Map<String,List<BoxGp>> boxGpMap = new HashMap<String,List<BoxGp>>();
		int i = 0;
		List boxGpList = new ArrayList(5);
		for ( BoxGp boxGp: groups ){
			boxGpList.add( boxGp );
			if ( i % 2 == 1 ){
				boxGpMap.put( boxGp.getBoxSubGroup(), boxGpList );
				boxGpList = new ArrayList(5);
			}
			i++;
		}
		form.put( CaretStrPool.BOX_GROUP, boxGpMap );
	}
	
	public void cancelApplication ( PortletRequest request ) throws PortalException, SystemException{
		long vcgAnId = ParamUtil.getLong(request, CaretStrPool.VCGANID, 0);
		if ( vcgAnId == 0 && request.getAttribute(CaretStrPool.VCGANID) != null){
			vcgAnId = (Long) request.getAttribute(CaretStrPool.VCGANID);
		}
		VcgApplication vcgApp = new VcgApplication( VcgAnLocalServiceUtil.getVcgAn(vcgAnId) );
		_log.info( "app status = " + vcgApp.getStatus( ) );
		if ( ApplicationStatus.NEED_SIGNATURE.name().equals( vcgApp.getStatus() ) ){
			vcgApp.setStatus( ApplicationStatus.CANCELLED.name() );
			CaretLocalServiceUtil.save(vcgApp);
			ServiceContext sc = CaretParam.setOnlineServiceContext(request);
			String onlineMessage = LanguageUtil.get( Locale.getDefault(), CaretStrPool.VETERAN_CANCELLED_ONLINE) ;
			if ( vcgApp.getPrimaryId() > 0 ){
				Person person = new Primary( PersnLocalServiceUtil.getPersn( vcgApp.getPrimaryId() ) );
				CaretLocalServiceUtil.addNote( CaretUtil.createNote(sc.getCreateDate(), vcgAnId, 0, 
					person.getRootUserId(), onlineMessage ) );
				vcgApp.setInvalidPerson( person.getPersnId(), onlineMessage );
			}
			if ( vcgApp.getSecondaryId() > 0 ){
				Person person = new Secondary( PersnLocalServiceUtil.getPersn( vcgApp.getSecondaryId() ) );
				CaretLocalServiceUtil.addNote( CaretUtil.createNote( sc.getCreateDate(), vcgAnId, 0, 
						person.getRootUserId(), onlineMessage ) );
				vcgApp.setInvalidPerson( person.getPersnId(), onlineMessage );
			}
			if ( vcgApp.getSecondaryTwoId() > 0 ){
				Person person = new SecondaryTwo( PersnLocalServiceUtil.getPersn( vcgApp.getSecondaryTwoId() ) ); 
				CaretLocalServiceUtil.addNote( CaretUtil.createNote( sc.getCreateDate(), vcgAnId, 0, 
						person.getRootUserId(), onlineMessage) );
				vcgApp.setInvalidPerson( person.getPersnId(), onlineMessage );
			}
			Person person = new Veteran( PersnLocalServiceUtil.getPersn( vcgApp.getVeteranId() ) ); 
			CaretLocalServiceUtil.addNote( CaretUtil.createNote( sc.getCreateDate(), vcgAnId, 0, 
					person.getRootUserId(), onlineMessage) );
		}
	}

	public void loadApplication ( PortletRequest request ){
		try {
			Map<String, Object> form = getForm(request);
			long userId =  PortalUtil.getUserId(request);
			long vcgAnId = ParamUtil.getLong(request, CaretStrPool.VCGANID, 0);
			
			Persn persn = PersnLocalServiceUtil.getLatest( PortalUtil.getUserId(request) );			
			Person formPerson = null;
			
			if ( vcgAnId == 0 ){ //is-new
				Veteran person;
				formPerson = person = new Veteran( persn );
				
				form.put(CaretStrPool.VETERAN_PERSN, formPerson);
				int slots = 0;
				
				if ( !person.isPrimaryAvailable() ){
					form.put( CaretStrPool.PRIMARY_PERSN, person.getPrimary() );
					slots++;
				}
				if ( !person.isSecondaryAvailable() ){
					form.put( CaretStrPool.SECONDARY_PERSN, person.getSecondary() );
					slots++;
				}
				if ( !person.isSecondaryTwoAvailable() ){
					form.put( CaretStrPool.SECONDARY_TWO_PERSN, person.getSecondaryTwo() );
					slots++;
				}
					
				request.getPortletSession().setAttribute( CaretStrPool.APP_NDX, slots );
			}
			
			Map<String,Object> caret = ResultMap.getCaretMap(request);

			caret.put( CaretStrPool.VHA_SYSTEM, CaretUtil.getVhaOrgTree( PortalUtil.getCompanyId( request ), true ) );
			caret.put( CaretStrPool.GENDER_TYPES, PortletProps.get(CaretStrPool.PERSN_GENDER_TYPES).split(StringPool.COMMA) );
			try {
				caret.put(CaretStrPool.STATES, RegionServiceUtil.getRegions( CountryConstants.DEFAULT_COUNTRY_ID ) );
			} catch (SystemException e) {
				ApplicationWorkFlowException.handleException(e);
			}
			
			
			form.put(CaretStrPool.VCGANID, vcgAnId);
			String prefix = CaretStrPool.VETERAN_PERSN;
			if ( vcgAnId > 0 ){  // not-new
				VcgAn vcgApplication = VcgAnLocalServiceUtil.getVcgAn(vcgAnId);
				
				//do we need the veteran for care-giver form or just the name of veteran?
				form.put(CaretStrPool.VETERAN_PERSN, PersnLocalServiceUtil.getPersn( vcgApplication.getVeteranId() ) );
				
				if ( vcgApplication.getPrimaryId() > 0 ){
					if ( new Person ( PersnLocalServiceUtil.getPersn( vcgApplication.getPrimaryId() ) ).getRootUserId() == userId ){
						formPerson = new Primary ( PersnLocalServiceUtil.getLatest( userId ) );
						prefix = CaretStrPool.PRIMARY_PERSN;
						form.put( CaretStrPool.PRIMARY_PERSN, formPerson );//TODO: do we need this?
					}
				} 
				if ( formPerson == null && vcgApplication.getSecondaryId() > 0 ){
					if ( new Person( PersnLocalServiceUtil.getPersn( vcgApplication.getSecondaryId() ) ).getRootUserId() == userId ){
						formPerson = new Secondary ( PersnLocalServiceUtil.getLatest( userId ) );
						form.put( CaretStrPool.SECONDARY_PERSN, formPerson );
						prefix = CaretStrPool.SECONDARY_PERSN;
					}
				}
				if ( formPerson == null && vcgApplication.getSecondaryTwoId() > 0 ){
					if ( new Person( PersnLocalServiceUtil.getPersn( vcgApplication.getSecondaryTwoId() ) ).getRootUserId() == userId ){
						formPerson = new SecondaryTwo ( PersnLocalServiceUtil.getLatest( userId ) );
						form.put( CaretStrPool.SECONDARY_TWO_PERSN, formPerson );
						prefix = CaretStrPool.SECONDARY_TWO_PERSN;
					}
				}
				
				form.put( CaretStrPool.VCGAN, vcgApplication );
				
				String relationshipNotFamily = PortletProps.get(CaretStrPool.RELATIONSHIP_NOT_FAMILY);
				String relationshipFamily = PortletProps.get(CaretStrPool.RELATIONSHIP_FAMILY);
				if ( !relationshipNotFamily.isEmpty() ){
					
					java.util.List c = Arrays.asList( (relationshipNotFamily + StringPool.COMMA + relationshipFamily).split(StringPool.COMMA) );
					Collections.sort( c );
					caret.put(CaretStrPool.RELATIONSHIP, c );
//					caret.put(CaretStrPool.RELATIONSHIP_NOT_FAMILY, relationshipNotFamily.split(StringPool.COMMA) );
//					caret.put(CaretStrPool.RELATIONSHIP_FAMILY, relationshipFamily.split(StringPool.COMMA) );
				}
				
			} else {
				VcgAn vcgAn = new VcgAnImpl();
				Object o = request.getAttribute(Veteran.ENROLLED_VA_HEALTH);
				if ( o != null ){
					vcgAn.setVaHealthEnrolled((Boolean)o);
				}
				form.put( CaretStrPool.VCGAN, vcgAn );
			}
			loadRequiredInputs( prefix, form );
			loadAddress(caret, formPerson, prefix);
			
			try {
				String extensions = StringUtil.merge(PrefsPropsUtil.getStringArray(PropsKeys.DL_FILE_EXTENSIONS, StringPool.COMMA));
//				dl.file.max.size
				long maxSize = Long.parseLong(PrefsPropsUtil.getString(PropsKeys.DL_FILE_MAX_SIZE)) / 1024;
				_log.info("extensions = " + extensions + ", maxSize=" + maxSize );
				form.put("extensions",  extensions );
				form.put("maxSize",  maxSize );
				
			} catch (NumberFormatException e) {
				ApplicationWorkFlowException.handleException(e);
			} catch (SystemException e) {
				ApplicationWorkFlowException.handleException(e);
			}
			
			request.setAttribute(CaretStrPool.MVC_PATH, formPerson.getOnlineView() );
			caret.put( CaretStrPool.SEARCH_CSS, SearchController.getSearchCss() );
			
		} catch (ApplicationWorkFlowException e) {
			ApplicationWorkFlowException.handleException(e);
		} catch (PortalException e) {
			ApplicationWorkFlowException.handleException(e);
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
	}
	
	public void loadRequiredInputs( String persn, Map<String, Object> form) {
		
		Map<String,Object> required = new CaretMap<String,Object>(StringPool.BLANK);
		form.put("required", required);
		
		if ( CaretStrPool.VETERAN_PERSN == persn ){
			for ( String key : PortletProps.get("required.veteran.input").split(StringPool.COMMA) ){
				required.put(key, CaretStrPool.REQUIRED_INPUT );
			};
		} else if ( CaretStrPool.PRIMARY_PERSN == persn ){
			for ( String key : PortletProps.get("required.primary.input").split(StringPool.COMMA) ){
				required.put(key, CaretStrPool.REQUIRED_INPUT );
			};		
		} else if ( CaretStrPool.SECONDARY_PERSN == persn ){
			for ( String key : PortletProps.get("required.secondary.input").split(StringPool.COMMA) ){
				required.put(key, CaretStrPool.REQUIRED_INPUT );
			};
		} else if ( CaretStrPool.SECONDARY_TWO_PERSN == persn ){
			for ( String key : PortletProps.get("required.secondaryTwo.input").split(StringPool.COMMA) ){
				required.put(key, CaretStrPool.REQUIRED_INPUT );
			};
		}
	}
	
	public boolean validateRequired( String context, PortletRequest request ){
		return true;
	}

	
}
