package gov.va.caret.service.persistence;

import com.liferay.portal.kernel.bean.PortletBeanLocatorUtil;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ReferenceRegistry;
import com.liferay.portal.service.ServiceContext;

import gov.va.caret.model.ZipFy;

import java.util.List;

/**
 * The persistence utility for the zip fy service. This utility wraps {@link ZipFyPersistenceImpl} and provides direct access to the database for CRUD operations. This utility should only be used by the service layer, as it must operate within a transaction. Never access this utility in a JSP, controller, model, or other front-end class.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author caret
 * @see ZipFyPersistence
 * @see ZipFyPersistenceImpl
 * @generated
 */
public class ZipFyUtil {
    private static ZipFyPersistence _persistence;

    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify this class directly. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this class.
     */

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#clearCache()
     */
    public static void clearCache() {
        getPersistence().clearCache();
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#clearCache(com.liferay.portal.model.BaseModel)
     */
    public static void clearCache(ZipFy zipFy) {
        getPersistence().clearCache(zipFy);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#countWithDynamicQuery(DynamicQuery)
     */
    public static long countWithDynamicQuery(DynamicQuery dynamicQuery)
        throws SystemException {
        return getPersistence().countWithDynamicQuery(dynamicQuery);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery)
     */
    public static List<ZipFy> findWithDynamicQuery(DynamicQuery dynamicQuery)
        throws SystemException {
        return getPersistence().findWithDynamicQuery(dynamicQuery);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery, int, int)
     */
    public static List<ZipFy> findWithDynamicQuery(DynamicQuery dynamicQuery,
        int start, int end) throws SystemException {
        return getPersistence().findWithDynamicQuery(dynamicQuery, start, end);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery, int, int, OrderByComparator)
     */
    public static List<ZipFy> findWithDynamicQuery(DynamicQuery dynamicQuery,
        int start, int end, OrderByComparator orderByComparator)
        throws SystemException {
        return getPersistence()
                   .findWithDynamicQuery(dynamicQuery, start, end,
            orderByComparator);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#update(com.liferay.portal.model.BaseModel)
     */
    public static ZipFy update(ZipFy zipFy) throws SystemException {
        return getPersistence().update(zipFy);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#update(com.liferay.portal.model.BaseModel, ServiceContext)
     */
    public static ZipFy update(ZipFy zipFy, ServiceContext serviceContext)
        throws SystemException {
        return getPersistence().update(zipFy, serviceContext);
    }

    /**
    * Returns all the zip fies where facilZip = &#63;.
    *
    * @param facilZip the facil zip
    * @return the matching zip fies
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.ZipFy> findByZip(
        java.lang.String facilZip)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findByZip(facilZip);
    }

    /**
    * Returns a range of all the zip fies where facilZip = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.ZipFyModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param facilZip the facil zip
    * @param start the lower bound of the range of zip fies
    * @param end the upper bound of the range of zip fies (not inclusive)
    * @return the range of matching zip fies
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.ZipFy> findByZip(
        java.lang.String facilZip, int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findByZip(facilZip, start, end);
    }

    /**
    * Returns an ordered range of all the zip fies where facilZip = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.ZipFyModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param facilZip the facil zip
    * @param start the lower bound of the range of zip fies
    * @param end the upper bound of the range of zip fies (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of matching zip fies
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.ZipFy> findByZip(
        java.lang.String facilZip, int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence()
                   .findByZip(facilZip, start, end, orderByComparator);
    }

    /**
    * Returns the first zip fy in the ordered set where facilZip = &#63;.
    *
    * @param facilZip the facil zip
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching zip fy
    * @throws gov.va.caret.NoSuchZipFyException if a matching zip fy could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.ZipFy findByZip_First(
        java.lang.String facilZip,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchZipFyException {
        return getPersistence().findByZip_First(facilZip, orderByComparator);
    }

    /**
    * Returns the first zip fy in the ordered set where facilZip = &#63;.
    *
    * @param facilZip the facil zip
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching zip fy, or <code>null</code> if a matching zip fy could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.ZipFy fetchByZip_First(
        java.lang.String facilZip,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().fetchByZip_First(facilZip, orderByComparator);
    }

    /**
    * Returns the last zip fy in the ordered set where facilZip = &#63;.
    *
    * @param facilZip the facil zip
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching zip fy
    * @throws gov.va.caret.NoSuchZipFyException if a matching zip fy could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.ZipFy findByZip_Last(
        java.lang.String facilZip,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchZipFyException {
        return getPersistence().findByZip_Last(facilZip, orderByComparator);
    }

    /**
    * Returns the last zip fy in the ordered set where facilZip = &#63;.
    *
    * @param facilZip the facil zip
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching zip fy, or <code>null</code> if a matching zip fy could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.ZipFy fetchByZip_Last(
        java.lang.String facilZip,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().fetchByZip_Last(facilZip, orderByComparator);
    }

    /**
    * Returns the zip fies before and after the current zip fy in the ordered set where facilZip = &#63;.
    *
    * @param zipFyId the primary key of the current zip fy
    * @param facilZip the facil zip
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the previous, current, and next zip fy
    * @throws gov.va.caret.NoSuchZipFyException if a zip fy with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.ZipFy[] findByZip_PrevAndNext(
        long zipFyId, java.lang.String facilZip,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchZipFyException {
        return getPersistence()
                   .findByZip_PrevAndNext(zipFyId, facilZip, orderByComparator);
    }

    /**
    * Removes all the zip fies where facilZip = &#63; from the database.
    *
    * @param facilZip the facil zip
    * @throws SystemException if a system exception occurred
    */
    public static void removeByZip(java.lang.String facilZip)
        throws com.liferay.portal.kernel.exception.SystemException {
        getPersistence().removeByZip(facilZip);
    }

    /**
    * Returns the number of zip fies where facilZip = &#63;.
    *
    * @param facilZip the facil zip
    * @return the number of matching zip fies
    * @throws SystemException if a system exception occurred
    */
    public static int countByZip(java.lang.String facilZip)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().countByZip(facilZip);
    }

    /**
    * Caches the zip fy in the entity cache if it is enabled.
    *
    * @param zipFy the zip fy
    */
    public static void cacheResult(gov.va.caret.model.ZipFy zipFy) {
        getPersistence().cacheResult(zipFy);
    }

    /**
    * Caches the zip fies in the entity cache if it is enabled.
    *
    * @param zipFies the zip fies
    */
    public static void cacheResult(
        java.util.List<gov.va.caret.model.ZipFy> zipFies) {
        getPersistence().cacheResult(zipFies);
    }

    /**
    * Creates a new zip fy with the primary key. Does not add the zip fy to the database.
    *
    * @param zipFyId the primary key for the new zip fy
    * @return the new zip fy
    */
    public static gov.va.caret.model.ZipFy create(long zipFyId) {
        return getPersistence().create(zipFyId);
    }

    /**
    * Removes the zip fy with the primary key from the database. Also notifies the appropriate model listeners.
    *
    * @param zipFyId the primary key of the zip fy
    * @return the zip fy that was removed
    * @throws gov.va.caret.NoSuchZipFyException if a zip fy with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.ZipFy remove(long zipFyId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchZipFyException {
        return getPersistence().remove(zipFyId);
    }

    public static gov.va.caret.model.ZipFy updateImpl(
        gov.va.caret.model.ZipFy zipFy)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().updateImpl(zipFy);
    }

    /**
    * Returns the zip fy with the primary key or throws a {@link gov.va.caret.NoSuchZipFyException} if it could not be found.
    *
    * @param zipFyId the primary key of the zip fy
    * @return the zip fy
    * @throws gov.va.caret.NoSuchZipFyException if a zip fy with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.ZipFy findByPrimaryKey(long zipFyId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchZipFyException {
        return getPersistence().findByPrimaryKey(zipFyId);
    }

    /**
    * Returns the zip fy with the primary key or returns <code>null</code> if it could not be found.
    *
    * @param zipFyId the primary key of the zip fy
    * @return the zip fy, or <code>null</code> if a zip fy with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.ZipFy fetchByPrimaryKey(long zipFyId)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().fetchByPrimaryKey(zipFyId);
    }

    /**
    * Returns all the zip fies.
    *
    * @return the zip fies
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.ZipFy> findAll()
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findAll();
    }

    /**
    * Returns a range of all the zip fies.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.ZipFyModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of zip fies
    * @param end the upper bound of the range of zip fies (not inclusive)
    * @return the range of zip fies
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.ZipFy> findAll(int start,
        int end) throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findAll(start, end);
    }

    /**
    * Returns an ordered range of all the zip fies.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.ZipFyModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of zip fies
    * @param end the upper bound of the range of zip fies (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of zip fies
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.ZipFy> findAll(int start,
        int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findAll(start, end, orderByComparator);
    }

    /**
    * Removes all the zip fies from the database.
    *
    * @throws SystemException if a system exception occurred
    */
    public static void removeAll()
        throws com.liferay.portal.kernel.exception.SystemException {
        getPersistence().removeAll();
    }

    /**
    * Returns the number of zip fies.
    *
    * @return the number of zip fies
    * @throws SystemException if a system exception occurred
    */
    public static int countAll()
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().countAll();
    }

    public static ZipFyPersistence getPersistence() {
        if (_persistence == null) {
            _persistence = (ZipFyPersistence) PortletBeanLocatorUtil.locate(gov.va.caret.service.ClpSerializer.getServletContextName(),
                    ZipFyPersistence.class.getName());

            ReferenceRegistry.registerReference(ZipFyUtil.class, "_persistence");
        }

        return _persistence;
    }

    /**
     * @deprecated As of 6.2.0
     */
    public void setPersistence(ZipFyPersistence persistence) {
    }
}
