package gov.va.caret.service.persistence;

import com.liferay.portal.kernel.bean.PortletBeanLocatorUtil;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ReferenceRegistry;
import com.liferay.portal.service.ServiceContext;

import gov.va.caret.model.Vcg;

import java.util.List;

/**
 * The persistence utility for the vcg service. This utility wraps {@link VcgPersistenceImpl} and provides direct access to the database for CRUD operations. This utility should only be used by the service layer, as it must operate within a transaction. Never access this utility in a JSP, controller, model, or other front-end class.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author caret
 * @see VcgPersistence
 * @see VcgPersistenceImpl
 * @generated
 */
public class VcgUtil {
    private static VcgPersistence _persistence;

    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify this class directly. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this class.
     */

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#clearCache()
     */
    public static void clearCache() {
        getPersistence().clearCache();
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#clearCache(com.liferay.portal.model.BaseModel)
     */
    public static void clearCache(Vcg vcg) {
        getPersistence().clearCache(vcg);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#countWithDynamicQuery(DynamicQuery)
     */
    public static long countWithDynamicQuery(DynamicQuery dynamicQuery)
        throws SystemException {
        return getPersistence().countWithDynamicQuery(dynamicQuery);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery)
     */
    public static List<Vcg> findWithDynamicQuery(DynamicQuery dynamicQuery)
        throws SystemException {
        return getPersistence().findWithDynamicQuery(dynamicQuery);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery, int, int)
     */
    public static List<Vcg> findWithDynamicQuery(DynamicQuery dynamicQuery,
        int start, int end) throws SystemException {
        return getPersistence().findWithDynamicQuery(dynamicQuery, start, end);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery, int, int, OrderByComparator)
     */
    public static List<Vcg> findWithDynamicQuery(DynamicQuery dynamicQuery,
        int start, int end, OrderByComparator orderByComparator)
        throws SystemException {
        return getPersistence()
                   .findWithDynamicQuery(dynamicQuery, start, end,
            orderByComparator);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#update(com.liferay.portal.model.BaseModel)
     */
    public static Vcg update(Vcg vcg) throws SystemException {
        return getPersistence().update(vcg);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#update(com.liferay.portal.model.BaseModel, ServiceContext)
     */
    public static Vcg update(Vcg vcg, ServiceContext serviceContext)
        throws SystemException {
        return getPersistence().update(vcg, serviceContext);
    }

    /**
    * Returns the vcg where veteranId = &#63; or throws a {@link gov.va.caret.NoSuchVcgException} if it could not be found.
    *
    * @param veteranId the veteran ID
    * @return the matching vcg
    * @throws gov.va.caret.NoSuchVcgException if a matching vcg could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Vcg findByVeteran(long veteranId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchVcgException {
        return getPersistence().findByVeteran(veteranId);
    }

    /**
    * Returns the vcg where veteranId = &#63; or returns <code>null</code> if it could not be found. Uses the finder cache.
    *
    * @param veteranId the veteran ID
    * @return the matching vcg, or <code>null</code> if a matching vcg could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Vcg fetchByVeteran(long veteranId)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().fetchByVeteran(veteranId);
    }

    /**
    * Returns the vcg where veteranId = &#63; or returns <code>null</code> if it could not be found, optionally using the finder cache.
    *
    * @param veteranId the veteran ID
    * @param retrieveFromCache whether to use the finder cache
    * @return the matching vcg, or <code>null</code> if a matching vcg could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Vcg fetchByVeteran(long veteranId,
        boolean retrieveFromCache)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().fetchByVeteran(veteranId, retrieveFromCache);
    }

    /**
    * Removes the vcg where veteranId = &#63; from the database.
    *
    * @param veteranId the veteran ID
    * @return the vcg that was removed
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Vcg removeByVeteran(long veteranId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchVcgException {
        return getPersistence().removeByVeteran(veteranId);
    }

    /**
    * Returns the number of vcgs where veteranId = &#63;.
    *
    * @param veteranId the veteran ID
    * @return the number of matching vcgs
    * @throws SystemException if a system exception occurred
    */
    public static int countByVeteran(long veteranId)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().countByVeteran(veteranId);
    }

    /**
    * Caches the vcg in the entity cache if it is enabled.
    *
    * @param vcg the vcg
    */
    public static void cacheResult(gov.va.caret.model.Vcg vcg) {
        getPersistence().cacheResult(vcg);
    }

    /**
    * Caches the vcgs in the entity cache if it is enabled.
    *
    * @param vcgs the vcgs
    */
    public static void cacheResult(java.util.List<gov.va.caret.model.Vcg> vcgs) {
        getPersistence().cacheResult(vcgs);
    }

    /**
    * Creates a new vcg with the primary key. Does not add the vcg to the database.
    *
    * @param vcgId the primary key for the new vcg
    * @return the new vcg
    */
    public static gov.va.caret.model.Vcg create(long vcgId) {
        return getPersistence().create(vcgId);
    }

    /**
    * Removes the vcg with the primary key from the database. Also notifies the appropriate model listeners.
    *
    * @param vcgId the primary key of the vcg
    * @return the vcg that was removed
    * @throws gov.va.caret.NoSuchVcgException if a vcg with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Vcg remove(long vcgId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchVcgException {
        return getPersistence().remove(vcgId);
    }

    public static gov.va.caret.model.Vcg updateImpl(gov.va.caret.model.Vcg vcg)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().updateImpl(vcg);
    }

    /**
    * Returns the vcg with the primary key or throws a {@link gov.va.caret.NoSuchVcgException} if it could not be found.
    *
    * @param vcgId the primary key of the vcg
    * @return the vcg
    * @throws gov.va.caret.NoSuchVcgException if a vcg with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Vcg findByPrimaryKey(long vcgId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchVcgException {
        return getPersistence().findByPrimaryKey(vcgId);
    }

    /**
    * Returns the vcg with the primary key or returns <code>null</code> if it could not be found.
    *
    * @param vcgId the primary key of the vcg
    * @return the vcg, or <code>null</code> if a vcg with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Vcg fetchByPrimaryKey(long vcgId)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().fetchByPrimaryKey(vcgId);
    }

    /**
    * Returns all the vcgs.
    *
    * @return the vcgs
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.Vcg> findAll()
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findAll();
    }

    /**
    * Returns a range of all the vcgs.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.VcgModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of vcgs
    * @param end the upper bound of the range of vcgs (not inclusive)
    * @return the range of vcgs
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.Vcg> findAll(int start,
        int end) throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findAll(start, end);
    }

    /**
    * Returns an ordered range of all the vcgs.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.VcgModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of vcgs
    * @param end the upper bound of the range of vcgs (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of vcgs
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.Vcg> findAll(int start,
        int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findAll(start, end, orderByComparator);
    }

    /**
    * Removes all the vcgs from the database.
    *
    * @throws SystemException if a system exception occurred
    */
    public static void removeAll()
        throws com.liferay.portal.kernel.exception.SystemException {
        getPersistence().removeAll();
    }

    /**
    * Returns the number of vcgs.
    *
    * @return the number of vcgs
    * @throws SystemException if a system exception occurred
    */
    public static int countAll()
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().countAll();
    }

    public static VcgPersistence getPersistence() {
        if (_persistence == null) {
            _persistence = (VcgPersistence) PortletBeanLocatorUtil.locate(gov.va.caret.service.ClpSerializer.getServletContextName(),
                    VcgPersistence.class.getName());

            ReferenceRegistry.registerReference(VcgUtil.class, "_persistence");
        }

        return _persistence;
    }

    /**
     * @deprecated As of 6.2.0
     */
    public void setPersistence(VcgPersistence persistence) {
    }
}
