package gov.va.caret.service.persistence;

import com.liferay.portal.kernel.bean.PortletBeanLocatorUtil;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ReferenceRegistry;
import com.liferay.portal.service.ServiceContext;

import gov.va.caret.model.VcgAn;

import java.util.List;

/**
 * The persistence utility for the vcg an service. This utility wraps {@link VcgAnPersistenceImpl} and provides direct access to the database for CRUD operations. This utility should only be used by the service layer, as it must operate within a transaction. Never access this utility in a JSP, controller, model, or other front-end class.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author caret
 * @see VcgAnPersistence
 * @see VcgAnPersistenceImpl
 * @generated
 */
public class VcgAnUtil {
    private static VcgAnPersistence _persistence;

    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify this class directly. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this class.
     */

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#clearCache()
     */
    public static void clearCache() {
        getPersistence().clearCache();
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#clearCache(com.liferay.portal.model.BaseModel)
     */
    public static void clearCache(VcgAn vcgAn) {
        getPersistence().clearCache(vcgAn);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#countWithDynamicQuery(DynamicQuery)
     */
    public static long countWithDynamicQuery(DynamicQuery dynamicQuery)
        throws SystemException {
        return getPersistence().countWithDynamicQuery(dynamicQuery);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery)
     */
    public static List<VcgAn> findWithDynamicQuery(DynamicQuery dynamicQuery)
        throws SystemException {
        return getPersistence().findWithDynamicQuery(dynamicQuery);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery, int, int)
     */
    public static List<VcgAn> findWithDynamicQuery(DynamicQuery dynamicQuery,
        int start, int end) throws SystemException {
        return getPersistence().findWithDynamicQuery(dynamicQuery, start, end);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery, int, int, OrderByComparator)
     */
    public static List<VcgAn> findWithDynamicQuery(DynamicQuery dynamicQuery,
        int start, int end, OrderByComparator orderByComparator)
        throws SystemException {
        return getPersistence()
                   .findWithDynamicQuery(dynamicQuery, start, end,
            orderByComparator);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#update(com.liferay.portal.model.BaseModel)
     */
    public static VcgAn update(VcgAn vcgAn) throws SystemException {
        return getPersistence().update(vcgAn);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#update(com.liferay.portal.model.BaseModel, ServiceContext)
     */
    public static VcgAn update(VcgAn vcgAn, ServiceContext serviceContext)
        throws SystemException {
        return getPersistence().update(vcgAn, serviceContext);
    }

    /**
    * Returns all the vcg ans where vcgId = &#63;.
    *
    * @param vcgId the vcg ID
    * @return the matching vcg ans
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.VcgAn> findByVcgId(
        long vcgId) throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findByVcgId(vcgId);
    }

    /**
    * Returns a range of all the vcg ans where vcgId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.VcgAnModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param vcgId the vcg ID
    * @param start the lower bound of the range of vcg ans
    * @param end the upper bound of the range of vcg ans (not inclusive)
    * @return the range of matching vcg ans
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.VcgAn> findByVcgId(
        long vcgId, int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findByVcgId(vcgId, start, end);
    }

    /**
    * Returns an ordered range of all the vcg ans where vcgId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.VcgAnModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param vcgId the vcg ID
    * @param start the lower bound of the range of vcg ans
    * @param end the upper bound of the range of vcg ans (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of matching vcg ans
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.VcgAn> findByVcgId(
        long vcgId, int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findByVcgId(vcgId, start, end, orderByComparator);
    }

    /**
    * Returns the first vcg an in the ordered set where vcgId = &#63;.
    *
    * @param vcgId the vcg ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching vcg an
    * @throws gov.va.caret.NoSuchVcgAnException if a matching vcg an could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.VcgAn findByVcgId_First(long vcgId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchVcgAnException {
        return getPersistence().findByVcgId_First(vcgId, orderByComparator);
    }

    /**
    * Returns the first vcg an in the ordered set where vcgId = &#63;.
    *
    * @param vcgId the vcg ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching vcg an, or <code>null</code> if a matching vcg an could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.VcgAn fetchByVcgId_First(long vcgId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().fetchByVcgId_First(vcgId, orderByComparator);
    }

    /**
    * Returns the last vcg an in the ordered set where vcgId = &#63;.
    *
    * @param vcgId the vcg ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching vcg an
    * @throws gov.va.caret.NoSuchVcgAnException if a matching vcg an could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.VcgAn findByVcgId_Last(long vcgId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchVcgAnException {
        return getPersistence().findByVcgId_Last(vcgId, orderByComparator);
    }

    /**
    * Returns the last vcg an in the ordered set where vcgId = &#63;.
    *
    * @param vcgId the vcg ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching vcg an, or <code>null</code> if a matching vcg an could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.VcgAn fetchByVcgId_Last(long vcgId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().fetchByVcgId_Last(vcgId, orderByComparator);
    }

    /**
    * Returns the vcg ans before and after the current vcg an in the ordered set where vcgId = &#63;.
    *
    * @param vcgAnId the primary key of the current vcg an
    * @param vcgId the vcg ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the previous, current, and next vcg an
    * @throws gov.va.caret.NoSuchVcgAnException if a vcg an with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.VcgAn[] findByVcgId_PrevAndNext(
        long vcgAnId, long vcgId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchVcgAnException {
        return getPersistence()
                   .findByVcgId_PrevAndNext(vcgAnId, vcgId, orderByComparator);
    }

    /**
    * Removes all the vcg ans where vcgId = &#63; from the database.
    *
    * @param vcgId the vcg ID
    * @throws SystemException if a system exception occurred
    */
    public static void removeByVcgId(long vcgId)
        throws com.liferay.portal.kernel.exception.SystemException {
        getPersistence().removeByVcgId(vcgId);
    }

    /**
    * Returns the number of vcg ans where vcgId = &#63;.
    *
    * @param vcgId the vcg ID
    * @return the number of matching vcg ans
    * @throws SystemException if a system exception occurred
    */
    public static int countByVcgId(long vcgId)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().countByVcgId(vcgId);
    }

    /**
    * Returns all the vcg ans where veteranId = &#63;.
    *
    * @param veteranId the veteran ID
    * @return the matching vcg ans
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.VcgAn> findByVeteranId(
        long veteranId)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findByVeteranId(veteranId);
    }

    /**
    * Returns a range of all the vcg ans where veteranId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.VcgAnModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param veteranId the veteran ID
    * @param start the lower bound of the range of vcg ans
    * @param end the upper bound of the range of vcg ans (not inclusive)
    * @return the range of matching vcg ans
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.VcgAn> findByVeteranId(
        long veteranId, int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findByVeteranId(veteranId, start, end);
    }

    /**
    * Returns an ordered range of all the vcg ans where veteranId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.VcgAnModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param veteranId the veteran ID
    * @param start the lower bound of the range of vcg ans
    * @param end the upper bound of the range of vcg ans (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of matching vcg ans
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.VcgAn> findByVeteranId(
        long veteranId, int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence()
                   .findByVeteranId(veteranId, start, end, orderByComparator);
    }

    /**
    * Returns the first vcg an in the ordered set where veteranId = &#63;.
    *
    * @param veteranId the veteran ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching vcg an
    * @throws gov.va.caret.NoSuchVcgAnException if a matching vcg an could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.VcgAn findByVeteranId_First(
        long veteranId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchVcgAnException {
        return getPersistence()
                   .findByVeteranId_First(veteranId, orderByComparator);
    }

    /**
    * Returns the first vcg an in the ordered set where veteranId = &#63;.
    *
    * @param veteranId the veteran ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching vcg an, or <code>null</code> if a matching vcg an could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.VcgAn fetchByVeteranId_First(
        long veteranId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence()
                   .fetchByVeteranId_First(veteranId, orderByComparator);
    }

    /**
    * Returns the last vcg an in the ordered set where veteranId = &#63;.
    *
    * @param veteranId the veteran ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching vcg an
    * @throws gov.va.caret.NoSuchVcgAnException if a matching vcg an could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.VcgAn findByVeteranId_Last(
        long veteranId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchVcgAnException {
        return getPersistence()
                   .findByVeteranId_Last(veteranId, orderByComparator);
    }

    /**
    * Returns the last vcg an in the ordered set where veteranId = &#63;.
    *
    * @param veteranId the veteran ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching vcg an, or <code>null</code> if a matching vcg an could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.VcgAn fetchByVeteranId_Last(
        long veteranId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence()
                   .fetchByVeteranId_Last(veteranId, orderByComparator);
    }

    /**
    * Returns the vcg ans before and after the current vcg an in the ordered set where veteranId = &#63;.
    *
    * @param vcgAnId the primary key of the current vcg an
    * @param veteranId the veteran ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the previous, current, and next vcg an
    * @throws gov.va.caret.NoSuchVcgAnException if a vcg an with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.VcgAn[] findByVeteranId_PrevAndNext(
        long vcgAnId, long veteranId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchVcgAnException {
        return getPersistence()
                   .findByVeteranId_PrevAndNext(vcgAnId, veteranId,
            orderByComparator);
    }

    /**
    * Removes all the vcg ans where veteranId = &#63; from the database.
    *
    * @param veteranId the veteran ID
    * @throws SystemException if a system exception occurred
    */
    public static void removeByVeteranId(long veteranId)
        throws com.liferay.portal.kernel.exception.SystemException {
        getPersistence().removeByVeteranId(veteranId);
    }

    /**
    * Returns the number of vcg ans where veteranId = &#63;.
    *
    * @param veteranId the veteran ID
    * @return the number of matching vcg ans
    * @throws SystemException if a system exception occurred
    */
    public static int countByVeteranId(long veteranId)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().countByVeteranId(veteranId);
    }

    /**
    * Returns all the vcg ans where primaryId = &#63;.
    *
    * @param primaryId the primary ID
    * @return the matching vcg ans
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.VcgAn> findByPrimaryId(
        long primaryId)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findByPrimaryId(primaryId);
    }

    /**
    * Returns a range of all the vcg ans where primaryId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.VcgAnModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param primaryId the primary ID
    * @param start the lower bound of the range of vcg ans
    * @param end the upper bound of the range of vcg ans (not inclusive)
    * @return the range of matching vcg ans
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.VcgAn> findByPrimaryId(
        long primaryId, int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findByPrimaryId(primaryId, start, end);
    }

    /**
    * Returns an ordered range of all the vcg ans where primaryId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.VcgAnModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param primaryId the primary ID
    * @param start the lower bound of the range of vcg ans
    * @param end the upper bound of the range of vcg ans (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of matching vcg ans
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.VcgAn> findByPrimaryId(
        long primaryId, int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence()
                   .findByPrimaryId(primaryId, start, end, orderByComparator);
    }

    /**
    * Returns the first vcg an in the ordered set where primaryId = &#63;.
    *
    * @param primaryId the primary ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching vcg an
    * @throws gov.va.caret.NoSuchVcgAnException if a matching vcg an could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.VcgAn findByPrimaryId_First(
        long primaryId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchVcgAnException {
        return getPersistence()
                   .findByPrimaryId_First(primaryId, orderByComparator);
    }

    /**
    * Returns the first vcg an in the ordered set where primaryId = &#63;.
    *
    * @param primaryId the primary ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching vcg an, or <code>null</code> if a matching vcg an could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.VcgAn fetchByPrimaryId_First(
        long primaryId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence()
                   .fetchByPrimaryId_First(primaryId, orderByComparator);
    }

    /**
    * Returns the last vcg an in the ordered set where primaryId = &#63;.
    *
    * @param primaryId the primary ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching vcg an
    * @throws gov.va.caret.NoSuchVcgAnException if a matching vcg an could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.VcgAn findByPrimaryId_Last(
        long primaryId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchVcgAnException {
        return getPersistence()
                   .findByPrimaryId_Last(primaryId, orderByComparator);
    }

    /**
    * Returns the last vcg an in the ordered set where primaryId = &#63;.
    *
    * @param primaryId the primary ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching vcg an, or <code>null</code> if a matching vcg an could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.VcgAn fetchByPrimaryId_Last(
        long primaryId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence()
                   .fetchByPrimaryId_Last(primaryId, orderByComparator);
    }

    /**
    * Returns the vcg ans before and after the current vcg an in the ordered set where primaryId = &#63;.
    *
    * @param vcgAnId the primary key of the current vcg an
    * @param primaryId the primary ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the previous, current, and next vcg an
    * @throws gov.va.caret.NoSuchVcgAnException if a vcg an with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.VcgAn[] findByPrimaryId_PrevAndNext(
        long vcgAnId, long primaryId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchVcgAnException {
        return getPersistence()
                   .findByPrimaryId_PrevAndNext(vcgAnId, primaryId,
            orderByComparator);
    }

    /**
    * Removes all the vcg ans where primaryId = &#63; from the database.
    *
    * @param primaryId the primary ID
    * @throws SystemException if a system exception occurred
    */
    public static void removeByPrimaryId(long primaryId)
        throws com.liferay.portal.kernel.exception.SystemException {
        getPersistence().removeByPrimaryId(primaryId);
    }

    /**
    * Returns the number of vcg ans where primaryId = &#63;.
    *
    * @param primaryId the primary ID
    * @return the number of matching vcg ans
    * @throws SystemException if a system exception occurred
    */
    public static int countByPrimaryId(long primaryId)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().countByPrimaryId(primaryId);
    }

    /**
    * Returns all the vcg ans where secondaryId = &#63;.
    *
    * @param secondaryId the secondary ID
    * @return the matching vcg ans
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.VcgAn> findBySecondaryId(
        long secondaryId)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findBySecondaryId(secondaryId);
    }

    /**
    * Returns a range of all the vcg ans where secondaryId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.VcgAnModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param secondaryId the secondary ID
    * @param start the lower bound of the range of vcg ans
    * @param end the upper bound of the range of vcg ans (not inclusive)
    * @return the range of matching vcg ans
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.VcgAn> findBySecondaryId(
        long secondaryId, int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findBySecondaryId(secondaryId, start, end);
    }

    /**
    * Returns an ordered range of all the vcg ans where secondaryId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.VcgAnModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param secondaryId the secondary ID
    * @param start the lower bound of the range of vcg ans
    * @param end the upper bound of the range of vcg ans (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of matching vcg ans
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.VcgAn> findBySecondaryId(
        long secondaryId, int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence()
                   .findBySecondaryId(secondaryId, start, end, orderByComparator);
    }

    /**
    * Returns the first vcg an in the ordered set where secondaryId = &#63;.
    *
    * @param secondaryId the secondary ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching vcg an
    * @throws gov.va.caret.NoSuchVcgAnException if a matching vcg an could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.VcgAn findBySecondaryId_First(
        long secondaryId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchVcgAnException {
        return getPersistence()
                   .findBySecondaryId_First(secondaryId, orderByComparator);
    }

    /**
    * Returns the first vcg an in the ordered set where secondaryId = &#63;.
    *
    * @param secondaryId the secondary ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching vcg an, or <code>null</code> if a matching vcg an could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.VcgAn fetchBySecondaryId_First(
        long secondaryId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence()
                   .fetchBySecondaryId_First(secondaryId, orderByComparator);
    }

    /**
    * Returns the last vcg an in the ordered set where secondaryId = &#63;.
    *
    * @param secondaryId the secondary ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching vcg an
    * @throws gov.va.caret.NoSuchVcgAnException if a matching vcg an could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.VcgAn findBySecondaryId_Last(
        long secondaryId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchVcgAnException {
        return getPersistence()
                   .findBySecondaryId_Last(secondaryId, orderByComparator);
    }

    /**
    * Returns the last vcg an in the ordered set where secondaryId = &#63;.
    *
    * @param secondaryId the secondary ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching vcg an, or <code>null</code> if a matching vcg an could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.VcgAn fetchBySecondaryId_Last(
        long secondaryId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence()
                   .fetchBySecondaryId_Last(secondaryId, orderByComparator);
    }

    /**
    * Returns the vcg ans before and after the current vcg an in the ordered set where secondaryId = &#63;.
    *
    * @param vcgAnId the primary key of the current vcg an
    * @param secondaryId the secondary ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the previous, current, and next vcg an
    * @throws gov.va.caret.NoSuchVcgAnException if a vcg an with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.VcgAn[] findBySecondaryId_PrevAndNext(
        long vcgAnId, long secondaryId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchVcgAnException {
        return getPersistence()
                   .findBySecondaryId_PrevAndNext(vcgAnId, secondaryId,
            orderByComparator);
    }

    /**
    * Removes all the vcg ans where secondaryId = &#63; from the database.
    *
    * @param secondaryId the secondary ID
    * @throws SystemException if a system exception occurred
    */
    public static void removeBySecondaryId(long secondaryId)
        throws com.liferay.portal.kernel.exception.SystemException {
        getPersistence().removeBySecondaryId(secondaryId);
    }

    /**
    * Returns the number of vcg ans where secondaryId = &#63;.
    *
    * @param secondaryId the secondary ID
    * @return the number of matching vcg ans
    * @throws SystemException if a system exception occurred
    */
    public static int countBySecondaryId(long secondaryId)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().countBySecondaryId(secondaryId);
    }

    /**
    * Returns all the vcg ans where secondaryTwoId = &#63;.
    *
    * @param secondaryTwoId the secondary two ID
    * @return the matching vcg ans
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.VcgAn> findBySecondaryTwoId(
        long secondaryTwoId)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findBySecondaryTwoId(secondaryTwoId);
    }

    /**
    * Returns a range of all the vcg ans where secondaryTwoId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.VcgAnModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param secondaryTwoId the secondary two ID
    * @param start the lower bound of the range of vcg ans
    * @param end the upper bound of the range of vcg ans (not inclusive)
    * @return the range of matching vcg ans
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.VcgAn> findBySecondaryTwoId(
        long secondaryTwoId, int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findBySecondaryTwoId(secondaryTwoId, start, end);
    }

    /**
    * Returns an ordered range of all the vcg ans where secondaryTwoId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.VcgAnModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param secondaryTwoId the secondary two ID
    * @param start the lower bound of the range of vcg ans
    * @param end the upper bound of the range of vcg ans (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of matching vcg ans
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.VcgAn> findBySecondaryTwoId(
        long secondaryTwoId, int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence()
                   .findBySecondaryTwoId(secondaryTwoId, start, end,
            orderByComparator);
    }

    /**
    * Returns the first vcg an in the ordered set where secondaryTwoId = &#63;.
    *
    * @param secondaryTwoId the secondary two ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching vcg an
    * @throws gov.va.caret.NoSuchVcgAnException if a matching vcg an could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.VcgAn findBySecondaryTwoId_First(
        long secondaryTwoId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchVcgAnException {
        return getPersistence()
                   .findBySecondaryTwoId_First(secondaryTwoId, orderByComparator);
    }

    /**
    * Returns the first vcg an in the ordered set where secondaryTwoId = &#63;.
    *
    * @param secondaryTwoId the secondary two ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching vcg an, or <code>null</code> if a matching vcg an could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.VcgAn fetchBySecondaryTwoId_First(
        long secondaryTwoId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence()
                   .fetchBySecondaryTwoId_First(secondaryTwoId,
            orderByComparator);
    }

    /**
    * Returns the last vcg an in the ordered set where secondaryTwoId = &#63;.
    *
    * @param secondaryTwoId the secondary two ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching vcg an
    * @throws gov.va.caret.NoSuchVcgAnException if a matching vcg an could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.VcgAn findBySecondaryTwoId_Last(
        long secondaryTwoId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchVcgAnException {
        return getPersistence()
                   .findBySecondaryTwoId_Last(secondaryTwoId, orderByComparator);
    }

    /**
    * Returns the last vcg an in the ordered set where secondaryTwoId = &#63;.
    *
    * @param secondaryTwoId the secondary two ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching vcg an, or <code>null</code> if a matching vcg an could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.VcgAn fetchBySecondaryTwoId_Last(
        long secondaryTwoId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence()
                   .fetchBySecondaryTwoId_Last(secondaryTwoId, orderByComparator);
    }

    /**
    * Returns the vcg ans before and after the current vcg an in the ordered set where secondaryTwoId = &#63;.
    *
    * @param vcgAnId the primary key of the current vcg an
    * @param secondaryTwoId the secondary two ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the previous, current, and next vcg an
    * @throws gov.va.caret.NoSuchVcgAnException if a vcg an with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.VcgAn[] findBySecondaryTwoId_PrevAndNext(
        long vcgAnId, long secondaryTwoId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchVcgAnException {
        return getPersistence()
                   .findBySecondaryTwoId_PrevAndNext(vcgAnId, secondaryTwoId,
            orderByComparator);
    }

    /**
    * Removes all the vcg ans where secondaryTwoId = &#63; from the database.
    *
    * @param secondaryTwoId the secondary two ID
    * @throws SystemException if a system exception occurred
    */
    public static void removeBySecondaryTwoId(long secondaryTwoId)
        throws com.liferay.portal.kernel.exception.SystemException {
        getPersistence().removeBySecondaryTwoId(secondaryTwoId);
    }

    /**
    * Returns the number of vcg ans where secondaryTwoId = &#63;.
    *
    * @param secondaryTwoId the secondary two ID
    * @return the number of matching vcg ans
    * @throws SystemException if a system exception occurred
    */
    public static int countBySecondaryTwoId(long secondaryTwoId)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().countBySecondaryTwoId(secondaryTwoId);
    }

    /**
    * Returns all the vcg ans where primaryId &gt; &#63; and veteranId = &#63;.
    *
    * @param primaryId the primary ID
    * @param veteranId the veteran ID
    * @return the matching vcg ans
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.VcgAn> findByPrimaryApp(
        long primaryId, long veteranId)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findByPrimaryApp(primaryId, veteranId);
    }

    /**
    * Returns a range of all the vcg ans where primaryId &gt; &#63; and veteranId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.VcgAnModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param primaryId the primary ID
    * @param veteranId the veteran ID
    * @param start the lower bound of the range of vcg ans
    * @param end the upper bound of the range of vcg ans (not inclusive)
    * @return the range of matching vcg ans
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.VcgAn> findByPrimaryApp(
        long primaryId, long veteranId, int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence()
                   .findByPrimaryApp(primaryId, veteranId, start, end);
    }

    /**
    * Returns an ordered range of all the vcg ans where primaryId &gt; &#63; and veteranId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.VcgAnModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param primaryId the primary ID
    * @param veteranId the veteran ID
    * @param start the lower bound of the range of vcg ans
    * @param end the upper bound of the range of vcg ans (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of matching vcg ans
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.VcgAn> findByPrimaryApp(
        long primaryId, long veteranId, int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence()
                   .findByPrimaryApp(primaryId, veteranId, start, end,
            orderByComparator);
    }

    /**
    * Returns the first vcg an in the ordered set where primaryId &gt; &#63; and veteranId = &#63;.
    *
    * @param primaryId the primary ID
    * @param veteranId the veteran ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching vcg an
    * @throws gov.va.caret.NoSuchVcgAnException if a matching vcg an could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.VcgAn findByPrimaryApp_First(
        long primaryId, long veteranId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchVcgAnException {
        return getPersistence()
                   .findByPrimaryApp_First(primaryId, veteranId,
            orderByComparator);
    }

    /**
    * Returns the first vcg an in the ordered set where primaryId &gt; &#63; and veteranId = &#63;.
    *
    * @param primaryId the primary ID
    * @param veteranId the veteran ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching vcg an, or <code>null</code> if a matching vcg an could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.VcgAn fetchByPrimaryApp_First(
        long primaryId, long veteranId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence()
                   .fetchByPrimaryApp_First(primaryId, veteranId,
            orderByComparator);
    }

    /**
    * Returns the last vcg an in the ordered set where primaryId &gt; &#63; and veteranId = &#63;.
    *
    * @param primaryId the primary ID
    * @param veteranId the veteran ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching vcg an
    * @throws gov.va.caret.NoSuchVcgAnException if a matching vcg an could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.VcgAn findByPrimaryApp_Last(
        long primaryId, long veteranId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchVcgAnException {
        return getPersistence()
                   .findByPrimaryApp_Last(primaryId, veteranId,
            orderByComparator);
    }

    /**
    * Returns the last vcg an in the ordered set where primaryId &gt; &#63; and veteranId = &#63;.
    *
    * @param primaryId the primary ID
    * @param veteranId the veteran ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching vcg an, or <code>null</code> if a matching vcg an could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.VcgAn fetchByPrimaryApp_Last(
        long primaryId, long veteranId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence()
                   .fetchByPrimaryApp_Last(primaryId, veteranId,
            orderByComparator);
    }

    /**
    * Returns the vcg ans before and after the current vcg an in the ordered set where primaryId &gt; &#63; and veteranId = &#63;.
    *
    * @param vcgAnId the primary key of the current vcg an
    * @param primaryId the primary ID
    * @param veteranId the veteran ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the previous, current, and next vcg an
    * @throws gov.va.caret.NoSuchVcgAnException if a vcg an with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.VcgAn[] findByPrimaryApp_PrevAndNext(
        long vcgAnId, long primaryId, long veteranId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchVcgAnException {
        return getPersistence()
                   .findByPrimaryApp_PrevAndNext(vcgAnId, primaryId, veteranId,
            orderByComparator);
    }

    /**
    * Removes all the vcg ans where primaryId &gt; &#63; and veteranId = &#63; from the database.
    *
    * @param primaryId the primary ID
    * @param veteranId the veteran ID
    * @throws SystemException if a system exception occurred
    */
    public static void removeByPrimaryApp(long primaryId, long veteranId)
        throws com.liferay.portal.kernel.exception.SystemException {
        getPersistence().removeByPrimaryApp(primaryId, veteranId);
    }

    /**
    * Returns the number of vcg ans where primaryId &gt; &#63; and veteranId = &#63;.
    *
    * @param primaryId the primary ID
    * @param veteranId the veteran ID
    * @return the number of matching vcg ans
    * @throws SystemException if a system exception occurred
    */
    public static int countByPrimaryApp(long primaryId, long veteranId)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().countByPrimaryApp(primaryId, veteranId);
    }

    /**
    * Caches the vcg an in the entity cache if it is enabled.
    *
    * @param vcgAn the vcg an
    */
    public static void cacheResult(gov.va.caret.model.VcgAn vcgAn) {
        getPersistence().cacheResult(vcgAn);
    }

    /**
    * Caches the vcg ans in the entity cache if it is enabled.
    *
    * @param vcgAns the vcg ans
    */
    public static void cacheResult(
        java.util.List<gov.va.caret.model.VcgAn> vcgAns) {
        getPersistence().cacheResult(vcgAns);
    }

    /**
    * Creates a new vcg an with the primary key. Does not add the vcg an to the database.
    *
    * @param vcgAnId the primary key for the new vcg an
    * @return the new vcg an
    */
    public static gov.va.caret.model.VcgAn create(long vcgAnId) {
        return getPersistence().create(vcgAnId);
    }

    /**
    * Removes the vcg an with the primary key from the database. Also notifies the appropriate model listeners.
    *
    * @param vcgAnId the primary key of the vcg an
    * @return the vcg an that was removed
    * @throws gov.va.caret.NoSuchVcgAnException if a vcg an with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.VcgAn remove(long vcgAnId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchVcgAnException {
        return getPersistence().remove(vcgAnId);
    }

    public static gov.va.caret.model.VcgAn updateImpl(
        gov.va.caret.model.VcgAn vcgAn)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().updateImpl(vcgAn);
    }

    /**
    * Returns the vcg an with the primary key or throws a {@link gov.va.caret.NoSuchVcgAnException} if it could not be found.
    *
    * @param vcgAnId the primary key of the vcg an
    * @return the vcg an
    * @throws gov.va.caret.NoSuchVcgAnException if a vcg an with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.VcgAn findByPrimaryKey(long vcgAnId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchVcgAnException {
        return getPersistence().findByPrimaryKey(vcgAnId);
    }

    /**
    * Returns the vcg an with the primary key or returns <code>null</code> if it could not be found.
    *
    * @param vcgAnId the primary key of the vcg an
    * @return the vcg an, or <code>null</code> if a vcg an with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.VcgAn fetchByPrimaryKey(long vcgAnId)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().fetchByPrimaryKey(vcgAnId);
    }

    /**
    * Returns all the vcg ans.
    *
    * @return the vcg ans
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.VcgAn> findAll()
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findAll();
    }

    /**
    * Returns a range of all the vcg ans.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.VcgAnModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of vcg ans
    * @param end the upper bound of the range of vcg ans (not inclusive)
    * @return the range of vcg ans
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.VcgAn> findAll(int start,
        int end) throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findAll(start, end);
    }

    /**
    * Returns an ordered range of all the vcg ans.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.VcgAnModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of vcg ans
    * @param end the upper bound of the range of vcg ans (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of vcg ans
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.VcgAn> findAll(int start,
        int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findAll(start, end, orderByComparator);
    }

    /**
    * Removes all the vcg ans from the database.
    *
    * @throws SystemException if a system exception occurred
    */
    public static void removeAll()
        throws com.liferay.portal.kernel.exception.SystemException {
        getPersistence().removeAll();
    }

    /**
    * Returns the number of vcg ans.
    *
    * @return the number of vcg ans
    * @throws SystemException if a system exception occurred
    */
    public static int countAll()
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().countAll();
    }

    public static VcgAnPersistence getPersistence() {
        if (_persistence == null) {
            _persistence = (VcgAnPersistence) PortletBeanLocatorUtil.locate(gov.va.caret.service.ClpSerializer.getServletContextName(),
                    VcgAnPersistence.class.getName());

            ReferenceRegistry.registerReference(VcgAnUtil.class, "_persistence");
        }

        return _persistence;
    }

    /**
     * @deprecated As of 6.2.0
     */
    public void setPersistence(VcgAnPersistence persistence) {
    }
}
