package gov.va.caret.service.persistence;

import com.liferay.portal.kernel.bean.PortletBeanLocatorUtil;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ReferenceRegistry;
import com.liferay.portal.service.ServiceContext;

import gov.va.caret.model.StiRd;

import java.util.List;

/**
 * The persistence utility for the sti rd service. This utility wraps {@link StiRdPersistenceImpl} and provides direct access to the database for CRUD operations. This utility should only be used by the service layer, as it must operate within a transaction. Never access this utility in a JSP, controller, model, or other front-end class.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author caret
 * @see StiRdPersistence
 * @see StiRdPersistenceImpl
 * @generated
 */
public class StiRdUtil {
    private static StiRdPersistence _persistence;

    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify this class directly. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this class.
     */

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#clearCache()
     */
    public static void clearCache() {
        getPersistence().clearCache();
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#clearCache(com.liferay.portal.model.BaseModel)
     */
    public static void clearCache(StiRd stiRd) {
        getPersistence().clearCache(stiRd);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#countWithDynamicQuery(DynamicQuery)
     */
    public static long countWithDynamicQuery(DynamicQuery dynamicQuery)
        throws SystemException {
        return getPersistence().countWithDynamicQuery(dynamicQuery);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery)
     */
    public static List<StiRd> findWithDynamicQuery(DynamicQuery dynamicQuery)
        throws SystemException {
        return getPersistence().findWithDynamicQuery(dynamicQuery);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery, int, int)
     */
    public static List<StiRd> findWithDynamicQuery(DynamicQuery dynamicQuery,
        int start, int end) throws SystemException {
        return getPersistence().findWithDynamicQuery(dynamicQuery, start, end);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery, int, int, OrderByComparator)
     */
    public static List<StiRd> findWithDynamicQuery(DynamicQuery dynamicQuery,
        int start, int end, OrderByComparator orderByComparator)
        throws SystemException {
        return getPersistence()
                   .findWithDynamicQuery(dynamicQuery, start, end,
            orderByComparator);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#update(com.liferay.portal.model.BaseModel)
     */
    public static StiRd update(StiRd stiRd) throws SystemException {
        return getPersistence().update(stiRd);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#update(com.liferay.portal.model.BaseModel, ServiceContext)
     */
    public static StiRd update(StiRd stiRd, ServiceContext serviceContext)
        throws SystemException {
        return getPersistence().update(stiRd, serviceContext);
    }

    /**
    * Returns all the sti rds where vcgAnId = &#63;.
    *
    * @param vcgAnId the vcg an ID
    * @return the matching sti rds
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.StiRd> findByVcgAnId(
        long vcgAnId)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findByVcgAnId(vcgAnId);
    }

    /**
    * Returns a range of all the sti rds where vcgAnId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.StiRdModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param vcgAnId the vcg an ID
    * @param start the lower bound of the range of sti rds
    * @param end the upper bound of the range of sti rds (not inclusive)
    * @return the range of matching sti rds
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.StiRd> findByVcgAnId(
        long vcgAnId, int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findByVcgAnId(vcgAnId, start, end);
    }

    /**
    * Returns an ordered range of all the sti rds where vcgAnId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.StiRdModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param vcgAnId the vcg an ID
    * @param start the lower bound of the range of sti rds
    * @param end the upper bound of the range of sti rds (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of matching sti rds
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.StiRd> findByVcgAnId(
        long vcgAnId, int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence()
                   .findByVcgAnId(vcgAnId, start, end, orderByComparator);
    }

    /**
    * Returns the first sti rd in the ordered set where vcgAnId = &#63;.
    *
    * @param vcgAnId the vcg an ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching sti rd
    * @throws gov.va.caret.NoSuchStiRdException if a matching sti rd could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.StiRd findByVcgAnId_First(long vcgAnId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchStiRdException {
        return getPersistence().findByVcgAnId_First(vcgAnId, orderByComparator);
    }

    /**
    * Returns the first sti rd in the ordered set where vcgAnId = &#63;.
    *
    * @param vcgAnId the vcg an ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching sti rd, or <code>null</code> if a matching sti rd could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.StiRd fetchByVcgAnId_First(long vcgAnId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().fetchByVcgAnId_First(vcgAnId, orderByComparator);
    }

    /**
    * Returns the last sti rd in the ordered set where vcgAnId = &#63;.
    *
    * @param vcgAnId the vcg an ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching sti rd
    * @throws gov.va.caret.NoSuchStiRdException if a matching sti rd could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.StiRd findByVcgAnId_Last(long vcgAnId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchStiRdException {
        return getPersistence().findByVcgAnId_Last(vcgAnId, orderByComparator);
    }

    /**
    * Returns the last sti rd in the ordered set where vcgAnId = &#63;.
    *
    * @param vcgAnId the vcg an ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching sti rd, or <code>null</code> if a matching sti rd could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.StiRd fetchByVcgAnId_Last(long vcgAnId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().fetchByVcgAnId_Last(vcgAnId, orderByComparator);
    }

    /**
    * Returns the sti rds before and after the current sti rd in the ordered set where vcgAnId = &#63;.
    *
    * @param stiRdId the primary key of the current sti rd
    * @param vcgAnId the vcg an ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the previous, current, and next sti rd
    * @throws gov.va.caret.NoSuchStiRdException if a sti rd with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.StiRd[] findByVcgAnId_PrevAndNext(
        long stiRdId, long vcgAnId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchStiRdException {
        return getPersistence()
                   .findByVcgAnId_PrevAndNext(stiRdId, vcgAnId,
            orderByComparator);
    }

    /**
    * Removes all the sti rds where vcgAnId = &#63; from the database.
    *
    * @param vcgAnId the vcg an ID
    * @throws SystemException if a system exception occurred
    */
    public static void removeByVcgAnId(long vcgAnId)
        throws com.liferay.portal.kernel.exception.SystemException {
        getPersistence().removeByVcgAnId(vcgAnId);
    }

    /**
    * Returns the number of sti rds where vcgAnId = &#63;.
    *
    * @param vcgAnId the vcg an ID
    * @return the number of matching sti rds
    * @throws SystemException if a system exception occurred
    */
    public static int countByVcgAnId(long vcgAnId)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().countByVcgAnId(vcgAnId);
    }

    /**
    * Caches the sti rd in the entity cache if it is enabled.
    *
    * @param stiRd the sti rd
    */
    public static void cacheResult(gov.va.caret.model.StiRd stiRd) {
        getPersistence().cacheResult(stiRd);
    }

    /**
    * Caches the sti rds in the entity cache if it is enabled.
    *
    * @param stiRds the sti rds
    */
    public static void cacheResult(
        java.util.List<gov.va.caret.model.StiRd> stiRds) {
        getPersistence().cacheResult(stiRds);
    }

    /**
    * Creates a new sti rd with the primary key. Does not add the sti rd to the database.
    *
    * @param stiRdId the primary key for the new sti rd
    * @return the new sti rd
    */
    public static gov.va.caret.model.StiRd create(long stiRdId) {
        return getPersistence().create(stiRdId);
    }

    /**
    * Removes the sti rd with the primary key from the database. Also notifies the appropriate model listeners.
    *
    * @param stiRdId the primary key of the sti rd
    * @return the sti rd that was removed
    * @throws gov.va.caret.NoSuchStiRdException if a sti rd with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.StiRd remove(long stiRdId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchStiRdException {
        return getPersistence().remove(stiRdId);
    }

    public static gov.va.caret.model.StiRd updateImpl(
        gov.va.caret.model.StiRd stiRd)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().updateImpl(stiRd);
    }

    /**
    * Returns the sti rd with the primary key or throws a {@link gov.va.caret.NoSuchStiRdException} if it could not be found.
    *
    * @param stiRdId the primary key of the sti rd
    * @return the sti rd
    * @throws gov.va.caret.NoSuchStiRdException if a sti rd with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.StiRd findByPrimaryKey(long stiRdId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchStiRdException {
        return getPersistence().findByPrimaryKey(stiRdId);
    }

    /**
    * Returns the sti rd with the primary key or returns <code>null</code> if it could not be found.
    *
    * @param stiRdId the primary key of the sti rd
    * @return the sti rd, or <code>null</code> if a sti rd with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.StiRd fetchByPrimaryKey(long stiRdId)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().fetchByPrimaryKey(stiRdId);
    }

    /**
    * Returns all the sti rds.
    *
    * @return the sti rds
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.StiRd> findAll()
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findAll();
    }

    /**
    * Returns a range of all the sti rds.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.StiRdModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of sti rds
    * @param end the upper bound of the range of sti rds (not inclusive)
    * @return the range of sti rds
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.StiRd> findAll(int start,
        int end) throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findAll(start, end);
    }

    /**
    * Returns an ordered range of all the sti rds.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.StiRdModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of sti rds
    * @param end the upper bound of the range of sti rds (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of sti rds
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.StiRd> findAll(int start,
        int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findAll(start, end, orderByComparator);
    }

    /**
    * Removes all the sti rds from the database.
    *
    * @throws SystemException if a system exception occurred
    */
    public static void removeAll()
        throws com.liferay.portal.kernel.exception.SystemException {
        getPersistence().removeAll();
    }

    /**
    * Returns the number of sti rds.
    *
    * @return the number of sti rds
    * @throws SystemException if a system exception occurred
    */
    public static int countAll()
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().countAll();
    }

    public static StiRdPersistence getPersistence() {
        if (_persistence == null) {
            _persistence = (StiRdPersistence) PortletBeanLocatorUtil.locate(gov.va.caret.service.ClpSerializer.getServletContextName(),
                    StiRdPersistence.class.getName());

            ReferenceRegistry.registerReference(StiRdUtil.class, "_persistence");
        }

        return _persistence;
    }

    /**
     * @deprecated As of 6.2.0
     */
    public void setPersistence(StiRdPersistence persistence) {
    }
}
