package gov.va.caret.service.persistence;

import com.liferay.portal.kernel.bean.PortletBeanLocatorUtil;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ReferenceRegistry;
import com.liferay.portal.service.ServiceContext;

import gov.va.caret.model.StiPt;

import java.util.List;

/**
 * The persistence utility for the sti pt service. This utility wraps {@link StiPtPersistenceImpl} and provides direct access to the database for CRUD operations. This utility should only be used by the service layer, as it must operate within a transaction. Never access this utility in a JSP, controller, model, or other front-end class.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author caret
 * @see StiPtPersistence
 * @see StiPtPersistenceImpl
 * @generated
 */
public class StiPtUtil {
    private static StiPtPersistence _persistence;

    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify this class directly. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this class.
     */

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#clearCache()
     */
    public static void clearCache() {
        getPersistence().clearCache();
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#clearCache(com.liferay.portal.model.BaseModel)
     */
    public static void clearCache(StiPt stiPt) {
        getPersistence().clearCache(stiPt);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#countWithDynamicQuery(DynamicQuery)
     */
    public static long countWithDynamicQuery(DynamicQuery dynamicQuery)
        throws SystemException {
        return getPersistence().countWithDynamicQuery(dynamicQuery);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery)
     */
    public static List<StiPt> findWithDynamicQuery(DynamicQuery dynamicQuery)
        throws SystemException {
        return getPersistence().findWithDynamicQuery(dynamicQuery);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery, int, int)
     */
    public static List<StiPt> findWithDynamicQuery(DynamicQuery dynamicQuery,
        int start, int end) throws SystemException {
        return getPersistence().findWithDynamicQuery(dynamicQuery, start, end);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery, int, int, OrderByComparator)
     */
    public static List<StiPt> findWithDynamicQuery(DynamicQuery dynamicQuery,
        int start, int end, OrderByComparator orderByComparator)
        throws SystemException {
        return getPersistence()
                   .findWithDynamicQuery(dynamicQuery, start, end,
            orderByComparator);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#update(com.liferay.portal.model.BaseModel)
     */
    public static StiPt update(StiPt stiPt) throws SystemException {
        return getPersistence().update(stiPt);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#update(com.liferay.portal.model.BaseModel, ServiceContext)
     */
    public static StiPt update(StiPt stiPt, ServiceContext serviceContext)
        throws SystemException {
        return getPersistence().update(stiPt, serviceContext);
    }

    /**
    * Returns all the sti pts where stiRdId = &#63;.
    *
    * @param stiRdId the sti rd ID
    * @return the matching sti pts
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.StiPt> findByStiRdId(
        long stiRdId)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findByStiRdId(stiRdId);
    }

    /**
    * Returns a range of all the sti pts where stiRdId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.StiPtModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param stiRdId the sti rd ID
    * @param start the lower bound of the range of sti pts
    * @param end the upper bound of the range of sti pts (not inclusive)
    * @return the range of matching sti pts
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.StiPt> findByStiRdId(
        long stiRdId, int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findByStiRdId(stiRdId, start, end);
    }

    /**
    * Returns an ordered range of all the sti pts where stiRdId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.StiPtModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param stiRdId the sti rd ID
    * @param start the lower bound of the range of sti pts
    * @param end the upper bound of the range of sti pts (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of matching sti pts
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.StiPt> findByStiRdId(
        long stiRdId, int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence()
                   .findByStiRdId(stiRdId, start, end, orderByComparator);
    }

    /**
    * Returns the first sti pt in the ordered set where stiRdId = &#63;.
    *
    * @param stiRdId the sti rd ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching sti pt
    * @throws gov.va.caret.NoSuchStiPtException if a matching sti pt could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.StiPt findByStiRdId_First(long stiRdId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchStiPtException {
        return getPersistence().findByStiRdId_First(stiRdId, orderByComparator);
    }

    /**
    * Returns the first sti pt in the ordered set where stiRdId = &#63;.
    *
    * @param stiRdId the sti rd ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching sti pt, or <code>null</code> if a matching sti pt could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.StiPt fetchByStiRdId_First(long stiRdId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().fetchByStiRdId_First(stiRdId, orderByComparator);
    }

    /**
    * Returns the last sti pt in the ordered set where stiRdId = &#63;.
    *
    * @param stiRdId the sti rd ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching sti pt
    * @throws gov.va.caret.NoSuchStiPtException if a matching sti pt could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.StiPt findByStiRdId_Last(long stiRdId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchStiPtException {
        return getPersistence().findByStiRdId_Last(stiRdId, orderByComparator);
    }

    /**
    * Returns the last sti pt in the ordered set where stiRdId = &#63;.
    *
    * @param stiRdId the sti rd ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching sti pt, or <code>null</code> if a matching sti pt could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.StiPt fetchByStiRdId_Last(long stiRdId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().fetchByStiRdId_Last(stiRdId, orderByComparator);
    }

    /**
    * Returns the sti pts before and after the current sti pt in the ordered set where stiRdId = &#63;.
    *
    * @param stiPtId the primary key of the current sti pt
    * @param stiRdId the sti rd ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the previous, current, and next sti pt
    * @throws gov.va.caret.NoSuchStiPtException if a sti pt with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.StiPt[] findByStiRdId_PrevAndNext(
        long stiPtId, long stiRdId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchStiPtException {
        return getPersistence()
                   .findByStiRdId_PrevAndNext(stiPtId, stiRdId,
            orderByComparator);
    }

    /**
    * Removes all the sti pts where stiRdId = &#63; from the database.
    *
    * @param stiRdId the sti rd ID
    * @throws SystemException if a system exception occurred
    */
    public static void removeByStiRdId(long stiRdId)
        throws com.liferay.portal.kernel.exception.SystemException {
        getPersistence().removeByStiRdId(stiRdId);
    }

    /**
    * Returns the number of sti pts where stiRdId = &#63;.
    *
    * @param stiRdId the sti rd ID
    * @return the number of matching sti pts
    * @throws SystemException if a system exception occurred
    */
    public static int countByStiRdId(long stiRdId)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().countByStiRdId(stiRdId);
    }

    /**
    * Returns all the sti pts where vendrId = &#63;.
    *
    * @param vendrId the vendr ID
    * @return the matching sti pts
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.StiPt> findByVendrId(
        long vendrId)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findByVendrId(vendrId);
    }

    /**
    * Returns a range of all the sti pts where vendrId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.StiPtModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param vendrId the vendr ID
    * @param start the lower bound of the range of sti pts
    * @param end the upper bound of the range of sti pts (not inclusive)
    * @return the range of matching sti pts
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.StiPt> findByVendrId(
        long vendrId, int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findByVendrId(vendrId, start, end);
    }

    /**
    * Returns an ordered range of all the sti pts where vendrId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.StiPtModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param vendrId the vendr ID
    * @param start the lower bound of the range of sti pts
    * @param end the upper bound of the range of sti pts (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of matching sti pts
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.StiPt> findByVendrId(
        long vendrId, int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence()
                   .findByVendrId(vendrId, start, end, orderByComparator);
    }

    /**
    * Returns the first sti pt in the ordered set where vendrId = &#63;.
    *
    * @param vendrId the vendr ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching sti pt
    * @throws gov.va.caret.NoSuchStiPtException if a matching sti pt could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.StiPt findByVendrId_First(long vendrId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchStiPtException {
        return getPersistence().findByVendrId_First(vendrId, orderByComparator);
    }

    /**
    * Returns the first sti pt in the ordered set where vendrId = &#63;.
    *
    * @param vendrId the vendr ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching sti pt, or <code>null</code> if a matching sti pt could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.StiPt fetchByVendrId_First(long vendrId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().fetchByVendrId_First(vendrId, orderByComparator);
    }

    /**
    * Returns the last sti pt in the ordered set where vendrId = &#63;.
    *
    * @param vendrId the vendr ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching sti pt
    * @throws gov.va.caret.NoSuchStiPtException if a matching sti pt could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.StiPt findByVendrId_Last(long vendrId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchStiPtException {
        return getPersistence().findByVendrId_Last(vendrId, orderByComparator);
    }

    /**
    * Returns the last sti pt in the ordered set where vendrId = &#63;.
    *
    * @param vendrId the vendr ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching sti pt, or <code>null</code> if a matching sti pt could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.StiPt fetchByVendrId_Last(long vendrId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().fetchByVendrId_Last(vendrId, orderByComparator);
    }

    /**
    * Returns the sti pts before and after the current sti pt in the ordered set where vendrId = &#63;.
    *
    * @param stiPtId the primary key of the current sti pt
    * @param vendrId the vendr ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the previous, current, and next sti pt
    * @throws gov.va.caret.NoSuchStiPtException if a sti pt with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.StiPt[] findByVendrId_PrevAndNext(
        long stiPtId, long vendrId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchStiPtException {
        return getPersistence()
                   .findByVendrId_PrevAndNext(stiPtId, vendrId,
            orderByComparator);
    }

    /**
    * Removes all the sti pts where vendrId = &#63; from the database.
    *
    * @param vendrId the vendr ID
    * @throws SystemException if a system exception occurred
    */
    public static void removeByVendrId(long vendrId)
        throws com.liferay.portal.kernel.exception.SystemException {
        getPersistence().removeByVendrId(vendrId);
    }

    /**
    * Returns the number of sti pts where vendrId = &#63;.
    *
    * @param vendrId the vendr ID
    * @return the number of matching sti pts
    * @throws SystemException if a system exception occurred
    */
    public static int countByVendrId(long vendrId)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().countByVendrId(vendrId);
    }

    /**
    * Returns all the sti pts where stipendStatus = &#63; and stipendStartDate = &#63;.
    *
    * @param stipendStatus the stipend status
    * @param stipendStartDate the stipend start date
    * @return the matching sti pts
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.StiPt> findByStipendStatus(
        java.lang.String stipendStatus, java.util.Date stipendStartDate)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence()
                   .findByStipendStatus(stipendStatus, stipendStartDate);
    }

    /**
    * Returns a range of all the sti pts where stipendStatus = &#63; and stipendStartDate = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.StiPtModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param stipendStatus the stipend status
    * @param stipendStartDate the stipend start date
    * @param start the lower bound of the range of sti pts
    * @param end the upper bound of the range of sti pts (not inclusive)
    * @return the range of matching sti pts
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.StiPt> findByStipendStatus(
        java.lang.String stipendStatus, java.util.Date stipendStartDate,
        int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence()
                   .findByStipendStatus(stipendStatus, stipendStartDate, start,
            end);
    }

    /**
    * Returns an ordered range of all the sti pts where stipendStatus = &#63; and stipendStartDate = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.StiPtModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param stipendStatus the stipend status
    * @param stipendStartDate the stipend start date
    * @param start the lower bound of the range of sti pts
    * @param end the upper bound of the range of sti pts (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of matching sti pts
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.StiPt> findByStipendStatus(
        java.lang.String stipendStatus, java.util.Date stipendStartDate,
        int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence()
                   .findByStipendStatus(stipendStatus, stipendStartDate, start,
            end, orderByComparator);
    }

    /**
    * Returns the first sti pt in the ordered set where stipendStatus = &#63; and stipendStartDate = &#63;.
    *
    * @param stipendStatus the stipend status
    * @param stipendStartDate the stipend start date
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching sti pt
    * @throws gov.va.caret.NoSuchStiPtException if a matching sti pt could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.StiPt findByStipendStatus_First(
        java.lang.String stipendStatus, java.util.Date stipendStartDate,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchStiPtException {
        return getPersistence()
                   .findByStipendStatus_First(stipendStatus, stipendStartDate,
            orderByComparator);
    }

    /**
    * Returns the first sti pt in the ordered set where stipendStatus = &#63; and stipendStartDate = &#63;.
    *
    * @param stipendStatus the stipend status
    * @param stipendStartDate the stipend start date
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching sti pt, or <code>null</code> if a matching sti pt could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.StiPt fetchByStipendStatus_First(
        java.lang.String stipendStatus, java.util.Date stipendStartDate,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence()
                   .fetchByStipendStatus_First(stipendStatus, stipendStartDate,
            orderByComparator);
    }

    /**
    * Returns the last sti pt in the ordered set where stipendStatus = &#63; and stipendStartDate = &#63;.
    *
    * @param stipendStatus the stipend status
    * @param stipendStartDate the stipend start date
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching sti pt
    * @throws gov.va.caret.NoSuchStiPtException if a matching sti pt could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.StiPt findByStipendStatus_Last(
        java.lang.String stipendStatus, java.util.Date stipendStartDate,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchStiPtException {
        return getPersistence()
                   .findByStipendStatus_Last(stipendStatus, stipendStartDate,
            orderByComparator);
    }

    /**
    * Returns the last sti pt in the ordered set where stipendStatus = &#63; and stipendStartDate = &#63;.
    *
    * @param stipendStatus the stipend status
    * @param stipendStartDate the stipend start date
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching sti pt, or <code>null</code> if a matching sti pt could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.StiPt fetchByStipendStatus_Last(
        java.lang.String stipendStatus, java.util.Date stipendStartDate,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence()
                   .fetchByStipendStatus_Last(stipendStatus, stipendStartDate,
            orderByComparator);
    }

    /**
    * Returns the sti pts before and after the current sti pt in the ordered set where stipendStatus = &#63; and stipendStartDate = &#63;.
    *
    * @param stiPtId the primary key of the current sti pt
    * @param stipendStatus the stipend status
    * @param stipendStartDate the stipend start date
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the previous, current, and next sti pt
    * @throws gov.va.caret.NoSuchStiPtException if a sti pt with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.StiPt[] findByStipendStatus_PrevAndNext(
        long stiPtId, java.lang.String stipendStatus,
        java.util.Date stipendStartDate,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchStiPtException {
        return getPersistence()
                   .findByStipendStatus_PrevAndNext(stiPtId, stipendStatus,
            stipendStartDate, orderByComparator);
    }

    /**
    * Removes all the sti pts where stipendStatus = &#63; and stipendStartDate = &#63; from the database.
    *
    * @param stipendStatus the stipend status
    * @param stipendStartDate the stipend start date
    * @throws SystemException if a system exception occurred
    */
    public static void removeByStipendStatus(java.lang.String stipendStatus,
        java.util.Date stipendStartDate)
        throws com.liferay.portal.kernel.exception.SystemException {
        getPersistence().removeByStipendStatus(stipendStatus, stipendStartDate);
    }

    /**
    * Returns the number of sti pts where stipendStatus = &#63; and stipendStartDate = &#63;.
    *
    * @param stipendStatus the stipend status
    * @param stipendStartDate the stipend start date
    * @return the number of matching sti pts
    * @throws SystemException if a system exception occurred
    */
    public static int countByStipendStatus(java.lang.String stipendStatus,
        java.util.Date stipendStartDate)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence()
                   .countByStipendStatus(stipendStatus, stipendStartDate);
    }

    /**
    * Caches the sti pt in the entity cache if it is enabled.
    *
    * @param stiPt the sti pt
    */
    public static void cacheResult(gov.va.caret.model.StiPt stiPt) {
        getPersistence().cacheResult(stiPt);
    }

    /**
    * Caches the sti pts in the entity cache if it is enabled.
    *
    * @param stiPts the sti pts
    */
    public static void cacheResult(
        java.util.List<gov.va.caret.model.StiPt> stiPts) {
        getPersistence().cacheResult(stiPts);
    }

    /**
    * Creates a new sti pt with the primary key. Does not add the sti pt to the database.
    *
    * @param stiPtId the primary key for the new sti pt
    * @return the new sti pt
    */
    public static gov.va.caret.model.StiPt create(long stiPtId) {
        return getPersistence().create(stiPtId);
    }

    /**
    * Removes the sti pt with the primary key from the database. Also notifies the appropriate model listeners.
    *
    * @param stiPtId the primary key of the sti pt
    * @return the sti pt that was removed
    * @throws gov.va.caret.NoSuchStiPtException if a sti pt with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.StiPt remove(long stiPtId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchStiPtException {
        return getPersistence().remove(stiPtId);
    }

    public static gov.va.caret.model.StiPt updateImpl(
        gov.va.caret.model.StiPt stiPt)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().updateImpl(stiPt);
    }

    /**
    * Returns the sti pt with the primary key or throws a {@link gov.va.caret.NoSuchStiPtException} if it could not be found.
    *
    * @param stiPtId the primary key of the sti pt
    * @return the sti pt
    * @throws gov.va.caret.NoSuchStiPtException if a sti pt with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.StiPt findByPrimaryKey(long stiPtId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchStiPtException {
        return getPersistence().findByPrimaryKey(stiPtId);
    }

    /**
    * Returns the sti pt with the primary key or returns <code>null</code> if it could not be found.
    *
    * @param stiPtId the primary key of the sti pt
    * @return the sti pt, or <code>null</code> if a sti pt with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.StiPt fetchByPrimaryKey(long stiPtId)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().fetchByPrimaryKey(stiPtId);
    }

    /**
    * Returns all the sti pts.
    *
    * @return the sti pts
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.StiPt> findAll()
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findAll();
    }

    /**
    * Returns a range of all the sti pts.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.StiPtModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of sti pts
    * @param end the upper bound of the range of sti pts (not inclusive)
    * @return the range of sti pts
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.StiPt> findAll(int start,
        int end) throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findAll(start, end);
    }

    /**
    * Returns an ordered range of all the sti pts.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.StiPtModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of sti pts
    * @param end the upper bound of the range of sti pts (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of sti pts
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.StiPt> findAll(int start,
        int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findAll(start, end, orderByComparator);
    }

    /**
    * Removes all the sti pts from the database.
    *
    * @throws SystemException if a system exception occurred
    */
    public static void removeAll()
        throws com.liferay.portal.kernel.exception.SystemException {
        getPersistence().removeAll();
    }

    /**
    * Returns the number of sti pts.
    *
    * @return the number of sti pts
    * @throws SystemException if a system exception occurred
    */
    public static int countAll()
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().countAll();
    }

    public static StiPtPersistence getPersistence() {
        if (_persistence == null) {
            _persistence = (StiPtPersistence) PortletBeanLocatorUtil.locate(gov.va.caret.service.ClpSerializer.getServletContextName(),
                    StiPtPersistence.class.getName());

            ReferenceRegistry.registerReference(StiPtUtil.class, "_persistence");
        }

        return _persistence;
    }

    /**
     * @deprecated As of 6.2.0
     */
    public void setPersistence(StiPtPersistence persistence) {
    }
}
