package gov.va.caret.service.persistence;

import com.liferay.portal.kernel.bean.PortletBeanLocatorUtil;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ReferenceRegistry;
import com.liferay.portal.service.ServiceContext;

import gov.va.caret.model.Persn;

import java.util.List;

/**
 * The persistence utility for the persn service. This utility wraps {@link PersnPersistenceImpl} and provides direct access to the database for CRUD operations. This utility should only be used by the service layer, as it must operate within a transaction. Never access this utility in a JSP, controller, model, or other front-end class.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author caret
 * @see PersnPersistence
 * @see PersnPersistenceImpl
 * @generated
 */
public class PersnUtil {
    private static PersnPersistence _persistence;

    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify this class directly. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this class.
     */

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#clearCache()
     */
    public static void clearCache() {
        getPersistence().clearCache();
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#clearCache(com.liferay.portal.model.BaseModel)
     */
    public static void clearCache(Persn persn) {
        getPersistence().clearCache(persn);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#countWithDynamicQuery(DynamicQuery)
     */
    public static long countWithDynamicQuery(DynamicQuery dynamicQuery)
        throws SystemException {
        return getPersistence().countWithDynamicQuery(dynamicQuery);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery)
     */
    public static List<Persn> findWithDynamicQuery(DynamicQuery dynamicQuery)
        throws SystemException {
        return getPersistence().findWithDynamicQuery(dynamicQuery);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery, int, int)
     */
    public static List<Persn> findWithDynamicQuery(DynamicQuery dynamicQuery,
        int start, int end) throws SystemException {
        return getPersistence().findWithDynamicQuery(dynamicQuery, start, end);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery, int, int, OrderByComparator)
     */
    public static List<Persn> findWithDynamicQuery(DynamicQuery dynamicQuery,
        int start, int end, OrderByComparator orderByComparator)
        throws SystemException {
        return getPersistence()
                   .findWithDynamicQuery(dynamicQuery, start, end,
            orderByComparator);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#update(com.liferay.portal.model.BaseModel)
     */
    public static Persn update(Persn persn) throws SystemException {
        return getPersistence().update(persn);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#update(com.liferay.portal.model.BaseModel, ServiceContext)
     */
    public static Persn update(Persn persn, ServiceContext serviceContext)
        throws SystemException {
        return getPersistence().update(persn, serviceContext);
    }

    /**
    * Returns all the persns where firstName = &#63;.
    *
    * @param firstName the first name
    * @return the matching persns
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.Persn> findByFirstName(
        java.lang.String firstName)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findByFirstName(firstName);
    }

    /**
    * Returns a range of all the persns where firstName = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.PersnModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param firstName the first name
    * @param start the lower bound of the range of persns
    * @param end the upper bound of the range of persns (not inclusive)
    * @return the range of matching persns
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.Persn> findByFirstName(
        java.lang.String firstName, int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findByFirstName(firstName, start, end);
    }

    /**
    * Returns an ordered range of all the persns where firstName = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.PersnModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param firstName the first name
    * @param start the lower bound of the range of persns
    * @param end the upper bound of the range of persns (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of matching persns
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.Persn> findByFirstName(
        java.lang.String firstName, int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence()
                   .findByFirstName(firstName, start, end, orderByComparator);
    }

    /**
    * Returns the first persn in the ordered set where firstName = &#63;.
    *
    * @param firstName the first name
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching persn
    * @throws gov.va.caret.NoSuchPersnException if a matching persn could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Persn findByFirstName_First(
        java.lang.String firstName,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchPersnException {
        return getPersistence()
                   .findByFirstName_First(firstName, orderByComparator);
    }

    /**
    * Returns the first persn in the ordered set where firstName = &#63;.
    *
    * @param firstName the first name
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching persn, or <code>null</code> if a matching persn could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Persn fetchByFirstName_First(
        java.lang.String firstName,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence()
                   .fetchByFirstName_First(firstName, orderByComparator);
    }

    /**
    * Returns the last persn in the ordered set where firstName = &#63;.
    *
    * @param firstName the first name
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching persn
    * @throws gov.va.caret.NoSuchPersnException if a matching persn could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Persn findByFirstName_Last(
        java.lang.String firstName,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchPersnException {
        return getPersistence()
                   .findByFirstName_Last(firstName, orderByComparator);
    }

    /**
    * Returns the last persn in the ordered set where firstName = &#63;.
    *
    * @param firstName the first name
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching persn, or <code>null</code> if a matching persn could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Persn fetchByFirstName_Last(
        java.lang.String firstName,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence()
                   .fetchByFirstName_Last(firstName, orderByComparator);
    }

    /**
    * Returns the persns before and after the current persn in the ordered set where firstName = &#63;.
    *
    * @param persnId the primary key of the current persn
    * @param firstName the first name
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the previous, current, and next persn
    * @throws gov.va.caret.NoSuchPersnException if a persn with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Persn[] findByFirstName_PrevAndNext(
        long persnId, java.lang.String firstName,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchPersnException {
        return getPersistence()
                   .findByFirstName_PrevAndNext(persnId, firstName,
            orderByComparator);
    }

    /**
    * Removes all the persns where firstName = &#63; from the database.
    *
    * @param firstName the first name
    * @throws SystemException if a system exception occurred
    */
    public static void removeByFirstName(java.lang.String firstName)
        throws com.liferay.portal.kernel.exception.SystemException {
        getPersistence().removeByFirstName(firstName);
    }

    /**
    * Returns the number of persns where firstName = &#63;.
    *
    * @param firstName the first name
    * @return the number of matching persns
    * @throws SystemException if a system exception occurred
    */
    public static int countByFirstName(java.lang.String firstName)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().countByFirstName(firstName);
    }

    /**
    * Returns all the persns where lastName = &#63;.
    *
    * @param lastName the last name
    * @return the matching persns
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.Persn> findByLastName(
        java.lang.String lastName)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findByLastName(lastName);
    }

    /**
    * Returns a range of all the persns where lastName = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.PersnModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param lastName the last name
    * @param start the lower bound of the range of persns
    * @param end the upper bound of the range of persns (not inclusive)
    * @return the range of matching persns
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.Persn> findByLastName(
        java.lang.String lastName, int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findByLastName(lastName, start, end);
    }

    /**
    * Returns an ordered range of all the persns where lastName = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.PersnModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param lastName the last name
    * @param start the lower bound of the range of persns
    * @param end the upper bound of the range of persns (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of matching persns
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.Persn> findByLastName(
        java.lang.String lastName, int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence()
                   .findByLastName(lastName, start, end, orderByComparator);
    }

    /**
    * Returns the first persn in the ordered set where lastName = &#63;.
    *
    * @param lastName the last name
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching persn
    * @throws gov.va.caret.NoSuchPersnException if a matching persn could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Persn findByLastName_First(
        java.lang.String lastName,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchPersnException {
        return getPersistence().findByLastName_First(lastName, orderByComparator);
    }

    /**
    * Returns the first persn in the ordered set where lastName = &#63;.
    *
    * @param lastName the last name
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching persn, or <code>null</code> if a matching persn could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Persn fetchByLastName_First(
        java.lang.String lastName,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence()
                   .fetchByLastName_First(lastName, orderByComparator);
    }

    /**
    * Returns the last persn in the ordered set where lastName = &#63;.
    *
    * @param lastName the last name
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching persn
    * @throws gov.va.caret.NoSuchPersnException if a matching persn could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Persn findByLastName_Last(
        java.lang.String lastName,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchPersnException {
        return getPersistence().findByLastName_Last(lastName, orderByComparator);
    }

    /**
    * Returns the last persn in the ordered set where lastName = &#63;.
    *
    * @param lastName the last name
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching persn, or <code>null</code> if a matching persn could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Persn fetchByLastName_Last(
        java.lang.String lastName,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().fetchByLastName_Last(lastName, orderByComparator);
    }

    /**
    * Returns the persns before and after the current persn in the ordered set where lastName = &#63;.
    *
    * @param persnId the primary key of the current persn
    * @param lastName the last name
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the previous, current, and next persn
    * @throws gov.va.caret.NoSuchPersnException if a persn with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Persn[] findByLastName_PrevAndNext(
        long persnId, java.lang.String lastName,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchPersnException {
        return getPersistence()
                   .findByLastName_PrevAndNext(persnId, lastName,
            orderByComparator);
    }

    /**
    * Removes all the persns where lastName = &#63; from the database.
    *
    * @param lastName the last name
    * @throws SystemException if a system exception occurred
    */
    public static void removeByLastName(java.lang.String lastName)
        throws com.liferay.portal.kernel.exception.SystemException {
        getPersistence().removeByLastName(lastName);
    }

    /**
    * Returns the number of persns where lastName = &#63;.
    *
    * @param lastName the last name
    * @return the number of matching persns
    * @throws SystemException if a system exception occurred
    */
    public static int countByLastName(java.lang.String lastName)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().countByLastName(lastName);
    }

    /**
    * Returns all the persns where birthDate = &#63;.
    *
    * @param birthDate the birth date
    * @return the matching persns
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.Persn> findByBirthDate(
        java.util.Date birthDate)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findByBirthDate(birthDate);
    }

    /**
    * Returns a range of all the persns where birthDate = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.PersnModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param birthDate the birth date
    * @param start the lower bound of the range of persns
    * @param end the upper bound of the range of persns (not inclusive)
    * @return the range of matching persns
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.Persn> findByBirthDate(
        java.util.Date birthDate, int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findByBirthDate(birthDate, start, end);
    }

    /**
    * Returns an ordered range of all the persns where birthDate = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.PersnModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param birthDate the birth date
    * @param start the lower bound of the range of persns
    * @param end the upper bound of the range of persns (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of matching persns
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.Persn> findByBirthDate(
        java.util.Date birthDate, int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence()
                   .findByBirthDate(birthDate, start, end, orderByComparator);
    }

    /**
    * Returns the first persn in the ordered set where birthDate = &#63;.
    *
    * @param birthDate the birth date
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching persn
    * @throws gov.va.caret.NoSuchPersnException if a matching persn could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Persn findByBirthDate_First(
        java.util.Date birthDate,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchPersnException {
        return getPersistence()
                   .findByBirthDate_First(birthDate, orderByComparator);
    }

    /**
    * Returns the first persn in the ordered set where birthDate = &#63;.
    *
    * @param birthDate the birth date
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching persn, or <code>null</code> if a matching persn could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Persn fetchByBirthDate_First(
        java.util.Date birthDate,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence()
                   .fetchByBirthDate_First(birthDate, orderByComparator);
    }

    /**
    * Returns the last persn in the ordered set where birthDate = &#63;.
    *
    * @param birthDate the birth date
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching persn
    * @throws gov.va.caret.NoSuchPersnException if a matching persn could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Persn findByBirthDate_Last(
        java.util.Date birthDate,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchPersnException {
        return getPersistence()
                   .findByBirthDate_Last(birthDate, orderByComparator);
    }

    /**
    * Returns the last persn in the ordered set where birthDate = &#63;.
    *
    * @param birthDate the birth date
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching persn, or <code>null</code> if a matching persn could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Persn fetchByBirthDate_Last(
        java.util.Date birthDate,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence()
                   .fetchByBirthDate_Last(birthDate, orderByComparator);
    }

    /**
    * Returns the persns before and after the current persn in the ordered set where birthDate = &#63;.
    *
    * @param persnId the primary key of the current persn
    * @param birthDate the birth date
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the previous, current, and next persn
    * @throws gov.va.caret.NoSuchPersnException if a persn with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Persn[] findByBirthDate_PrevAndNext(
        long persnId, java.util.Date birthDate,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchPersnException {
        return getPersistence()
                   .findByBirthDate_PrevAndNext(persnId, birthDate,
            orderByComparator);
    }

    /**
    * Removes all the persns where birthDate = &#63; from the database.
    *
    * @param birthDate the birth date
    * @throws SystemException if a system exception occurred
    */
    public static void removeByBirthDate(java.util.Date birthDate)
        throws com.liferay.portal.kernel.exception.SystemException {
        getPersistence().removeByBirthDate(birthDate);
    }

    /**
    * Returns the number of persns where birthDate = &#63;.
    *
    * @param birthDate the birth date
    * @return the number of matching persns
    * @throws SystemException if a system exception occurred
    */
    public static int countByBirthDate(java.util.Date birthDate)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().countByBirthDate(birthDate);
    }

    /**
    * Returns the persn where persnUserId = &#63; or throws a {@link gov.va.caret.NoSuchPersnException} if it could not be found.
    *
    * @param persnUserId the persn user ID
    * @return the matching persn
    * @throws gov.va.caret.NoSuchPersnException if a matching persn could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Persn findByUser(long persnUserId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchPersnException {
        return getPersistence().findByUser(persnUserId);
    }

    /**
    * Returns the persn where persnUserId = &#63; or returns <code>null</code> if it could not be found. Uses the finder cache.
    *
    * @param persnUserId the persn user ID
    * @return the matching persn, or <code>null</code> if a matching persn could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Persn fetchByUser(long persnUserId)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().fetchByUser(persnUserId);
    }

    /**
    * Returns the persn where persnUserId = &#63; or returns <code>null</code> if it could not be found, optionally using the finder cache.
    *
    * @param persnUserId the persn user ID
    * @param retrieveFromCache whether to use the finder cache
    * @return the matching persn, or <code>null</code> if a matching persn could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Persn fetchByUser(long persnUserId,
        boolean retrieveFromCache)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().fetchByUser(persnUserId, retrieveFromCache);
    }

    /**
    * Removes the persn where persnUserId = &#63; from the database.
    *
    * @param persnUserId the persn user ID
    * @return the persn that was removed
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Persn removeByUser(long persnUserId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchPersnException {
        return getPersistence().removeByUser(persnUserId);
    }

    /**
    * Returns the number of persns where persnUserId = &#63;.
    *
    * @param persnUserId the persn user ID
    * @return the number of matching persns
    * @throws SystemException if a system exception occurred
    */
    public static int countByUser(long persnUserId)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().countByUser(persnUserId);
    }

    /**
    * Returns all the persns where gender = &#63;.
    *
    * @param gender the gender
    * @return the matching persns
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.Persn> findByGender(
        java.lang.String gender)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findByGender(gender);
    }

    /**
    * Returns a range of all the persns where gender = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.PersnModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param gender the gender
    * @param start the lower bound of the range of persns
    * @param end the upper bound of the range of persns (not inclusive)
    * @return the range of matching persns
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.Persn> findByGender(
        java.lang.String gender, int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findByGender(gender, start, end);
    }

    /**
    * Returns an ordered range of all the persns where gender = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.PersnModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param gender the gender
    * @param start the lower bound of the range of persns
    * @param end the upper bound of the range of persns (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of matching persns
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.Persn> findByGender(
        java.lang.String gender, int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence()
                   .findByGender(gender, start, end, orderByComparator);
    }

    /**
    * Returns the first persn in the ordered set where gender = &#63;.
    *
    * @param gender the gender
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching persn
    * @throws gov.va.caret.NoSuchPersnException if a matching persn could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Persn findByGender_First(
        java.lang.String gender,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchPersnException {
        return getPersistence().findByGender_First(gender, orderByComparator);
    }

    /**
    * Returns the first persn in the ordered set where gender = &#63;.
    *
    * @param gender the gender
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching persn, or <code>null</code> if a matching persn could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Persn fetchByGender_First(
        java.lang.String gender,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().fetchByGender_First(gender, orderByComparator);
    }

    /**
    * Returns the last persn in the ordered set where gender = &#63;.
    *
    * @param gender the gender
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching persn
    * @throws gov.va.caret.NoSuchPersnException if a matching persn could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Persn findByGender_Last(
        java.lang.String gender,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchPersnException {
        return getPersistence().findByGender_Last(gender, orderByComparator);
    }

    /**
    * Returns the last persn in the ordered set where gender = &#63;.
    *
    * @param gender the gender
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching persn, or <code>null</code> if a matching persn could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Persn fetchByGender_Last(
        java.lang.String gender,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().fetchByGender_Last(gender, orderByComparator);
    }

    /**
    * Returns the persns before and after the current persn in the ordered set where gender = &#63;.
    *
    * @param persnId the primary key of the current persn
    * @param gender the gender
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the previous, current, and next persn
    * @throws gov.va.caret.NoSuchPersnException if a persn with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Persn[] findByGender_PrevAndNext(
        long persnId, java.lang.String gender,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchPersnException {
        return getPersistence()
                   .findByGender_PrevAndNext(persnId, gender, orderByComparator);
    }

    /**
    * Removes all the persns where gender = &#63; from the database.
    *
    * @param gender the gender
    * @throws SystemException if a system exception occurred
    */
    public static void removeByGender(java.lang.String gender)
        throws com.liferay.portal.kernel.exception.SystemException {
        getPersistence().removeByGender(gender);
    }

    /**
    * Returns the number of persns where gender = &#63;.
    *
    * @param gender the gender
    * @return the number of matching persns
    * @throws SystemException if a system exception occurred
    */
    public static int countByGender(java.lang.String gender)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().countByGender(gender);
    }

    /**
    * Returns the persn where externalId = &#63; or throws a {@link gov.va.caret.NoSuchPersnException} if it could not be found.
    *
    * @param externalId the external ID
    * @return the matching persn
    * @throws gov.va.caret.NoSuchPersnException if a matching persn could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Persn findByExternalId(
        java.lang.String externalId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchPersnException {
        return getPersistence().findByExternalId(externalId);
    }

    /**
    * Returns the persn where externalId = &#63; or returns <code>null</code> if it could not be found. Uses the finder cache.
    *
    * @param externalId the external ID
    * @return the matching persn, or <code>null</code> if a matching persn could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Persn fetchByExternalId(
        java.lang.String externalId)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().fetchByExternalId(externalId);
    }

    /**
    * Returns the persn where externalId = &#63; or returns <code>null</code> if it could not be found, optionally using the finder cache.
    *
    * @param externalId the external ID
    * @param retrieveFromCache whether to use the finder cache
    * @return the matching persn, or <code>null</code> if a matching persn could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Persn fetchByExternalId(
        java.lang.String externalId, boolean retrieveFromCache)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().fetchByExternalId(externalId, retrieveFromCache);
    }

    /**
    * Removes the persn where externalId = &#63; from the database.
    *
    * @param externalId the external ID
    * @return the persn that was removed
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Persn removeByExternalId(
        java.lang.String externalId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchPersnException {
        return getPersistence().removeByExternalId(externalId);
    }

    /**
    * Returns the number of persns where externalId = &#63;.
    *
    * @param externalId the external ID
    * @return the number of matching persns
    * @throws SystemException if a system exception occurred
    */
    public static int countByExternalId(java.lang.String externalId)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().countByExternalId(externalId);
    }

    /**
    * Caches the persn in the entity cache if it is enabled.
    *
    * @param persn the persn
    */
    public static void cacheResult(gov.va.caret.model.Persn persn) {
        getPersistence().cacheResult(persn);
    }

    /**
    * Caches the persns in the entity cache if it is enabled.
    *
    * @param persns the persns
    */
    public static void cacheResult(
        java.util.List<gov.va.caret.model.Persn> persns) {
        getPersistence().cacheResult(persns);
    }

    /**
    * Creates a new persn with the primary key. Does not add the persn to the database.
    *
    * @param persnId the primary key for the new persn
    * @return the new persn
    */
    public static gov.va.caret.model.Persn create(long persnId) {
        return getPersistence().create(persnId);
    }

    /**
    * Removes the persn with the primary key from the database. Also notifies the appropriate model listeners.
    *
    * @param persnId the primary key of the persn
    * @return the persn that was removed
    * @throws gov.va.caret.NoSuchPersnException if a persn with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Persn remove(long persnId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchPersnException {
        return getPersistence().remove(persnId);
    }

    public static gov.va.caret.model.Persn updateImpl(
        gov.va.caret.model.Persn persn)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().updateImpl(persn);
    }

    /**
    * Returns the persn with the primary key or throws a {@link gov.va.caret.NoSuchPersnException} if it could not be found.
    *
    * @param persnId the primary key of the persn
    * @return the persn
    * @throws gov.va.caret.NoSuchPersnException if a persn with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Persn findByPrimaryKey(long persnId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchPersnException {
        return getPersistence().findByPrimaryKey(persnId);
    }

    /**
    * Returns the persn with the primary key or returns <code>null</code> if it could not be found.
    *
    * @param persnId the primary key of the persn
    * @return the persn, or <code>null</code> if a persn with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Persn fetchByPrimaryKey(long persnId)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().fetchByPrimaryKey(persnId);
    }

    /**
    * Returns all the persns.
    *
    * @return the persns
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.Persn> findAll()
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findAll();
    }

    /**
    * Returns a range of all the persns.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.PersnModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of persns
    * @param end the upper bound of the range of persns (not inclusive)
    * @return the range of persns
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.Persn> findAll(int start,
        int end) throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findAll(start, end);
    }

    /**
    * Returns an ordered range of all the persns.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.PersnModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of persns
    * @param end the upper bound of the range of persns (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of persns
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.Persn> findAll(int start,
        int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findAll(start, end, orderByComparator);
    }

    /**
    * Removes all the persns from the database.
    *
    * @throws SystemException if a system exception occurred
    */
    public static void removeAll()
        throws com.liferay.portal.kernel.exception.SystemException {
        getPersistence().removeAll();
    }

    /**
    * Returns the number of persns.
    *
    * @return the number of persns
    * @throws SystemException if a system exception occurred
    */
    public static int countAll()
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().countAll();
    }

    public static PersnPersistence getPersistence() {
        if (_persistence == null) {
            _persistence = (PersnPersistence) PortletBeanLocatorUtil.locate(gov.va.caret.service.ClpSerializer.getServletContextName(),
                    PersnPersistence.class.getName());

            ReferenceRegistry.registerReference(PersnUtil.class, "_persistence");
        }

        return _persistence;
    }

    /**
     * @deprecated As of 6.2.0
     */
    public void setPersistence(PersnPersistence persistence) {
    }
}
