/**
 * Copyright (c) 2000-2013 Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package gov.va.caret.service.persistence;

import com.liferay.portal.kernel.bean.PortletBeanLocatorUtil;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ReferenceRegistry;
import com.liferay.portal.service.ServiceContext;

import gov.va.caret.model.PMReadMessage;

import java.util.List;

/**
 * The persistence utility for the p m read message service. This utility wraps {@link PMReadMessagePersistenceImpl} and provides direct access to the database for CRUD operations. This utility should only be used by the service layer, as it must operate within a transaction. Never access this utility in a JSP, controller, model, or other front-end class.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author caret
 * @see PMReadMessagePersistence
 * @see PMReadMessagePersistenceImpl
 * @generated
 */
public class PMReadMessageUtil {
	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify this class directly. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this class.
	 */

	/**
	 * @see com.liferay.portal.service.persistence.BasePersistence#clearCache()
	 */
	public static void clearCache() {
		getPersistence().clearCache();
	}

	/**
	 * @see com.liferay.portal.service.persistence.BasePersistence#clearCache(com.liferay.portal.model.BaseModel)
	 */
	public static void clearCache(PMReadMessage pmReadMessage) {
		getPersistence().clearCache(pmReadMessage);
	}

	/**
	 * @see com.liferay.portal.service.persistence.BasePersistence#countWithDynamicQuery(DynamicQuery)
	 */
	public static long countWithDynamicQuery(DynamicQuery dynamicQuery)
		throws SystemException {
		return getPersistence().countWithDynamicQuery(dynamicQuery);
	}

	/**
	 * @see com.liferay.portal.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery)
	 */
	public static List<PMReadMessage> findWithDynamicQuery(
		DynamicQuery dynamicQuery) throws SystemException {
		return getPersistence().findWithDynamicQuery(dynamicQuery);
	}

	/**
	 * @see com.liferay.portal.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery, int, int)
	 */
	public static List<PMReadMessage> findWithDynamicQuery(
		DynamicQuery dynamicQuery, int start, int end)
		throws SystemException {
		return getPersistence().findWithDynamicQuery(dynamicQuery, start, end);
	}

	/**
	 * @see com.liferay.portal.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery, int, int, OrderByComparator)
	 */
	public static List<PMReadMessage> findWithDynamicQuery(
		DynamicQuery dynamicQuery, int start, int end,
		OrderByComparator orderByComparator) throws SystemException {
		return getPersistence()
				   .findWithDynamicQuery(dynamicQuery, start, end,
			orderByComparator);
	}

	/**
	 * @see com.liferay.portal.service.persistence.BasePersistence#update(com.liferay.portal.model.BaseModel)
	 */
	public static PMReadMessage update(PMReadMessage pmReadMessage)
		throws SystemException {
		return getPersistence().update(pmReadMessage);
	}

	/**
	 * @see com.liferay.portal.service.persistence.BasePersistence#update(com.liferay.portal.model.BaseModel, ServiceContext)
	 */
	public static PMReadMessage update(PMReadMessage pmReadMessage,
		ServiceContext serviceContext) throws SystemException {
		return getPersistence().update(pmReadMessage, serviceContext);
	}

	/**
	* Returns all the p m read messages where messageId = &#63;.
	*
	* @param messageId the message ID
	* @return the matching p m read messages
	* @throws SystemException if a system exception occurred
	*/
	public static java.util.List<gov.va.caret.model.PMReadMessage> findByMessageId(
		long messageId)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getPersistence().findByMessageId(messageId);
	}

	/**
	* Returns a range of all the p m read messages where messageId = &#63;.
	*
	* <p>
	* Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.PMReadMessageModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
	* </p>
	*
	* @param messageId the message ID
	* @param start the lower bound of the range of p m read messages
	* @param end the upper bound of the range of p m read messages (not inclusive)
	* @return the range of matching p m read messages
	* @throws SystemException if a system exception occurred
	*/
	public static java.util.List<gov.va.caret.model.PMReadMessage> findByMessageId(
		long messageId, int start, int end)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getPersistence().findByMessageId(messageId, start, end);
	}

	/**
	* Returns an ordered range of all the p m read messages where messageId = &#63;.
	*
	* <p>
	* Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.PMReadMessageModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
	* </p>
	*
	* @param messageId the message ID
	* @param start the lower bound of the range of p m read messages
	* @param end the upper bound of the range of p m read messages (not inclusive)
	* @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
	* @return the ordered range of matching p m read messages
	* @throws SystemException if a system exception occurred
	*/
	public static java.util.List<gov.va.caret.model.PMReadMessage> findByMessageId(
		long messageId, int start, int end,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getPersistence()
				   .findByMessageId(messageId, start, end, orderByComparator);
	}

	/**
	* Returns the first p m read message in the ordered set where messageId = &#63;.
	*
	* @param messageId the message ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the first matching p m read message
	* @throws gov.va.caret.NoSuchPMReadMessageException if a matching p m read message could not be found
	* @throws SystemException if a system exception occurred
	*/
	public static gov.va.caret.model.PMReadMessage findByMessageId_First(
		long messageId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException,
			gov.va.caret.NoSuchPMReadMessageException {
		return getPersistence()
				   .findByMessageId_First(messageId, orderByComparator);
	}

	/**
	* Returns the first p m read message in the ordered set where messageId = &#63;.
	*
	* @param messageId the message ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the first matching p m read message, or <code>null</code> if a matching p m read message could not be found
	* @throws SystemException if a system exception occurred
	*/
	public static gov.va.caret.model.PMReadMessage fetchByMessageId_First(
		long messageId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getPersistence()
				   .fetchByMessageId_First(messageId, orderByComparator);
	}

	/**
	* Returns the last p m read message in the ordered set where messageId = &#63;.
	*
	* @param messageId the message ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the last matching p m read message
	* @throws gov.va.caret.NoSuchPMReadMessageException if a matching p m read message could not be found
	* @throws SystemException if a system exception occurred
	*/
	public static gov.va.caret.model.PMReadMessage findByMessageId_Last(
		long messageId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException,
			gov.va.caret.NoSuchPMReadMessageException {
		return getPersistence()
				   .findByMessageId_Last(messageId, orderByComparator);
	}

	/**
	* Returns the last p m read message in the ordered set where messageId = &#63;.
	*
	* @param messageId the message ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the last matching p m read message, or <code>null</code> if a matching p m read message could not be found
	* @throws SystemException if a system exception occurred
	*/
	public static gov.va.caret.model.PMReadMessage fetchByMessageId_Last(
		long messageId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getPersistence()
				   .fetchByMessageId_Last(messageId, orderByComparator);
	}

	/**
	* Returns the p m read messages before and after the current p m read message in the ordered set where messageId = &#63;.
	*
	* @param readMessageId the primary key of the current p m read message
	* @param messageId the message ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the previous, current, and next p m read message
	* @throws gov.va.caret.NoSuchPMReadMessageException if a p m read message with the primary key could not be found
	* @throws SystemException if a system exception occurred
	*/
	public static gov.va.caret.model.PMReadMessage[] findByMessageId_PrevAndNext(
		long readMessageId, long messageId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException,
			gov.va.caret.NoSuchPMReadMessageException {
		return getPersistence()
				   .findByMessageId_PrevAndNext(readMessageId, messageId,
			orderByComparator);
	}

	/**
	* Removes all the p m read messages where messageId = &#63; from the database.
	*
	* @param messageId the message ID
	* @throws SystemException if a system exception occurred
	*/
	public static void removeByMessageId(long messageId)
		throws com.liferay.portal.kernel.exception.SystemException {
		getPersistence().removeByMessageId(messageId);
	}

	/**
	* Returns the number of p m read messages where messageId = &#63;.
	*
	* @param messageId the message ID
	* @return the number of matching p m read messages
	* @throws SystemException if a system exception occurred
	*/
	public static int countByMessageId(long messageId)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getPersistence().countByMessageId(messageId);
	}

	/**
	* Caches the p m read message in the entity cache if it is enabled.
	*
	* @param pmReadMessage the p m read message
	*/
	public static void cacheResult(
		gov.va.caret.model.PMReadMessage pmReadMessage) {
		getPersistence().cacheResult(pmReadMessage);
	}

	/**
	* Caches the p m read messages in the entity cache if it is enabled.
	*
	* @param pmReadMessages the p m read messages
	*/
	public static void cacheResult(
		java.util.List<gov.va.caret.model.PMReadMessage> pmReadMessages) {
		getPersistence().cacheResult(pmReadMessages);
	}

	/**
	* Creates a new p m read message with the primary key. Does not add the p m read message to the database.
	*
	* @param readMessageId the primary key for the new p m read message
	* @return the new p m read message
	*/
	public static gov.va.caret.model.PMReadMessage create(long readMessageId) {
		return getPersistence().create(readMessageId);
	}

	/**
	* Removes the p m read message with the primary key from the database. Also notifies the appropriate model listeners.
	*
	* @param readMessageId the primary key of the p m read message
	* @return the p m read message that was removed
	* @throws gov.va.caret.NoSuchPMReadMessageException if a p m read message with the primary key could not be found
	* @throws SystemException if a system exception occurred
	*/
	public static gov.va.caret.model.PMReadMessage remove(long readMessageId)
		throws com.liferay.portal.kernel.exception.SystemException,
			gov.va.caret.NoSuchPMReadMessageException {
		return getPersistence().remove(readMessageId);
	}

	public static gov.va.caret.model.PMReadMessage updateImpl(
		gov.va.caret.model.PMReadMessage pmReadMessage)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getPersistence().updateImpl(pmReadMessage);
	}

	/**
	* Returns the p m read message with the primary key or throws a {@link gov.va.caret.NoSuchPMReadMessageException} if it could not be found.
	*
	* @param readMessageId the primary key of the p m read message
	* @return the p m read message
	* @throws gov.va.caret.NoSuchPMReadMessageException if a p m read message with the primary key could not be found
	* @throws SystemException if a system exception occurred
	*/
	public static gov.va.caret.model.PMReadMessage findByPrimaryKey(
		long readMessageId)
		throws com.liferay.portal.kernel.exception.SystemException,
			gov.va.caret.NoSuchPMReadMessageException {
		return getPersistence().findByPrimaryKey(readMessageId);
	}

	/**
	* Returns the p m read message with the primary key or returns <code>null</code> if it could not be found.
	*
	* @param readMessageId the primary key of the p m read message
	* @return the p m read message, or <code>null</code> if a p m read message with the primary key could not be found
	* @throws SystemException if a system exception occurred
	*/
	public static gov.va.caret.model.PMReadMessage fetchByPrimaryKey(
		long readMessageId)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getPersistence().fetchByPrimaryKey(readMessageId);
	}

	/**
	* Returns all the p m read messages.
	*
	* @return the p m read messages
	* @throws SystemException if a system exception occurred
	*/
	public static java.util.List<gov.va.caret.model.PMReadMessage> findAll()
		throws com.liferay.portal.kernel.exception.SystemException {
		return getPersistence().findAll();
	}

	/**
	* Returns a range of all the p m read messages.
	*
	* <p>
	* Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.PMReadMessageModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
	* </p>
	*
	* @param start the lower bound of the range of p m read messages
	* @param end the upper bound of the range of p m read messages (not inclusive)
	* @return the range of p m read messages
	* @throws SystemException if a system exception occurred
	*/
	public static java.util.List<gov.va.caret.model.PMReadMessage> findAll(
		int start, int end)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getPersistence().findAll(start, end);
	}

	/**
	* Returns an ordered range of all the p m read messages.
	*
	* <p>
	* Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.PMReadMessageModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
	* </p>
	*
	* @param start the lower bound of the range of p m read messages
	* @param end the upper bound of the range of p m read messages (not inclusive)
	* @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
	* @return the ordered range of p m read messages
	* @throws SystemException if a system exception occurred
	*/
	public static java.util.List<gov.va.caret.model.PMReadMessage> findAll(
		int start, int end,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getPersistence().findAll(start, end, orderByComparator);
	}

	/**
	* Removes all the p m read messages from the database.
	*
	* @throws SystemException if a system exception occurred
	*/
	public static void removeAll()
		throws com.liferay.portal.kernel.exception.SystemException {
		getPersistence().removeAll();
	}

	/**
	* Returns the number of p m read messages.
	*
	* @return the number of p m read messages
	* @throws SystemException if a system exception occurred
	*/
	public static int countAll()
		throws com.liferay.portal.kernel.exception.SystemException {
		return getPersistence().countAll();
	}

	public static PMReadMessagePersistence getPersistence() {
		if (_persistence == null) {
			_persistence = (PMReadMessagePersistence)PortletBeanLocatorUtil.locate(gov.va.caret.service.ClpSerializer.getServletContextName(),
					PMReadMessagePersistence.class.getName());

			ReferenceRegistry.registerReference(PMReadMessageUtil.class,
				"_persistence");
		}

		return _persistence;
	}

	/**
	 * @deprecated As of 6.2.0
	 */
	public void setPersistence(PMReadMessagePersistence persistence) {
	}

	private static PMReadMessagePersistence _persistence;
}