package gov.va.caret.service.persistence;

import com.liferay.portal.service.persistence.BasePersistence;

import gov.va.caret.model.Note;

/**
 * The persistence interface for the note service.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author caret
 * @see NotePersistenceImpl
 * @see NoteUtil
 * @generated
 */
public interface NotePersistence extends BasePersistence<Note> {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this interface directly. Always use {@link NoteUtil} to access the note persistence. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this interface.
     */

    /**
    * Returns all the notes where uuid = &#63;.
    *
    * @param uuid the uuid
    * @return the matching notes
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.Note> findByUuid(
        java.lang.String uuid)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns a range of all the notes where uuid = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.NoteModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param uuid the uuid
    * @param start the lower bound of the range of notes
    * @param end the upper bound of the range of notes (not inclusive)
    * @return the range of matching notes
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.Note> findByUuid(
        java.lang.String uuid, int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns an ordered range of all the notes where uuid = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.NoteModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param uuid the uuid
    * @param start the lower bound of the range of notes
    * @param end the upper bound of the range of notes (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of matching notes
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.Note> findByUuid(
        java.lang.String uuid, int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the first note in the ordered set where uuid = &#63;.
    *
    * @param uuid the uuid
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching note
    * @throws gov.va.caret.NoSuchNoteException if a matching note could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Note findByUuid_First(java.lang.String uuid,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchNoteException;

    /**
    * Returns the first note in the ordered set where uuid = &#63;.
    *
    * @param uuid the uuid
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching note, or <code>null</code> if a matching note could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Note fetchByUuid_First(java.lang.String uuid,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the last note in the ordered set where uuid = &#63;.
    *
    * @param uuid the uuid
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching note
    * @throws gov.va.caret.NoSuchNoteException if a matching note could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Note findByUuid_Last(java.lang.String uuid,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchNoteException;

    /**
    * Returns the last note in the ordered set where uuid = &#63;.
    *
    * @param uuid the uuid
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching note, or <code>null</code> if a matching note could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Note fetchByUuid_Last(java.lang.String uuid,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the notes before and after the current note in the ordered set where uuid = &#63;.
    *
    * @param noteId the primary key of the current note
    * @param uuid the uuid
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the previous, current, and next note
    * @throws gov.va.caret.NoSuchNoteException if a note with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Note[] findByUuid_PrevAndNext(long noteId,
        java.lang.String uuid,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchNoteException;

    /**
    * Removes all the notes where uuid = &#63; from the database.
    *
    * @param uuid the uuid
    * @throws SystemException if a system exception occurred
    */
    public void removeByUuid(java.lang.String uuid)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the number of notes where uuid = &#63;.
    *
    * @param uuid the uuid
    * @return the number of matching notes
    * @throws SystemException if a system exception occurred
    */
    public int countByUuid(java.lang.String uuid)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the note where uuid = &#63; and groupId = &#63; or throws a {@link gov.va.caret.NoSuchNoteException} if it could not be found.
    *
    * @param uuid the uuid
    * @param groupId the group ID
    * @return the matching note
    * @throws gov.va.caret.NoSuchNoteException if a matching note could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Note findByUUID_G(java.lang.String uuid,
        long groupId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchNoteException;

    /**
    * Returns the note where uuid = &#63; and groupId = &#63; or returns <code>null</code> if it could not be found. Uses the finder cache.
    *
    * @param uuid the uuid
    * @param groupId the group ID
    * @return the matching note, or <code>null</code> if a matching note could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Note fetchByUUID_G(java.lang.String uuid,
        long groupId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the note where uuid = &#63; and groupId = &#63; or returns <code>null</code> if it could not be found, optionally using the finder cache.
    *
    * @param uuid the uuid
    * @param groupId the group ID
    * @param retrieveFromCache whether to use the finder cache
    * @return the matching note, or <code>null</code> if a matching note could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Note fetchByUUID_G(java.lang.String uuid,
        long groupId, boolean retrieveFromCache)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Removes the note where uuid = &#63; and groupId = &#63; from the database.
    *
    * @param uuid the uuid
    * @param groupId the group ID
    * @return the note that was removed
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Note removeByUUID_G(java.lang.String uuid,
        long groupId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchNoteException;

    /**
    * Returns the number of notes where uuid = &#63; and groupId = &#63;.
    *
    * @param uuid the uuid
    * @param groupId the group ID
    * @return the number of matching notes
    * @throws SystemException if a system exception occurred
    */
    public int countByUUID_G(java.lang.String uuid, long groupId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns all the notes where groupId = &#63;.
    *
    * @param groupId the group ID
    * @return the matching notes
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.Note> findByGroupId(long groupId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns a range of all the notes where groupId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.NoteModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param groupId the group ID
    * @param start the lower bound of the range of notes
    * @param end the upper bound of the range of notes (not inclusive)
    * @return the range of matching notes
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.Note> findByGroupId(long groupId,
        int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns an ordered range of all the notes where groupId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.NoteModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param groupId the group ID
    * @param start the lower bound of the range of notes
    * @param end the upper bound of the range of notes (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of matching notes
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.Note> findByGroupId(long groupId,
        int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the first note in the ordered set where groupId = &#63;.
    *
    * @param groupId the group ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching note
    * @throws gov.va.caret.NoSuchNoteException if a matching note could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Note findByGroupId_First(long groupId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchNoteException;

    /**
    * Returns the first note in the ordered set where groupId = &#63;.
    *
    * @param groupId the group ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching note, or <code>null</code> if a matching note could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Note fetchByGroupId_First(long groupId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the last note in the ordered set where groupId = &#63;.
    *
    * @param groupId the group ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching note
    * @throws gov.va.caret.NoSuchNoteException if a matching note could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Note findByGroupId_Last(long groupId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchNoteException;

    /**
    * Returns the last note in the ordered set where groupId = &#63;.
    *
    * @param groupId the group ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching note, or <code>null</code> if a matching note could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Note fetchByGroupId_Last(long groupId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the notes before and after the current note in the ordered set where groupId = &#63;.
    *
    * @param noteId the primary key of the current note
    * @param groupId the group ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the previous, current, and next note
    * @throws gov.va.caret.NoSuchNoteException if a note with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Note[] findByGroupId_PrevAndNext(long noteId,
        long groupId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchNoteException;

    /**
    * Removes all the notes where groupId = &#63; from the database.
    *
    * @param groupId the group ID
    * @throws SystemException if a system exception occurred
    */
    public void removeByGroupId(long groupId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the number of notes where groupId = &#63;.
    *
    * @param groupId the group ID
    * @return the number of matching notes
    * @throws SystemException if a system exception occurred
    */
    public int countByGroupId(long groupId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns all the notes where chainId = &#63;.
    *
    * @param chainId the chain ID
    * @return the matching notes
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.Note> findByChainId(long chainId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns a range of all the notes where chainId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.NoteModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param chainId the chain ID
    * @param start the lower bound of the range of notes
    * @param end the upper bound of the range of notes (not inclusive)
    * @return the range of matching notes
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.Note> findByChainId(long chainId,
        int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns an ordered range of all the notes where chainId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.NoteModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param chainId the chain ID
    * @param start the lower bound of the range of notes
    * @param end the upper bound of the range of notes (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of matching notes
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.Note> findByChainId(long chainId,
        int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the first note in the ordered set where chainId = &#63;.
    *
    * @param chainId the chain ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching note
    * @throws gov.va.caret.NoSuchNoteException if a matching note could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Note findByChainId_First(long chainId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchNoteException;

    /**
    * Returns the first note in the ordered set where chainId = &#63;.
    *
    * @param chainId the chain ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching note, or <code>null</code> if a matching note could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Note fetchByChainId_First(long chainId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the last note in the ordered set where chainId = &#63;.
    *
    * @param chainId the chain ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching note
    * @throws gov.va.caret.NoSuchNoteException if a matching note could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Note findByChainId_Last(long chainId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchNoteException;

    /**
    * Returns the last note in the ordered set where chainId = &#63;.
    *
    * @param chainId the chain ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching note, or <code>null</code> if a matching note could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Note fetchByChainId_Last(long chainId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the notes before and after the current note in the ordered set where chainId = &#63;.
    *
    * @param noteId the primary key of the current note
    * @param chainId the chain ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the previous, current, and next note
    * @throws gov.va.caret.NoSuchNoteException if a note with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Note[] findByChainId_PrevAndNext(long noteId,
        long chainId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchNoteException;

    /**
    * Removes all the notes where chainId = &#63; from the database.
    *
    * @param chainId the chain ID
    * @throws SystemException if a system exception occurred
    */
    public void removeByChainId(long chainId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the number of notes where chainId = &#63;.
    *
    * @param chainId the chain ID
    * @return the number of matching notes
    * @throws SystemException if a system exception occurred
    */
    public int countByChainId(long chainId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns all the notes where userId = &#63;.
    *
    * @param userId the user ID
    * @return the matching notes
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.Note> findByUserId(long userId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns a range of all the notes where userId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.NoteModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param userId the user ID
    * @param start the lower bound of the range of notes
    * @param end the upper bound of the range of notes (not inclusive)
    * @return the range of matching notes
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.Note> findByUserId(long userId,
        int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns an ordered range of all the notes where userId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.NoteModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param userId the user ID
    * @param start the lower bound of the range of notes
    * @param end the upper bound of the range of notes (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of matching notes
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.Note> findByUserId(long userId,
        int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the first note in the ordered set where userId = &#63;.
    *
    * @param userId the user ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching note
    * @throws gov.va.caret.NoSuchNoteException if a matching note could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Note findByUserId_First(long userId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchNoteException;

    /**
    * Returns the first note in the ordered set where userId = &#63;.
    *
    * @param userId the user ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching note, or <code>null</code> if a matching note could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Note fetchByUserId_First(long userId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the last note in the ordered set where userId = &#63;.
    *
    * @param userId the user ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching note
    * @throws gov.va.caret.NoSuchNoteException if a matching note could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Note findByUserId_Last(long userId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchNoteException;

    /**
    * Returns the last note in the ordered set where userId = &#63;.
    *
    * @param userId the user ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching note, or <code>null</code> if a matching note could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Note fetchByUserId_Last(long userId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the notes before and after the current note in the ordered set where userId = &#63;.
    *
    * @param noteId the primary key of the current note
    * @param userId the user ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the previous, current, and next note
    * @throws gov.va.caret.NoSuchNoteException if a note with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Note[] findByUserId_PrevAndNext(long noteId,
        long userId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchNoteException;

    /**
    * Removes all the notes where userId = &#63; from the database.
    *
    * @param userId the user ID
    * @throws SystemException if a system exception occurred
    */
    public void removeByUserId(long userId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the number of notes where userId = &#63;.
    *
    * @param userId the user ID
    * @return the number of matching notes
    * @throws SystemException if a system exception occurred
    */
    public int countByUserId(long userId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Caches the note in the entity cache if it is enabled.
    *
    * @param note the note
    */
    public void cacheResult(gov.va.caret.model.Note note);

    /**
    * Caches the notes in the entity cache if it is enabled.
    *
    * @param notes the notes
    */
    public void cacheResult(java.util.List<gov.va.caret.model.Note> notes);

    /**
    * Creates a new note with the primary key. Does not add the note to the database.
    *
    * @param noteId the primary key for the new note
    * @return the new note
    */
    public gov.va.caret.model.Note create(long noteId);

    /**
    * Removes the note with the primary key from the database. Also notifies the appropriate model listeners.
    *
    * @param noteId the primary key of the note
    * @return the note that was removed
    * @throws gov.va.caret.NoSuchNoteException if a note with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Note remove(long noteId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchNoteException;

    public gov.va.caret.model.Note updateImpl(gov.va.caret.model.Note note)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the note with the primary key or throws a {@link gov.va.caret.NoSuchNoteException} if it could not be found.
    *
    * @param noteId the primary key of the note
    * @return the note
    * @throws gov.va.caret.NoSuchNoteException if a note with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Note findByPrimaryKey(long noteId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchNoteException;

    /**
    * Returns the note with the primary key or returns <code>null</code> if it could not be found.
    *
    * @param noteId the primary key of the note
    * @return the note, or <code>null</code> if a note with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Note fetchByPrimaryKey(long noteId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns all the notes.
    *
    * @return the notes
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.Note> findAll()
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns a range of all the notes.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.NoteModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of notes
    * @param end the upper bound of the range of notes (not inclusive)
    * @return the range of notes
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.Note> findAll(int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns an ordered range of all the notes.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.NoteModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of notes
    * @param end the upper bound of the range of notes (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of notes
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.Note> findAll(int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Removes all the notes from the database.
    *
    * @throws SystemException if a system exception occurred
    */
    public void removeAll()
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the number of notes.
    *
    * @return the number of notes
    * @throws SystemException if a system exception occurred
    */
    public int countAll()
        throws com.liferay.portal.kernel.exception.SystemException;
}
