package gov.va.caret.service.persistence;

import com.liferay.portal.kernel.bean.PortletBeanLocatorUtil;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ReferenceRegistry;
import com.liferay.portal.service.ServiceContext;

import gov.va.caret.model.Docum;

import java.util.List;

/**
 * The persistence utility for the docum service. This utility wraps {@link DocumPersistenceImpl} and provides direct access to the database for CRUD operations. This utility should only be used by the service layer, as it must operate within a transaction. Never access this utility in a JSP, controller, model, or other front-end class.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author caret
 * @see DocumPersistence
 * @see DocumPersistenceImpl
 * @generated
 */
public class DocumUtil {
    private static DocumPersistence _persistence;

    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify this class directly. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this class.
     */

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#clearCache()
     */
    public static void clearCache() {
        getPersistence().clearCache();
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#clearCache(com.liferay.portal.model.BaseModel)
     */
    public static void clearCache(Docum docum) {
        getPersistence().clearCache(docum);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#countWithDynamicQuery(DynamicQuery)
     */
    public static long countWithDynamicQuery(DynamicQuery dynamicQuery)
        throws SystemException {
        return getPersistence().countWithDynamicQuery(dynamicQuery);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery)
     */
    public static List<Docum> findWithDynamicQuery(DynamicQuery dynamicQuery)
        throws SystemException {
        return getPersistence().findWithDynamicQuery(dynamicQuery);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery, int, int)
     */
    public static List<Docum> findWithDynamicQuery(DynamicQuery dynamicQuery,
        int start, int end) throws SystemException {
        return getPersistence().findWithDynamicQuery(dynamicQuery, start, end);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery, int, int, OrderByComparator)
     */
    public static List<Docum> findWithDynamicQuery(DynamicQuery dynamicQuery,
        int start, int end, OrderByComparator orderByComparator)
        throws SystemException {
        return getPersistence()
                   .findWithDynamicQuery(dynamicQuery, start, end,
            orderByComparator);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#update(com.liferay.portal.model.BaseModel)
     */
    public static Docum update(Docum docum) throws SystemException {
        return getPersistence().update(docum);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#update(com.liferay.portal.model.BaseModel, ServiceContext)
     */
    public static Docum update(Docum docum, ServiceContext serviceContext)
        throws SystemException {
        return getPersistence().update(docum, serviceContext);
    }

    /**
    * Returns all the docums where classPk = &#63; and classId = &#63; and type = &#63;.
    *
    * @param classPk the class pk
    * @param classId the class ID
    * @param type the type
    * @return the matching docums
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.Docum> findByType(
        long classPk, long classId, java.lang.String type)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findByType(classPk, classId, type);
    }

    /**
    * Returns a range of all the docums where classPk = &#63; and classId = &#63; and type = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.DocumModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param classPk the class pk
    * @param classId the class ID
    * @param type the type
    * @param start the lower bound of the range of docums
    * @param end the upper bound of the range of docums (not inclusive)
    * @return the range of matching docums
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.Docum> findByType(
        long classPk, long classId, java.lang.String type, int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findByType(classPk, classId, type, start, end);
    }

    /**
    * Returns an ordered range of all the docums where classPk = &#63; and classId = &#63; and type = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.DocumModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param classPk the class pk
    * @param classId the class ID
    * @param type the type
    * @param start the lower bound of the range of docums
    * @param end the upper bound of the range of docums (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of matching docums
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.Docum> findByType(
        long classPk, long classId, java.lang.String type, int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence()
                   .findByType(classPk, classId, type, start, end,
            orderByComparator);
    }

    /**
    * Returns the first docum in the ordered set where classPk = &#63; and classId = &#63; and type = &#63;.
    *
    * @param classPk the class pk
    * @param classId the class ID
    * @param type the type
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching docum
    * @throws gov.va.caret.NoSuchDocumException if a matching docum could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Docum findByType_First(long classPk,
        long classId, java.lang.String type,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchDocumException {
        return getPersistence()
                   .findByType_First(classPk, classId, type, orderByComparator);
    }

    /**
    * Returns the first docum in the ordered set where classPk = &#63; and classId = &#63; and type = &#63;.
    *
    * @param classPk the class pk
    * @param classId the class ID
    * @param type the type
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching docum, or <code>null</code> if a matching docum could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Docum fetchByType_First(long classPk,
        long classId, java.lang.String type,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence()
                   .fetchByType_First(classPk, classId, type, orderByComparator);
    }

    /**
    * Returns the last docum in the ordered set where classPk = &#63; and classId = &#63; and type = &#63;.
    *
    * @param classPk the class pk
    * @param classId the class ID
    * @param type the type
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching docum
    * @throws gov.va.caret.NoSuchDocumException if a matching docum could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Docum findByType_Last(long classPk,
        long classId, java.lang.String type,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchDocumException {
        return getPersistence()
                   .findByType_Last(classPk, classId, type, orderByComparator);
    }

    /**
    * Returns the last docum in the ordered set where classPk = &#63; and classId = &#63; and type = &#63;.
    *
    * @param classPk the class pk
    * @param classId the class ID
    * @param type the type
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching docum, or <code>null</code> if a matching docum could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Docum fetchByType_Last(long classPk,
        long classId, java.lang.String type,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence()
                   .fetchByType_Last(classPk, classId, type, orderByComparator);
    }

    /**
    * Returns the docums before and after the current docum in the ordered set where classPk = &#63; and classId = &#63; and type = &#63;.
    *
    * @param documId the primary key of the current docum
    * @param classPk the class pk
    * @param classId the class ID
    * @param type the type
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the previous, current, and next docum
    * @throws gov.va.caret.NoSuchDocumException if a docum with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Docum[] findByType_PrevAndNext(
        long documId, long classPk, long classId, java.lang.String type,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchDocumException {
        return getPersistence()
                   .findByType_PrevAndNext(documId, classPk, classId, type,
            orderByComparator);
    }

    /**
    * Removes all the docums where classPk = &#63; and classId = &#63; and type = &#63; from the database.
    *
    * @param classPk the class pk
    * @param classId the class ID
    * @param type the type
    * @throws SystemException if a system exception occurred
    */
    public static void removeByType(long classPk, long classId,
        java.lang.String type)
        throws com.liferay.portal.kernel.exception.SystemException {
        getPersistence().removeByType(classPk, classId, type);
    }

    /**
    * Returns the number of docums where classPk = &#63; and classId = &#63; and type = &#63;.
    *
    * @param classPk the class pk
    * @param classId the class ID
    * @param type the type
    * @return the number of matching docums
    * @throws SystemException if a system exception occurred
    */
    public static int countByType(long classPk, long classId,
        java.lang.String type)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().countByType(classPk, classId, type);
    }

    /**
    * Returns all the docums where classPk = &#63;.
    *
    * @param classPk the class pk
    * @return the matching docums
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.Docum> findByClassPk(
        long classPk)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findByClassPk(classPk);
    }

    /**
    * Returns a range of all the docums where classPk = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.DocumModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param classPk the class pk
    * @param start the lower bound of the range of docums
    * @param end the upper bound of the range of docums (not inclusive)
    * @return the range of matching docums
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.Docum> findByClassPk(
        long classPk, int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findByClassPk(classPk, start, end);
    }

    /**
    * Returns an ordered range of all the docums where classPk = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.DocumModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param classPk the class pk
    * @param start the lower bound of the range of docums
    * @param end the upper bound of the range of docums (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of matching docums
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.Docum> findByClassPk(
        long classPk, int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence()
                   .findByClassPk(classPk, start, end, orderByComparator);
    }

    /**
    * Returns the first docum in the ordered set where classPk = &#63;.
    *
    * @param classPk the class pk
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching docum
    * @throws gov.va.caret.NoSuchDocumException if a matching docum could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Docum findByClassPk_First(long classPk,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchDocumException {
        return getPersistence().findByClassPk_First(classPk, orderByComparator);
    }

    /**
    * Returns the first docum in the ordered set where classPk = &#63;.
    *
    * @param classPk the class pk
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching docum, or <code>null</code> if a matching docum could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Docum fetchByClassPk_First(long classPk,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().fetchByClassPk_First(classPk, orderByComparator);
    }

    /**
    * Returns the last docum in the ordered set where classPk = &#63;.
    *
    * @param classPk the class pk
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching docum
    * @throws gov.va.caret.NoSuchDocumException if a matching docum could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Docum findByClassPk_Last(long classPk,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchDocumException {
        return getPersistence().findByClassPk_Last(classPk, orderByComparator);
    }

    /**
    * Returns the last docum in the ordered set where classPk = &#63;.
    *
    * @param classPk the class pk
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching docum, or <code>null</code> if a matching docum could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Docum fetchByClassPk_Last(long classPk,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().fetchByClassPk_Last(classPk, orderByComparator);
    }

    /**
    * Returns the docums before and after the current docum in the ordered set where classPk = &#63;.
    *
    * @param documId the primary key of the current docum
    * @param classPk the class pk
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the previous, current, and next docum
    * @throws gov.va.caret.NoSuchDocumException if a docum with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Docum[] findByClassPk_PrevAndNext(
        long documId, long classPk,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchDocumException {
        return getPersistence()
                   .findByClassPk_PrevAndNext(documId, classPk,
            orderByComparator);
    }

    /**
    * Removes all the docums where classPk = &#63; from the database.
    *
    * @param classPk the class pk
    * @throws SystemException if a system exception occurred
    */
    public static void removeByClassPk(long classPk)
        throws com.liferay.portal.kernel.exception.SystemException {
        getPersistence().removeByClassPk(classPk);
    }

    /**
    * Returns the number of docums where classPk = &#63;.
    *
    * @param classPk the class pk
    * @return the number of matching docums
    * @throws SystemException if a system exception occurred
    */
    public static int countByClassPk(long classPk)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().countByClassPk(classPk);
    }

    /**
    * Returns all the docums where classId = &#63;.
    *
    * @param classId the class ID
    * @return the matching docums
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.Docum> findByClassId(
        long classId)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findByClassId(classId);
    }

    /**
    * Returns a range of all the docums where classId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.DocumModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param classId the class ID
    * @param start the lower bound of the range of docums
    * @param end the upper bound of the range of docums (not inclusive)
    * @return the range of matching docums
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.Docum> findByClassId(
        long classId, int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findByClassId(classId, start, end);
    }

    /**
    * Returns an ordered range of all the docums where classId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.DocumModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param classId the class ID
    * @param start the lower bound of the range of docums
    * @param end the upper bound of the range of docums (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of matching docums
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.Docum> findByClassId(
        long classId, int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence()
                   .findByClassId(classId, start, end, orderByComparator);
    }

    /**
    * Returns the first docum in the ordered set where classId = &#63;.
    *
    * @param classId the class ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching docum
    * @throws gov.va.caret.NoSuchDocumException if a matching docum could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Docum findByClassId_First(long classId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchDocumException {
        return getPersistence().findByClassId_First(classId, orderByComparator);
    }

    /**
    * Returns the first docum in the ordered set where classId = &#63;.
    *
    * @param classId the class ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching docum, or <code>null</code> if a matching docum could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Docum fetchByClassId_First(long classId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().fetchByClassId_First(classId, orderByComparator);
    }

    /**
    * Returns the last docum in the ordered set where classId = &#63;.
    *
    * @param classId the class ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching docum
    * @throws gov.va.caret.NoSuchDocumException if a matching docum could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Docum findByClassId_Last(long classId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchDocumException {
        return getPersistence().findByClassId_Last(classId, orderByComparator);
    }

    /**
    * Returns the last docum in the ordered set where classId = &#63;.
    *
    * @param classId the class ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching docum, or <code>null</code> if a matching docum could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Docum fetchByClassId_Last(long classId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().fetchByClassId_Last(classId, orderByComparator);
    }

    /**
    * Returns the docums before and after the current docum in the ordered set where classId = &#63;.
    *
    * @param documId the primary key of the current docum
    * @param classId the class ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the previous, current, and next docum
    * @throws gov.va.caret.NoSuchDocumException if a docum with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Docum[] findByClassId_PrevAndNext(
        long documId, long classId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchDocumException {
        return getPersistence()
                   .findByClassId_PrevAndNext(documId, classId,
            orderByComparator);
    }

    /**
    * Removes all the docums where classId = &#63; from the database.
    *
    * @param classId the class ID
    * @throws SystemException if a system exception occurred
    */
    public static void removeByClassId(long classId)
        throws com.liferay.portal.kernel.exception.SystemException {
        getPersistence().removeByClassId(classId);
    }

    /**
    * Returns the number of docums where classId = &#63;.
    *
    * @param classId the class ID
    * @return the number of matching docums
    * @throws SystemException if a system exception occurred
    */
    public static int countByClassId(long classId)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().countByClassId(classId);
    }

    /**
    * Caches the docum in the entity cache if it is enabled.
    *
    * @param docum the docum
    */
    public static void cacheResult(gov.va.caret.model.Docum docum) {
        getPersistence().cacheResult(docum);
    }

    /**
    * Caches the docums in the entity cache if it is enabled.
    *
    * @param docums the docums
    */
    public static void cacheResult(
        java.util.List<gov.va.caret.model.Docum> docums) {
        getPersistence().cacheResult(docums);
    }

    /**
    * Creates a new docum with the primary key. Does not add the docum to the database.
    *
    * @param documId the primary key for the new docum
    * @return the new docum
    */
    public static gov.va.caret.model.Docum create(long documId) {
        return getPersistence().create(documId);
    }

    /**
    * Removes the docum with the primary key from the database. Also notifies the appropriate model listeners.
    *
    * @param documId the primary key of the docum
    * @return the docum that was removed
    * @throws gov.va.caret.NoSuchDocumException if a docum with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Docum remove(long documId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchDocumException {
        return getPersistence().remove(documId);
    }

    public static gov.va.caret.model.Docum updateImpl(
        gov.va.caret.model.Docum docum)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().updateImpl(docum);
    }

    /**
    * Returns the docum with the primary key or throws a {@link gov.va.caret.NoSuchDocumException} if it could not be found.
    *
    * @param documId the primary key of the docum
    * @return the docum
    * @throws gov.va.caret.NoSuchDocumException if a docum with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Docum findByPrimaryKey(long documId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchDocumException {
        return getPersistence().findByPrimaryKey(documId);
    }

    /**
    * Returns the docum with the primary key or returns <code>null</code> if it could not be found.
    *
    * @param documId the primary key of the docum
    * @return the docum, or <code>null</code> if a docum with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Docum fetchByPrimaryKey(long documId)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().fetchByPrimaryKey(documId);
    }

    /**
    * Returns all the docums.
    *
    * @return the docums
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.Docum> findAll()
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findAll();
    }

    /**
    * Returns a range of all the docums.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.DocumModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of docums
    * @param end the upper bound of the range of docums (not inclusive)
    * @return the range of docums
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.Docum> findAll(int start,
        int end) throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findAll(start, end);
    }

    /**
    * Returns an ordered range of all the docums.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.DocumModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of docums
    * @param end the upper bound of the range of docums (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of docums
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.Docum> findAll(int start,
        int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findAll(start, end, orderByComparator);
    }

    /**
    * Removes all the docums from the database.
    *
    * @throws SystemException if a system exception occurred
    */
    public static void removeAll()
        throws com.liferay.portal.kernel.exception.SystemException {
        getPersistence().removeAll();
    }

    /**
    * Returns the number of docums.
    *
    * @return the number of docums
    * @throws SystemException if a system exception occurred
    */
    public static int countAll()
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().countAll();
    }

    public static DocumPersistence getPersistence() {
        if (_persistence == null) {
            _persistence = (DocumPersistence) PortletBeanLocatorUtil.locate(gov.va.caret.service.ClpSerializer.getServletContextName(),
                    DocumPersistence.class.getName());

            ReferenceRegistry.registerReference(DocumUtil.class, "_persistence");
        }

        return _persistence;
    }

    /**
     * @deprecated As of 6.2.0
     */
    public void setPersistence(DocumPersistence persistence) {
    }
}
